/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import pyrosim.legacy_2006_2.domain.HeadRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;

public class HeadProcessor
extends AFDSRecordProcessor {
    public HeadProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "HEAD";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        if (!"HEAD".equals(rec.getType())) {
            return false;
        }
        try {
            String chid = (String)rec.getValue("CHID");
            String title = (String)rec.getValue("TITLE");
            HeadRecord head = this.getContainer().getHeadManager().getHeadRecord();
            head.setTitle(title);
            head.setCHID(chid);
            this.flagPyroTypeAffected(HeadRecord.class);
        }
        catch (NullPointerException e1) {
            err = true;
        }
        catch (ClassCastException e2) {
            err = true;
        }
        if (err) {
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

