/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.io.FDSInputRecordDebugInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;

public class FDSInputRecord
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final String BNDF = "BNDF";
    public static final String BNDF_QUANTITY = "QUANTITY";
    public static final String BNDF_DTSAM = "DTSAM";
    public static final String PDIM = "PDIM";
    public static final String XBAR0 = "XBAR0";
    public static final String YBAR0 = "YBAR0";
    public static final String ZBAR0 = "ZBAR0";
    public static final String XBAR = "XBAR";
    public static final String YBAR = "YBAR";
    public static final String ZBAR = "ZBAR";
    public static final String GRID = "GRID";
    public static final String IBAR = "IBAR";
    public static final String JBAR = "JBAR";
    public static final String KBAR = "KBAR";
    public static final String TRNX = "TRNX";
    public static final String TRNY = "TRNY";
    public static final String TRNZ = "TRNZ";
    public static final String CC = "CC";
    public static final String PC = "PC";
    public static final String MESH_NUMBER = "MESH_NUMBER";
    public static final String IDERIV = "IDERIV";
    public static final String HEAD_CHID = "CHID";
    public static final String HEAD_TITLE = "TITLE";
    public static final String HEAD = "HEAD";
    public static final String HEAT = "HEAT";
    public static final String HEAT_XYZ = "XYZ";
    public static final String HEAT_RTI = "RTI";
    public static final String HEAT_ACTIVATION_TEMP = "ACTIVATION_TEMPERATURE";
    public static final String HEAT_LABEL = "LABEL";
    public static final String SMOD = "SMOD";
    public static final String SMOD_XYZ = "XYZ";
    public static final String SMOD_LENGTH = "LENGTH";
    public static final String SMOD_ALPHA_C = "ALPHA_C";
    public static final String SMOD_BETA_C = "BETA_C";
    public static final String SMOD_ALPHA_E = "ALPHA_E";
    public static final String SMOD_BETA_E = "BETA_E";
    public static final String SMOD_ACTIVATION_OBS = "ACTIVATION_OBSCURATION";
    public static final String SMOD_LABEL = "LABEL";
    public static final String ISOF = "ISOF";
    public static final String ISOF_QUANTITY = "QUANTITY";
    public static final String ISOF_VALUE = "VALUE(";
    public static final String ISOF_DTSAM = "DTSAM";
    public static final String ALL = "ALL";
    public static final String DATABASE_RECORD = "DATABASE_RECORD";
    public static final String MISC = "MISC";
    public static final String DNS = "DNS";
    public static final String DB_FILE = "DATABASE";
    public static final String DB_DIR = "DATABASE_DIRECTORY";
    public static final String SURF_DEFAULT = "SURF_DEFAULT";
    public static final String REACTION = "REACTION";
    public static final String TEMP_AMBIENT = "TMPA";
    public static final String TEMP_OUTSIDE = "TMPO";
    public static final String INIT_VEL_X = "U0";
    public static final String INIT_VEL_Y = "V0";
    public static final String INIT_VEL_Z = "W0";
    public static final String NUM_FRAMES = "NFRAMES";
    public static final String AUTOMATIC_Z = "AUTOMATIC_Z";
    public static final String SUPPRESSION = "SUPPRESSION";
    public static final String CHARACTERISTIC_VELOCITY = "CHARACTERISTIC_VELOCITY";
    public static final String GAUGE_TEMPERATURE = "GAUGE_TEMPERATURE";
    public static final String BACKGROUND_SPECIES = "BACKGROUND_SPECIES";
    public static final String BAROCLINIC = "BAROCLINIC";
    public static final String CSMAG = "CSMAG";
    public static final String DENSITY = "DENSITY";
    public static final String DT0DZ = "DT0DZ";
    public static final String DTCORE = "DTCORE";
    public static final String DTSPAR = "DTSPAR";
    public static final String GVEC = "GVEC";
    public static final String ISOTHERMAL = "ISOTHERMAL";
    public static final String INCOMPRESSIBLE = "INCOMPRESSIBLE";
    public static final String PR = "PR";
    public static final String PINF = "PINF";
    public static final String POROUS_FLOOR = "POROUS_FLOOR";
    public static final String RADIATION = "RADIATION";
    public static final String RESTART = "RESTART";
    public static final String SC = "SC";
    public static final String SMOKE3D = "SMOKE3D";
    public static final String TEXTURE_ORIGIN = "TEXTURE_ORIGIN";
    public static final String LEAK_AREA = "LEAK_AREA";
    public static final String DTSAM_PART = "DTSAM_PART";
    public static final String DTPAR = "DTPAR";
    public static final String NPPS = "NPPS";
    public static final String MAXIMUM_DROPLETS = "MAXIMUM_DROPLETS";
    public static final String RENDER_FILE = "RENDER_FILE";
    public static final int SIMTYPE_LES = 0;
    public static final int SIMTYPE_DNS = 1;
    public static final int BAROCLINIC_NEGLECT = 0;
    public static final int BAROCLINIC_RESTORE = 1;
    public static final UnitDouble DEF_CHARACTERISTIC_VELOCITY = new UnitDouble(1.0, FdsSISystem.getInstance().getVelocityUnit());
    public static final UnitDouble DEF_GAUGE_TEMPERATURE = new UnitDouble(20.0, FdsSISystem.getInstance().getTempUnit());
    public static final UnitDouble DEF_AMBIENT_TEMP = new UnitDouble(20.0, FdsSISystem.getInstance().getTempUnit());
    public static final UnitDouble DEF_OUTSIDE_TEMP = new UnitDouble(20.0, FdsSISystem.getInstance().getTempUnit());
    public static final UnitDouble DEF_AMBIENT_PRESSURE = new UnitDouble(101325.0, FdsSISystem.getInstance().getAmbientPressureUnit());
    public static final UnitPoint3D DEF_INIT_VEL = new UnitPoint3D(0.0, 0.0, 0.0, FdsSISystem.getInstance().getVelocityUnit());
    public static final int DEF_BAROCLINIC_LES = 0;
    public static final int DEF_BAROCLINIC_DNS = 1;
    public static final double DEF_CSMAG = 0.2;
    public static final UnitDouble DEF_DT0DZ = new UnitDouble(-0.0097, FdsSISystem.getInstance().getAtmGradUnit());
    public static final UnitDouble DEF_DTPAR = new UnitDouble(0.05, FdsSISystem.getInstance().getTimeUnit());
    public static final UnitDouble DEF_DTSPAR = new UnitDouble(0.05, FdsSISystem.getInstance().getTimeUnit());
    public static final UnitPoint3D DEF_GVEC = new UnitPoint3D(0.0, 0.0, -9.81, FdsSISystem.getInstance().getAccelUnit());
    public static final boolean DEF_ISOTHERMAL = false;
    public static final boolean DEF_RADSOLVEROFF = false;
    public static final boolean DEF_INCOMPRESSIBLE = false;
    public static final double DEF_PR = 0.5;
    public static final boolean DEF_POROUS_FLOOR = true;
    public static final boolean DEF_RADIATION = true;
    public static final boolean DEF_RESTART = false;
    public static final double DEF_SC = 0.5;
    public static final boolean DEF_SMOKE3D = true;
    public static final UnitDouble DEF_NPPS = new UnitDouble(100000.0, FdsSISystem.getInstance().getTimeUnit());
    public static final int DEF_MAXIMUM_DROPLETS = 500000;
    public static final int DEF_NUM_FRAMES = 1000;
    public static final boolean DEF_SUPPRESSION = true;
    public static final boolean DEF_AUTOMATIC_Z = true;
    public static final int DEF_SIMTYPE = 0;
    public static final String OBST = "OBST";
    public static final String HOLE = "HOLE";
    public static final String COORDS = "XB";
    public static final String SURF1 = "SURF_ID";
    public static final String SURF3 = "SURF_IDS";
    public static final String SURF6 = "SURF_ID6";
    public static final String GRID_WALL = "CB";
    public static final String PBX = "PBX";
    public static final String PBY = "PBY";
    public static final String PBZ = "PBZ";
    public static final String RGB = "RGB";
    public static final String COLOR = "COLOR";
    public static final String T_CREATE = "T_CREATE";
    public static final String T_REMOVE = "T_REMOVE";
    public static final String HEAT_CREATE = "HEAT_CREATE";
    public static final String HEAT_REMOVE = "HEAT_REMOVE";
    public static final String PERMIT_HOLE = "PERMIT_HOLE";
    public static final String SAWTOOTH = "SAWTOOTH";
    public static final String THICKEN = "THICKEN";
    public static final String INIVS_COLOR = "INVISIBLE";
    public static final String PART = "PART";
    public static final String PART_ID = "ID";
    public static final String PART_DENSITY = "DENSITY";
    public static final String PART_VAPTEMP = "VAPORIZATION_TEMPERATURE";
    public static final String PART_MELTTEMP = "MELTING_TEMPERATURE";
    public static final String PART_SPECIFICHEAT = "SPECIFIC_HEAT";
    public static final String PART_HEATVAP = "HEAT_OF_VAPORIZATION";
    public static final String PART_DIAMETER = "DIAMETER";
    public static final String PART_GAMMAD = "GAMMA_D";
    public static final String PART_MASSLESS = "MASSLESS";
    public static final String PART_STATIC = "STATIC";
    public static final String PART_FUEL = "FUEL";
    public static final String PART_HEATCOMBUST = "HEAT_OF_COMBUSTION";
    public static final String PART_WATER = "WATER";
    public static final String PART_SAMPLE = "SAMPLING_FACTOR";
    public static final String PART_QUANTITY = "QUANTITY";
    public static final String PART_INITDROP = "NUMBER_INITIAL_DROPLETS";
    public static final String PART_MASSVOL = "MASS_PER_VOLUME";
    public static final String PART_DROPSEC = "DROPLETS_PER_SECOND";
    public static final String PART_AGE = "AGE";
    public static final String PART_INITTEMP = "INITIAL_TEMPERATURE";
    public static final String PIPE = "PIPE";
    public static final String PIPE_DELAY = "DELAY";
    public static final String PIPE_PRESSURE = "PRESSURE";
    public static final String PL3D = "PL3D";
    public static final String PL3D_QUANTITIES = "QUANTITIES";
    public static final String PL3D_DTSAM = "DTSAM";
    public static final String PL3D_WRITE_XYZ = "WRITE_XYZ";
    public static final String RAMP = "RAMP";
    public static final String RAMP_ID = "ID";
    public static final String RAMP_T = "T";
    public static final String RAMP_F = "F";
    public static final String REAC = "REAC";
    public static final String REAC_ID = "ID";
    public static final String SLCF = "SLCF";
    public static final String SLCF_QUANTITY = "QUANTITY";
    public static final String SLCF_VECTOR = "VECTOR";
    public static final String SLCF_CB = "CB";
    public static final String SLCF_DTSAM = "DTSAM";
    public static final String SLCF_K_HIGH = "K_HIGH";
    public static final String SLCF_K_LOW = "K_LOW";
    public static final String SLCF_MESH_NUMBER = "MESH_NUMBER";
    public static final String SLCF_WRITE_XYZ = "WRITE_XYZ";
    public static final String SLCF_XB = "XB";
    public static final String SPRK = "SPRK";
    public static final String SPRK_LABEL = "LABEL";
    public static final String SPRK_MAKE = "MAKE";
    public static final String SPRK_ORIENTATION = "ORIENTATION";
    public static final String SPRK_PART_ID = "PART_ID";
    public static final String SPRK_ROTATION = "ROTATION";
    public static final String SPRK_T_ACTIVATE = "T_ACTIVATE";
    public static final String SPRK_T_DEACTIVATE = "T_DEACTIVATE";
    public static final String SPRK_XYZ = "XYZ";
    public static final String SURF = "SURF";
    public static final String THCP = "THCP";
    public static final String THCP_COORDS = "XYZ";
    public static final String THCP_QUANTITY = "QUANTITY";
    public static final String THCP_LABEL = "LABEL";
    public static final String THCP_DEPTH = "DEPTH";
    public static final String THCP_DIAMETER = "DIAMETER";
    public static final String THCP_DTSAM = "DTSAM";
    public static final String THCP_EMISSIVITY = "EMISSIVITY";
    public static final String THCP_K_HIGH = "K_HIGH";
    public static final String THCP_K_LOW = "K_LOW";
    public static final String THCP_XB = "XB";
    public static final String THCP_IOR = "IOR";
    public static final String TIME = "TIME";
    public static final String TWFIN = "TWFIN";
    public static final String DT = "DT";
    public static final String SYNCHRONIZE = "SYNCHRONIZE";
    public static final UnitDouble DEF_TWFIN = new UnitDouble(1.0, FdsSISystem.getInstance().getTimeUnit());
    public static final String VENT = "VENT";
    public static final String VENT_T_CLOSE = "T_CLOSE";
    public static final String VENT_T_OPEN = "T_OPEN";
    public static final String VENT_T_ACTIVATE = "T_ACTIVATE";
    public static final String VENT_T_DEACTIVATE = "T_DEACTIVATE";
    public static final String VENT_HEAT_ACTIVATE = "HEAT_ACTIVATE";
    public static final String VENT_HEAT_DEACTIVATE = "HEAT_DEACTIVATE";
    public static final String VENT_IOR = "IOR";
    public static final String RADI = "RADI";
    public static final String ANGLE_INCREMENT = "ANGLE_INCREMENT";
    public static final String CH4_BANDS = "CH4_BANDS";
    public static final String KAPPA0 = "KAPPA0";
    public static final String NMIEANG = "NMIEANG";
    public static final String NUMBER_RADIATION_ANGLES = "NUMBER_RADIATION_ANGLES";
    public static final String PATH = "PATH";
    public static final String RADTMP = "RADTMP";
    public static final String TIME_STEP_INCREMENT = "TIME_STEP_INCREMENT";
    public static final String WIDE_BAND_MODEL = "WIDE_BAND_MODEL";
    private String d_type;
    private String d_comment;
    private PropHash d_properties = new PropHash();
    private transient FDSInputRecordDebugInfo d_debugInfo = null;
    private int d_numDecimals;
    private PyroMod d_pyroMod;

    public FDSInputRecord() {
    }

    public FDSInputRecord(String record) throws FDSRecordFormatException {
        this(record, (String)null);
    }

    public FDSInputRecord(String record, FDSInputRecordDebugInfo debugInfo) throws FDSRecordFormatException {
        this(record, null, debugInfo);
    }

    public FDSInputRecord(String record, String comment) throws FDSRecordFormatException {
        this();
        this.d_comment = comment;
        this.parseRecord(record);
    }

    public FDSInputRecord(String record, String comment, FDSInputRecordDebugInfo debugInfo) throws FDSRecordFormatException {
        this();
        this.d_comment = comment;
        this.d_debugInfo = debugInfo;
        this.parseRecord(record);
    }

    public void setNumDecimals(int num) {
        this.d_numDecimals = num;
    }

    public int getNumDecimals() {
        return this.d_numDecimals;
    }

    private void parseRecord(String record) throws FDSRecordFormatException {
        String curr;
        StringTokenizer strTok = new StringTokenizer(record, " ,=\n\r\t'", true);
        Vector<String> tokens = new Vector<String>();
        while (strTok.hasMoreTokens()) {
            curr = strTok.nextToken();
            if (curr.equals("'")) {
                StringBuffer concatString = new StringBuffer();
                while (true) {
                    String innerCurr = "";
                    try {
                        innerCurr = strTok.nextToken();
                    }
                    catch (NoSuchElementException e) {
                        if (tokens.size() > 0) {
                            this.d_type = (String)tokens.get(0);
                        }
                        throw new FDSRecordFormatException(this, "Unterminated string constant");
                    }
                    if (innerCurr.equals("'")) break;
                    concatString.append(innerCurr);
                }
                tokens.add('\'' + concatString.toString() + '\'');
                continue;
            }
            if (this.isDelimTok(curr)) continue;
            tokens.add(curr);
        }
        if (tokens.size() <= 3 || !tokens.get(2).toString().equals("=")) {
            return;
        }
        this.d_type = (String)tokens.get(0);
        curr = null;
        String next = null;
        String currKey = null;
        for (int i = 1; i < tokens.size() - 1; ++i) {
            curr = (String)tokens.get(i);
            next = (String)tokens.get(i + 1);
            if (curr.equals("=")) continue;
            if (next.equals("=")) {
                currKey = curr;
                this.d_properties.put(currKey);
                continue;
            }
            this.putValue(currKey, curr);
        }
        this.putValue(currKey, next);
    }

    private void putValue(String key, String value) {
        if (value.compareToIgnoreCase(".TRUE.") == 0) {
            this.d_properties.put(key, Boolean.TRUE);
        } else if (value.compareToIgnoreCase(".FALSE.") == 0) {
            this.d_properties.put(key, Boolean.FALSE);
        } else if (value.length() > 1 && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
            this.d_properties.put(key, value.substring(1, value.length() - 1));
        } else {
            try {
                Double d = Double.parseDouble(value);
                this.d_properties.put(key, d);
            }
            catch (NumberFormatException e) {
                this.d_properties.put(key, value);
            }
        }
    }

    private boolean isDelimTok(String tok) {
        return tok.equals(" ") || tok.equals(",") || tok.equals("\n") || tok.equals("\r") || tok.equals("\t");
    }

    public void setType(String type) {
        this.d_type = type;
    }

    public String getType() {
        return this.d_type;
    }

    public String[] getKeys() {
        return this.d_properties.keySet().toArray(new String[this.d_properties.size()]);
    }

    public Object[] getValues() {
        return this.d_properties.values().toArray();
    }

    public Object getValue(String key) {
        return this.d_properties.get(key);
    }

    public void setValue(String key, Object value) {
        this.d_properties.put(key, value);
    }

    public boolean removeValue(String key) {
        return this.d_properties.remove(key) != null;
    }

    public Object clone() {
        FDSInputRecord newFile = new FDSInputRecord();
        newFile.setComment(this.getComment());
        newFile.setType(this.getType());
        String[] keys = this.getKeys();
        Object[] values = this.getValues();
        for (int m = 0; m < keys.length; ++m) {
            newFile.setValue(keys[m], values[m]);
        }
        return newFile;
    }

    public String getComment() {
        return this.d_comment;
    }

    public void setComment(String comment) {
        this.d_comment = comment;
    }

    public FDSInputRecordDebugInfo getDebugInfo() {
        return this.d_debugInfo;
    }

    public boolean empty() {
        return this.d_properties.size() == 0;
    }

    public double extractDouble(String valueKey, double defaultValue, DoubleValueRange range) throws ClassCastException, FDSRecordFormatException {
        return this.extractDouble(valueKey, defaultValue, range, true);
    }

    public double extractDouble(String valueKey, double defaultValue, DoubleValueRange range, boolean useDefIfNoValue) throws ClassCastException, FDSRecordFormatException {
        Double D = (Double)this.getValue(valueKey);
        double d = defaultValue;
        if (D != null) {
            if (range != null && !range.checkValue(D)) {
                throw new FDSRecordFormatException(this, valueKey + " must be " + range.describeRange() + ".");
            }
            d = D;
        } else if (!useDefIfNoValue) {
            throw new FDSRecordFormatException(this, valueKey + " must be specified.");
        }
        return d;
    }

    public UnitDouble extractDouble(String valueKey, Unit unit, UnitDouble defaultValue, UnitDoubleValueRange range) throws ClassCastException, FDSRecordFormatException {
        return this.extractDouble(valueKey, unit, defaultValue, range, true);
    }

    public UnitDouble extractDouble(String valueKey, Unit unit, UnitDouble defaultValue, UnitDoubleValueRange range, boolean useDefIfNoValue) throws ClassCastException, FDSRecordFormatException {
        Double D = (Double)this.getValue(valueKey);
        UnitDouble val = defaultValue;
        if (D != null) {
            val = new UnitDouble(D, unit);
            if (range != null && !range.checkValue(val)) {
                throw new FDSRecordFormatException(this, valueKey + " must be " + range.describeRange() + ".");
            }
        } else if (!useDefIfNoValue) {
            throw new FDSRecordFormatException(this, valueKey + " must be specified.");
        }
        return val;
    }

    public int extractInt(String valueKey, int defaultValue, IntValueRange range) throws ClassCastException, FDSRecordFormatException {
        return this.extractInt(valueKey, defaultValue, range, true);
    }

    public int extractInt(String valueKey, int defaultValue, IntValueRange range, boolean useDefIfNoValue) throws ClassCastException, FDSRecordFormatException {
        Double D = (Double)this.getValue(valueKey);
        int i = defaultValue;
        if (D != null) {
            if (range != null && !range.checkValue(D.intValue())) {
                throw new FDSRecordFormatException(this, valueKey + " must be " + range.describeRange() + ".");
            }
            i = D.intValue();
        } else if (!useDefIfNoValue) {
            throw new FDSRecordFormatException(this, valueKey + " must be specified.");
        }
        return i;
    }

    public boolean extractBoolean(String valueKey, boolean defaultValue) throws ClassCastException {
        Boolean B = (Boolean)this.getValue(valueKey);
        boolean b = defaultValue;
        if (B != null) {
            b = B;
        }
        return b;
    }

    class PropHash
    extends LinkedHashMap
    implements Serializable {
        static final long serialVersionUID = 1L;

        PropHash() {
        }

        public void put(String key) {
            this.put(key, (Object)null);
        }

        @Override
        public void put(String key, Object value) {
            Object existingValue = this.get(key);
            if (existingValue == null) {
                super.put(key, value);
                return;
            }
            if (existingValue instanceof Collection) {
                ((Collection)existingValue).add(value);
                return;
            }
            Vector<Object> vec = new Vector<Object>();
            vec.add(existingValue);
            vec.add(value);
            super.put(key, vec);
        }
    }
}

