/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Primitive;

public class Triangle
implements Primitive,
Serializable {
    static final long serialVersionUID = 1L;
    private Point3d[] d_points;
    private Vector3d d_normal;
    private PrimProps d_props;

    public Triangle(Point3d[] points, Vector3d normal, PrimProps props) {
        assert (points.length == 3);
        this.d_points = points;
        this.d_props = props;
        this.d_normal = normal == null ? Geometry.calcNormal(points[0], points[1], points[2]) : normal;
    }

    public Triangle(Point3d[] points, PrimProps props) {
        this(points, null, props);
    }

    public Triangle(Point3d p1, Point3d p2, Point3d p3, PrimProps props) {
        this(p1, p2, p3, null, props);
    }

    public Triangle(Point3d p1, Point3d p2, Point3d p3, Vector3d normal, PrimProps props) {
        this(new Point3d[]{p1, p2, p3}, normal, props);
    }

    public int getNumPoints() {
        return 3;
    }

    public Point3d getPoint(int index) {
        assert (index < 3 && index >= 0);
        return this.d_points[index];
    }

    @Override
    public Point3d[] getPoints() {
        return this.d_points;
    }

    @Override
    public PrimProps getProps() {
        return this.d_props;
    }

    @Override
    public void setProps(PrimProps p) {
        this.d_props = p;
    }

    @Override
    public Vector3d getNormal() {
        return this.d_normal;
    }
}

