/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.awt.Color;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFDSProperties;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IFragGenerator;

public class HoleFragGenerator
implements IFDSFragGenerator {
    private final IFDSProperties d_props;

    public HoleFragGenerator(IFDSProperties props) {
        this.d_props = props;
    }

    @Override
    public FDSObject generateFrag(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Color color = this.d_props.getColor();
        AlignedHole ah = new AlignedHole(new UnitPoint3D(minx, miny, minz, lu), new UnitPoint3D(maxx, maxy, maxz, lu), this.d_props.getName() + " [Segment]");
        ah.setColor(color);
        ah.setSelected(this.d_props.isSelected());
        ah.setVisible(this.d_props.isVisible());
        Vector segmentEvents = ah.getEventsSeparatedByType();
        Collection<ActivationEventList> objEvents = this.d_props.getEventsSeparatedByType();
        for (ActivationEventList list : objEvents) {
            segmentEvents.add((ActivationEventList)list.clone());
        }
        return ah;
    }

    @Override
    public IFDSProperties getProps() {
        return this.d_props;
    }

    @Override
    public int getCellPriority() {
        return FDSRasterization.getCellPriority(true, false, false);
    }

    @Override
    public <T2> boolean canMerge(IFragGenerator<T2> fragGen2) {
        if (!(fragGen2 instanceof HoleFragGenerator)) {
            return false;
        }
        HoleFragGenerator hfg2 = (HoleFragGenerator)fragGen2;
        return this.getProps().equals(hfg2.getProps());
    }
}

