/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.domain.dependencies.APyroManReplaceDepOnTask;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class SmodList
extends APyroDomainManager<String, SmodRecord>
implements Serializable {
    static final long serialVersionUID = 1698158972204305638L;
    private final List<SmodRecord> d_recs = new ArrayList<SmodRecord>();

    @Override
    public boolean add(SmodRecord smod) {
        if (this.contains(smod.getLabel())) {
            return false;
        }
        boolean ret = this.d_recs.add(smod) && super.add(smod);
        this.fireDomainEvent(new PyroDomainEvent<SmodList, SmodRecord>(this, smod, SmodRecord.class, 3));
        return ret;
    }

    @Override
    public boolean remove(SmodRecord smod) {
        boolean ret = this.d_recs.remove(smod) && super.remove(smod);
        this.fireDomainEvent(new PyroDomainEvent<SmodList, SmodRecord>(this, smod, SmodRecord.class, 4));
        return ret;
    }

    public int indexOf(String label) {
        for (int i = 0; i < this.d_recs.size(); ++i) {
            if (!this.d_recs.get(i).getLabel().equalsIgnoreCase(label)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Task taskAddAll(Collection<? extends SmodRecord> pyroObjects) {
        return new APyroManAddTask<String, SmodRecord>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(SmodRecord obj) {
                return SmodList.this.add(obj);
            }

            @Override
            public boolean remove(SmodRecord obj) {
                return SmodList.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<SmodRecord> pyroObjects, List<SmodRecord> replacements) {
        return new APyroManReplaceDepOnTask<String, SmodRecord>((IPyroManager)this, pyroObjects, replacements, this.getDomains()){

            @Override
            public boolean add(SmodRecord obj) {
                return SmodList.this.add(obj);
            }

            @Override
            public boolean remove(SmodRecord obj) {
                return SmodList.this.remove(obj);
            }
        };
    }

    @Override
    public boolean contains(String label) {
        return this.indexOf(label) >= 0;
    }

    @Override
    public SmodRecord get(String key) {
        int ix = this.indexOf(key);
        if (ix >= 0) {
            return this.d_recs.get(this.indexOf(key));
        }
        return null;
    }

    @Override
    public SmodRecord get(SmodRecord pyroObject) {
        return this.get(pyroObject.getLabel());
    }

    @Override
    public boolean canMakeUnique(SmodRecord pyroObject) {
        return true;
    }

    @Override
    public Task taskMakeUnique(SmodRecord pyroObject) {
        return new AMakeUniqueNameTask<SmodRecord>(this.getDomains(), pyroObject){

            @Override
            protected Task taskMakeUnique(SmodRecord obj) {
                return obj.taskSetLabel(APyroDomainManager.getUniqueName(SmodList.this, obj.getLabel()));
            }
        };
    }

    @Override
    public String describeObject(SmodRecord pyroObject) {
        return pyroObject.getLabel();
    }

    @Override
    public int size() {
        return this.d_recs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d_recs.isEmpty();
    }

    public SmodRecord[] toArray() {
        return this.d_recs.toArray(new SmodRecord[this.size()]);
    }

    public SmodRecord[] toArray(SmodRecord[] array) {
        return this.d_recs.toArray(array);
    }

    @Override
    public Class<SmodRecord> getVClass() {
        return SmodRecord.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public Collection<? extends SmodRecord> toCollection() {
        return new PyroCollection<String, SmodRecord>(this);
    }

    @Override
    public Iterator<SmodRecord> iterator() {
        return this.d_recs.iterator();
    }
}

