/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.AOrdPyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.AOrderedPyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddAtIndexTask;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.IOrderedPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class GridList
extends AOrderedPyroDomainManager<String, Grid> {
    private Vector<Grid> d_grids;

    public GridList(PyroMod mod) {
    }

    public void setGrids(Vector<Grid> grids) {
        this.d_grids = grids;
    }

    @Override
    public Collection<? extends Grid> toCollection() {
        return new PyroCollection<String, Grid>(this);
    }

    protected boolean add(Grid pyroObject, int index) {
        assert (index >= 0 && index <= this.size());
        Grid old = this.get(pyroObject.getName());
        if (old != null) {
            return false;
        }
        super.add(pyroObject);
        this.d_grids.insertElementAt(pyroObject, index);
        this.fireDomainEvent(new GridDomainEvent(this, pyroObject, 3));
        return true;
    }

    @Override
    protected boolean add(Grid pyroObject) {
        return this.add(pyroObject, this.d_grids.size());
    }

    protected Grid remove(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        Grid existing = this.d_grids.get(index);
        super.remove(existing);
        this.d_grids.remove(index);
        this.fireDomainEvent(new GridDomainEvent(this, existing, 4));
        return existing;
    }

    @Override
    protected boolean remove(Grid obj) {
        int index = this.indexOf(obj);
        if (index < 0) {
            return false;
        }
        return this.remove(index) != null;
    }

    private boolean removeAll(Collection<? extends Grid> grids) {
        this.pauseUpdates();
        boolean result = true;
        for (Grid grid : grids) {
            if (this.remove(grid)) continue;
            result = false;
        }
        this.resumeUpdates();
        return result;
    }

    @Override
    public boolean contains(String key) {
        return this.get(key) != null;
    }

    @Override
    public Grid get(String key) {
        for (Grid g : this.d_grids) {
            if (!g.getName().equals(key)) continue;
            return g;
        }
        return null;
    }

    @Override
    public Grid get(int index) {
        return this.d_grids.get(index);
    }

    @Override
    public int size() {
        return this.d_grids.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d_grids.isEmpty();
    }

    public Grid[] toArray() {
        return this.d_grids.toArray(new Grid[this.d_grids.size()]);
    }

    public Grid[] toArray(Grid[] array) {
        return this.d_grids.toArray(array);
    }

    @Override
    public Iterator<Grid> iterator() {
        return this.d_grids.iterator();
    }

    @Override
    public Class<Grid> getVClass() {
        return Grid.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(Grid pyroObject) {
        return true;
    }

    @Override
    public String describeObject(Grid pyroObject) {
        return pyroObject.getName();
    }

    @Override
    public Grid get(Grid pyroObject) {
        return this.get(pyroObject.getName());
    }

    public String getUniqueName(String baseName) {
        return GridList.getUniqueName(this, baseName);
    }

    @Override
    public Task taskMakeUnique(Grid pyroObject) {
        return new AMakeUniqueNameTask<Grid>(this.getDomains(), pyroObject){

            @Override
            protected Task taskMakeUnique(Grid obj) {
                return obj.taskSetName(APyroDomainManager.getUniqueName(GridList.this, obj.getName()));
            }
        };
    }

    @Override
    public Task taskAddAll(Collection<? extends Grid> pyroObjects) {
        return new APyroManAddTask<String, Grid>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(Grid obj) {
                return GridList.this.add(obj);
            }

            @Override
            public boolean remove(Grid obj) {
                return GridList.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskAddAll(Collection<? extends Grid> objs, int index) {
        return new APyroManAddAtIndexTask<String, Grid>((IPyroManager)this, objs, index){

            @Override
            public void removeAll(Collection<? extends Grid> objs) {
                GridList.this.removeAll(objs);
            }

            @Override
            public boolean add(Grid obj, int index) {
                return GridList.this.add(obj, index);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<Grid> pyroObjects, List<Grid> replacements) {
        return new AOrdPyroManReplaceTask<String, Grid>((IOrderedPyroManager)this, pyroObjects, replacements){

            @Override
            public void add(Grid obj, int index) {
                GridList.this.add(obj, index);
            }

            @Override
            public void remove(int index) {
                GridList.this.remove(index);
            }
        };
    }

    public Task taskReorder(Grid g, int newIx) {
        return new ReorderTask(this, g, newIx);
    }

    private static class ReorderTask
    extends ATask {
        private final GridList d_gList;
        private final Grid d_grid;
        private int d_nextIx;
        private int d_lastIx;

        public ReorderTask(GridList gList, Grid g, int newIx) {
            super(0, true);
            this.d_gList = gList;
            this.d_grid = g;
            this.d_nextIx = newIx;
            this.d_lastIx = gList.indexOf(g);
        }

        @Override
        public void undo() {
            this.run();
        }

        @Override
        public void run() {
            assert (this.d_gList.get(this.d_lastIx) == this.d_grid);
            this.d_gList.remove(this.d_grid);
            this.d_gList.add(this.d_grid, this.d_nextIx);
            int tmp = this.d_lastIx;
            this.d_lastIx = this.d_nextIx;
            this.d_nextIx = tmp;
            this.d_gList.fireDomainEvent(new GridDomainEvent(this.d_grid, 2));
        }
    }
}

