/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.GridList;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class Grid
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_minPoint;
    private UnitPoint3D d_maxPoint;
    private UnitDouble[] d_x;
    private UnitDouble[] d_y;
    private UnitDouble[] d_z;
    private String d_name = null;
    private Vector<Vent> d_attachedVents;
    private UnitDouble d_minxyDim;
    private static final Hashtable<String, ValueRange> d_ranges = new Hashtable(2);

    public static ValueRange getValueRange(String field) {
        return d_ranges.get(field);
    }

    public Grid(String name) {
        UnitPoint3D min = new UnitPoint3D(0.0, 0.0, 0.0, (Unit)SI.METER);
        UnitPoint3D max = new UnitPoint3D(10.0, 10.0, 3.0, (Unit)SI.METER);
        this.init(min, max, Grid.makeUniformDivisions(20, min.xu(), max.xu()), Grid.makeUniformDivisions(20, min.yu(), max.yu()), Grid.makeUniformDivisions(6, min.zu(), max.zu()), name);
    }

    public Grid(UnitPoint3D minPoint, UnitPoint3D maxPoint, int xCells, int yCells, int zCells, String name) {
        this.init(minPoint, maxPoint, Grid.makeUniformDivisions(xCells, minPoint.xu(), maxPoint.xu()), Grid.makeUniformDivisions(yCells, minPoint.yu(), maxPoint.yu()), Grid.makeUniformDivisions(zCells, minPoint.zu(), maxPoint.zu()), name);
    }

    public Grid(UnitPoint3D minPoint, UnitPoint3D maxPoint, UnitDouble[] xCellWidths, UnitDouble[] yCellWidths, UnitDouble[] zCellWidths, String name) {
        this.init(minPoint, maxPoint, xCellWidths, yCellWidths, zCellWidths, name);
    }

    private void init(UnitPoint3D minPoint, UnitPoint3D maxPoint, UnitDouble[] xCellWidths, UnitDouble[] yCellWidths, UnitDouble[] zCellWidths, String name) {
        this.d_minPoint = minPoint;
        this.d_maxPoint = maxPoint;
        this.d_x = xCellWidths;
        this.d_y = yCellWidths;
        this.d_z = zCellWidths;
        this.d_attachedVents = new Vector();
        this.d_name = name;
        this.d_minxyDim = new UnitDouble(Math.min(this.getMinSpace(this.d_x), this.getMinSpace(this.d_y)), this.d_x[0].getUnit());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_minxyDim == null) {
            this.d_minxyDim = new UnitDouble(Math.min(this.getMinSpace(this.d_x), this.getMinSpace(this.d_y)), this.d_x[0].getUnit());
        }
    }

    private double getMinSpace(UnitDouble[] vals) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < vals.length; ++i) {
            min = Math.min(min, vals[i].getValue(vals[i].getUnit()));
        }
        return min;
    }

    @Override
    public Object clone() {
        Grid clone = (Grid)super.clone();
        clone.imprint(this);
        return clone;
    }

    public Task taskImprint(Grid g) {
        return new ImprintGridTask(this, g);
    }

    public void imprint(Grid g) {
        int m;
        assert (this != g);
        this.pauseUpdates(false);
        this.d_name = g.d_name;
        this.d_minPoint = (UnitPoint3D)g.d_minPoint.clone();
        this.d_maxPoint = (UnitPoint3D)g.d_maxPoint.clone();
        this.d_x = new UnitDouble[g.d_x.length];
        for (m = 0; m < g.d_x.length; ++m) {
            this.d_x[m] = (UnitDouble)g.d_x[m].clone();
        }
        this.d_y = new UnitDouble[g.d_y.length];
        for (m = 0; m < g.d_y.length; ++m) {
            this.d_y[m] = (UnitDouble)g.d_y[m].clone();
        }
        this.d_z = new UnitDouble[g.d_z.length];
        for (m = 0; m < g.d_z.length; ++m) {
            this.d_z[m] = (UnitDouble)g.d_z[m].clone();
        }
        if (g.d_attachedVents != null) {
            this.d_attachedVents = new Vector(g.d_attachedVents.size());
            for (Vent vent : g.d_attachedVents) {
                this.d_attachedVents.add(vent);
            }
        } else {
            this.d_attachedVents = null;
        }
        this.d_minxyDim = new UnitDouble(Math.min(this.getMinSpace(this.d_x), this.getMinSpace(this.d_y)), this.d_x[0].getUnit());
        System.out.println("updating grid " + this.getDomains().size());
        this.resumeUpdates(new GridDomainEvent(this, 5));
    }

    public UnitDouble getMinXYDim() {
        return this.d_minxyDim;
    }

    @Override
    public boolean equals(Object o) {
        int m;
        if (!(o instanceof Grid)) {
            return false;
        }
        Grid g = (Grid)o;
        if (this.d_x.length != g.d_x.length || this.d_y.length != g.d_y.length || this.d_z.length != g.d_z.length) {
            return false;
        }
        for (m = 0; m < this.d_x.length; ++m) {
            if (this.d_x[m].equals(g.d_x[m])) continue;
            return false;
        }
        for (m = 0; m < this.d_y.length; ++m) {
            if (this.d_y[m].equals(g.d_y[m])) continue;
            return false;
        }
        for (m = 0; m < this.d_z.length; ++m) {
            if (this.d_z[m].equals(g.d_z[m])) continue;
            return false;
        }
        boolean equal = this.d_name.equalsIgnoreCase(g.d_name) && (this.d_minPoint == null ? g.d_minPoint == null : this.d_minPoint.equals(g.d_minPoint)) && (this.d_maxPoint == null ? g.d_maxPoint == null : this.d_maxPoint.equals(g.d_maxPoint)) && (this.d_attachedVents == null ? g.d_attachedVents == null : this.d_attachedVents.equals(g.d_attachedVents));
        return equal;
    }

    public static UnitDouble[] makeUniformDivisions(int numDivs, UnitDouble min, UnitDouble max) {
        Object[] divs = new UnitDouble[numDivs];
        BaseUnit u = SI.METER;
        double width = (max.getValue((Unit)u) - min.getValue((Unit)u)) / (double)numDivs;
        Arrays.fill(divs, new UnitDouble(width, (Unit)u));
        return divs;
    }

    private void setName(String name) {
        this.d_name = name;
        this.fireDomainEvent(new GridDomainEvent(this, 5));
    }

    public Task taskSetName(String name) {
        return new ASetNameTask(name){

            @Override
            public void setName(String newName) {
                Grid.this.setName(newName);
            }

            @Override
            protected String getName() {
                return Grid.this.getName();
            }
        };
    }

    public String getName() {
        return this.d_name;
    }

    public UnitPoint3D getMinPoint() {
        return this.d_minPoint;
    }

    public UnitPoint3D getMaxPoint() {
        return this.d_maxPoint;
    }

    public UnitDouble[] getXDivisions() {
        return this.d_x;
    }

    public UnitDouble[] getYDivisions() {
        return this.d_y;
    }

    public UnitDouble[] getZDivisions() {
        return this.d_z;
    }

    private UnitDouble[] convertDivisionsToPositions(UnitDouble minPos, UnitDouble maxPos, UnitDouble[] divisions) {
        UnitDouble[] positions = new UnitDouble[divisions.length + 1];
        positions[0] = minPos;
        for (int i = 1; i < positions.length; ++i) {
            positions[i] = (UnitDouble)positions[i - 1].clone();
            positions[i] = positions[i].add(divisions[i - 1]);
        }
        return positions;
    }

    public UnitDouble[] getXLinePositions() {
        return this.convertDivisionsToPositions(this.d_minPoint.xu(), this.d_maxPoint.xu(), this.d_x);
    }

    public UnitDouble[] getYLinePositions() {
        return this.convertDivisionsToPositions(this.d_minPoint.yu(), this.d_maxPoint.yu(), this.d_y);
    }

    public UnitDouble[] getZLinePositions() {
        return this.convertDivisionsToPositions(this.d_minPoint.zu(), this.d_maxPoint.zu(), this.d_z);
    }

    @Override
    public String getFDSType() {
        return "GRID";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        double length;
        int i;
        double[] xs = new double[this.d_x.length];
        double[] ys = new double[this.d_y.length];
        double[] zs = new double[this.d_z.length];
        boolean xUniform = true;
        boolean yUniform = true;
        boolean zUniform = true;
        Unit u = FdsSISystem.getInstance().getLengthUnit();
        for (i = 0; i < xs.length; ++i) {
            xs[i] = this.d_x[i].getValue(u);
            if (xs[i] == xs[0]) continue;
            xUniform = false;
        }
        for (i = 0; i < ys.length; ++i) {
            ys[i] = this.d_y[i].getValue(u);
            if (ys[i] == ys[0]) continue;
            yUniform = false;
        }
        for (i = 0; i < zs.length; ++i) {
            zs[i] = this.d_z[i].getValue(u);
            if (zs[i] == zs[0]) continue;
            zUniform = false;
        }
        FDSInputRecord gridRec = new FDSInputRecord();
        gridRec.setComment(this.d_name);
        gridRec.setType("GRID");
        gridRec.setValue("IBAR", this.d_x.length);
        gridRec.setValue("JBAR", this.d_y.length);
        gridRec.setValue("KBAR", this.d_z.length);
        recs.add(gridRec);
        FDSInputRecord pdimRec = new FDSInputRecord();
        pdimRec.setComment(this.d_name);
        pdimRec.setType("PDIM");
        pdimRec.setValue("XBAR0", this.getMinPoint().x(u));
        pdimRec.setValue("YBAR0", this.getMinPoint().y(u));
        pdimRec.setValue("ZBAR0", this.getMinPoint().z(u));
        pdimRec.setValue("XBAR", this.getMaxPoint().x(u));
        pdimRec.setValue("YBAR", this.getMaxPoint().y(u));
        pdimRec.setValue("ZBAR", this.getMaxPoint().z(u));
        recs.add(pdimRec);
        if (!xUniform) {
            length = this.getMaxPoint().x(u) - this.getMinPoint().x(u);
            this.addTRNRecords(recs, this.getMinPoint().x(u), xs, length, "TRNX");
        }
        if (!yUniform) {
            length = this.getMaxPoint().y(u) - this.getMinPoint().y(u);
            this.addTRNRecords(recs, this.getMinPoint().y(u), ys, length, "TRNY");
        }
        if (!zUniform) {
            length = this.getMaxPoint().z(u) - this.getMinPoint().z(u);
            this.addTRNRecords(recs, this.getMinPoint().z(u), zs, length, "TRNZ");
        }
    }

    private void addTRNRecords(Collection c, double min, double[] sizes, double length, String recName) {
        if (sizes.length <= 0) {
            return;
        }
        PyroMod pyMod = (PyroMod)this.getDomains().iterator().next();
        GridList gList = pyMod.getGridManager();
        int gridno = gList.indexOf(this) + 1;
        double numDivisions = sizes.length;
        double numSame = 1.0;
        double sizeLast = sizes[0];
        double pc = min + sizeLast;
        double ccLast = min;
        int m = 1;
        while ((double)m < numDivisions) {
            if (sizes[m] == sizeLast) {
                numSame += 1.0;
            } else {
                double ccCurrent = ccLast + numSame * length / numDivisions;
                FDSInputRecord trnRec = new FDSInputRecord();
                trnRec.setComment(this.d_name);
                trnRec.setType(recName);
                trnRec.setValue("CC", ccCurrent);
                trnRec.setValue("PC", pc);
                trnRec.setValue("MESH_NUMBER", gridno);
                c.add(trnRec);
                numSame = 1.0;
                sizeLast = sizes[m];
                ccLast = ccCurrent;
            }
            pc += sizes[m];
            ++m;
        }
    }

    public int ventIndex(Vent v) {
        for (int m = 0; m < this.d_attachedVents.size(); ++m) {
            if (!v.equals(this.d_attachedVents.get(m))) continue;
            return m;
        }
        return -1;
    }

    public boolean attachVent(Vent v) {
        if (this.ventIndex(v) >= 0) {
            return false;
        }
        this.d_attachedVents.add(v);
        return true;
    }

    public boolean detachVent(Vent v) {
        int ventIndex = this.ventIndex(v);
        if (ventIndex < 0) {
            return false;
        }
        this.d_attachedVents.remove(ventIndex);
        return true;
    }

    @Override
    public String getTypeDescription() {
        return "Grid";
    }

    public String getUniqueID() {
        return this.getName();
    }

    public Object getUniqueTypeKey() {
        return "Grid";
    }

    static {
        d_ranges.put("IBAR", IntValueRange.createCheckedMin(1, false));
        d_ranges.put("JBAR", IntValueRange.createCheckedMin(1, false));
        d_ranges.put("KBAR", IntValueRange.createCheckedMin(1, false));
    }

    private static class ImprintGridTask
    implements Task {
        private final Grid d_target;
        private final Grid d_holder;
        private final Grid d_newData;

        public ImprintGridTask(Grid target, Grid newData) {
            this.d_target = target;
            this.d_newData = newData;
            this.d_holder = new Grid(target.getName());
            this.d_holder.imprint(target);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            this.d_target.imprint(this.d_holder);
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void run() {
            this.d_target.imprint(this.d_newData);
        }
    }
}

