/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AFDSFaceProps;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.BlockFragGenerator;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.geom.Triangle;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class FDSConvexPoly
extends AbstractFDSObject
implements Serializable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D[] d_points;

    public FDSConvexPoly(Material mat, UnitPoint3D ... points) {
        super("Convex Polygon");
        this.d_points = points;
        ConvexPolyFace face = new ConvexPolyFace(this);
        face.setMaterial(mat);
        this.d_faces = new Vector(1);
        this.d_faces.add(face);
    }

    private void changed() {
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setPoints(UnitPoint3D ... points) {
        this.d_points = points;
        this.changed();
    }

    public UnitPoint3D[] getPoints() {
        return this.d_points;
    }

    public int getNumPoints() {
        return this.d_points.length;
    }

    public UnitPoint3D getPoint(int index) {
        assert (index >= 0 && index < this.d_points.length);
        return this.d_points[index];
    }

    public void setPoint(int index, UnitPoint3D p) {
        assert (index >= 0 && index < this.d_points.length);
        this.d_points[index] = p;
        this.changed();
    }

    private ConvexPolyFace getFace() {
        return (ConvexPolyFace)this.getFace(0);
    }

    @Override
    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof FDSConvexPoly)) {
            return;
        }
        ADomainObject.pauseUpdates(this);
        super.imprint(baseObject);
        this.getFace().d_obj = this;
        FDSConvexPoly t = (FDSConvexPoly)baseObject;
        this.d_points = FDSConvexPoly.clonePoints(t.d_points);
        this.changed();
        ADomainObject.resumeUpdates(this);
    }

    private static UnitPoint3D[] clonePoints(UnitPoint3D[] points) {
        UnitPoint3D[] newPoints = new UnitPoint3D[points.length];
        for (int m = 0; m < points.length; ++m) {
            newPoints[m] = (UnitPoint3D)points[m].clone();
        }
        return newPoints;
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void translate(UnitPoint3D delta) {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d delta3d = delta.getPoint3dValue(lu);
        for (int m = 0; m < this.d_points.length; ++m) {
            Point3d p3d = this.d_points[m].getPoint3dValue(lu);
            p3d.add(delta3d);
            this.d_points[m] = new UnitPoint3D(p3d, lu);
        }
        this.changed();
    }

    @Override
    protected void rotate(UnitPoint3D base, Vector3d rotAxis, UnitDouble amount) {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        Matrix3d rot = FDSConvexPoly.getRotateMat(rotAxis, amount);
        for (int m = 0; m < this.d_points.length; ++m) {
            Point3d p3d = this.d_points[m].getPoint3dValue(lu);
            FDSConvexPoly.rotatePoint(p3d, base3d, rot);
            this.d_points[m] = new UnitPoint3D(p3d, lu);
        }
        this.changed();
    }

    @Override
    protected void mirror(int internalPlane, UnitDouble value) {
    }

    @Override
    protected void scale(UnitPoint3D base, Tuple3d scale) {
        assert (scale.x >= 0.0 && scale.y >= 0.0 && scale.z >= 0.0);
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        for (int m = 0; m < this.d_points.length; ++m) {
            Point3d p3d = this.d_points[m].getPoint3dValue(lu);
            FDSConvexPoly.scalePoint(p3d, base3d, scale);
            this.d_points[m] = new UnitPoint3D(p3d, lu);
        }
        this.changed();
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
        this.getFace().setMaterial(mat);
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return this.getFace().getMaterial();
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
    }

    @Override
    public String getFDSType() {
        return "POLY";
    }

    @Override
    public String getTypeDescription() {
        return "Convex Polygon";
    }

    @Override
    public boolean isRasterizable() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    private static class ConvexPolyFace
    implements IFace,
    Serializable {
        static final long serialVersionUID = 1L;
        private Material d_mat;
        private FDSConvexPoly d_obj;

        public ConvexPolyFace(FDSConvexPoly t) {
            this.d_obj = t;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }

        @Override
        public String getName() {
            return "Triangle Face";
        }

        @Override
        public void getGeometry(Geometry g) {
            PrimProps props = new PrimProps(this.d_mat, this.d_obj.getColor());
            Unit lu = Geometry.GEOM_LENGTH_UNIT;
            if (this.d_obj.d_points.length == 3) {
                Point3d p1 = this.d_obj.d_points[0].getPoint3dValue(lu);
                Point3d p2 = this.d_obj.d_points[1].getPoint3dValue(lu);
                Point3d p3 = this.d_obj.d_points[2].getPoint3dValue(lu);
                g.addTriangle(new Triangle(p1, p2, p3, props));
            } else if (this.d_obj.d_points.length == 4) {
                Point3d p1 = this.d_obj.d_points[0].getPoint3dValue(lu);
                Point3d p2 = this.d_obj.d_points[1].getPoint3dValue(lu);
                Point3d p3 = this.d_obj.d_points[2].getPoint3dValue(lu);
                Point3d p4 = this.d_obj.d_points[3].getPoint3dValue(lu);
                g.addQuad(new Quad(p1, p2, p3, p4, props));
            }
        }

        @Override
        public Material getMaterial() {
            return this.d_mat;
        }

        @Override
        public void setMaterial(Material m) {
            this.d_mat = m;
            this.d_obj.changed();
        }

        @Override
        public Iterator getVentIterator() {
            return null;
        }

        @Override
        public boolean isSelected() {
            return false;
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return this.d_obj.d_points;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return new BlockFragGenerator(new AFDSFaceProps(this){

                @Override
                public boolean isThickened() {
                    return false;
                }

                @Override
                public boolean permitsHoles() {
                    return true;
                }

                @Override
                public boolean isSawtoothed() {
                    return false;
                }
            }, FDSRasterization.getCellPriority(false, true, true));
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_obj;
        }
    }

    private class SaveGeomTask
    extends ATask {
        private UnitPoint3D[] d_points;
        private Material d_mat;

        public SaveGeomTask(int est) {
            super(est, true);
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(FDSConvexPoly.this);
            FDSConvexPoly.this.setPoints(this.d_points);
            FDSConvexPoly.this.setMaterial(this.d_mat);
            ADomainObject.resumeUpdates(FDSConvexPoly.this);
        }

        @Override
        public void run() {
            this.d_points = FDSConvexPoly.clonePoints(FDSConvexPoly.this.d_points);
            this.d_mat = FDSConvexPoly.this.getMaterial();
        }
    }
}

