/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.List;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.BNDFList;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantityParam;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class BoundaryConditionsTask
implements Task {
    private final PyroMod d_mediator;
    private final List d_nameLst;
    private final List d_enableLst;
    private final List d_paramLst;
    private final List d_valueLst;
    private final UnitDouble d_FWI;

    public BoundaryConditionsTask(PyroMod mediator, List nameLst, List enableLst, List paramLst, List valueLst, UnitDouble FWI) {
        this.d_mediator = mediator;
        this.d_nameLst = nameLst;
        this.d_enableLst = enableLst;
        this.d_paramLst = paramLst;
        this.d_valueLst = valueLst;
        this.d_FWI = FWI;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        BNDFList list = this.d_mediator.getBNDFList();
        for (int m = 0; m < this.d_nameLst.size(); ++m) {
            BNDFRecord record = list.get((String)this.d_nameLst.get(m));
            if (((Boolean)this.d_enableLst.get(m)).booleanValue()) {
                if (record == null) {
                    record = new BNDFRecord(this.d_FWI, (String)this.d_nameLst.get(m));
                    list.taskAdd(record).run();
                } else {
                    record.setDTSam(this.d_FWI);
                }
                SolidPhaseQuantityParam[] params = (SolidPhaseQuantityParam[])this.d_paramLst.get(m);
                ArrayList values = (ArrayList)this.d_valueLst.get(m);
                for (int n = 0; n < params.length; ++n) {
                    UnitDouble value = (UnitDouble)values.get(n);
                    record.setExtraParam(params[n].getName(), value, params[n].getUnitType());
                }
                continue;
            }
            if (record == null) continue;
            list.taskRemove(record, (BNDFRecord)null).run();
        }
        this.d_mediator.resumeUpdates();
    }
}

