/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.BNDFRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class BNDFRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    public static final String DEPTH = "DEPTH";
    public static final UnitDouble DEF_DEPTH = new UnitDouble(0.0, (Unit)SI.METER);
    private UnitDouble d_dtsam = null;
    private String d_quantity = null;
    private Hashtable d_htExtraParams = new Hashtable(5);
    private static final Hashtable<String, ValueRange> d_ranges;

    public BNDFRecord(UnitDouble dtsam, String quantity) {
        this.d_quantity = quantity;
        this.d_dtsam = dtsam;
    }

    public static ValueRange getValueRange(String field) {
        return d_ranges.get(field);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.updateExtraParams();
        if ((!(ois instanceof PyroSimObjectInputStream) || ois instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)ois).getVersion() < 13) && this.d_dtsam != null && !BNDFRecord.getValueRange("DTSAM").checkValue(this.d_dtsam)) {
            this.d_dtsam = null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BNDFRecord)) {
            return false;
        }
        BNDFRecord b = (BNDFRecord)o;
        return this.d_quantity.equals(b.d_quantity) && this.d_htExtraParams.equals(b.d_htExtraParams) && (this.d_dtsam != null ? this.d_dtsam.equals(b.d_dtsam) : b.d_dtsam == null);
    }

    @Override
    public Object clone() {
        UnitDouble dtsam = this.d_dtsam != null ? (UnitDouble)this.d_dtsam.clone() : null;
        BNDFRecord clone = new BNDFRecord(dtsam, this.d_quantity);
        for (Object param : this.d_htExtraParams.values()) {
            ExtraParam ep = (ExtraParam)param;
            clone.setExtraParam(ep.d_sName, (UnitDouble)ep.d_udValue.clone(), ep.d_unitType);
        }
        return clone;
    }

    private void updateExtraParams() {
        for (String sName : this.d_htExtraParams.keySet()) {
            Object value = this.d_htExtraParams.get(sName);
            if (!(value instanceof BNDFRecord.ExtraParam)) continue;
            BNDFRecord.ExtraParam oldParam = (BNDFRecord.ExtraParam)value;
            UnitDouble udValue = new UnitDouble(oldParam.d_dValue, SI.CELSIUS);
            ExtraParam newParam = new ExtraParam(sName, udValue, 1);
            this.d_htExtraParams.put(sName, newParam);
        }
    }

    public boolean destroy() {
        ExtraParam[] params = this.getAllExtraParams();
        for (PyroMod mod : this.getDomains()) {
            for (int m = 0; m < params.length; ++m) {
                if (params[m].d_sName.equals("CHARACTERISTIC_VELOCITY")) {
                    mod.getMiscManager().getMiscRecord().setCharVel(null);
                    continue;
                }
                if (!params[m].d_sName.equals("GAUGE_TEMPERATURE")) continue;
                mod.getMiscManager().getMiscRecord().setGaugeTemp(null);
            }
        }
        return true;
    }

    public UnitDouble getDTSam() {
        return this.d_dtsam;
    }

    public void setDTSam(UnitDouble dtsam) {
        this.d_dtsam = dtsam;
        this.fireDomainEvent(new PyroDomainEvent(this, BNDFRecord.class, 5));
    }

    public String getQuantity() {
        return this.d_quantity;
    }

    public void setQuantity(String quantity) {
        this.d_quantity = quantity;
        this.fireDomainEvent(new PyroDomainEvent(this, BNDFRecord.class, 5));
    }

    public UnitDouble getExtraParam(String paramName) {
        for (PyroMod mod : this.getDomains()) {
            if (paramName.equals("CHARACTERISTIC_VELOCITY")) {
                return mod.getMiscManager().getMiscRecord().getCharVel();
            }
            if (!paramName.equals("GAUGE_TEMPERATURE")) continue;
            return mod.getMiscManager().getMiscRecord().getGaugeTemp();
        }
        return ((ExtraParam)this.d_htExtraParams.get((Object)paramName)).d_udValue;
    }

    public int getExtraParamUnitType(String paramName) {
        return ((ExtraParam)this.d_htExtraParams.get((Object)paramName)).d_unitType;
    }

    public ExtraParam[] getAllExtraParams() {
        return this.d_htExtraParams.values().toArray(new ExtraParam[this.d_htExtraParams.size()]);
    }

    public void setExtraParam(String name, UnitDouble value, int unitType) {
        for (PyroMod mod : this.getDomains()) {
            if (name.equals("CHARACTERISTIC_VELOCITY")) {
                mod.getMiscManager().getMiscRecord().setCharVel(value);
            } else if (name.equals("GAUGE_TEMPERATURE")) {
                mod.getMiscManager().getMiscRecord().setGaugeTemp(value);
            }
            ExtraParam eparam = (ExtraParam)this.d_htExtraParams.get(name);
            if (eparam == null) {
                eparam = new ExtraParam(name, value, unitType);
                this.d_htExtraParams.put(name, eparam);
                continue;
            }
            eparam.d_udValue = value;
        }
        this.fireDomainEvent(new PyroDomainEvent(this, BNDFRecord.class, 5));
    }

    @Override
    public String getFDSType() {
        return "BNDF";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord record = new FDSInputRecord();
        record.setType("BNDF");
        record.setValue("QUANTITY", this.d_quantity);
        FdsSISystem fdsUS = FdsSISystem.getInstance();
        if (this.d_dtsam != null) {
            record.setValue("DTSAM", this.d_dtsam.getValue(fdsUS.getTimeUnit()));
        }
        ExtraParam[] params = this.getAllExtraParams();
        for (int m = 0; m < params.length; ++m) {
            if (params[m].d_sName.equals("CHARACTERISTIC_VELOCITY") || params[m].d_sName.equals("GAUGE_TEMPERATURE")) continue;
            record.setValue(params[m].d_sName, params[m].d_udValue.getValue(fdsUS.getUnit(params[m].d_unitType)));
        }
        recs.add(record);
    }

    @Override
    public String getTypeDescription() {
        return "Boundary Quantity";
    }

    static {
        FdsSISystem si = FdsSISystem.getInstance();
        d_ranges = new Hashtable(1);
        d_ranges.put("DTSAM", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), false));
    }

    public class ExtraParam
    implements Serializable {
        static final long serialVersionUID = 1L;
        int d_unitType;
        public UnitDouble d_udValue;
        public String d_sName;
        public double d_dValue;

        public ExtraParam(String name, UnitDouble value, int unitType) {
            this.d_udValue = value;
            this.d_sName = name;
            this.d_unitType = unitType;
        }
    }
}

