/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Collection;
import pyrosim.legacy_2006_2.domain.APyroManOpTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public abstract class APyroManAddAtIndexTask<K, V extends IPyroObject>
extends APyroManOpTask<K, V> {
    private final Collection<V> d_actuallyAdded;
    private final int d_index;

    protected abstract void removeAll(Collection<? extends V> var1);

    protected abstract boolean add(V var1, int var2);

    public APyroManAddAtIndexTask(IPyroManager<K, V> manager, Collection<? extends V> objs, int index) {
        super(manager, objs);
        assert (index <= manager.size() && index >= 0);
        this.d_actuallyAdded = new ArrayList<V>(objs.size());
        this.d_index = index;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void undo() {
        this.removeAll(this.d_actuallyAdded);
        this.d_actuallyAdded.clear();
    }

    @Override
    public void run() {
        ADomainObject.pauseUpdates(this.getManager());
        int addIndex = this.d_index;
        for (IPyroObject obj : this.getObjects()) {
            if (!this.add(obj, addIndex)) continue;
            this.d_actuallyAdded.add(obj);
            ++addIndex;
        }
        ADomainObject.resumeUpdates(this.getManager());
    }
}

