/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.vecmath.Point2d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class UnitPoint2D
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public UnitDouble x;
    public UnitDouble y;

    public UnitPoint2D(UnitDouble x, UnitDouble y) {
        this.x = x;
        this.y = y;
    }

    public UnitPoint2D(Point2D p, Unit unit) {
        this(p.getX(), p.getY(), unit);
    }

    public UnitPoint2D(Point2d p, Unit unit) {
        this(p.x, p.y, unit);
    }

    public UnitPoint2D(double x, double y, Unit unit) {
        this(new UnitDouble(x, unit), new UnitDouble(y, unit));
    }

    public UnitPoint2D(double[] data, Unit unit) {
        assert (data.length >= 2);
        this.x = new UnitDouble(data[0], unit);
        this.y = new UnitDouble(data[1], unit);
    }

    public Point2D.Double getValue(Unit desiredUnit) {
        return new Point2D.Double(this.x.getValue(desiredUnit), this.y.getValue(desiredUnit));
    }

    public Point2d getP2dValue(Unit desiredUnit) {
        return new Point2d(this.x.getValue(desiredUnit), this.y.getValue(desiredUnit));
    }

    public void getData(double[] data, Unit desiredUnit) {
        assert (data.length >= 2);
        data[0] = this.x.getValue(desiredUnit);
        data[1] = this.y.getValue(desiredUnit);
    }

    public Object clone() {
        return new UnitPoint2D((UnitDouble)this.x.clone(), (UnitDouble)this.y.clone());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnitPoint2D)) {
            return false;
        }
        UnitPoint2D p = (UnitPoint2D)obj;
        return this.x.equals(p.x) && this.y.equals(p.y);
    }

    public String toString() {
        if (this.x.getUnit().equals((Object)this.y.getUnit())) {
            return "(" + this.x.getValueNoUnit() + ", " + this.y.getValueNoUnit() + ") " + this.x.getUnit().toString();
        }
        return "(" + this.x + ", " + this.y + ")";
    }
}

