/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.awt.Color;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.PyroSimSelectionModel;
import pyrosim.legacy_2006_2.PyroTaskManager;
import pyrosim.legacy_2006_2.ReplaceDlg;
import pyrosim.legacy_2006_2.Serialized;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.domain.BNDFList;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.DeepFDSObjectIterator;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSConvexPoly;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectManager;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.FloorManager;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.GridList;
import pyrosim.legacy_2006_2.domain.HeadManager;
import pyrosim.legacy_2006_2.domain.HeadRecord;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.domain.Hole;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.IsofList;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.MiscManager;
import pyrosim.legacy_2006_2.domain.PL3DManager;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.domain.PartList;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.PipeManager;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.domain.RadiManager;
import pyrosim.legacy_2006_2.domain.RadiRecord;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.ReactionList;
import pyrosim.legacy_2006_2.domain.Slab;
import pyrosim.legacy_2006_2.domain.SlcfList;
import pyrosim.legacy_2006_2.domain.SlcfRecord;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.domain.SprkList;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.domain.ThcpList;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.domain.TimeManager;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.domain.dependencies.ADependencyManager;
import pyrosim.legacy_2006_2.domain.dependencies.FDSDependencyMap;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.events.FDSRasterDomainEvent;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.events.PyroModDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputFile;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.ReacProcessor;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainListener;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Mediator;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Disposable;
import pyrosim.legacy_2006_2.thunderheadeng.util.DisposableCounter;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Keyable;
import pyrosim.legacy_2006_2.thunderheadeng.util.KeyableObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.TaskManager;
import pyrosim.legacy_2006_2.thunderheadeng.util.TypedCollection;
import pyrosim.legacy_2006_2.thunderheadeng.util.TypedList;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class PyroMod
extends Mediator
implements Serializable,
Disposable {
    static final long serialVersionUID = 1L;
    public static final String DEF_DATABASE_FILENAME = "database4.data";
    public static final String DEF_DATABASE_FILEPATH = "no longer used!";
    public static final String NEWMODELPREF_DATABASE_FILE = "DatabaseFile";
    public static final String PREF_RESTART = "RestartPreviousCalculation";
    public static final String NEWMODELPREF_DTCORE = "SaveRestartFiles";
    public static final String NEWMODELPREF_SIM_END_TIME = "NewModelSimEndTime";
    public static final String NEWMODELPREF_SIM_TIME_STEP = "NewModelSimTimeStep";
    public static final String NEWMODELPREF_SIM_SYNC = "NewModelSimSync";
    public static final String NEWMODELPREF_SIM_NUM_FRAMES = "NewModelSimNumFrames";
    public static final String NEWMODELPREF_ATM_TEMP_LAPSE = "NewModelAtmosphericTempLapseRate";
    public static final String NEWMODELPREF_SIM_TMPA = "NewModelSimAmbientTemp";
    public static final String NEWMODELPREF_SIM_PRESSAMB = "NewModelSimAmbientPressure";
    public static final String NEWMODELPREF_SIM_TMPO = "NewModelSimOutsideTemp";
    public static final String NEWMODELPREF_SIM_U0 = "NewModelSimU0";
    public static final String NEWMODELPREF_SIM_V0 = "NewModelSimV0";
    public static final String NEWMODELPREF_SIM_W0 = "NewModelSimW0";
    public static final String NEWMODELPREF_AUTOMFADJUST = "NewModelAutoMixFracAdj";
    public static final String NEWMODELPREF_GPFSUPPRESS = "NewModelGasPhaseFireSup";
    public static final String NEWMODELPREF_SIM_GVECX = "NewModelSimGvecX";
    public static final String NEWMODELPREF_SIM_GVECY = "NewModelSimGvecY";
    public static final String NEWMODELPREF_SIM_GVECZ = "NewModelSimGvecZ";
    public static final String NEWMODELPREF_NULLVALUE = "null";
    public static final String NEWMODELPREF_SIM_SMAG = "SmagorinskyConstant";
    public static final String NEWMODELPREF_SIM_SCHMIDT = "SchmidtNumber";
    public static final String NEWMODELPREF_SIM_PRANDTL = "PrandtlNumber";
    public static final String PREF_ISOTHERMAL = "IsothermalCalcuation";
    public static final String PREF_INCOMPRESSIBLE = "IncompressibleCalculation";
    public static final String PREF_RADSOLVER = "RadiationSolver";
    public static final String PREF_SMOKEOFF = "3DSmokeVisualization";
    public static final String PREF_SIMTYPE = "SimulationType";
    public static final String PREF_BAROCLINIC = "BaroclinicTorque";
    public static final String PREF_LASTMATLIBRARY = "LastMaterialLib";
    public static final String PREF_LASTREACLIBRARY = "LastReactionLib";
    public static final String PREF_FDSLOCATION = "FDSLocation";
    public static final String PREF_SVLOCATION = "SVLocation";
    public static final String PREF_DXFLOCATION = "DXFLocation";
    public static final String PREF_RUNSV = "RunSV";
    public static final String PREF_DRAWCOLORBUFFER = "EnableColorBufferDrawing";
    public static final String PREF_DRAWDEPTHBUFFER = "EnableDepthBufferDrawing";
    public static final String PREF_USEVERTEXBUFFERS = "UseVertexBuffers";
    public static final String NEWMODELPREF_SPRK_POROUSFLOOR = "PorousFloor";
    public static final String NEWMODELPREF_SPRK_DTSPAR = "NewModelSprinklerDtspar";
    public static final String NEWMODELPREF_PART_DTSAM = "NewModelParticleDtsam";
    public static final String NEWMODELPREF_PART_DTPAR = "NewModelParticleDtpar";
    public static final String NEWMODELPREF_PART_NPPS = "NewModelParticleNumPartsPerSec";
    public static final String NEWMODELPREF_PART_MAXDROP = "NewModelParticleMaxDroplets";
    public static final String PREF_ANGLE_INCREMENT = "AngleIncrement";
    public static final String PREF_CH4_BANDS = "CH4Bands";
    public static final String PREF_KAPPA0 = "Kappa0";
    public static final String PREF_NMIEANG = "NMIEAng";
    public static final String PREF_NUMBER_RADIATION_ANGLES = "NumberRadAngles";
    public static final String PREF_PATH = "RadiPath";
    public static final String PREF_RADTMP = "RadSrcTemp";
    public static final String PREF_TIME_STEP_INCREMENT = "TimeStepIncrement";
    public static final String PREF_WIDE_BAND_MODEL = "WideBandModel";
    private DisposableCounter d_dc = new DisposableCounter();
    public Serialized ser;
    private final transient PyroModDependencyManager d_dependencyManager;
    private final transient TaskManager d_taskMan;
    private transient boolean d_rasterPreview = false;
    private final transient File d_sprkDir;
    private transient UnitDouble d_alignTol;
    private transient PyroSimSelectionModel d_selModel;
    private final transient FDSRasterization d_rasterizations = new FDSRasterization(this);
    private final transient HeadManager d_headManager = new HeadManager(this);
    private final transient GridList d_gridList = new GridList(this);
    private final transient TimeManager d_timeManager = new TimeManager(this);
    private final transient FloorManager d_floorManager = new FloorManager(this);
    private final transient MiscManager d_miscManager = new MiscManager(this);
    private final transient RadiManager d_radiManager = new RadiManager(this);
    private final transient PL3DManager d_pl3dManager = new PL3DManager(this);
    private final transient PipeManager d_pipeManager = new PipeManager(this);

    public PyroMod() {
        this(null, false);
    }

    public PyroMod(Serialized preSer) {
        this(preSer, false);
    }

    public PyroMod(boolean selectObjectsWhenAdded) {
        this(null, selectObjectsWhenAdded);
    }

    public PyroMod(Serialized preSer, boolean selectObjectsWhenAdded) {
        this.d_selModel = new PyroSimSelectionModel(this);
        this.d_dependencyManager = new PyroModDependencyManager();
        this.d_taskMan = new PyroTaskManager(this);
        this.d_sprkDir = PyroSim.getApp() != null ? PyroSim.getApp().getDatabaseDir() : null;
        if (preSer == null) {
            this.ser = new Serialized();
            this.resetModel();
        } else {
            this.ser = preSer;
            this.updateManagersForLegacyStorage();
        }
        this.initializeListeners();
        this.d_alignTol = null;
        this.addListener(new IDomainListener(){

            public void domainChanged(List events, Mediator domain) {
                for (Object evt : events) {
                    if (!(evt instanceof GridDomainEvent) && !(evt instanceof PyroDomainEvent) && !(evt instanceof PyroModDomainEvent)) continue;
                    PyroMod.this.d_alignTol = null;
                }
            }
        });
    }

    public UnitDouble getAlignTol() {
        if (this.d_alignTol == null) {
            this.d_alignTol = this.calcAlignTol();
        }
        return this.d_alignTol;
    }

    private UnitDouble calcAlignTol() {
        if (!this.d_gridList.isEmpty()) {
            Iterator<Grid> it = this.d_gridList.iterator();
            UnitDouble mindim = new UnitDouble(Double.MAX_VALUE, (Unit)SI.METER);
            while (it.hasNext()) {
                Grid g = it.next();
                mindim = UnitDouble.min(mindim, g.getMinXYDim());
            }
            return new UnitDouble(mindim.getValue(mindim.getUnit()) / 4.0, mindim.getUnit());
        }
        Unit lenUnit = FdsSISystem.getInstance().getLengthUnit();
        return new UnitDouble(Double.MIN_VALUE, lenUnit);
    }

    public void resetModel() {
        this.pauseUpdates(false);
        this.setPreviewMode(false);
        this.d_selModel.clearSelection();
        this.ser.d_headRecord = new HeadRecord();
        this.ser.d_walls = new FDSComposite();
        this.ser.d_walls.taskSetName("Model").run();
        this.ser.d_materials = new MaterialList(new MaterialList());
        this.ser.d_grids = new Vector();
        this.ser.d_floors = new Hashtable();
        this.ser.d_unprocessedRecords = new String();
        this.ser.d_reaction = null;
        this.ser.d_reactions = new ReactionList();
        this.ser.d_simulationEndTime = null;
        this.ser.d_restart = false;
        this.ser.d_dtcore = null;
        this.ser.d_initialTimeStep = null;
        this.ser.d_synchronized = false;
        this.ser.d_numFrames = 1000;
        this.ser.d_atmTempLapse = null;
        this.ser.d_ambientTemp = null;
        this.ser.d_ambientPressure = null;
        this.ser.d_outsideTemp = null;
        this.ser.d_initVel = null;
        this.ser.d_notPorousFloor = false;
        this.ser.d_sprkDtspar = null;
        this.ser.d_partDtpar = null;
        this.ser.d_partDtsam = null;
        this.ser.d_partNpps = null;
        this.ser.d_partMaxDrop = 500000;
        this.ser.d_useAutoMixtureFractionAdjust = true;
        this.ser.d_useGasPhaseFireSuppression = true;
        this.ser.d_gvec = null;
        this.ser.d_smag = 0.2;
        this.ser.d_schmidt = 0.5;
        this.ser.d_prandtl = 0.5;
        this.ser.d_isothermal = false;
        this.ser.d_incompressible = false;
        this.ser.d_radSolverOff = false;
        this.ser.d_radi = new RadiRecord(RadiRecord.DEFAULT);
        this.ser.d_smokeOff = false;
        this.ser.d_simulationType = 0;
        this.ser.d_baroclinic = this.ser.d_simulationType == 1 ? 1 : 0;
        this.ser.d_charVel = null;
        this.ser.d_gaugeTemp = null;
        this.ser.d_thcpList = new ThcpList();
        this.ser.d_isofList = new IsofList();
        this.ser.d_slcfList = new SlcfList();
        this.ser.d_bndfList = new BNDFList();
        this.ser.d_pl3dRecord = new PL3DRecord(null);
        this.ser.d_partList = new PartList();
        this.ser.d_sprkList = new SprkList();
        this.ser.d_pipeRecord = new PipeRecord(new UnitDouble(0.0, FdsSISystem.getInstance().getTimeUnit()), null);
        this.ser.d_heatDetectors = new HeatDetectorList();
        this.ser.d_smodList = new SmodList();
        this.ser.d_textures = new TextureDB();
        this.updateManagersForLegacyStorage();
        this.getFloorManager().taskAddDefaultFloor().run();
        this.initializeListeners();
        this.resumeUpdates(PyroModDomainEvent.newOpenInstance());
    }

    public File getDBDir() {
        return this.d_sprkDir;
    }

    @Override
    protected void fireEvents(List<IDomainEvent> events) {
        FDSRasterDomainEvent rastEvts;
        for (IDomainEvent event : events) {
            PyroDomainEvent evt;
            if (event instanceof PyroDomainEvent && (evt = (PyroDomainEvent)event).getEventType() == 4) {
                this.pauseUpdates(false);
                this.deselect(evt.getObjects());
                this.resumeUpdates();
            }
            this.d_rasterizations.respondToEvents(event);
        }
        if (this.d_rasterPreview) {
            this.d_rasterizations.rasterizeObjects();
        }
        if ((rastEvts = this.d_rasterizations.getEvents()).hasChanges()) {
            events.add(rastEvts);
            events = super.mergeEvents(events);
        }
        super.fireEvents(events);
    }

    public FDSRasterization getRasterizations() {
        return this.d_rasterizations;
    }

    public void setPreviewMode(boolean rasterPreview) {
    }

    public boolean isPreviewMode() {
        return this.d_rasterPreview;
    }

    public TaskManager getTaskManager() {
        return this.d_taskMan;
    }

    public PyroSimSelectionModel getSelectionModel() {
        return this.d_selModel;
    }

    @Override
    public void acquire() {
        this.d_dc.acquire(this);
    }

    @Override
    public void release() {
        this.d_dc.release(this);
    }

    @Override
    public void dispose() {
        this.removeListeners();
    }

    public void initializeListeners() {
        Set<Class> pyroTypes = PyroMod.getAllPyroObjectTypes();
        for (Class c : pyroTypes) {
            IPyroManager<?, PyroMod> pm = this.getPyroSimManager(c);
            pm.addDomain(this);
        }
    }

    public void removeListeners() {
        Set<Class> pyroTypes = PyroMod.getAllPyroObjectTypes();
        for (Class c : pyroTypes) {
            IPyroManager<?, PyroMod> pm = this.getPyroSimManager(c);
            pm.removeDomain(this);
        }
    }

    public void initDemoData() {
        AlignedBlock b;
        this.ser.d_materials.taskAdd(new Material("Carpet", new Color(0.1f, 0.2f, 0.3f))).run();
        this.ser.d_materials.taskAdd(new Material("Wood", new Color(0.8f, 0.8f, 0.6f))).run();
        this.ser.d_materials.taskAdd(new Material("Upholstery", new Color(0.4f, 0.5f, 0.6f))).run();
        BaseUnit unit = SI.METER;
        for (int i = -1; i < 4; ++i) {
            b = new AlignedBlock(new UnitPoint3D(i, i, i, (Unit)unit), new UnitPoint3D(i + 1, i + 1, i + 1, (Unit)unit), this.getDefaultMaterial());
            b.taskSetName("Obstruction " + i).run();
            this.ser.d_walls.taskAdd(b).run();
        }
        ((AlignedBlock)this.ser.d_walls.get(1)).setMaterial(this.ser.d_materials.get("Carpet"));
        ((AlignedBlock)this.ser.d_walls.get(3)).setMaterial(this.ser.d_materials.get("Wood"));
        FDSComposite comp = new FDSComposite();
        comp.taskSetName("Chair").run();
        b = new AlignedBlock(new UnitPoint3D(10.0, 10.0, 10.0, (Unit)unit), new UnitPoint3D(15.0, 12.0, 11.0, (Unit)unit), "Seat", this.getDefaultMaterial());
        b.setMaterial(this.ser.d_materials.get("Upholstery"));
        comp.taskAdd(b).run();
        FDSComposite arms = new FDSComposite();
        arms.taskSetName("Arms").run();
        b = new AlignedBlock(new UnitPoint3D(10.0, 10.0, 11.0, (Unit)unit), new UnitPoint3D(11.0, 12.0, 14.0, (Unit)unit), "Left Arm", this.getDefaultMaterial());
        b.setMaterial(this.ser.d_materials.get("Upholstery"));
        arms.taskAdd(b).run();
        b = new AlignedBlock(new UnitPoint3D(14.0, 10.0, 11.0, (Unit)unit), new UnitPoint3D(15.0, 12.0, 14.0, (Unit)unit), "Right Arm", this.getDefaultMaterial());
        b.setMaterial(this.ser.d_materials.get("Upholstery"));
        arms.taskAdd(b).run();
        comp.taskAdd(arms).run();
        this.ser.d_walls.taskAdd(comp).run();
        this.fireDomainEvent(PyroModDomainEvent.newOpenInstance());
    }

    public FDSComposite getObstructions() {
        return this.ser.d_walls;
    }

    public FDSObjectManager<FDSObject> getFDSObjectManager() {
        return new FDSObjectManager<FDSObject>(this.ser.d_walls, true, FDSObject.class);
    }

    public FDSObject[] getSelectedObstructionsArray() {
        Vector selection = new Vector();
        this.getSelection(this.ser.d_walls, selection);
        return selection.toArray(new FDSObject[selection.size()]);
    }

    public List<FDSObject> getSelectedObstructions() {
        Vector<FDSObject> selection = new Vector<FDSObject>();
        this.getSelection(this.ser.d_walls, selection);
        return selection;
    }

    public Collection<Grid> getSelectedGrids() {
        return this.getSelectionModel().getSelected(Grid.class);
    }

    public Collection<Material> getSelectedMaterials() {
        return this.getSelectionModel().getSelected(Material.class);
    }

    public Collection<Reaction> getSelectedReactions() {
        return this.getSelectionModel().getSelected(Reaction.class);
    }

    public List getObstructionsUsing(Material m) {
        ArrayList<FDSObject> refs = new ArrayList<FDSObject>();
        DeepFDSObjectIterator it = new DeepFDSObjectIterator(this.getObstructions());
        while (it.hasNext()) {
            FDSObject obj = it.next();
            if (!this.objectUses(obj, m)) continue;
            refs.add(obj);
        }
        return refs;
    }

    private boolean objectUses(FDSObject obj, Material m) {
        for (int i = 0; i < obj.getNumFaces(); ++i) {
            if (obj.getMaterial(i) != m) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectedDecendent(FDSObject obj) {
        FDSObject[] sel = this.getSelectedObstructionsArray();
        for (int i = 0; i < sel.length; ++i) {
            if (sel[i] == obj) {
                return true;
            }
            if (!(sel[i] instanceof FDSComposite) || !((FDSComposite)sel[i]).isDecendent(obj)) continue;
            return true;
        }
        return false;
    }

    private void getSelection(FDSObject obj, List selection) {
        if (obj.isSelected()) {
            selection.add(obj);
            return;
        }
        if (obj instanceof FDSComposite) {
            FDSComposite comp = (FDSComposite)obj;
            int count = comp.size();
            for (int i = 0; i < count; ++i) {
                this.getSelection(comp.get(i), selection);
            }
        }
    }

    public void setFDSObjectsSelected(Collection<? extends FDSObject> objs, boolean selected) {
        this.pauseUpdates();
        for (FDSObject fDSObject : objs) {
            fDSObject.setSelected(selected);
        }
        this.resumeUpdates();
    }

    public void unselectFDSObjects() {
        this.setFDSObjectsSelected(this.getSelectedObstructions(), false);
    }

    public void setSelectedFDSObjects(Collection<? extends FDSObject> objsToSelect) {
        this.pauseUpdates();
        List<FDSObject> selObsts = this.getSelectedObstructions();
        this.setFDSObjectsSelected(selObsts, false);
        this.setFDSObjectsSelected(objsToSelect, true);
        this.resumeUpdates();
    }

    public void clearSelection() {
        this.pauseUpdates();
        this.unselectFDSObjects();
        this.getSelectionModel().clearSelection();
        this.resumeUpdates();
    }

    public void select(Collection objs) {
        this.pauseUpdates();
        for (Object obj : objs) {
            this.select(obj);
        }
        this.resumeUpdates();
    }

    public void select(Object obj) {
        if (obj instanceof FDSObject) {
            ((FDSObject)obj).setSelected(true);
        } else {
            this.getSelectionModel().select(obj);
        }
    }

    public void deselect(Collection objs) {
        this.pauseUpdates();
        for (Object obj : objs) {
            this.deselect(obj);
        }
        this.resumeUpdates();
    }

    public void deselect(Object obj) {
        if (obj instanceof FDSObject) {
            ((FDSObject)obj).setSelected(false);
        } else {
            this.getSelectionModel().deselect(obj);
        }
    }

    public void setSelection(Collection objs) {
        this.pauseUpdates();
        this.clearSelection();
        this.select(objs);
        this.resumeUpdates();
    }

    public MaterialList getMaterials() {
        return this.ser.d_materials;
    }

    public ReactionList getReactions() {
        return this.ser.d_reactions;
    }

    public Task taskReorderGrids(final List<Grid> grids, int insertPt) {
        CompositeTask<PyroMod> tsk = new CompositeTask<PyroMod>(this){

            @Override
            public void undo() {
                PyroMod.this.pauseUpdates(false);
                super.undo();
                PyroMod.this.resumeUpdates(new GridDomainEvent(grids, 2));
            }

            @Override
            public void run() {
                PyroMod.this.pauseUpdates(false);
                super.run();
                PyroMod.this.resumeUpdates(new GridDomainEvent(grids, 2));
            }

            @Override
            protected void queueBeginRuntimeTasks() {
                this.addTask(PyroMod.this.getGridManager().taskRemoveAll(grids, (List<Grid>)null));
            }
        };
        int newInsertPt = insertPt;
        for (Grid g : grids) {
            int index = this.getGridManager().indexOf(g);
            if (index >= insertPt) continue;
            --newInsertPt;
        }
        tsk.addTask(this.getGridManager().taskAddAll((Collection<? extends Grid>)grids, newInsertPt));
        return tsk;
    }

    public String getUnprocessedRecords() {
        return this.ser.d_unprocessedRecords;
    }

    public void setUnprocessedRecords(String unprocessedRecords) {
        this.ser.d_unprocessedRecords = unprocessedRecords;
    }

    public Object getObjectForKey(int key) {
        return KeyableObject.KEY_GENERATOR.getFirstObjectWithKey(key);
    }

    public Set<?> getObjectsForKeys(Collection<Integer> keys) {
        HashSet<Keyable> objs = new HashSet<Keyable>(keys.size(), 1.0f);
        for (Integer key : keys) {
            Keyable value = KeyableObject.KEY_GENERATOR.getFirstObjectWithKey(key);
            if (value == null) {
                System.err.println("No object returned for key, " + key);
                continue;
            }
            objs.add(value);
        }
        return objs;
    }

    private static void showWarnings(WarningReport<Warning> warnings, boolean suppress) {
        if (!warnings.isEmpty()) {
            if (!suppress) {
                JFrame owner = null;
                if (Application.getApp() != null) {
                    owner = Application.getApp().getMainFrame();
                }
                WarningDlg<Warning> dlg = new WarningDlg<Warning>((Window)owner, Intl.intl("PSM Warnings"), Intl.intl("There were some problems reading the PyroSim file.  The following table lists the problems and how they were resolved."), warnings);
                dlg.doModal();
            } else {
                System.out.println("Warnings:\n" + warnings.prepareReport());
            }
        }
    }

    public void openModel(PyroSimObjectInputStream ois, boolean suppressWarnings) throws IOException, ClassNotFoundException, Exception {
        Serialized serNew = null;
        serNew = ois.readModel();
        if (serNew.d_textures == null) {
            serNew.d_textures = new TextureDB();
        }
        if (serNew.d_radi == null) {
            serNew.d_radi = new RadiRecord(RadiRecord.DEFAULT);
        }
        this.setSerialized(serNew);
        if (this.ser.d_floors.size() == 0) {
            this.getFloorManager().taskAddDefaultFloor().run();
        }
        this.setPreviewMode(false);
    }

    public boolean saveModel(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.ser);
        return true;
    }

    public boolean readFDS4File(String filename) throws Exception {
        this.pauseUpdates(false);
        try {
            PyroMod tempMod = new PyroMod();
            FDSInputFile reader = new FDSInputFile();
            reader.parseFile(filename, tempMod);
            tempMod.ser.d_floors = new Hashtable();
            this.setSerialized(tempMod.ser);
            this.getFloorManager().taskAddDefaultFloor().run();
            this.setPreviewMode(false);
            ReactionList rList = tempMod.getReactions();
            MiscRecord mRec = this.getMiscManager().getMiscRecord();
            if (mRec.getReaction() == null && rList.size() > 0) {
                mRec.setReaction(ReacProcessor.last.getName());
            }
            tempMod.release();
            tempMod = null;
            this.resumeUpdates(PyroModDomainEvent.newOpenInstance());
            return true;
        }
        catch (Exception e) {
            this.resumeUpdates();
            throw e;
        }
    }

    public Collection<DisplayablePointObject> getDisplayablePoints() {
        ThcpList thcpList = this.ser.d_thcpList;
        HeatDetectorList heatList = this.ser.d_heatDetectors;
        SprkList sprkList = this.ser.d_sprkList;
        SmodList smodList = this.ser.d_smodList;
        Vector<DisplayablePointObject> objects = new Vector<DisplayablePointObject>(thcpList.size() + heatList.size() + sprkList.size());
        for (ThcpRecord thcp : thcpList) {
            objects.add(thcp);
        }
        for (HeatDetector heat : heatList) {
            objects.add(heat);
        }
        for (SprkRecord sprk : sprkList) {
            objects.add(sprk);
        }
        for (SmodRecord smod : smodList) {
            objects.add(smod);
        }
        return objects;
    }

    public void setSerialized(Serialized serialized) {
        this.removeListeners();
        this.ser = serialized;
        this.updateManagersForLegacyStorage();
        this.initializeListeners();
        this.d_selModel.clearSelection();
    }

    private void updateManagersForLegacyStorage() {
        this.d_headManager.setHeadRecord(this.ser.d_headRecord);
        this.d_gridList.setGrids(this.ser.d_grids);
        this.d_floorManager.setFloors(this.ser.d_floors);
        this.d_radiManager.setRadiRecord(this.ser.d_radi);
        this.d_pl3dManager.setPL3DRecord(this.ser.d_pl3dRecord);
        this.d_pipeManager.setPipeRecord(this.ser.d_pipeRecord);
    }

    public HeadManager getHeadManager() {
        return this.d_headManager;
    }

    public void setHeadRecord(HeadRecord head) {
        this.ser.d_headRecord = head;
        this.d_headManager.setHeadRecord(head);
    }

    public GridList getGridManager() {
        return this.d_gridList;
    }

    public TimeManager getTimeManager() {
        return this.d_timeManager;
    }

    public FloorManager getFloorManager() {
        return this.d_floorManager;
    }

    public MiscManager getMiscManager() {
        return this.d_miscManager;
    }

    public RadiManager getRadiManager() {
        return this.d_radiManager;
    }

    public PL3DManager getPL3DManager() {
        return this.d_pl3dManager;
    }

    public void setPL3DRecord(PL3DRecord rec) {
        this.ser.d_pl3dRecord = rec;
        this.d_pl3dManager.setPL3DRecord(rec);
    }

    public PipeManager getPipeManager() {
        return this.d_pipeManager;
    }

    public void setPipeRecord(PipeRecord pipe) {
        this.ser.d_pipeRecord = pipe;
        this.d_pipeManager.setPipeRecord(pipe);
    }

    public ThcpList getThcpList() {
        return this.ser.d_thcpList;
    }

    public BNDFList getBNDFList() {
        return this.ser.d_bndfList;
    }

    public IsofList getIsofList() {
        return this.ser.d_isofList;
    }

    public SlcfList getSlcfList() {
        return this.ser.d_slcfList;
    }

    public PartList getPartList() {
        return this.ser.d_partList;
    }

    public SprkList getSprkList() {
        return this.ser.d_sprkList;
    }

    public HeatDetectorList getHeatDetectors() {
        return this.ser.d_heatDetectors;
    }

    public SmodList getSmokeDetectors() {
        return this.ser.d_smodList;
    }

    public TextureDB getTextureDB() {
        return this.ser.d_textures;
    }

    public Collection<TypedCollection<? extends IPyroObject>> collectAllPyroObjectsByType(Set<Class> types) {
        Vector<TypedCollection<? extends IPyroObject>> pyroObjectsByType = new Vector<TypedCollection<? extends IPyroObject>>(types.size());
        for (Class c : types) {
            Collection coll = this.getPyroSimManager(c).toCollection();
            pyroObjectsByType.add(new TypedCollection(coll, c));
        }
        return pyroObjectsByType;
    }

    public Set<IPyroObject> collectAllPyroObjects(Set<Class> types) {
        int numObjects = 0;
        for (Class c : types) {
            Collection coll = this.getPyroSimManager(c).toCollection();
            numObjects += coll.size();
        }
        HashSet<IPyroObject> allObjects = new HashSet<IPyroObject>(numObjects);
        for (Class c : types) {
            Collection coll = this.getPyroSimManager(c).toCollection();
            allObjects.addAll(coll);
        }
        return allObjects;
    }

    public static Set<Class> getAllPyroObjectTypes() {
        Set<Class> notDependedOn = PyroMod.getAllPyroObjectTypesNotDependedOn();
        Set<Class> dependedOn = PyroMod.getAllPyroObjectTypesDependedOn();
        HashSet<Class> pyroTypes = new HashSet<Class>(notDependedOn.size() + dependedOn.size());
        pyroTypes.addAll(notDependedOn);
        pyroTypes.addAll(dependedOn);
        return pyroTypes;
    }

    public static Set<Class> getAllPyroObjectTypesDependedOn() {
        Class[] types = new Class[]{SmodRecord.class, HeatDetector.class, Material.class, PartRecord.class, Reaction.class};
        return new HashSet<Class>(new VectorFromArray<Class>(types));
    }

    public static Set<Class> getAllPyroObjectTypesNotDependedOn() {
        Class[] types = new Class[]{FDSComposite.class, AlignedBlock.class, Wall.class, Slab.class, FDSConvexPoly.class, AlignedHole.class, Hole.class, Vent.class, BNDFRecord.class, Grid.class, HeadRecord.class, IsofRecord.class, MiscRecord.class, RadiRecord.class, PipeRecord.class, PL3DRecord.class, SlcfRecord.class, SprkRecord.class, ThcpRecord.class, TimeRecord.class, Floor.class};
        return new HashSet<Class>(new VectorFromArray<Class>(types));
    }

    public <T extends IPyroObject> IPyroManager<?, T> getPyroSimManager(Class<T> objectType) {
        if (objectType.equals(BNDFRecord.class)) {
            return this.getBNDFList();
        }
        if (FDSObject.class.isAssignableFrom(objectType)) {
            return new FDSObjectManager<T>(this.getObstructions(), true, objectType);
        }
        if (objectType.equals(Grid.class)) {
            return this.getGridManager();
        }
        if (objectType.equals(HeadRecord.class)) {
            return this.getHeadManager();
        }
        if (objectType.equals(HeatDetector.class)) {
            return this.getHeatDetectors();
        }
        if (objectType.equals(SmodRecord.class)) {
            return this.getSmokeDetectors();
        }
        if (objectType.equals(IsofRecord.class)) {
            return this.getIsofList();
        }
        if (objectType.equals(Material.class)) {
            return this.getMaterials();
        }
        if (objectType.equals(MiscRecord.class)) {
            return this.getMiscManager();
        }
        if (objectType.equals(RadiRecord.class)) {
            return this.getRadiManager();
        }
        if (objectType.equals(PartRecord.class)) {
            return this.getPartList();
        }
        if (objectType.equals(PipeRecord.class)) {
            return this.getPipeManager();
        }
        if (objectType.equals(PL3DRecord.class)) {
            return this.getPL3DManager();
        }
        if (objectType.equals(Reaction.class)) {
            return this.getReactions();
        }
        if (objectType.equals(SlcfRecord.class)) {
            return this.getSlcfList();
        }
        if (objectType.equals(SprkRecord.class)) {
            return this.getSprkList();
        }
        if (objectType.equals(ThcpRecord.class)) {
            return this.getThcpList();
        }
        if (objectType.equals(TimeRecord.class)) {
            return this.getTimeManager();
        }
        if (objectType.equals(Floor.class)) {
            return this.getFloorManager();
        }
        return null;
    }

    public <T> T getDefaultReplacementForObjectType(Class<T> type) {
        if (type.isAssignableFrom(Material.class)) {
            Material defaultMat = this.getDefaultMaterial();
            return type.cast(defaultMat);
        }
        return null;
    }

    public Material getDefaultMaterial() {
        return this.getMaterials().get("INERT");
    }

    public <T extends IPyroDependedOn> List<T> getReplacementsFor(TypedList<T> objects) {
        Vector<IPyroDependedOn> replacements = new Vector<IPyroDependedOn>(objects.size());
        LinkedList<T> availableReplacements = new LinkedList<T>();
        for (IPyroObject o : this.getPyroSimManager(objects.getType())) {
            availableReplacements.add(objects.getType().cast(o));
        }
        availableReplacements.removeAll(objects);
        assert (availableReplacements.size() == this.getPyroSimManager(objects.getType()).size() - objects.size());
        IPyroDependedOn defaultReplace = (IPyroDependedOn)this.getDefaultReplacementForObjectType(objects.getType());
        for (IPyroDependedOn objToReplace : objects) {
            if (this.getDependencyManager().getDependentsOf(objToReplace).size() == 0) {
                replacements.add(null);
                continue;
            }
            ReplaceDlg<IPyroDependedOn> dlg = new ReplaceDlg<IPyroDependedOn>("Replace " + objToReplace.getTypeDescription(), objToReplace, availableReplacements, defaultReplace, objects.getType());
            int res = dlg.doModal();
            if (res == 1) {
                IPyroDependedOn replacement = dlg.getReplacer();
                replacements.add(replacement);
                continue;
            }
            return null;
        }
        return replacements;
    }

    public PyroModDependencyManager getDependencyManager() {
        return this.d_dependencyManager;
    }

    public Object getLockObj() {
        return this.ser;
    }

    public static class TimeRecord
    extends ADomainObject<PyroMod>
    implements IFDSRenderable,
    IPyroObject {
        private PyroMod d_pyroMod;
        private static final Hashtable<String, ValueRange> d_ranges;

        public TimeRecord(PyroMod mediator) {
            this.d_pyroMod = mediator;
        }

        public static ValueRange getValueRange(String field) {
            return d_ranges.get(field);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof TimeRecord)) {
                return false;
            }
            TimeRecord t = (TimeRecord)o;
            boolean equal = (this.getSimulationStopTime() == null ? t.getSimulationStopTime() == null : this.getSimulationStopTime().equals(t.getSimulationStopTime())) && (this.getInitialTimeStep() == null ? t.getInitialTimeStep() == null : this.getInitialTimeStep().equals(t.getInitialTimeStep())) && this.getSyncFlag() == t.getSyncFlag();
            return equal;
        }

        @Override
        public Object clone() {
            assert (false);
            return null;
        }

        public void imprint(TimeRecord tr) {
            this.pauseUpdates(false);
            this.setInitialTimeStep(tr.getInitialTimeStep() != null ? (UnitDouble)tr.getInitialTimeStep().clone() : null);
            this.setSimulationStopTime(tr.getSimulationStopTime() != null ? (UnitDouble)tr.getSimulationStopTime().clone() : null);
            this.setSyncFlag(tr.getSyncFlag());
            this.resumeUpdates(new PyroDomainEvent(this, TimeRecord.class, 5));
        }

        public boolean getSyncFlag() {
            return this.d_pyroMod.ser.d_synchronized;
        }

        public void setSyncFlag(boolean sync) {
            this.d_pyroMod.ser.d_synchronized = sync;
            this.fireChangedEvt();
        }

        public UnitDouble getSimulationStopTime() {
            return this.d_pyroMod.ser.d_simulationEndTime;
        }

        public void setSimulationStopTime(UnitDouble stopTime) {
            this.d_pyroMod.ser.d_simulationEndTime = stopTime;
            this.fireChangedEvt();
        }

        public UnitDouble getInitialTimeStep() {
            return this.d_pyroMod.ser.d_initialTimeStep;
        }

        public void setInitialTimeStep(UnitDouble timeStep) {
            this.d_pyroMod.ser.d_initialTimeStep = timeStep;
            this.fireChangedEvt();
        }

        private void fireChangedEvt() {
            this.fireDomainEvent(new PyroDomainEvent(this, TimeRecord.class, 5));
        }

        @Override
        public String getFDSType() {
            return "TIME";
        }

        @Override
        public void getInputRecords(Collection<FDSInputRecord> recs) {
            UnitDouble timeStep;
            FDSInputRecord time = new FDSInputRecord();
            time.setType("TIME");
            FdsSISystem us = FdsSISystem.getInstance();
            UnitDouble stopTime = this.getSimulationStopTime();
            if (stopTime != null && !stopTime.equals(FDSInputRecord.DEF_TWFIN)) {
                time.setValue("TWFIN", stopTime.getValue(us.getTimeUnit()));
            }
            if ((timeStep = this.getInitialTimeStep()) != null) {
                time.setValue("DT", timeStep.getValue(us.getTimeUnit()));
            }
            if (this.getSyncFlag()) {
                time.setValue("SYNCHRONIZE", Boolean.TRUE);
            }
            if (time.getKeys().length > 0) {
                recs.add(time);
            }
        }

        @Override
        public String getTypeDescription() {
            return "Time Record";
        }

        static {
            FdsSISystem si = FdsSISystem.getInstance();
            d_ranges = new Hashtable(2);
            d_ranges.put("TWFIN", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), true));
            d_ranges.put("DT", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), false));
        }
    }

    public static class MiscRecord
    extends ADomainObject<PyroMod>
    implements IDependent,
    IFDSRenderable,
    IPyroObject {
        private PyroMod d_pyroMod;
        private static final Hashtable<String, ValueRange> d_ranges;

        public MiscRecord(PyroMod mediator) {
            this.d_pyroMod = mediator;
        }

        public static ValueRange getValueRange(String field) {
            return d_ranges.get(field);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MiscRecord)) {
                return false;
            }
            MiscRecord mr = (MiscRecord)o;
            boolean equal = (this.getDtcore() != null ? this.getDtcore().equals(mr.getDtcore()) : mr.getDtcore() == null) && (this.getAmbientTemp() != null ? this.getAmbientTemp().equals(mr.getAmbientTemp()) : mr.getAmbientTemp() == null) && (this.getAmbientPressure() != null ? this.getAmbientPressure().equals(mr.getAmbientPressure()) : mr.getAmbientPressure() == null) && (this.getInitVel() != null ? this.getInitVel().equals(mr.getInitVel()) : mr.getInitVel() == null) && (this.getCharVel() != null ? this.getCharVel().equals(mr.getCharVel()) : mr.getCharVel() == null) && (this.getGaugeTemp() != null ? this.getGaugeTemp().equals(mr.getGaugeTemp()) : mr.getGaugeTemp() == null) && (this.getAtmTempLapse() != null ? this.getAtmTempLapse().equals(mr.getAtmTempLapse()) : mr.getAtmTempLapse() == null) && (this.getOutsideTemp() != null ? this.getOutsideTemp().equals(mr.getOutsideTemp()) : mr.getOutsideTemp() == null) && (this.getSprkDtspar() != null ? this.getSprkDtspar().equals(mr.getSprkDtspar()) : mr.getSprkDtspar() == null) && (this.getPartDtsam() != null ? this.getPartDtsam().equals(mr.getPartDtsam()) : mr.getPartDtsam() == null) && (this.getPartDtpar() != null ? this.getPartDtpar().equals(mr.getPartDtpar()) : mr.getPartDtpar() == null) && (this.getPartNpps() != null ? this.getPartNpps().equals(mr.getPartNpps()) : mr.getPartNpps() == null) && (this.getReaction() != null ? this.getReaction().equals(mr.getReaction()) : mr.getReaction() == null) && (this.getGvec() != null ? this.getGvec().equals(mr.getGvec()) : mr.getGvec() == null) && this.getRestart() == mr.getRestart() && this.getNumFrames() == mr.getNumFrames() && this.getPorousFloor() == mr.getPorousFloor() && this.getPartMaxDrop() == mr.getPartMaxDrop() && this.getAutoMFAdjust() == mr.getAutoMFAdjust() && this.getGPFSuppress() == mr.getGPFSuppress() && this.getSimulationType() == mr.getSimulationType() && this.getSmag() == mr.getSmag() && this.getSchmidt() == mr.getSchmidt() && this.getPrandtl() == mr.getPrandtl() && this.getIsothermal() == mr.getIsothermal() && this.getIncompressible() == mr.getIncompressible() && this.getRadSolverOff() == mr.getRadSolverOff() && this.getSmokeOff() == mr.getSmokeOff() && this.getBaroclinic() == mr.getBaroclinic();
            return equal;
        }

        @Override
        public Object clone() {
            assert (false);
            return null;
        }

        public void imprint(MiscRecord mr) {
            this.pauseUpdates(false);
            this.setDtcore(mr.getDtcore() != null ? (UnitDouble)mr.getDtcore().clone() : null);
            this.setAmbientTemp(mr.getAmbientTemp() != null ? (UnitDouble)mr.getAmbientTemp().clone() : null);
            this.setAmbientPressure(mr.getAmbientPressure() != null ? (UnitDouble)mr.getAmbientPressure().clone() : null);
            this.setInitVel(mr.getInitVel() != null ? (UnitPoint3D)mr.getInitVel().clone() : null);
            this.setCharVel(mr.getCharVel() != null ? (UnitDouble)mr.getCharVel().clone() : null);
            this.setGaugeTemp(mr.getGaugeTemp() != null ? (UnitDouble)mr.getGaugeTemp().clone() : null);
            this.setAtmTempLapse(mr.getAtmTempLapse() != null ? (UnitDouble)mr.getAtmTempLapse().clone() : null);
            this.setOutsideTemp(mr.getOutsideTemp() != null ? (UnitDouble)mr.getOutsideTemp().clone() : null);
            this.setSprkDtspar(mr.getSprkDtspar() != null ? (UnitDouble)mr.getSprkDtspar().clone() : null);
            this.setPartDtsam(mr.getPartDtsam() != null ? (UnitDouble)mr.getPartDtsam().clone() : null);
            this.setPartDtpar(mr.getPartDtpar() != null ? (UnitDouble)mr.getPartDtpar().clone() : null);
            this.setPartNpps(mr.getPartNpps() != null ? (UnitDouble)mr.getPartNpps().clone() : null);
            this.setGvec(mr.getGvec() != null ? (UnitPoint3D)mr.getGvec().clone() : null);
            this.setRestart(mr.getRestart());
            this.setNumFrames(mr.getNumFrames());
            this.setPorousFloor(mr.getPorousFloor());
            this.setPartMaxDrop(mr.getPartMaxDrop());
            this.setReaction(mr.getReaction());
            this.setAutoMFAdjust(mr.getAutoMFAdjust());
            this.setGPFSuppress(mr.getGPFSuppress());
            this.setSimulationType(mr.getSimulationType());
            this.setSmag(mr.getSmag());
            this.setSchmidt(mr.getSchmidt());
            this.setPrandtl(mr.getPrandtl());
            this.setIsothermal(mr.getIsothermal());
            this.setIncompressible(mr.getIncompressible());
            this.setRadSolverOff(mr.getRadSolverOff());
            this.setSmokeOff(mr.getSmokeOff());
            this.setBaroclinic(mr.getBaroclinic());
            this.resumeWithEvent();
        }

        public boolean getRestart() {
            return this.d_pyroMod.ser.d_restart;
        }

        public void setRestart(boolean restart) {
            this.d_pyroMod.ser.d_restart = restart;
            this.fireChangeEvent();
        }

        public UnitDouble getDtcore() {
            return this.d_pyroMod.ser.d_dtcore;
        }

        public void setDtcore(UnitDouble dtcore) {
            this.d_pyroMod.ser.d_dtcore = dtcore;
            this.fireChangeEvent();
        }

        public UnitDouble getAmbientTemp() {
            return this.d_pyroMod.ser.d_ambientTemp;
        }

        public void setAmbientTemp(UnitDouble ambTemp) {
            this.d_pyroMod.ser.d_ambientTemp = ambTemp;
            this.fireChangeEvent();
        }

        public UnitDouble getAmbientPressure() {
            return this.d_pyroMod.ser.d_ambientPressure;
        }

        public void setAmbientPressure(UnitDouble ambPress) {
            this.d_pyroMod.ser.d_ambientPressure = ambPress;
            this.fireChangeEvent();
        }

        public UnitPoint3D getInitVel() {
            return this.d_pyroMod.ser.d_initVel;
        }

        public void setInitVel(UnitPoint3D initVel) {
            this.d_pyroMod.ser.d_initVel = initVel;
            this.fireChangeEvent();
        }

        public int getNumFrames() {
            return this.d_pyroMod.ser.d_numFrames;
        }

        public void setNumFrames(int nf) {
            this.d_pyroMod.ser.d_numFrames = nf;
            this.fireChangeEvent();
        }

        public void setCharVel(UnitDouble charVel) {
            this.d_pyroMod.ser.d_charVel = charVel;
            this.fireChangeEvent();
        }

        public UnitDouble getCharVel() {
            return this.d_pyroMod.ser.d_charVel;
        }

        public void setGaugeTemp(UnitDouble gaugeTemp) {
            this.d_pyroMod.ser.d_gaugeTemp = gaugeTemp;
            this.fireChangeEvent();
        }

        public UnitDouble getGaugeTemp() {
            return this.d_pyroMod.ser.d_gaugeTemp;
        }

        public void setAtmTempLapse(UnitDouble atmTempLapse) {
            this.d_pyroMod.ser.d_atmTempLapse = atmTempLapse;
            this.fireChangeEvent();
        }

        public UnitDouble getAtmTempLapse() {
            return this.d_pyroMod.ser.d_atmTempLapse;
        }

        public UnitDouble getOutsideTemp() {
            return this.d_pyroMod.ser.d_outsideTemp;
        }

        public void setOutsideTemp(UnitDouble outsideTemp) {
            this.d_pyroMod.ser.d_outsideTemp = outsideTemp;
            this.fireChangeEvent();
        }

        public boolean getPorousFloor() {
            return !this.d_pyroMod.ser.d_notPorousFloor;
        }

        public void setPorousFloor(boolean porousFloor) {
            this.d_pyroMod.ser.d_notPorousFloor = !porousFloor;
            this.fireChangeEvent();
        }

        public UnitDouble getSprkDtspar() {
            return this.d_pyroMod.ser.d_sprkDtspar;
        }

        public void setSprkDtspar(UnitDouble sprkDtspar) {
            this.d_pyroMod.ser.d_sprkDtspar = sprkDtspar;
            this.fireChangeEvent();
        }

        public UnitDouble getPartDtsam() {
            return this.d_pyroMod.ser.d_partDtsam;
        }

        public void setPartDtsam(UnitDouble partDtsam) {
            this.d_pyroMod.ser.d_partDtsam = partDtsam;
            this.fireChangeEvent();
        }

        public UnitDouble getPartDtpar() {
            return this.d_pyroMod.ser.d_partDtpar;
        }

        public void setPartDtpar(UnitDouble partDtpar) {
            this.d_pyroMod.ser.d_partDtpar = partDtpar;
            this.fireChangeEvent();
        }

        public UnitDouble getPartNpps() {
            return this.d_pyroMod.ser.d_partNpps;
        }

        public void setPartNpps(UnitDouble partNpps) {
            this.d_pyroMod.ser.d_partNpps = partNpps;
            this.fireChangeEvent();
        }

        public int getPartMaxDrop() {
            return this.d_pyroMod.ser.d_partMaxDrop;
        }

        public void setPartMaxDrop(int partMaxDrop) {
            this.d_pyroMod.ser.d_partMaxDrop = partMaxDrop;
            this.fireChangeEvent();
        }

        public String getReaction() {
            return this.d_pyroMod.ser.d_reaction;
        }

        public void setReaction(String reaction) {
            this.d_pyroMod.ser.d_reaction = reaction;
            this.fireChangeEvent();
        }

        public boolean getAutoMFAdjust() {
            return this.d_pyroMod.ser.d_useAutoMixtureFractionAdjust;
        }

        public void setAutoMFAdjust(boolean use) {
            this.d_pyroMod.ser.d_useAutoMixtureFractionAdjust = use;
            this.fireChangeEvent();
        }

        public boolean getGPFSuppress() {
            return this.d_pyroMod.ser.d_useGasPhaseFireSuppression;
        }

        public void setGPFSuppress(boolean use) {
            this.d_pyroMod.ser.d_useGasPhaseFireSuppression = use;
            this.fireChangeEvent();
        }

        public int getSimulationType() {
            return this.d_pyroMod.ser.d_simulationType;
        }

        public void setSimulationType(int simType) {
            this.d_pyroMod.ser.d_simulationType = simType;
            this.fireChangeEvent();
        }

        public double getSmag() {
            return this.d_pyroMod.ser.d_smag;
        }

        public void setSmag(double smag) {
            this.d_pyroMod.ser.d_smag = smag;
            this.fireChangeEvent();
        }

        public double getSchmidt() {
            return this.d_pyroMod.ser.d_schmidt;
        }

        public void setSchmidt(double schmidt) {
            this.d_pyroMod.ser.d_schmidt = schmidt;
            this.fireChangeEvent();
        }

        public double getPrandtl() {
            return this.d_pyroMod.ser.d_prandtl;
        }

        public void setPrandtl(double prandtl) {
            this.d_pyroMod.ser.d_prandtl = prandtl;
            this.fireChangeEvent();
        }

        public boolean getIsothermal() {
            return this.d_pyroMod.ser.d_isothermal;
        }

        public void setIsothermal(boolean isothermal) {
            this.d_pyroMod.ser.d_isothermal = isothermal;
            this.fireChangeEvent();
        }

        public boolean getIncompressible() {
            return this.d_pyroMod.ser.d_incompressible;
        }

        public void setIncompressible(boolean incompressible) {
            this.d_pyroMod.ser.d_incompressible = incompressible;
            this.fireChangeEvent();
        }

        public boolean getRadSolverOff() {
            return this.d_pyroMod.ser.d_radSolverOff;
        }

        public void setRadSolverOff(boolean radSolver) {
            this.d_pyroMod.ser.d_radSolverOff = radSolver;
            this.fireChangeEvent();
        }

        public RadiRecord getRadiParams() {
            return this.d_pyroMod.ser.d_radi;
        }

        public boolean getSmokeOff() {
            return this.d_pyroMod.ser.d_smokeOff;
        }

        public void setSmokeOff(boolean smokeOff) {
            this.d_pyroMod.ser.d_smokeOff = smokeOff;
            this.fireChangeEvent();
        }

        public int getBaroclinic() {
            return this.d_pyroMod.ser.d_baroclinic;
        }

        public void setBaroclinic(int baroclinic) {
            this.d_pyroMod.ser.d_baroclinic = baroclinic;
            this.fireChangeEvent();
        }

        public UnitPoint3D getGvec() {
            return this.d_pyroMod.ser.d_gvec;
        }

        public void setGvec(UnitPoint3D gvec) {
            this.d_pyroMod.ser.d_gvec = gvec;
            this.fireChangeEvent();
        }

        public void setRenderFile(String filename) {
            this.d_pyroMod.ser.d_renderFile = filename;
            this.fireChangeEvent();
        }

        public String getRenderFile() {
            return this.d_pyroMod.ser.d_renderFile;
        }

        @Override
        public String getFDSType() {
            return "MISC";
        }

        @Override
        public void getInputRecords(Collection<FDSInputRecord> recs) {
            String renderFile;
            UnitPoint3D gvec;
            boolean smokeOff;
            double smag;
            boolean useRadiation;
            boolean incompressible;
            boolean isothermal;
            int partMaxDrop;
            UnitDouble partNpps;
            UnitDouble partDtsam;
            UnitDouble partDtpar;
            UnitDouble sprkDtspar;
            boolean porousFloor;
            int numFrames;
            UnitPoint3D initVel;
            UnitDouble outTemp;
            UnitDouble ambPress;
            UnitDouble ambTemp;
            UnitDouble atmTempLapse;
            UnitDouble gaugeTemp;
            UnitDouble charVel;
            UnitDouble dtcore;
            Boolean gpfSuppress;
            Boolean autoMFAdjust;
            String reaction;
            FDSInputRecord misc = new FDSInputRecord();
            misc.setType("MISC");
            FdsSISystem us = FdsSISystem.getInstance();
            int simType = this.getSimulationType();
            if (simType != 0) {
                misc.setValue("DNS", Boolean.TRUE);
            } else {
                int baroclinic = this.getBaroclinic();
                if (baroclinic == 1) {
                    misc.setValue("BAROCLINIC", Boolean.TRUE);
                }
            }
            boolean restart = this.getRestart();
            if (restart) {
                misc.setValue("RESTART", restart);
            }
            if ((reaction = this.getReaction()) != null) {
                misc.setValue("REACTION", reaction);
            }
            if (!(autoMFAdjust = Boolean.valueOf(this.getAutoMFAdjust())).booleanValue()) {
                misc.setValue("AUTOMATIC_Z", autoMFAdjust);
            }
            if (!(gpfSuppress = Boolean.valueOf(this.getGPFSuppress())).booleanValue()) {
                misc.setValue("SUPPRESSION", gpfSuppress);
            }
            if ((dtcore = this.getDtcore()) != null) {
                misc.setValue("DTCORE", dtcore.getValue(us.getTimeUnit()));
            }
            if ((charVel = this.getCharVel()) != null) {
                misc.setValue("CHARACTERISTIC_VELOCITY", charVel.getValue(us.getVelocityUnit()));
            }
            if ((gaugeTemp = this.getGaugeTemp()) != null) {
                misc.setValue("GAUGE_TEMPERATURE", gaugeTemp.getValue(us.getTempUnit()));
            }
            if ((atmTempLapse = this.getAtmTempLapse()) != null && !atmTempLapse.equals(FDSInputRecord.DEF_DT0DZ)) {
                misc.setValue("DT0DZ", atmTempLapse.getValue(us.getAtmGradUnit()));
            }
            if ((ambTemp = this.getAmbientTemp()) != null && !ambTemp.equals(FDSInputRecord.DEF_AMBIENT_TEMP)) {
                misc.setValue("TMPA", ambTemp.getValue(us.getTempUnit()));
            }
            if ((ambPress = this.getAmbientPressure()) != null && !ambPress.equals(FDSInputRecord.DEF_AMBIENT_PRESSURE)) {
                misc.setValue("PINF", ambPress.getValue(us.getAmbientPressureUnit()));
            }
            if ((outTemp = this.getOutsideTemp()) != null && !outTemp.equals(FDSInputRecord.DEF_OUTSIDE_TEMP)) {
                misc.setValue("TMPO", outTemp.getValue(us.getTempUnit()));
            }
            if ((initVel = this.getInitVel()) != null) {
                if (!initVel.xu().equals(FDSInputRecord.DEF_INIT_VEL.xu())) {
                    misc.setValue("U0", initVel.x(us.getVelocityUnit()));
                }
                if (!initVel.yu().equals(FDSInputRecord.DEF_INIT_VEL.yu())) {
                    misc.setValue("V0", initVel.y(us.getVelocityUnit()));
                }
                if (!initVel.zu().equals(FDSInputRecord.DEF_INIT_VEL.zu())) {
                    misc.setValue("W0", initVel.z(us.getVelocityUnit()));
                }
            }
            if ((numFrames = this.getNumFrames()) != 1000) {
                misc.setValue("NFRAMES", numFrames);
            }
            if (!(porousFloor = this.getPorousFloor())) {
                misc.setValue("POROUS_FLOOR", porousFloor);
            }
            if ((sprkDtspar = this.getSprkDtspar()) != null && !sprkDtspar.equals(FDSInputRecord.DEF_DTSPAR)) {
                misc.setValue("DTSPAR", sprkDtspar.getValue(us.getTimeUnit()));
            }
            if ((partDtpar = this.getPartDtpar()) != null && !partDtpar.equals(FDSInputRecord.DEF_DTPAR)) {
                misc.setValue("DTPAR", partDtpar.getValue(us.getTimeUnit()));
            }
            if ((partDtsam = this.getPartDtsam()) != null && partDtsam.getValue(us.getTimeUnit()) > 0.0) {
                misc.setValue("DTSAM_PART", partDtsam.getValue(us.getTimeUnit()));
            }
            if ((partNpps = this.getPartNpps()) != null && !partNpps.equals(FDSInputRecord.DEF_NPPS)) {
                misc.setValue("NPPS", partNpps.getValue(us.getTimeUnit()));
            }
            if ((partMaxDrop = this.getPartMaxDrop()) != 0 && partMaxDrop != 500000) {
                misc.setValue("MAXIMUM_DROPLETS", partMaxDrop);
            }
            if (isothermal = this.getIsothermal()) {
                misc.setValue("ISOTHERMAL", isothermal);
            }
            if (incompressible = this.getIncompressible()) {
                misc.setValue("INCOMPRESSIBLE", incompressible);
            }
            boolean bl = useRadiation = !this.getRadSolverOff();
            if (!useRadiation) {
                misc.setValue("RADIATION", useRadiation);
            }
            if ((smag = this.getSmag()) != 0.2) {
                misc.setValue("CSMAG", smag);
            }
            if (simType == 0) {
                double prandtl;
                double schmidt = this.getSchmidt();
                if (schmidt != 0.5) {
                    misc.setValue("SC", schmidt);
                }
                if ((prandtl = this.getPrandtl()) != 0.5) {
                    misc.setValue("PR", prandtl);
                }
            }
            if (smokeOff = this.getSmokeOff()) {
                misc.setValue("SMOKE3D", !smokeOff);
            }
            if ((gvec = this.getGvec()) != null && !gvec.equals(FDSInputRecord.DEF_GVEC)) {
                Vector<Double> xyz = new Vector<Double>(3);
                xyz.add(gvec.x(us.getAccelUnit()));
                xyz.add(gvec.y(us.getAccelUnit()));
                xyz.add(gvec.z(us.getAccelUnit()));
                misc.setValue("GVEC", xyz);
            }
            if ((renderFile = this.getRenderFile()) != null) {
                misc.setValue("RENDER_FILE", renderFile);
            }
            if (misc.getKeys().length > 0) {
                recs.add(misc);
            }
        }

        private void fireChangeEvent() {
            if (this.belongsToADomain()) {
                this.fireDomainEvent(new PyroDomainEvent(this, MiscRecord.class, 5));
            }
        }

        private void resumeWithEvent() {
            if (this.belongsToADomain()) {
                this.resumeUpdates(new PyroDomainEvent(this, MiscRecord.class, 5));
            }
        }

        @Override
        public String getTypeDescription() {
            return "Miscellaneous Record";
        }

        @Override
        public void getObjectsDependedOn(Set<IDependedOn> dependencies, Class<IDependedOn> type) {
            Reaction r;
            String reac;
            if (type.isAssignableFrom(Reaction.class) && (reac = this.getReaction()) != null && (r = this.d_pyroMod.getReactions().get(reac)) != null) {
                dependencies.add(r);
            }
        }

        @Override
        public boolean dependsOnObject(IDependedOn depOn) {
            if (depOn instanceof Reaction) {
                Reaction depOnReac = (Reaction)depOn;
                String reac = this.getReaction();
                if (reac != null && reac.equals(depOnReac.getName())) {
                    return true;
                }
            }
            return false;
        }

        public Task taskSetReaction(String replacement) {
            return new ReplaceReactionTask(this, this.getReaction(), replacement);
        }

        @Override
        public Task taskUpdateAfterDependedOnReplaced(IDependedOn old, IDependedOn replacement) {
            assert (old instanceof Reaction);
            Reaction replR = (Reaction)replacement;
            return this.taskUpdateBeforeDependedOnRenamed(old, replR != null ? replR.getName() : null);
        }

        @Override
        public Task taskUpdateBeforeDependedOnRenamed(IDependedOn dep, String newID) {
            assert (dep instanceof Reaction);
            Reaction depOnReac = (Reaction)dep;
            assert (dep == null ? depOnReac == null : this.getReaction().equals(depOnReac.getName()));
            return this.taskSetReaction(newID);
        }

        @Override
        public Task taskUpdateAfterDependedOnChanged(IDependedOn dep, Object info) {
            return null;
        }

        static {
            FdsSISystem si = FdsSISystem.getInstance();
            d_ranges = new Hashtable(2);
            d_ranges.put("NFRAMES", IntValueRange.createCheckedMin(1, true));
            d_ranges.put("NPPS", IntValueRange.createCheckedMin(1, true));
            d_ranges.put("MAXIMUM_DROPLETS", IntValueRange.createCheckedMin(1, true));
            d_ranges.put("DTCORE", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), false));
            d_ranges.put("DTSAM_PART", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), true));
            d_ranges.put("DTSPAR", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), false));
            d_ranges.put("DTPAR", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), false));
            d_ranges.put("SC", DoubleValueRange.createCheckedMin(0.0, false));
            d_ranges.put("PR", DoubleValueRange.createCheckedMin(0.0, false));
            d_ranges.put("CSMAG", DoubleValueRange.createCheckedMin(0.0, false));
            d_ranges.put("PINF", UnitDoubleValueRange.createCheckedMin(0.0, si.getAmbientPressureUnit(), false));
        }

        private static class ReplaceReactionTask
        implements Task {
            private final MiscRecord d_owner;
            private final String d_obj;
            private final String d_replacement;

            public ReplaceReactionTask(MiscRecord owner, String obj, String repl) {
                this.d_owner = owner;
                this.d_obj = obj;
                this.d_replacement = repl;
            }

            @Override
            public boolean canUndo() {
                return true;
            }

            @Override
            public int getEst() {
                return 0;
            }

            @Override
            public void undo() {
                this.d_owner.setReaction(this.d_obj);
            }

            @Override
            public void run() {
                this.d_owner.setReaction(this.d_replacement);
            }
        }
    }

    public class PyroModDependencyManager
    extends ADependencyManager {
        @Override
        public Map<Class, Set<Class>> getPossibleDepedentsForDependedOns() {
            return FDSDependencyMap.getPossibleDependenciesForObjectsDependedOn();
        }

        @Override
        public Map<Class, Set<Class>> getPossibleDependedOnsForDependents() {
            return FDSDependencyMap.getPossibleDependenciesForDependentObjects();
        }

        @Override
        public <T extends IDependent> Iterator<T> getDependentObjectsIteratorForType(Class<T> type) {
            if (IPyroObject.class.isAssignableFrom(type)) {
                return PyroMod.this.getPyroSimManager(type).iterator();
            }
            return null;
        }

        @Override
        public <T extends IDependedOn> List<T> getReplacementsFor(TypedList<T> objects) {
            if (IPyroDependedOn.class.isAssignableFrom(objects.getType())) {
                return PyroMod.this.getReplacementsFor(objects);
            }
            return null;
        }
    }
}

