/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.AbstractUnitSystem;

public class FdsNonSISystem
extends AbstractUnitSystem {
    private static final Unit d_rti = NonSI.FOOT.multiply((Unit)SI.SECOND).root(2).label("&#8730(ft&#183s");
    private static final Unit d_density = NonSI.POUND.divide(NonSI.FOOT.pow(3));
    private static final Unit d_atmGrad = NonSI.RANKINE.divide(NonSI.FOOT).label(NonSI.FAHRENHEIT.toString() + "/" + NonSI.FOOT.toString());
    private static final Unit d_accel = NonSI.FOOT.divide(SI.SECOND.pow(2));
    private static final Unit d_ambientPressure = NonSI.MILLIMETER_OF_MERCURY;
    private static final Unit d_velocity = NonSI.FOOT.divide((Unit)SI.SECOND);
    private static final Unit d_diameter = NonSI.INCH;
    private static final Unit d_specEnergy = NonSI.BTU.divide(NonSI.POUND);
    private static final Unit d_specHeat = NonSI.BTU.divide(NonSI.POUND).divide(NonSI.RANKINE);
    private static final Unit d_absorptionCoefficient = NonSI.FOOT.pow(-1);
    private static final Unit d_REACPreExpFactor = SI.CENTI((Unit)SI.METER).pow(3).divide((Unit)SI.MOLE).divide((Unit)SI.SECOND);
    private static final Unit d_energyPerMol = NonSI.BTU.divide((Unit)SI.MOLE);
    private static final Unit d_visibility = NonSI.FOOT.pow(2).divide(NonSI.POUND);
    private static final Unit d_molecularWeight = SI.GRAM.divide((Unit)SI.MOLE);
    private static final Unit d_massFrac = SI.KILOGRAM.divide((Unit)SI.KILOGRAM);
    private static final Unit d_diffusion = NonSI.FOOT.pow(2).divide((Unit)SI.SECOND);
    private static final Unit d_conductivity = NonSI.BTU.divide(NonSI.HOUR).divide(NonSI.FOOT.multiply(NonSI.RANKINE));
    private static final Unit d_burnRate = NonSI.POUND.divide(NonSI.FOOT.pow(2)).divide((Unit)SI.SECOND);
    private static final Unit d_extCoefficient = SI.SECOND.pow(-1);
    private static final Unit d_hrrpua = NonSI.BTU.divide(NonSI.HOUR).divide(NonSI.FOOT.pow(2));
    private static final Unit d_hrrpuv = SI.KILO((Unit)SI.WATT).divide(SI.METER.pow(3));
    private static final Unit d_surfDensity = NonSI.POUND.divide(NonSI.FOOT.pow(2));
    private static final Unit d_volFlux = NonSI.FOOT.pow(3).divide((Unit)SI.SECOND);
    private static final Unit d_mixFrac = Unit.ONE.alternate("kg/kg");
    private static final Unit d_unitless = Unit.ONE;
    private static final Unit d_obscure = Unit.ONE.divide(NonSI.FOOT);
    private static final Unit d_kappa0 = Unit.ONE.divide(NonSI.FOOT);
    private static final FdsNonSISystem s_fdsSystem = new FdsNonSISystem();
    public static final String NAME = "English";

    public static FdsNonSISystem getInstance() {
        return s_fdsSystem;
    }

    @Override
    public String getSystemName() {
        return NAME;
    }

    @Override
    public Unit getDiffusionUnit() {
        return d_diffusion;
    }

    @Override
    public Unit getLengthUnit() {
        return NonSI.FOOT;
    }

    @Override
    public Unit getTempUnit() {
        return NonSI.FAHRENHEIT;
    }

    @Override
    public Unit getTimeUnit() {
        return SI.SECOND;
    }

    @Override
    public Unit getRtiUnit() {
        return d_rti;
    }

    @Override
    public Unit getDensityUnit() {
        return d_density;
    }

    @Override
    public Unit getAtmGradUnit() {
        return d_atmGrad;
    }

    @Override
    public Unit getAccelUnit() {
        return d_accel;
    }

    @Override
    public Unit getAmbientPressureUnit() {
        return d_ambientPressure;
    }

    @Override
    public Unit getVelocityUnit() {
        return d_velocity;
    }

    @Override
    public Unit getDiameterUnit() {
        return d_diameter;
    }

    @Override
    public Unit getSpecEnergyUnit() {
        return d_specEnergy;
    }

    @Override
    public Unit getSpecHeatUnit() {
        return d_specHeat;
    }

    @Override
    public Unit getPipePressureUnit() {
        return NonSI.BAR;
    }

    @Override
    public Unit getAbsorptionCoefficientUnit() {
        return d_absorptionCoefficient;
    }

    @Override
    public Unit getREACPreExpFactorUnit() {
        return d_REACPreExpFactor;
    }

    @Override
    public Unit getEnergyPerMolUnit() {
        return d_energyPerMol;
    }

    @Override
    public Unit getVisibilityUnit() {
        return d_visibility;
    }

    @Override
    public Unit getMolecularWeightUnit() {
        return d_molecularWeight;
    }

    @Override
    public Unit getMassFractionUnit() {
        return d_massFrac;
    }

    @Override
    public Unit getConductivityUnit() {
        return d_conductivity;
    }

    @Override
    public Unit getAngleUnit() {
        return NonSI.DEGREE_ANGLE;
    }

    @Override
    public Unit getBurningRateUnit() {
        return d_burnRate;
    }

    @Override
    public Unit getExtinguishingCoefficientUnit() {
        return d_extCoefficient;
    }

    @Override
    public Unit getHRRPUAUnit() {
        return d_hrrpua;
    }

    @Override
    public Unit getHRRPUVUnit() {
        return d_hrrpuv;
    }

    @Override
    public Unit getSurfaceDensityUnit() {
        return d_surfDensity;
    }

    @Override
    public Unit getVolumeFluxUnit() {
        return d_volFlux;
    }

    @Override
    public Unit getMixFracUnit() {
        return d_mixFrac;
    }

    @Override
    public Unit getObscurationUnit() {
        return d_obscure;
    }

    @Override
    public Unit getKappa0Unit() {
        return d_kappa0;
    }

    @Override
    public Unit getUnitlessUnit() {
        return d_unitless;
    }
}

