/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.DropletColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.common.ParticleQuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6UniqueRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;

public class ParticleRenderer
extends AFDS6UniqueRenderer {
    private final PinConnectionRenderer d_pinConns;

    public ParticleRenderer(FDSNameMap nameMap, PinConnectionRenderer pinConns) {
        super(nameMap);
        this.d_pinConns = pinConns;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Particle.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Particle obj = (Particle)o;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("PART");
        String id = this.getNameMap().mapToName("PART", obj);
        rec.setValue("ID", id);
        rec.setValue("FYI", obj.getFYI(), false);
        ParticleRenderer.renderCoreParams(rec, obj);
        ParticleRenderer.renderCustomFDSProps(rec, obj);
        if (obj.getInputPin().getConnections().isEmpty()) {
            props.props().pushProps();
            props.props().setRenderMultiLine(true);
            props.render(rec, o);
            props.props().popProps();
        } else {
            this.d_pinConns.markForInputRetrieval(obj.getInputPin(), rec, "CTRL_ID", "DEVC_ID");
        }
        return true;
    }

    public static void renderCoreParams(FDSRenderRecord rec, Particle part) {
        rec.setValue("STATIC", part.isStatic(), false);
        switch (part.getType()) {
            case TRACER: {
                ParticleRenderer.renderTracer(rec, part);
                break;
            }
            case LIQUID: {
                ParticleRenderer.renderLiquid(rec, part);
                break;
            }
            case SOLID: {
                ParticleRenderer.renderSolid(rec, part);
            }
        }
    }

    private static void renderTracer(FDSRenderRecord rec, Particle part) {
        rec.setValue("MASSLESS", true, true);
        ParticleRenderer.renderGeneric(rec, part, 1);
    }

    private static void renderLiquid(FDSRenderRecord rec, Particle part) {
        if (part.getSpecies() != null) {
            rec.setValue("SPEC_ID", part.getSpecies().getName());
        }
        ParticleRenderer.renderGeneric(rec, part);
        ParticleRenderer.renderDrag(rec, part);
    }

    private static void renderSolid(FDSRenderRecord rec, Particle part) {
        if (part.getSurface() != null) {
            rec.setValue("SURF_ID", part.getSurface().getName());
        }
        ParticleRenderer.renderGeneric(rec, part);
        ParticleRenderer.renderDrag(rec, part);
        ParticleRenderer.renderSizeDistribution(rec, part);
    }

    private static void renderDrag(FDSRenderRecord rec, Particle part) {
        String dragType = null;
        if (part.getDragType() == Particle.Drag.SPHERE) {
            dragType = "SPHERE";
        } else if (part.getDragType() == Particle.Drag.CYLINDER) {
            dragType = "CYLINDER";
        } else if (part.getDragType() == Particle.Drag.SCREEN) {
            dragType = "SCREEN";
        } else {
            rec.setValue("DRAG_COEFFICIENT", part.getDragCoef());
        }
        if (dragType != null) {
            rec.setValue("DRAG_LAW", dragType, false);
        }
        rec.setValue("DENSE_VOLUME_FRACTION", part.getDenseVolumeFraction(), false);
    }

    private static void renderGeneric(FDSRenderRecord rec, Particle part) {
        ParticleRenderer.renderGeneric(rec, part, 10);
    }

    private static void renderGeneric(FDSRenderRecord rec, Particle part, int defSampleFreq) {
        ParticleRenderer.renderSizeDistribution(rec, part);
        ParticleRenderer.renderColoring(rec, part.getColoring());
        ParticleRenderer.renderOutput(rec, part.getOutput(), defSampleFreq);
    }

    private static void renderSizeDistribution(FDSRenderRecord rec, Particle part) {
        if (part.getType() == Particle.Type.SOLID) {
            return;
        }
        if (part.getDiameter().isConstant()) {
            rec.setValue("DIAMETER", part.getDiameter().val, false);
        }
        if (part.getDistribution() == Particle.Distribution.CONST) {
            rec.setValue("MONODISPERSE", true, false);
            return;
        }
        rec.setValue("MINIMUM_DIAMETER", part.getMinDiameter(), false);
        rec.setValue("MAXIMUM_DIAMETER", part.getMaxDiameter(), false);
        switch (part.getDistribution()) {
            case ROSIN: {
                rec.setValue("DISTRIBUTION", "ROSIN-RAMMLER", false);
                rec.setValue("GAMMA_D", part.getGammaD(), false);
                break;
            }
            case LOGNORMAL: {
                rec.setValue("DISTRIBUTION", "LOGNORMAL", false);
                rec.setValue("SIGMA_D", part.getSigmaD(), false);
                break;
            }
            case ROSINLOGNORMAL: {
                rec.setValue("GAMMA_D", part.getGammaD(), false);
            }
        }
    }

    private static void renderColoring(FDSRenderRecord rec, IColoring coloring) {
        if (coloring == null) {
            return;
        }
        if (coloring instanceof ConstColoring) {
            ParticleRenderer.renderColor(rec, true, ((ConstColoring)coloring).color, "RGB", "COLOR", null);
        } else if (coloring instanceof DropletColoring) {
            Set<Integer> props = ((DropletColoring)coloring).d_properties;
            ArrayList<String> quantities = new ArrayList<String>(props.size());
            for (Integer prop : props) {
                quantities.add(ParticleQuantityMap.getFDSVal(prop));
            }
            rec.setValue("QUANTITIES", quantities, false);
        }
    }

    private static void renderOutput(FDSRenderRecord rec, Output output, int defSampleFreq) {
        rec.setValue("AGE", output.d_age, false);
        if (output.d_samplingFactor != defSampleFreq) {
            rec.setValue("SAMPLING_FACTOR", output.d_samplingFactor, false);
        }
    }
}

