/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.IObstructionRenderer;
import pyrosim.io.fds.v6.renderers.ObstructionRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.RotateXform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.objs.transform.TranslateXform;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GeomRenderer
extends AFDS6Renderer
implements IObstructionRenderer {
    public static final int MAX_ID_LENGTH = 30;
    private final PinConnectionRenderer d_pinRenderer;
    private final ObstructionRenderer d_obstRend;
    private RenderInfo d_ri;
    private static final FDSTransform FDS_IDENTITY = new FDSTransform();

    public GeomRenderer(FDSRasterization raster, PinConnectionRenderer pinRenderer) {
        this.d_pinRenderer = pinRenderer;
        this.d_obstRend = new ObstructionRenderer(raster, pinRenderer);
    }

    @Override
    public Map<IObstruction, List<Integer>> getObstIxes() {
        return this.d_obstRend.getObstIxes();
    }

    private static boolean hasTransform(FDSRenderRecord rec) {
        return rec.contains("AZIM") || rec.contains("ELEV") || rec.contains("GAXIS") || rec.contains("GROTATE") || rec.contains("SCALE") || rec.contains("XYZ") || rec.contains("XYZ0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        this.d_ri = new RenderInfo();
        boolean result = super.render(props, objs);
        RenderInfo ri = this.d_ri;
        props.props().pushProps();
        props.props().setRenderMultiLine(true);
        try {
            RecordInfo recinfo;
            Iterator<Map.Entry<FDSRenderRecord, RecordInfo>> entryit = ri.records.entrySet().iterator();
            while (entryit.hasNext()) {
                Map.Entry<FDSRenderRecord, RecordInfo> entry = entryit.next();
                FDSRenderRecord record = entry.getKey();
                recinfo = entry.getValue();
                if (!recinfo.compOnly || recinfo.referencedBy.size() != 1 || ri.records.get((Object)recinfo.referencedBy.get((int)0)).referencing.size() != 1 || GeomRenderer.hasTransform(record) && GeomRenderer.hasTransform(recinfo.referencedBy.get(0))) continue;
                entryit.remove();
                FDSRenderRecord parent = recinfo.referencedBy.get(0);
                RecordInfo parentInfo = ri.records.get(parent);
                parentInfo.referencing = recinfo.referencing;
                parent.setValue("GEOM_IDS", null);
                for (Map.Entry<String, Object> pentry : record.getProperties().entrySet()) {
                    if (parent.contains(pentry.getKey())) continue;
                    parent.setValue(pentry.getKey(), pentry.getValue());
                }
            }
            for (Map.Entry<FDSRenderRecord, RecordInfo> entry : ri.records.entrySet()) {
                FDSRenderRecord rec = entry.getKey();
                recinfo = entry.getValue();
                rec.setValue("COMPONENT_ONLY", recinfo.compOnly, false);
                props.render(rec, recinfo.obst);
            }
        }
        finally {
            props.props().popProps();
        }
        this.d_ri = new RenderInfo();
        return result |= this.d_obstRend.render(props, ri.toRasterize);
    }

    @Override
    protected boolean render(IFDSRecordRenderer props, IPyroObject obj) {
        IObstruction obst = (IObstruction)obj;
        if (!obst.getOptions(128)) {
            this.d_ri.toRasterize.add(obst);
            return true;
        }
        RenderInfo ri = this.d_ri;
        String name = this.nextName(obst.getName());
        int nfaces = obst.getNumFaces();
        Pair<FDSRenderRecord, RasterizeGeom> result = this.constructGeomRecords(obst, obst.getGeom(), Arrays.asList(GeomUtil.matchPrimCount(obst.getSurfaces(), Surface.class, false, nfaces)), Arrays.asList(GeomUtil.matchPrimCount(obst.getColors(), Color.class, false, nfaces)));
        FDSRenderRecord rec = (FDSRenderRecord)result.v1;
        RasterizeGeom rasterGeom = (RasterizeGeom)result.v2;
        if (rasterGeom != null && rasterGeom.isEmpty()) {
            rasterGeom = null;
        }
        if (rec == null && rasterGeom == null) {
            return false;
        }
        if (rec != null) {
            FDSRenderRecord root;
            rec = root = this.newRec(name, obst, Collections.singletonList(rec));
            ri.records.get((Object)rec).compOnly = false;
        }
        if (rasterGeom != null) {
            if (rec == null) {
                ri.toRasterize.add(obst);
            } else {
                IObstruction obstClone = (IObstruction)obst.clone();
                ArrayList<IGeom> geoms = new ArrayList<IGeom>(rasterGeom.geoms.size());
                for (Pair<TransformInfo, IGeom> geom : rasterGeom.geoms) {
                    geoms.add(((IGeom)geom.v2).transform((TransformInfo)geom.v1, 0));
                }
                obstClone.setGeom(GeomNodeUtil.newNode(thunderheadeng.geometry.objs.GeomUtil.group(geoms)));
                obstClone.setSurfaces(GeomUtil.optimize(theUtil.toArray(rasterGeom.surfs, Surface.class)));
                obstClone.setColors(GeomUtil.optimize(theUtil.toArray(rasterGeom.colors, Color.class)));
                ri.toRasterize.add(obstClone);
            }
        }
        return true;
    }

    private static int addXform(FDSTransform transform, ITransform xform, int i) {
        if (xform instanceof IdentityXform) {
            return i;
        }
        if (xform instanceof ScaleXform) {
            if (i > 0) {
                throw new RuntimeException();
            }
            ScaleXform s2 = (ScaleXform)xform;
            transform.scale = new Double[]{s2.x, s2.y, s2.z};
            return 1;
        }
        if (xform instanceof RotateXform) {
            if (i > 1) {
                throw new RuntimeException();
            }
            RotateXform r2 = (RotateXform)xform;
            AxisAngle4d aa = r2.getAxisAngle();
            Vector3d axis = new Vector3d(aa.x, aa.y, aa.z);
            Util3D.safeNormalize(axis, 0.0);
            transform.gaxis = new Double[]{axis.x, axis.y, axis.z};
            transform.grotate = new UnitDouble(-aa.angle, SI.RADIAN);
            return 2;
        }
        if (xform instanceof TranslateXform) {
            if (i > 2) {
                throw new RuntimeException();
            }
            TranslateXform t2 = (TranslateXform)xform;
            transform.xyz = new UnitDouble[]{new UnitDouble(t2.x, Geometry.LU), new UnitDouble(t2.y, Geometry.LU), new UnitDouble(t2.z, Geometry.LU)};
            return 3;
        }
        if (xform instanceof MatrixXform) {
            MatrixXform m = (MatrixXform)xform;
            AxisAngle4d[] rotate = new AxisAngle4d[]{null};
            Vector3d[] offset = new Vector3d[]{null};
            Vector3d[] scale = new Vector3d[]{null};
            Integer[] dcount = new Integer[]{0};
            thunderheadeng.geometry.objs.GeomUtil.decompose(m.xform, 1.0E-9, t -> {
                integerArray[0] = dcount[0] + 1;
                vector3dArray[0] = t;
            }, r -> {
                integerArray[0] = dcount[0] + 1;
                axisAngle4dArray[0] = r;
            }, s -> {
                integerArray[0] = dcount[0] + 1;
                vector3dArray[0] = s;
            });
            if (dcount[0] != 3) {
                throw new RuntimeException();
            }
            i = GeomRenderer.addXform(transform, TransformUtil.scale(scale[0].x, scale[0].y, scale[0].z), i);
            i = GeomRenderer.addXform(transform, TransformUtil.rotate(rotate[0]), i);
            i = GeomRenderer.addXform(transform, TransformUtil.translate(offset[0].x, offset[0].y, offset[0].z), i);
            return i;
        }
        throw new RuntimeException();
    }

    private static FDSTransform getFDSTransform(TransformInfo ti) {
        if (ti.isIdentity()) {
            return FDS_IDENTITY;
        }
        try {
            FDSTransform transform = new FDSTransform();
            Integer[] iter = new Integer[]{0};
            TransformUtil.iterateFirstToLast(ti.xform.optimize(), xform -> {
                integerArray[0] = GeomRenderer.addXform(transform, xform, iter[0]);
            });
            return transform;
        }
        catch (Throwable t) {
            if (ti.xform instanceof MatrixXform) {
                System.err.println("Non-standard transform");
                return null;
            }
            Matrix4d mat = ti.xform.toMatrix(false);
            return GeomRenderer.getFDSTransform(new MatrixXform(mat).getInfo());
        }
    }

    private Pair<FDSRenderRecord, RasterizeGeom> constructGeomRecords(IObstruction obst, IGeomNode node, List<Surface> surfs, List<Color> colors) {
        List<Surface> oSurfList = GeomRenderer.optimizeSurfList(surfs);
        Pair<FDSRenderRecord, RasterizeGeom> existing = this.d_ri.geomNodeRecords.get(new Pair<IGeomNode, List<Surface>>(node, oSurfList));
        if (existing != null) {
            return existing;
        }
        FDSTransform fdsxform = GeomRenderer.getFDSTransform(node.getLocalTransform().getInfo());
        if (fdsxform == null) {
            node = node.flatten();
            fdsxform = FDS_IDENTITY;
        }
        ArrayList<FDSRenderRecord> childRecs = new ArrayList<FDSRenderRecord>();
        RasterizeGeom childRG = new RasterizeGeom(node.getLocalTransform().getInfo());
        IGeom lgeom = node.getLocalGeom();
        int nprims = lgeom.getNumPrims(7);
        Pair<FDSRenderRecord, RasterizeGeom> localGeomRec = this.constructGeomRecords(obst, lgeom, surfs.subList(0, nprims), colors.subList(0, nprims));
        if (localGeomRec.v1 != null) {
            childRecs.add((FDSRenderRecord)localGeomRec.v1);
        }
        if (localGeomRec.v2 != null) {
            childRG.add((RasterizeGeom)localGeomRec.v2);
        }
        int propOffset = nprims;
        for (IGeomNode iGeomNode : node.getChildren()) {
            int nChildPrims = iGeomNode.getNumPrims(7);
            Pair<FDSRenderRecord, RasterizeGeom> rec = this.constructGeomRecords(obst, iGeomNode, surfs.subList(propOffset, propOffset + nChildPrims), colors.subList(propOffset, propOffset + nChildPrims));
            if (rec.v1 != null) {
                childRecs.add((FDSRenderRecord)rec.v1);
            }
            if (rec.v2 != null) {
                childRG.add((RasterizeGeom)rec.v2);
            }
            propOffset += nChildPrims;
        }
        FDSRenderRecord rec = null;
        if (!childRecs.isEmpty()) {
            if (childRecs.size() == 1 && node.getLocalTransform().isIdentity()) {
                this.generateName(obst, (FDSRenderRecord)childRecs.get(0));
                rec = (FDSRenderRecord)childRecs.get(0);
            } else {
                String string = this.nextName(obst.getName());
                rec = this.newRec(string, obst, childRecs);
                rec.setValue("ID", string);
                rec.setValue("SCALE", new FDSArray<Double>(fdsxform.scale), false);
                rec.setValue("GAXIS", new FDSArray<Double>(fdsxform.gaxis), false);
                rec.setValue("GROTATE", fdsxform.grotate, false);
                rec.setValue("XYZ", new FDSArray<UnitDouble>(fdsxform.xyz), false);
            }
        }
        this.d_ri.geomNodeRecords.put(new Pair<IGeomNode, List<Surface>>(node, oSurfList), new Pair<Object, RasterizeGeom>(rec, childRG));
        return new Pair<FDSRenderRecord, RasterizeGeom>(rec, childRG);
    }

    private String nextName(String baseName) {
        return this.d_ri.nameMap.generateName("GEOM", baseName, 30);
    }

    private String generateName(IObstruction obst, FDSRenderRecord rec) {
        String name = rec.getString("ID");
        if (name == null) {
            name = this.nextName(obst.getName() + "_part");
            rec.setValue("ID", name);
        }
        return name;
    }

    private List<String> generateNames(IObstruction obst, Collection<FDSRenderRecord> records) {
        ArrayList<String> names = new ArrayList<String>();
        for (FDSRenderRecord rec : records) {
            names.add(this.generateName(obst, rec));
        }
        return names;
    }

    private Pair<FDSRenderRecord, RasterizeGeom> constructGeomRecords(IObstruction obst, IGeom geom, List<Surface> surfList, List<Color> colorList) {
        int nprims = geom.getNumPrims(7);
        if (nprims == 0) {
            return new Pair<Object, Object>(null, null);
        }
        List<Surface> oSurfList = GeomRenderer.optimizeSurfList(surfList);
        Pair<FDSRenderRecord, RasterizeGeom> existing = this.d_ri.geomRecords.get(new Pair<IGeom, List<Surface>>(geom, oSurfList));
        if (existing != null) {
            return existing;
        }
        if (geom instanceof GeomGroup) {
            GeomGroup group = (GeomGroup)geom;
            RasterizeGeom rg = new RasterizeGeom(TransformUtil.IDENTITY_INFO);
            ArrayList<FDSRenderRecord> childRecs = new ArrayList<FDSRenderRecord>();
            int poffset = 0;
            for (IGeom child : group.children) {
                int pcount = child.getNumPrims(7);
                Pair<FDSRenderRecord, RasterizeGeom> childRec = this.constructGeomRecords(obst, child, surfList.subList(poffset, poffset + pcount), colorList.subList(poffset, poffset + pcount));
                if (childRec.v1 != null) {
                    childRecs.add((FDSRenderRecord)childRec.v1);
                }
                if (childRec.v2 != null) {
                    rg.add((RasterizeGeom)childRec.v2);
                }
                poffset += pcount;
            }
            FDSRenderRecord rec = null;
            if (!childRecs.isEmpty()) {
                rec = this.newRec(null, obst, childRecs);
            }
            this.d_ri.geomRecords.put(new Pair<IGeom, List<Surface>>(geom, oSurfList), new Pair<FDSRenderRecord, RasterizeGeom>(rec, rg));
            return new Pair<FDSRenderRecord, RasterizeGeom>(rec, rg);
        }
        if (geom.isShell()) {
            RasterizeGeom rg = new RasterizeGeom(nprims, TransformUtil.IDENTITY_INFO);
            rg.geoms.add(new Pair<TransformInfo, IGeom>(TransformUtil.IDENTITY_INFO, geom));
            rg.surfs.addAll(surfList);
            rg.colors.addAll(colorList);
            this.d_ri.geomRecords.put(new Pair<IGeom, List<Surface>>(geom, oSurfList), new Pair<Object, RasterizeGeom>(null, rg));
            return new Pair<Object, RasterizeGeom>(null, rg);
        }
        Iterator<Surface> surfit = surfList.iterator();
        LinkedIdentityHashMap surfs = new LinkedIdentityHashMap();
        LinkedHashMap verts = new LinkedHashMap();
        ArrayList faces = new ArrayList();
        IFaceConsumer addFace = (p1, p2, p3, surf) -> {
            int i1 = GeomRenderer.indexOf(verts, p1);
            int i2 = GeomRenderer.indexOf(verts, p2);
            int i3 = GeomRenderer.indexOf(verts, p3);
            if (i1 == i2 || i1 == i3 || i2 == i3) {
                return;
            }
            faces.add(i1);
            faces.add(i2);
            faces.add(i3);
            faces.add(GeomRenderer.indexOf(surfs, surf.getName()));
        };
        for (IPrimitive prim : thunderheadeng.geometry.objs.GeomUtil.explodeToTypes(geom, 7)) {
            Surface surf2 = surfit.next();
            if (!(prim instanceof IFace)) continue;
            IFace face = (IFace)prim;
            if (face instanceof Triangle) {
                Triangle tri = (Triangle)prim;
                addFace.add(tri.p1, tri.p2, tri.p3, surf2);
                continue;
            }
            Mesh triMesh = face.triangulate(0.1);
            Point3d[] mverts = triMesh.vertices;
            int[] mtris = triMesh.indices;
            for (int m = 0; m < triMesh.indices.length; m += 3) {
                addFace.add(mverts[mtris[m + 0]], mverts[mtris[m + 1]], mverts[mtris[m + 2]], surf2);
            }
        }
        if (faces.isEmpty()) {
            this.d_ri.geomRecords.put(new Pair<IGeom, List<Surface>>(geom, oSurfList), new Pair<Object, Object>(null, null));
            return new Pair<Object, Object>(null, null);
        }
        FDSRenderRecord rec = this.newRec(null, obst, Collections.emptyList());
        rec.setValue("SURF_ID", new ArrayList(surfs.keySet()));
        ArrayList<Double> vertcomps = new ArrayList<Double>(verts.size() * 3);
        for (Point3d p : verts.keySet()) {
            vertcomps.add(p.x);
            vertcomps.add(p.y);
            vertcomps.add(p.z);
        }
        rec.setValue("VERTS", vertcomps);
        rec.setValue("FACES", faces);
        this.d_ri.geomRecords.put(new Pair<IGeom, List<Surface>>(geom, oSurfList), new Pair<FDSRenderRecord, Object>(rec, null));
        return new Pair<FDSRenderRecord, Object>(rec, null);
    }

    private FDSRenderRecord newRec(String name, IObstruction obst, List<FDSRenderRecord> children) {
        FDSRenderRecord rec = FDS6Const.newRenderRecord("GEOM");
        this.d_ri.records.put(rec, new RecordInfo(obst, children));
        if (name != null) {
            rec.setValue("ID", name);
        }
        if (!children.isEmpty()) {
            rec.setValue("GEOM_IDS", this.generateNames(obst, children));
        }
        for (FDSRenderRecord child : children) {
            this.d_ri.records.get((Object)child).referencedBy.add(rec);
        }
        return rec;
    }

    private static List<Surface> optimizeSurfList(List<Surface> surfs) {
        if (surfs.isEmpty()) {
            return Collections.emptyList();
        }
        if (theUtil.isUniform(surfs)) {
            return Collections.singletonList(surfs.iterator().next());
        }
        return surfs;
    }

    private static <T> int indexOf(Map<T, Integer> verts, T p) {
        Integer ix = verts.get(p);
        if (ix == null) {
            ix = verts.size() + 1;
            verts.put(p, ix);
        }
        return ix;
    }

    private static class RecordInfo {
        public boolean compOnly = true;
        public final IObstruction obst;
        public List<FDSRenderRecord> referencing;
        public final List<FDSRenderRecord> referencedBy = new ArrayList<FDSRenderRecord>();

        public RecordInfo(IObstruction obst, List<FDSRenderRecord> referencing) {
            this.obst = obst;
            this.referencing = referencing;
        }
    }

    private static class RenderInfo {
        public final FDSNameMap nameMap = new FDSNameMap();
        public final List<IObstruction> toRasterize = new ArrayList<IObstruction>();
        public final Map<Pair<IGeom, List<Surface>>, Pair<FDSRenderRecord, RasterizeGeom>> geomRecords = new HashMap<Pair<IGeom, List<Surface>>, Pair<FDSRenderRecord, RasterizeGeom>>();
        public final Map<Pair<IGeomNode, List<Surface>>, Pair<FDSRenderRecord, RasterizeGeom>> geomNodeRecords = new HashMap<Pair<IGeomNode, List<Surface>>, Pair<FDSRenderRecord, RasterizeGeom>>();
        public final Map<FDSRenderRecord, RecordInfo> records = new LinkedIdentityHashMap<FDSRenderRecord, RecordInfo>();

        private RenderInfo() {
        }
    }

    private static class RasterizeGeom {
        public final List<Pair<TransformInfo, IGeom>> geoms = new ArrayList<Pair<TransformInfo, IGeom>>();
        public final List<Surface> surfs;
        public final List<Color> colors;
        public TransformInfo defti = TransformUtil.IDENTITY_INFO;

        public RasterizeGeom(TransformInfo defti) {
            this.surfs = new ArrayList<Surface>();
            this.colors = new ArrayList<Color>();
            this.defti = defti;
        }

        public RasterizeGeom(int nprims, TransformInfo defti) {
            this.surfs = new ArrayList<Surface>(nprims);
            this.colors = new ArrayList<Color>(nprims);
            this.defti = defti;
        }

        public boolean isEmpty() {
            return this.geoms.isEmpty();
        }

        public void add(RasterizeGeom rg) {
            this.add(this.defti, rg);
        }

        public void add(TransformInfo ti, RasterizeGeom rg) {
            for (Pair<TransformInfo, IGeom> geom : rg.geoms) {
                this.geoms.add(new Pair(ti.concatenate(((TransformInfo)geom.v1).xform), geom.v2));
            }
            this.surfs.addAll(rg.surfs);
            this.colors.addAll(rg.colors);
        }
    }

    private static interface IFaceConsumer {
        public void add(Point3d var1, Point3d var2, Point3d var3, Surface var4);
    }

    private static class FDSTransform {
        private static final UnitDouble ZERO = new UnitDouble(0.0, (Unit)SI.METER);
        public Double[] scale = new Double[]{1.0, 1.0, 1.0};
        public Double[] gaxis = new Double[]{0.0, 0.0, 0.0};
        public UnitDouble grotate = new UnitDouble(0.0, NonSI.DEGREE_ANGLE);
        public UnitDouble[] xyz = new UnitDouble[]{ZERO, ZERO, ZERO};

        private FDSTransform() {
        }
    }
}

