/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Obstruction;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDSObjParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.SolidGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GeomParser
extends AFDSObjParser {
    private final Map<String, Pair<IGeomNode, Surface[]>> d_components = new HashMap<String, Pair<IGeomNode, Surface[]>>();

    public GeomParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("GEOM");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = rec.getString("ID");
        if (id == null) {
            id = "Geom";
        }
        IGeom geom = EmptyGeom.INSTANCE;
        Surface[] surfs = new Surface[]{};
        List faces = rec.getList("FACES", true);
        List vertComps = rec.getList("VERTS", true);
        if (!faces.isEmpty() && !vertComps.isEmpty()) {
            List surfNames = rec.getList("SURF_ID", true);
            Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
            ArrayList<Surface> uniqueSurfs = new ArrayList<Surface>(surfNames.size());
            for (String surfName : surfNames) {
                uniqueSurfs.add(this.getSurfaceSafe(rec, surfName, surfFilter));
            }
            Point3d[] verts = new Point3d[vertComps.size() / 3];
            int m = 0;
            while (m < vertComps.size()) {
                int vix = m / 3;
                verts[vix] = new Point3d((Double)vertComps.get(m++), (Double)vertComps.get(m++), (Double)vertComps.get(m++));
            }
            int nfaces = faces.size() / 4;
            surfs = new Surface[nfaces];
            int soffset = 0;
            int[] indices = new int[nfaces * 3];
            int ioffset = 0;
            int m2 = 0;
            while (m2 < faces.size()) {
                indices[ioffset++] = (Integer)faces.get(m2++) - 1;
                indices[ioffset++] = (Integer)faces.get(m2++) - 1;
                indices[ioffset++] = (Integer)faces.get(m2++) - 1;
                int isurf = (Integer)faces.get(m2++);
                surfs[soffset++] = isurf == 0 ? this.getDefaultMat() : (Surface)uniqueSurfs.get(isurf - 1);
            }
            geom = new SolidGeom(new Mesh(verts, indices, 2));
        }
        List compNames = rec.getList("GEOM_IDS", true);
        List childNodes = Collections.emptyList();
        if (!compNames.isEmpty()) {
            childNodes = new ArrayList(compNames.size());
            ArrayList<Surface> allSurfs = new ArrayList<Surface>(Arrays.asList(surfs));
            for (String compName : compNames) {
                Pair<IGeomNode, Surface[]> comp = this.d_components.get(compName);
                if (comp == null) continue;
                allSurfs.addAll(Arrays.asList((Object[])comp.v2));
                childNodes.add(comp.v1);
            }
            surfs = theUtil.toArray(allSurfs, Surface.class);
            ((ArrayList)childNodes).trimToSize();
        }
        ITransform xform = GeomParser.parseTransform(rec);
        IGeomNode geomNode = GeomNodeUtil.newNode(xform, geom, Elements.NONE, childNodes);
        this.d_components.put(id, new Pair<IGeomNode, Surface[]>(geomNode, surfs));
        if (rec.getBoolean("COMPONENT_ONLY", true).booleanValue()) {
            return true;
        }
        surfs = GeomUtil.optimize(surfs);
        Obstruction obst = new Obstruction(id, geomNode, surfs);
        obst.setOptions(128, true);
        this.parseCustomFDSProps(obst, rec);
        this.addObject(obst);
        return true;
    }

    private static ITransform parseTransform(FDSParseRecord rec) {
        Function<String, Vector3d> getOffset = key -> {
            FDSArray offset = rec.getArray((String)key, true);
            return new Vector3d(((UnitDouble)offset.get(0)).get(Geometry.LU), ((UnitDouble)offset.get(1)).get(Geometry.LU), ((UnitDouble)offset.get(2)).get(Geometry.LU));
        };
        ToDoubleFunction<String> getAngle = key -> rec.getUnitDouble((String)key, true).get(Geometry.AU);
        FDSArray scale = rec.getArray("SCALE", true);
        FDSArray gaxis = rec.getArray("GAXIS", true);
        Vector3d axis = new Vector3d((Double)gaxis.get(0), (Double)gaxis.get(1), (Double)gaxis.get(2));
        if (Util3D.safeNormalize(axis, 0.0) == 0.0) {
            // empty if block
        }
        double grotate = getAngle.applyAsDouble("GROTATE");
        Vector3d xyz = getOffset.apply("XYZ");
        double azim = getAngle.applyAsDouble("AZIM");
        double elev = getAngle.applyAsDouble("ELEV");
        Vector3d xyz0 = getOffset.apply("XYZ0");
        ITransform xform = TransformUtil.translate(xyz.x, xyz.y, xyz.z).concatenate(TransformUtil.translate(xyz0.x, xyz0.y, xyz0.z)).concatenate(TransformUtil.rotate(axis.x, axis.y, axis.z, -grotate)).concatenate(TransformUtil.rotate(Math.cos(azim), Math.sin(azim), 0.0, elev)).concatenate(TransformUtil.rotate(0.0, 0.0, 1.0, azim)).concatenate(TransformUtil.scale((Double)scale.get(0), (Double)scale.get(1), (Double)scale.get(2))).concatenate(TransformUtil.translate(-xyz0.x, -xyz0.y, -xyz0.z));
        return xform;
    }
}

