/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.io.fds.LineScanner;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.util.FileWarningReport;

public class INIReader {
    private final FileWarningReport d_warnings = new FileWarningReport();
    private final AABox d_modelBounds;
    private final AABox d_gridBounds;
    private static final int ROTATION_3AXIS = 3;
    private static final int ROTATION_EYECENTERED = 1;
    private static final int ROTATION_2AXIS = 0;

    public INIReader(AABox modelBounds, AABox gridBounds) {
        this.d_modelBounds = modelBounds;
        this.d_gridBounds = gridBounds;
    }

    public FileWarningReport getWarnings() {
        return this.d_warnings;
    }

    public Collection<IPyroObject> read(InputStream in) throws IOException, ParseException {
        ArrayList<IPyroObject> viewpoints = new ArrayList<IPyroObject>();
        Type type = Type.UNKNOWN;
        LineScanner reader = new LineScanner(in);
        try {
            while (true) {
                String line;
                try {
                    line = reader.nextLine();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                if (line == null) break;
                try {
                    type = Type.valueOf(line.trim().toUpperCase());
                }
                catch (Throwable t) {
                    type = Type.UNKNOWN;
                }
                switch (type) {
                    case VIEWPOINT5: {
                        this.readViewpoint5(reader, viewpoints);
                        break;
                    }
                    case VIEWPOINT6: {
                        this.readViewpoint6(reader, viewpoints);
                    }
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ParseException(t.getLocalizedMessage(), reader.line);
        }
        ArrayList<IPyroObject> result = new ArrayList<IPyroObject>();
        for (int m = viewpoints.size() - 1; m >= 0; --m) {
            result.add((IPyroObject)viewpoints.get(m));
        }
        return result;
    }

    private void readViewpoint5(LineScanner reader, Collection<IPyroObject> objs) throws Throwable {
        this.readViewpoint(reader, objs, tokens -> {
            tokens.nextDoubles(4);
            tokens.nextLine();
            tokens.nextDoubles(4);
            tokens.nextLine();
            tokens.nextDoubles(4);
            tokens.nextLine();
            tokens.nextDoubles(4);
            tokens.nextLine();
            Matrix4d result = new Matrix4d();
            result.setIdentity();
            return result;
        });
    }

    private void readViewpoint6(LineScanner reader, Collection<IPyroObject> objs) throws Throwable {
        this.readViewpoint(reader, objs, tokens -> {
            double[] quat = tokens.nextDoubles(4);
            tokens.nextLine();
            Quat4d q = new Quat4d(quat);
            Matrix4d result = new Matrix4d();
            result.set(q);
            return result;
        });
    }

    private void readViewpoint(LineScanner toks, Collection<IPyroObject> objs, CheckedFunction<LineScanner, Matrix4d, Throwable> xformReader) throws Throwable {
        View.NavTool navTool;
        double[] dArray;
        double scale;
        boolean skip = false;
        int eyeview = toks.nextInt();
        toks.nextInt();
        toks.nextInt();
        toks.nextLine();
        double[] eye = toks.nextDoubles(3);
        double zoom = toks.nextDouble();
        zoom = 1.0;
        toks.nextInt();
        toks.nextLine();
        double view_angle = toks.nextDouble();
        double direction_angle = toks.nextDouble();
        double elevation_angle = toks.nextDouble();
        int projection_type = toks.nextInt();
        if (projection_type != 0) {
            this.d_warnings.addWarning(toks.newWarning(Intl.intl("Orthographic projections are not supported."), Intl.intl("Skipped viewpoint.")));
            skip = true;
        }
        toks.nextLine();
        double[] cen = toks.nextDoubles(3);
        toks.nextLine();
        double[] angle_zx = toks.nextDoubles(2);
        toks.nextLine();
        Matrix4d rotation_3axis = xformReader.apply(toks);
        int xyz_clipplane = toks.nextInt();
        int[] clip = toks.nextInts(6);
        toks.nextLine();
        double[] clip_vals = toks.nextDoubles(6);
        toks.nextLine();
        String name = toks.nextLine();
        if (skip) {
            return;
        }
        View view = new View(name);
        Matrix4d transform = new Matrix4d();
        transform.setIdentity();
        double d = scale = !this.d_gridBounds.isValid() ? 1.0 : DoubleStream.of(this.d_gridBounds.getWidth(), this.d_gridBounds.getHeight(), this.d_gridBounds.getDepth()).max().getAsDouble();
        if (!this.d_gridBounds.isValid()) {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.0;
            dArray2[1] = 0.0;
            dArray = dArray2;
            dArray2[2] = 0.0;
        } else {
            double[] dArray3 = new double[3];
            dArray3[0] = this.d_gridBounds.getMinX();
            dArray3[1] = this.d_gridBounds.getMinY();
            dArray = dArray3;
            dArray3[2] = this.d_gridBounds.getMinZ();
        }
        double[] gmin = dArray;
        UnaryOperator scaler = d2 -> {
            double[] result = Arrays.copyOf(d2, ((double[])d2).length);
            for (int m = 0; m < ((double[])d2).length; ++m) {
                result[m] = d2[m] * scale + gmin[m];
            }
            return result;
        };
        double StereoCameraOffset = 0.0;
        double DEG2RAD = Math.PI / 180;
        double[] camera_current_az_elev = angle_zx;
        double camera_current_azimuth = direction_angle;
        double camera_current_elevation = elevation_angle;
        double[] camera_current_cen = (double[])scaler.apply(cen);
        double[] camera_current_up = new double[]{0.0, 0.0, 1.0};
        double[] camera_current_eye = (double[])scaler.apply(eye);
        double[] zaxis_angles = new double[]{0.0, 90.0, 0.0};
        double az = zaxis_angles[0];
        double elev = zaxis_angles[1];
        Vector3d user_zaxis = new Vector3d(Math.cos(DEG2RAD * az) * Math.cos(DEG2RAD * elev), Math.sin(DEG2RAD * az) * Math.cos(DEG2RAD * elev), Math.sin(DEG2RAD * elev));
        double[] eyeINI = camera_current_eye;
        double sn_view_angle = Math.sin(DEG2RAD * view_angle);
        double cs_view_angle = Math.cos(DEG2RAD * view_angle);
        double sin_azimuth = Math.sin(DEG2RAD * camera_current_azimuth);
        double cos_azimuth = Math.cos(DEG2RAD * camera_current_azimuth);
        double xcen = camera_current_cen[0];
        double ycen = camera_current_cen[1];
        double zcen = camera_current_cen[2];
        double cos_elevation = Math.cos(DEG2RAD * camera_current_elevation);
        double sin_elevation = Math.sin(DEG2RAD * camera_current_elevation);
        double sin_dv_sum = sin_azimuth * cs_view_angle + cos_azimuth * sn_view_angle;
        double cos_dv_sum = cos_azimuth * cs_view_angle - sin_azimuth * sn_view_angle;
        double posx = eyeINI[0] + StereoCameraOffset * cos_dv_sum;
        double posy = eyeINI[1] - StereoCameraOffset * sin_dv_sum;
        double posz = eyeINI[2];
        double viewx = posx + sin_dv_sum * cos_elevation;
        double viewy = posy + cos_dv_sum * cos_elevation;
        double viewz = posz + sin_elevation;
        double elevation = camera_current_az_elev[1];
        double azimuth = camera_current_az_elev[0];
        double[] uup = camera_current_up;
        transform.mul(INIReader.gluLookAt(posx, posy, posz, viewx, viewy, viewz, uup[0], uup[1], uup[2]));
        transform.mul(Util.translateMat(xcen, ycen, zcen));
        Vector3d u = new Vector3d(0.0, 0.0, 1.0);
        Vector3d axis = new Vector3d();
        double angle = INIReader.rotateu2v(user_zaxis, u, axis);
        transform.mul(Util.rotMat(axis.x, axis.y, axis.z, angle));
        transform.mul(Util.rotMat(u.x, u.y, u.z, DEG2RAD * zaxis_angles[2]));
        if (eyeview == 3) {
            transform.mul(rotation_3axis);
        } else {
            if (eyeview == 0) {
                transform.mul(Util.rotMat(1.0, 0.0, 0.0, DEG2RAD * elevation));
            }
            transform.mul(Util.rotMat(0.0, 0.0, 1.0, DEG2RAD * azimuth));
        }
        transform.mul(Util.translateMat(-xcen, -ycen, -zcen));
        try {
            transform.invert();
        }
        catch (Throwable t) {
            this.d_warnings.addWarning(toks.newWarning(String.format(Intl.intl("Cannot reconstruct view angle from viewpoint, \"%s\"."), name), Intl.intl("Skipped viewpoint.")));
            return;
        }
        Point3d loc = new Point3d(0.0, 0.0, 0.0);
        Point3d ref = new Point3d(0.0, 0.0, -1.0);
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        transform.transform(loc);
        transform.transform(ref);
        transform.transform(up);
        double viewDist = new Point3d(camera_current_eye).distance(new Point3d(camera_current_cen));
        Vector3d viewDir = Util3D.vectorN(loc, ref);
        viewDir.scale(viewDist);
        ref = Util3D.add(loc, (Tuple3d)viewDir);
        CameraRecord rec = new CameraRecord(loc, ref, up, zoom, new Point2d(0.0, 0.0), 0.1, 10000.0, new PerspectiveCamera.FrustumRecord(0.7853981633974483));
        switch (eyeview) {
            case 1: {
                navTool = View.NavTool.ROAM;
                break;
            }
            default: {
                navTool = View.NavTool.ORBIT;
            }
        }
        view.set(View.PROP_CAMERA, new CameraState(rec));
        view.set(View.PROP_NAV_TOOL, navTool);
        if (xyz_clipplane != 0) {
            AABox box = this.d_modelBounds.scale(1.1);
            double[] bounds = new double[]{box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()};
            for (int m = 0; m < 6; ++m) {
                if (clip[m] == 0) continue;
                bounds[m] = clip_vals[m];
            }
            box = new AABox(bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5]);
            SectionBox sbox = new SectionBox(new AABoxGeom(box));
            view.set(View.PROP_SECTION_BOX, sbox);
        }
        objs.add(view);
    }

    private static double rotateu2v(Vector3d u, Vector3d v, Vector3d axis) {
        axis.cross(u, v);
        double sum = Util3D.safeNormalize(axis, 0.0);
        double normu = Util3D.safeNormalize(u, 0.0);
        double normv = Util3D.safeNormalize(v, 0.0);
        if (sum > 0.0 && normu > 0.0 && normv > 0.0) {
            axis.x /= sum;
            axis.y /= sum;
            axis.z /= sum;
            double cosangle = Util.clampT(u.dot(v) / (normu * normv), -1.0, 1.0);
            return Math.acos(cosangle);
        }
        axis.x = 0.0;
        axis.y = 0.0;
        axis.z = 1.0;
        return 0.0;
    }

    private static Matrix4d gluLookAt(double posx, double posy, double posz, double viewx, double viewy, double viewz, double upx, double upy, double upz) {
        Vector3d view = Util3D.vectorN(new Point3d(posx, posy, posz), new Point3d(viewx, viewy, viewz));
        Vector3d up = new Vector3d(upx, upy, upz);
        up.normalize();
        Vector3d right = Util3D.cross(view, up);
        up = Util3D.cross(right, view);
        Matrix4d xform = new Matrix4d(right.x, right.y, right.z, 0.0, up.x, up.y, up.z, 0.0, -view.x, -view.y, -view.z, 0.0, 0.0, 0.0, 0.0, 1.0);
        xform.mul(Util.translateMat(-posx, -posy, -posz));
        return xform;
    }

    private static List<String> getTokens(String line) {
        StringTokenizer stok = new StringTokenizer(line, " \t");
        ArrayList<String> result = new ArrayList<String>(stok.countTokens());
        while (stok.hasMoreTokens()) {
            result.add(stok.nextToken());
        }
        return result;
    }

    private static interface CheckedFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    private static enum Type {
        UNKNOWN,
        VIEWPOINT5,
        VIEWPOINT6;

    }
}

