/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pyrosim.Intl;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordDebugInfo;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSWarningReport;

public class FDSGrammar {
    private static final String REC_FIELD = "[a-zA-Z_]+[a-zA-Z_0-9]*";

    public static List<FDSParseRecord> parse(CharSequence data, String sourceFile, FDSWarningReport warnings, Map<String, FDSRecordSpec> recordSpecs, String finishRecType) throws FDSParseException {
        ArrayList<FDSParseRecord> records = new ArrayList<FDSParseRecord>();
        FDSLexer advancer = new FDSLexer(data);
        FDSParseException caughtExc = null;
        try {
            FDSParseRecord record;
            while (advancer.hasNext() && (record = FDSGrammar.readNextRecord(sourceFile, warnings, advancer, recordSpecs)) != null) {
                records.add(record);
                if (!record.getType().equals(finishRecType)) continue;
                break;
            }
        }
        catch (FDSParseException e) {
            caughtExc = e;
        }
        catch (Exception e) {
            caughtExc = new FDSParseException(sourceFile, advancer.getLineNumberLastMatch(), e.getMessage(), e.getStackTrace());
        }
        if (caughtExc != null) {
            throw caughtExc;
        }
        return records;
    }

    private static FDSParseRecord readNextRecord(String filename, FDSWarningReport warnings, FDSLexer advancer, Map<String, FDSRecordSpec> recordSpecs) throws Exception {
        String comment;
        FDSFieldAssign assign;
        boolean recBeginFound = false;
        while (advancer.hasNext()) {
            advancer.swallowSpace();
            if (!advancer.hasNext()) break;
            if (advancer.match('&', true)) {
                recBeginFound = true;
                break;
            }
            advancer.swallowLine();
        }
        if (!recBeginFound) {
            return null;
        }
        int recBeginIx = advancer.getLastMatchIx();
        int beginLine = advancer.getLineNumberLastMatch();
        String type = advancer.match(REC_FIELD, true);
        if (type == null) {
            throw new Exception(Intl.intl("Record has no type."));
        }
        type = type.toUpperCase();
        boolean recordRecognized = true;
        FDSRecordSpec recSpec = recordSpecs.get(type);
        if (recSpec == null) {
            recSpec = new FDSRecordSpec(type);
            recordRecognized = false;
        }
        ArrayList<FDSFieldAssign> fieldAssigns = new ArrayList<FDSFieldAssign>();
        while (advancer.hasNext() && advancer.peek() != '/' && (assign = FDSGrammar.extractFieldAssign(advancer)) != null) {
            fieldAssigns.add(assign);
        }
        if (advancer.match('/', false)) {
            comment = advancer.swallowLine();
            comment = comment == null ? "" : comment.trim();
        } else {
            throw new Exception(String.format(Intl.intl("Record is missing its closing '/'."), new Object[0]));
        }
        int recEndIx = advancer.getLastMatchIx();
        String recText = advancer.getText(recBeginIx, recEndIx);
        FDSRecordDebugInfo debugInfo = new FDSRecordDebugInfo(filename, recText, beginLine);
        FDSParseRecord record = new FDSParseRecord(recSpec, false);
        record.setDebugInfo(debugInfo);
        record.setComment(comment);
        for (FDSFieldAssign assign2 : fieldAssigns) {
            FDSRecordSpec.Field fieldSpec = recSpec.fields.get(assign2.field);
            if (fieldSpec == null) {
                if (recordRecognized) {
                    warnings.addWarning(new FDSParseWarning(record, String.format(Intl.intl("Unknown property, %1$s, for record %2$s."), assign2.field, type), Intl.intl("Property ignored or added to additional fields for imported object.")));
                }
                record.addUnknownProp(assign2.renderKey(), assign2.values);
                continue;
            }
            Object existingVal = record.get(assign2.field);
            if (existingVal == null) {
                existingVal = fieldSpec.newInitialValue();
            }
            Object newVal = assign2.assign(fieldSpec, existingVal);
            record.setValue(assign2.field, newVal);
        }
        return record;
    }

    private static FDSFieldAssign extractFieldAssign(FDSLexer advancer) throws Exception {
        ArrayList<IArraySubscript> subscripts = new ArrayList<IArraySubscript>();
        String fieldName = advancer.matchField(subscripts, true);
        if (fieldName == null) {
            return null;
        }
        fieldName = fieldName.toUpperCase();
        List<String> values = FDSGrammar.extractAssignmentValues(advancer);
        if (values.isEmpty()) {
            throw new Exception(String.format(Intl.intl("Invalid values specified for field, %s."), fieldName));
        }
        return new FDSFieldAssign(fieldName, subscripts, values);
    }

    private static void extractAssignmentRanges(FDSLexer advancer, List<IArraySubscript> subscripts) throws Exception {
        if (advancer.match("\\(", true) == null) {
            return;
        }
        try {
            while (advancer.hasNext()) {
                String[] range = advancer.matchMultiple("([-]?[0-9]*)\\:([-]?[0-9]*)", true);
                if (range != null) {
                    Integer ix1 = null;
                    Integer ix2 = null;
                    if (range.length > 0 && range[0] != null && range[0].length() > 0) {
                        ix1 = Integer.parseInt(range[0]);
                    }
                    if (range.length > 1 && range[1] != null && range[1].length() > 0) {
                        ix2 = Integer.parseInt(range[1]);
                    }
                    subscripts.add(new RangeSubscript(ix1, ix2));
                } else {
                    String elementIx = advancer.match("[-]?[0-9]+", true);
                    if (elementIx == null) {
                        throw new Exception(Intl.intl("Array assignment is missing a subscript."));
                    }
                    Integer ix = Integer.parseInt(elementIx);
                    subscripts.add(new ElementSubscript(ix));
                }
                if (advancer.match(',', true)) continue;
                break;
            }
        }
        catch (NumberFormatException e) {
            throw new Exception(Intl.intl("Array subscript must be an integer."));
        }
        if (advancer.match("\\)", true) == null) {
            throw new Exception(Intl.intl("Array subscript is missing its closing ')'."));
        }
    }

    private static List<String> extractAssignmentValues(FDSLexer advancer) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        while (advancer.hasNext()) {
            while (advancer.match(',', true)) {
                values.add(null);
            }
            if (advancer.matchField(new ArrayList<IArraySubscript>(), false) != null || advancer.match('/', false)) {
                advancer.unmatchLast();
                break;
            }
            String val = advancer.matchSingleVal();
            if (val == null) break;
            values.add(val);
            advancer.match(',', true);
        }
        return values;
    }

    private static class FDSLexer {
        private final CharSequence d_seq;
        private final int d_length;
        private int d_numLines = 1;
        private int d_ixNumLines = 0;
        private int d_ixLastMatch = 0;
        private int d_ix = 0;

        public FDSLexer(CharSequence seq) {
            this.d_seq = seq;
            this.d_length = this.d_seq.length();
        }

        public char peek() {
            return this.d_seq.charAt(this.d_ix);
        }

        public boolean hasNext() {
            return this.d_ix < this.d_length;
        }

        public String swallowLine() {
            String result;
            this.d_ixLastMatch = this.d_ix;
            int[] lix = this.findNext("(?m)$");
            if (lix != null) {
                result = this.d_seq.subSequence(this.d_ix, lix[0]).toString();
                this.d_ix = lix[1];
            } else {
                result = this.d_seq.subSequence(this.d_ix, this.d_seq.length()).toString();
                this.d_ix = this.d_length;
            }
            return result;
        }

        public void swallowSpace() {
            while (this.d_ix < this.d_length) {
                char c = this.d_seq.charAt(this.d_ix);
                if (Character.isWhitespace(c)) {
                    ++this.d_ix;
                    continue;
                }
                if (c == '!') {
                    this.swallowLine();
                    continue;
                }
                return;
            }
        }

        public boolean match(char m, boolean swallowSpace) {
            if (this.d_seq.charAt(this.d_ix) == m) {
                this.d_ixLastMatch = this.d_ix++;
                if (swallowSpace) {
                    this.swallowSpace();
                }
                return true;
            }
            return false;
        }

        public String matchBool() {
            return this.match("([\\.]*[tT]{1}[a-zA-Z]*[\\.]*)|([\\.]*[fF]{1}[a-zA-Z]*[\\.]*)", true);
        }

        public String matchNumber() {
            return this.match("([-+]?(([0-9]+\\.[0-9]+)|([0-9]+\\.)|(\\.[0-9]+)|([0-9]+))([eE][-+]?[0-9]+)?)", true);
        }

        public String matchString() {
            String match1 = this.match("(\\\"([^\\\"]*(\\\"\\\"[^\\\"]*)*)\\\")", true);
            if (match1 != null) {
                return match1;
            }
            String match2 = this.match("(\\'([^\\']*(\\'\\'[^\\']*)*)\\')", true);
            if (match2 != null) {
                return match2;
            }
            return null;
        }

        public String matchField(List<IArraySubscript> subscripts, boolean skipSpace) throws Exception {
            int lastIx = this.d_ix;
            String field = this.match(FDSGrammar.REC_FIELD, true);
            if (field == null) {
                return null;
            }
            FDSGrammar.extractAssignmentRanges(this, subscripts);
            if (!this.match('=', skipSpace)) {
                this.d_ixLastMatch = lastIx;
                this.d_ix = lastIx;
                return null;
            }
            this.d_ixLastMatch = lastIx;
            return field;
        }

        public int[] findNext(String regex) {
            Matcher matcher = Pattern.compile(regex).matcher(this.d_seq);
            if (!matcher.find(this.d_ix)) {
                return null;
            }
            return new int[]{matcher.start(), matcher.end()};
        }

        public String matchSingleVal() {
            String boolv = this.matchBool();
            if (boolv != null) {
                return boolv;
            }
            String numv = this.matchNumber();
            if (numv != null) {
                return numv.replaceFirst("^[+]", "");
            }
            return this.matchString();
        }

        public String match(String regex, boolean swallowSpace) {
            Matcher matcher = Pattern.compile(regex).matcher(this.d_seq).region(this.d_ix, this.d_length);
            if (!matcher.lookingAt()) {
                return null;
            }
            assert (matcher.start() == this.d_ix);
            String match = matcher.groupCount() > 0 && matcher.group(1) != null ? matcher.group(1) : matcher.group(0);
            this.d_ixLastMatch = this.d_ix;
            this.d_ix = matcher.end();
            if (swallowSpace) {
                this.swallowSpace();
            }
            return match;
        }

        public String[] matchMultiple(String regex, boolean swallowSpace) {
            Matcher matcher = Pattern.compile(regex).matcher(this.d_seq).region(this.d_ix, this.d_length);
            if (!matcher.lookingAt()) {
                return null;
            }
            assert (matcher.start() == this.d_ix);
            String[] matches = new String[matcher.groupCount()];
            for (int m = 0; m < matcher.groupCount(); ++m) {
                matches[m] = matcher.group(m + 1);
            }
            this.d_ixLastMatch = this.d_ix;
            this.d_ix = matcher.end();
            if (swallowSpace) {
                this.swallowSpace();
            }
            return matches;
        }

        public void unmatchLast() {
            this.d_ix = this.d_ixLastMatch;
        }

        public int getLastMatchIx() {
            return this.d_ixLastMatch;
        }

        public int getLineNumberLastMatch() {
            if (this.d_ixNumLines == this.d_ixLastMatch) {
                return this.d_numLines;
            }
            Matcher nlmatcher = Pattern.compile("(?m)^").matcher(this.d_seq);
            if (nlmatcher.find(this.d_ixNumLines)) {
                while (nlmatcher.find() && nlmatcher.end() <= this.d_ixLastMatch) {
                    ++this.d_numLines;
                }
                this.d_ixNumLines = this.d_ixLastMatch;
            }
            return this.d_numLines;
        }

        public String getText(int beginIx, int endIx) {
            return this.d_seq.subSequence(beginIx, endIx).toString();
        }
    }

    private static class FDSFieldAssign {
        public final String field;
        public final List<IArraySubscript> subscripts;
        public final List<String> values;

        public FDSFieldAssign(String field, List<IArraySubscript> subscripts, List<String> values) {
            this.field = field;
            this.subscripts = subscripts;
            this.values = values;
        }

        public String renderKey() {
            String key = this.field;
            if (this.subscripts.size() > 0) {
                key = key + "(";
                for (int m = 0; m < this.subscripts.size(); ++m) {
                    if (m != 0) {
                        key = key + ',';
                    }
                    key = key + this.subscripts.get(m).render();
                }
                key = key + ")";
            }
            return key;
        }

        public <T> T assign(FDSRecordSpec.Field<T> fieldSpec, T obj) throws Exception {
            int[] dimensions = fieldSpec.getDimensions();
            int[] offsets = fieldSpec.getIndexOffsets();
            ArrayList<int[]> ixes = new ArrayList<int[]>();
            if (this.subscripts.isEmpty()) {
                FDSFieldAssign.getIxes(ixes, this.values.size(), new int[dimensions.length], dimensions.length - 1, dimensions, offsets, null);
            } else {
                if (this.subscripts.size() != dimensions.length) {
                    throw new Exception(String.format(Intl.intl("Field %1$s must have 0 or %2$d subscripts."), fieldSpec.name, dimensions.length));
                }
                FDSFieldAssign.getIxes(ixes, this.values.size(), new int[dimensions.length], dimensions.length - 1, dimensions, offsets, this.subscripts);
            }
            int numVals = Math.min(ixes.size(), this.values.size());
            for (int m = 0; m < numVals; ++m) {
                int[] ix = (int[])ixes.get(m);
                obj = fieldSpec.set(obj, ix, this.values.get(m));
            }
            return obj;
        }

        private static void getIxes(List<int[]> ixes, int maxNum, int[] currIx, int dimIx, int[] dimensions, int[] offsets, List<IArraySubscript> subscripts) {
            int min = offsets[dimIx];
            int max = offsets[dimIx] + dimensions[dimIx];
            if (subscripts != null) {
                IArraySubscript subscript = subscripts.get(dimIx);
                Integer[] range = subscript.getRange();
                if (range[0] != null) {
                    min = range[0];
                }
                if (range[1] != null) {
                    max = range[1];
                }
            }
            if (dimIx == 0) {
                int m = min;
                while (m <= max) {
                    currIx[dimIx] = m++;
                    ixes.add((int[])currIx.clone());
                    if (ixes.size() < maxNum) continue;
                    return;
                }
            } else {
                int m = min;
                while (m <= max) {
                    currIx[dimIx] = m++;
                    FDSFieldAssign.getIxes(ixes, maxNum, currIx, dimIx - 1, dimensions, offsets, subscripts);
                    if (ixes.size() < maxNum) continue;
                    return;
                }
            }
        }
    }

    private static class ElementSubscript
    implements IArraySubscript {
        public final int ix;

        public ElementSubscript(int ix) {
            this.ix = ix;
        }

        @Override
        public String render() {
            return Integer.valueOf(this.ix).toString();
        }

        @Override
        public Integer[] getRange() {
            return new Integer[]{this.ix, this.ix};
        }
    }

    private static class RangeSubscript
    implements IArraySubscript {
        public final Integer ix1;
        public final Integer ix2;

        public RangeSubscript(Integer i1, Integer i2) {
            this.ix1 = i1;
            this.ix2 = i2;
        }

        @Override
        public String render() {
            if (this.ix1 != null && this.ix2 != null) {
                return this.ix1 + ":" + this.ix2;
            }
            if (this.ix1 != null) {
                return this.ix1 + ":";
            }
            if (this.ix2 != null) {
                return ":" + this.ix2;
            }
            return ":";
        }

        @Override
        public Integer[] getRange() {
            return new Integer[]{this.ix1, this.ix2};
        }
    }

    private static interface IArraySubscript {
        public String render();

        public Integer[] getRange();
    }
}

