/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.GridDisplay;
import thunderheadeng.cad.out.TeciGeomWriter;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.Filters;

public class PyroGeomFile {
    public static boolean write(File outDir, String filename, PyroMod model, Collection<? extends IPyroObject> allObjs, boolean linked, Map<IObstruction, List<Integer>> obstIxes, Map<Vent, Integer> ventIxes, boolean force, final Predicate<IHole> allowedCuttingHoles) throws IOException {
        File f = new File(outDir, filename);
        ArrayList<TeciGeomWriter.DefaultObj> objects = new ArrayList<TeciGeomWriter.DefaultObj>();
        Predicate<Surface> surfFilter = Filters.reject(model.getSurfaceMgr().get(PredefSurf.MIRROR), model.getSurfaceMgr().get(PredefSurf.OPEN), model.getSurfaceMgr().get(PredefSurf.PERIODIC));
        Surface defSurf = model.getSimParams().getMisc().getSurfDefault();
        final Collection<Grid> grids = Hierarchy.flatten(allObjs, Grid.class, new EnabledFilter());
        if (PyroPrefs.getBoolean(PyroPrefs.RESULTS_MESHBOUNDS) && surfFilter.test(defSurf)) {
            Collection<Vent> vents = Hierarchy.flatten(allObjs, Vent.class);
            GridMergeUtil.MergeResult mergedGrids = GridMergeUtil.mergeGrids(grids, vents);
            Map<Grid, GridMergeUtil.BoundaryInfo> gridFaces = mergedGrids.faces;
            for (Map.Entry<Grid, GridMergeUtil.BoundaryInfo> entry : gridFaces.entrySet()) {
                Grid g = entry.getKey();
                if (!g.isVisible()) continue;
                Point3d gcenter = g.getBounds().getCenter();
                for (Face face : entry.getValue().faces) {
                    if (!(face.plane.dot(gcenter) < 0.0)) continue;
                    face.flipOrient();
                }
                GridDisplay.DisplayData ddata = GridDisplay.generateDisplayData(entry.getValue().faces, entry.getValue().boundaryEdges, defSurf);
                IGeomNode geom = ddata.getGeom(true);
                int options = 2;
                IPrimProps.Face fprops = new IPrimProps.Face(defSurf.getColor(), defSurf.getAppearance() == null ? null : defSurf, options);
                objects.add(new TeciGeomWriter.DefaultObj(linked ? TeciGeomWriter.Type.FDS_MESH : TeciGeomWriter.Type.GENERIC, g.getName(), new DisplayGeom(geom, (IPrimProps)fprops), Collections.emptyList()));
            }
        }
        Collection<ISurfObj> objs = Hierarchy.flatten(allObjs, ISurfObj.class);
        ArrayList bgImages = new ArrayList();
        final GridMergeUtil.MergeResult[] mergedGrids = new GridMergeUtil.MergeResult[]{null};
        IPyroDisplayProps dprop = new IPyroDisplayProps(){

            @Override
            public double getFaceError() {
                return 0.1;
            }

            @Override
            public double getCurveError() {
                return 0.1;
            }

            @Override
            public Predicate<IHole> getHoleFilter() {
                return allowedCuttingHoles;
            }

            @Override
            public GridMergeUtil.MergeResult getMergedMeshes() {
                if (mergedGrids[0] == null) {
                    mergedGrids[0] = GridMergeUtil.mergeGrids(grids, Collections.emptyList());
                }
                return mergedGrids[0];
            }

            @Override
            public boolean getVentOrientVisible() {
                return false;
            }

            @Override
            public FDSRasterization getRasterizer() {
                return null;
            }

            @Override
            public ClippingManager getClippingManager() {
                return null;
            }
        };
        for (ISurfObj obj : objs) {
            if (!obj.isEnabled() || !obj.isVisible() || obj instanceof Vent && !surfFilter.test(((Vent)obj).getSurface())) continue;
            TeciGeomWriter.Type type = TeciGeomWriter.Type.GENERIC;
            Collection<Integer> ids = Collections.emptyList();
            if (linked) {
                if (obj instanceof Vent) {
                    type = TeciGeomWriter.Type.FDS_VENT;
                    Integer vix = ventIxes.get((Vent)obj);
                    if (vix != null) {
                        ids = Collections.singleton(vix);
                    }
                } else if (obj instanceof IObstruction) {
                    type = TeciGeomWriter.Type.FDS_OBST;
                    ids = obstIxes.getOrDefault((IObstruction)obj, Collections.emptyList());
                }
            }
            DisplayGeom dg = obj.getDisplayGeom(model, dprop);
            objects.add(new TeciGeomWriter.DefaultObj(type, obj.getName(), dg, ids));
        }
        if (!force && objects.isEmpty() && bgImages.isEmpty()) {
            f.delete();
            return false;
        }
        TeciGeomWriter.writeVis(f, new TeciGeomWriter.Options(PyroPrefs.getDouble(PyroPrefs.DISPLAY_EDGE_ERROR), PyroPrefs.getDouble(PyroPrefs.DISPLAY_FACE_ERROR)), objects, bgImages);
        return true;
    }
}

