/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.reaction.NewReactionDlg;
import pyrosim.gui.reaction.ReactionConfigPanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class ReactionManagerDlg
extends ManagerDlg<Reaction, ReactionList> {
    private static final long serialVersionUID = -1037669556045030814L;
    private final Action[] d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(Reaction.class), new RenameAction<Reaction, ReactionList>(this, Intl.intl("reaction")), new ManagerDlg.DeleteAction()};
    private final IEditor<Reaction> d_editor = new ReactionConfigPanel();
    private ReactionList d_mgr;
    private ExSpecList d_specs;

    public ReactionManagerDlg(JFrame frame) {
        super(frame, Intl.intl("Edit Reactions"), true);
    }

    private void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[1].setEnabled(this.d_mgr != null);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[3].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(ReactionList mgr, Reaction init, ExSpecList specs) {
        this.d_mgr = mgr;
        this.d_specs = specs;
        ((RenameAction)this.d_actions[2]).init(mgr);
        super.init(this.d_mgr, this.d_editor, this.d_actions, init);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 4782684556427102237L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ReactionManagerDlg.this.preSave()) {
                return;
            }
            int selIx = ReactionManagerDlg.this.getList().getSelectedIx();
            Reaction sugBase = selIx > -1 ? (Reaction)ReactionManagerDlg.this.getList().getItem(selIx) : null;
            NewReactionDlg dlg = new NewReactionDlg(ReactionManagerDlg.this.d_mgr, sugBase, ReactionManagerDlg.this.d_specs);
            if (dlg.doModal() == 1) {
                String name = dlg.getName();
                Reaction base = dlg.getBaseReac();
                Reaction.ReacType type = dlg.getReacType();
                Reaction reac = new Reaction(name, false, type);
                if (dlg.getFuel() != null) {
                    reac.setFuel(dlg.getFuel());
                }
                if (reac.getFuel() == null) {
                    reac.setFuel(ExSpecList.getDefaultFuel(true));
                }
                if (base != null) {
                    reac.imprint(base);
                }
                AddTask tsk = new AddTask((IPyroObject)ReactionManagerDlg.this.d_mgr, new IPyroObject[]{reac});
                PyroMod domain = (PyroMod)ReactionManagerDlg.this.d_mgr.getDomain();
                SelectTask wrapper = new SelectTask(domain, reac);
                wrapper.addTask(tsk);
                if (domain.getReactions().flatten().size() == 0) {
                    wrapper.addTask(domain.getReactions().taskSetActiveReaction(reac));
                }
                domain.getTaskManager().exec(wrapper, Intl.intl("New Reaction"));
                ReactionManagerDlg.this.getList().updateModelView(ReactionManagerDlg.this.d_mgr);
                ReactionManagerDlg.this.getList().select(reac);
                ReactionManagerDlg.this.updateActions();
            }
        }
    }
}

