/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.gui.comboboxes.ReactionComboBox;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;

public class NewReactionDlg
extends guiDialog {
    private static final long serialVersionUID = -2361461368515213155L;
    private ReactionList d_reacList = null;
    private guiTextField d_name = null;
    private guiComboBox<Reaction> d_baseReac = null;
    private guiComboBox<Reaction.ReacType> d_reacType = null;
    private guiLabel d_fuelLbl = null;
    private guiComboBox<ExSpec> d_fuelSpec = null;

    public NewReactionDlg(ReactionList reacList, Reaction defaultBase, ExSpecList specs) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("New Reaction"), 9);
        this.d_reacList = reacList;
        this.d_baseReac = this.getReacCombo(this.d_reacList, defaultBase);
        this.d_reacType = new guiComboBox();
        this.d_reacType.addItem((Reaction.ReacType)Reaction.ReacType.SIMPLE);
        this.d_reacType.addItem((Reaction.ReacType)Reaction.ReacType.COMPLEX);
        this.d_reacType.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Reaction.ReacType) {
                    this.setText(((Reaction.ReacType)((Object)value)).id);
                }
                return this;
            }
        });
        this.d_fuelLbl = new guiLabel(Intl.intl("Fuel Species:"));
        this.d_fuelSpec = new ExSpecComboBox(specs);
        this.d_fuelLbl.setVisible(false);
        this.d_fuelSpec.setVisible(false);
        this.d_reacType.addItemListener(e -> {
            boolean visible = this.d_reacType.getSelectedItem().equals((Object)Reaction.ReacType.COMPLEX);
            this.d_fuelLbl.setVisible(visible);
            this.d_fuelSpec.setVisible(visible);
        });
        this.d_name = new guiTextField(this.generateUniqueName());
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(dlgPanel, new guiLabel(Intl.intl("Reaction Name") + ":"), 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, this.d_name, 1, row++, 1, 1, 0, 0, 6, 0);
        if (!this.d_reacList.flatten().isEmpty()) {
            guiRadioButton typeReacRB = new guiRadioButton(Intl.intl("Reaction Type:"));
            GridBagUtil.add(dlgPanel, typeReacRB, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_reacType, 1, row++, 1, 1, 0, 0, 6, 0);
            GridBagUtil.add(dlgPanel, this.d_fuelLbl, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_fuelSpec, 1, row++, 1, 1, 0, 0, 6, 0);
            guiRadioButton tempReacRB = new guiRadioButton(Intl.intl("Template Reaction:"));
            GridBagUtil.add(dlgPanel, tempReacRB, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_baseReac, 1, row++, 1, 1, 0, 0, 6, 0);
            LinkStatus.link((AbstractButton)tempReacRB, this.d_baseReac);
            LinkStatus.link((AbstractButton)typeReacRB, this.d_reacType, this.d_fuelSpec);
            new guiButtonGroup(tempReacRB, typeReacRB);
            typeReacRB.setSelected(true);
        } else {
            guiLabel typeReacLab = new guiLabel(Intl.intl("Reaction Type:"));
            GridBagUtil.add(dlgPanel, typeReacLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_reacType, 1, row++, 1, 1, 0, 0, 6, 0);
            GridBagUtil.add(dlgPanel, this.d_fuelLbl, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_fuelSpec, 1, row++, 1, 1, 0, 0, 6, 0);
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        String reqName = this.d_name.getText();
        if (this.nameInUse(reqName)) {
            String msg = Intl.intl("Reaction name already in use.\nEach reaction must have a unique name.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            String msg = Intl.intl("You must name the reaction.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        if (this.d_fuelSpec.isEnabled() && this.d_fuelSpec.isVisible() && this.d_fuelSpec.getSelectedItem() == null) {
            String msg = Intl.intl("Cannot create a complex reaction without a fuel species. Add a fuel species to proceed.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    private guiComboBox<Reaction> getReacCombo(ReactionList reacList, Reaction defaultReac) {
        ReactionComboBox combo = new ReactionComboBox(reacList, defaultReac);
        return combo;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    public Reaction getBaseReac() {
        if (this.d_reacList.flatten().isEmpty()) {
            return null;
        }
        if (this.d_baseReac.isEnabled()) {
            return this.d_baseReac.getSelectedItem();
        }
        return null;
    }

    public Reaction.ReacType getReacType() {
        if (!this.d_reacType.isEnabled()) {
            return null;
        }
        return this.d_reacType.getSelectedItem();
    }

    public ExSpec getFuel() {
        if (!this.d_fuelSpec.isVisible() || !this.d_fuelSpec.isEnabled()) {
            return null;
        }
        return this.d_fuelSpec.getSelectedItem();
    }

    private String generateUniqueName() {
        return ((PyroMod)this.d_reacList.getDomain()).getNames(Reaction.class).generateName();
    }

    private boolean nameInUse(String name) {
        return ((PyroMod)this.d_reacList.getDomain()).getNames(Reaction.class).isRegistered(name);
    }
}

