/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JFrame;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.output.QuantityClipboard;
import pyrosim.gui.output.guiOutputUtil;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ComboBoxTableCell;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;

public class Slcf3dDialog
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private PyroMod d_pyroMod = ((PyroSim)Application.getApp()).getMediator();
    private guiTableEditor d_editor;
    private guiTable table;
    private Unit d_lengthUnit;
    private static final String OPT_YES = Intl.intl("YES");
    private static final String OPT_NO = Intl.intl("NO");

    public Slcf3dDialog(JFrame parent) {
        super((Window)parent, Intl.intl("Animated 3D Slices"), 9);
        UnitSystem system = ((PyroSim)Application.getApp()).getUnitSystem();
        this.d_lengthUnit = system.getLengthUnit();
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        String[] headers = (String[])Stream.of(COLUMN_IDS.values()).map(colEntr -> colEntr.name).toArray(String[]::new);
        Class[] clazzez = (Class[])Stream.of(COLUMN_IDS.values()).map(colEntr -> colEntr.clazz).toArray(Class[]::new);
        this.d_editor = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, clazzez), 30);
        this.table = this.d_editor.getTable();
        this.table.setNullValuesAllowed(false);
        Stream.of(COLUMN_IDS.values()).filter(colEntr -> colEntr.clazz.isAssignableFrom(UnitDouble.class)).forEach(colEntr -> {
            this.table.getColumnModel().getColumn(colEntr.ordinal()).setCellEditor(new guiTable.UnitDoubleEditor(this.d_lengthUnit));
            this.table.getColumnModel().getColumn(colEntr.ordinal()).setCellRenderer(new guiTable.UnitDoubleRenderer());
        });
        QuantityComboBox quantityBox = new QuantityComboBox(128L, QuantityType.GAS);
        ComboBoxTableCell<IQuantity> cell = new ComboBoxTableCell<IQuantity>(quantityBox);
        QuantityUtil.TypeFilter quantFilter = new QuantityUtil.TypeFilter(128L, QuantityType.GAS);
        this.table.setClipboard(COLUMN_IDS.GASPHASE.ordinal(), (guiTableClipboard)new QuantityClipboard(quantFilter));
        this.table.getColumnModel().getColumn(COLUMN_IDS.GASPHASE.ordinal()).setCellRenderer(cell);
        this.table.getColumnModel().getColumn(COLUMN_IDS.GASPHASE.ordinal()).setCellEditor(cell);
        this.table.setColumnOptions(COLUMN_IDS.USEVEC.ordinal(), OPT_YES, OPT_NO);
        this.table.setColumnOptions(COLUMN_IDS.CELLCENTER.ordinal(), OPT_YES, OPT_NO);
        this.loadData();
        this.table.autoSizeColumns(200);
        GridBagUtil.add(dlgPanel, this.d_editor, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        int height = this.table.getRowHeight();
        this.table.setRowHeight(height + 1);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        VolumeSlice[] vslices = this.getSlices();
        if (!Slcf3dDialog.noTwo3DSlicesSame(vslices)) {
            this.doWarn(Intl.intl("Error: Duplicate values of the same quantity are not permitted."));
            return false;
        }
        Set ids = Stream.of(vslices).map(vs -> vs.getName()).collect(Collectors.toSet());
        if (ids.size() != vslices.length) {
            this.doWarn(Intl.intl("Error: All slice IDs must be unique."));
            return false;
        }
        return true;
    }

    private void doWarn(String msg) {
        this.showMessageBox(msg);
        this.requestFocusHack();
    }

    private Collection<VolumeSlice> getAll3DSlices() {
        return ((APyroObject)this.d_pyroMod.getSlcf3dList()).flatten(VolumeSlice.class);
    }

    public void setInitialSel(Collection<? extends VolumeSlice> slices) {
        this.table.clearSelection();
        this.table.setColumnSelectionInterval(0, COLUMN_IDS.values().length - 1);
        for (Slice slice : slices) {
            int ix = Util.indexOf(this.getAll3DSlices(), slice);
            if (ix < 0) continue;
            this.table.addRowSelectionInterval(ix, ix);
        }
    }

    public void loadData() {
        Collection<VolumeSlice> slices = this.getAll3DSlices();
        int numRows = slices.size();
        if (numRows > 0) {
            guiDefaultTableModel model = (guiDefaultTableModel)this.table.getModel();
            int i = 0;
            for (VolumeSlice slice : slices) {
                String name = slice.getName();
                UnitAABox bounds = GeomUtil.getUnitBounds(slice);
                boolean includeVec = slice.includeFlowVector();
                String vecStr = includeVec ? OPT_YES : OPT_NO;
                boolean cellCentered = slice.isCellCentered();
                String centerStr = cellCentered ? OPT_YES : OPT_NO;
                model.setValueAt(name, i, COLUMN_IDS.ID.ordinal());
                model.setValueAt(bounds.getMin().xu().convert(this.d_lengthUnit), i, COLUMN_IDS.MINX.ordinal());
                model.setValueAt(bounds.getMax().xu().convert(this.d_lengthUnit), i, COLUMN_IDS.MAXX.ordinal());
                model.setValueAt(bounds.getMin().yu().convert(this.d_lengthUnit), i, COLUMN_IDS.MINY.ordinal());
                model.setValueAt(bounds.getMax().yu().convert(this.d_lengthUnit), i, COLUMN_IDS.MAXY.ordinal());
                model.setValueAt(bounds.getMin().zu().convert(this.d_lengthUnit), i, COLUMN_IDS.MINZ.ordinal());
                model.setValueAt(bounds.getMax().zu().convert(this.d_lengthUnit), i, COLUMN_IDS.MAXZ.ordinal());
                model.setValueAt(slice.getQuantity(), i, COLUMN_IDS.GASPHASE.ordinal());
                model.setValueAt(vecStr, i, COLUMN_IDS.USEVEC.ordinal());
                model.setValueAt(centerStr, i, COLUMN_IDS.CELLCENTER.ordinal());
                ++i;
            }
        }
    }

    public void saveData() {
        List<VolumeSlice> slices = Arrays.asList(this.getSlices());
        Task task = guiOutputUtil.taskReplaceObjs(this.d_pyroMod.getSlcf3dList(), slices);
        this.d_pyroMod.getTaskManager().exec(task, Intl.intl("Save 3D Slices"));
    }

    private VolumeSlice[] getSlices() {
        TableModel tm = this.d_editor.getTable().getModel();
        int numRows = tm.getRowCount();
        VolumeSlice[] records = new VolumeSlice[numRows];
        for (int i = 0; i < numRows; ++i) {
            Object nameObj = tm.getValueAt(i, COLUMN_IDS.ID.ordinal());
            Object minx = tm.getValueAt(i, COLUMN_IDS.MINX.ordinal());
            Object maxx = tm.getValueAt(i, COLUMN_IDS.MAXX.ordinal());
            Object miny = tm.getValueAt(i, COLUMN_IDS.MINY.ordinal());
            Object maxy = tm.getValueAt(i, COLUMN_IDS.MAXY.ordinal());
            Object minz = tm.getValueAt(i, COLUMN_IDS.MINZ.ordinal());
            Object maxz = tm.getValueAt(i, COLUMN_IDS.MAXZ.ordinal());
            Object quant = tm.getValueAt(i, COLUMN_IDS.GASPHASE.ordinal());
            Object vecOption = tm.getValueAt(i, COLUMN_IDS.USEVEC.ordinal());
            Object centerOption = tm.getValueAt(i, COLUMN_IDS.CELLCENTER.ordinal());
            boolean useVec = vecOption.equals(OPT_YES);
            boolean useCentered = centerOption.equals(OPT_YES);
            records[i] = new VolumeSlice((String)nameObj, (UnitDouble)minx, (UnitDouble)maxx, (UnitDouble)miny, (UnitDouble)maxy, (UnitDouble)minz, (UnitDouble)maxz, (IQuantity)quant, useVec, useCentered);
        }
        return records;
    }

    private boolean noTwo3DSlicesSame() {
        return Slcf3dDialog.noTwo3DSlicesSame(this.getSlices());
    }

    private static boolean noTwo3DSlicesSame(VolumeSlice[] slices) {
        HashSet<VolumeSlice> vslices = new HashSet<VolumeSlice>();
        for (VolumeSlice s3d : slices) {
            if (vslices.add(s3d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        this.savePreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
        if (result == 1) {
            this.saveData();
        }
        return result;
    }

    private static enum COLUMN_IDS {
        ID(Intl.intl("Name"), String.class),
        MINX(Intl.intl("Min X"), UnitDouble.class),
        MAXX(Intl.intl("Max X"), UnitDouble.class),
        MINY(Intl.intl("Min Y"), UnitDouble.class),
        MAXY(Intl.intl("Max Y"), UnitDouble.class),
        MINZ(Intl.intl("Min Z"), UnitDouble.class),
        MAXZ(Intl.intl("Max Z"), UnitDouble.class),
        GASPHASE(Intl.intl("Gas Phase Quantity"), IQuantity.class),
        USEVEC(Intl.intl("Use Vector?"), String.class),
        CELLCENTER(Intl.intl("Cell Centered?"), String.class);

        public final String name;
        public final Class<?> clazz;

        private COLUMN_IDS(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }
    }
}

