/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Floor;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.PointListEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.ClosedLinearCurve;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertyUtil;
import thunderheadeng.util.theUtil;

public class WallGeomEditor
extends guiPanel
implements IGeomEditor<WallGeom> {
    private static final long serialVersionUID = -4397271184479586500L;
    private final PointListEditor d_pointEditor;
    private final guiComboBox<WallGeom.Alignment> d_alignmentCB = new guiComboBox<WallGeom.Alignment>(WallGeom.Alignment.values());
    private final ValueField<UnitDouble> d_heightFld;
    private final ValueField<UnitDouble> d_thicknessFld;
    private boolean d_loadedClosed = false;

    public WallGeomEditor() {
        super(new GridBagLayout());
        this.d_alignmentCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -7671962728127094643L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String name = "";
                String tooltip = null;
                if (value != null) {
                    switch ((WallGeom.Alignment)((Object)value)) {
                        case LEFT: {
                            name = Intl.intl("Left");
                            tooltip = Intl.intl("Align the wall to the left of the reference line");
                            break;
                        }
                        case RIGHT: {
                            name = Intl.intl("Right");
                            tooltip = Intl.intl("Align the wall to the right of the reference line");
                            break;
                        }
                        default: {
                            name = Intl.intl("Center");
                            tooltip = Intl.intl("Align the center of the wall with the reference line");
                        }
                    }
                }
                WallGeomEditor.this.d_alignmentCB.setToolTipText(tooltip);
                this.setText(name);
                return this;
            }
        });
        Floor defFloor = new Floor("");
        this.d_pointEditor = new PointListEditor(false);
        this.d_heightFld = WallGeomEditor.newField(defFloor.getWallHeight());
        this.d_thicknessFld = WallGeomEditor.newField(new UnitDouble(0.2, (Unit)SI.METER));
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(Intl.intl("Thickness:"), this.d_thicknessFld, 0);
        gb.addRow(Intl.intl("Height:"), this.d_heightFld, 0);
        gb.addRow(Intl.intl("Alignment:"), this.d_alignmentCB, 0);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Reference Line")));
        gb.addIdentRow(this.d_pointEditor, new double[]{1.0, 1.0}, new int[]{0, 0});
        gb.finalizeRows();
    }

    private static ValueField newField(UnitDouble initVal) {
        ValueField<UnitDouble> fld = ValueFields.udFld(initVal, UnitDoubleVR.above(0.0, PyroSim.getApp().getUnitSystem().getLengthUnit(), true), UnitSystem.getSource(0));
        fld.setColumns(8);
        fld.setNullAllowed(true);
        return fld;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Wall");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getFaceNames() {
        void var5_7;
        WallGeom wg = this.getTempGeom();
        if (wg == null) {
            return new String[0];
        }
        ArrayList<Pair<WallGeom.Face, int[]>> faceRanges = new ArrayList<Pair<WallGeom.Face, int[]>>();
        WallGeom.Face[] faceArray = WallGeom.Face.values();
        int n = faceArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            WallGeom.Face face = faceArray[var5_7];
            int[] range = wg.getFaceRange(face);
            if (range[1] > 0) {
                faceRanges.add(new Pair<WallGeom.Face, int[]>(face, range));
            }
            ++var5_7;
        }
        Collections.sort(faceRanges, new Comparator<Pair<WallGeom.Face, int[]>>(){

            @Override
            public int compare(Pair<WallGeom.Face, int[]> o1, Pair<WallGeom.Face, int[]> o2) {
                return ((int[])o1.v2)[0] - ((int[])o2.v2)[0];
            }
        });
        ArrayList<String> faceNames = new ArrayList<String>();
        for (Pair pair : faceRanges) {
            String baseName = WallGeomEditor.getNameForFaceType((WallGeom.Face)((Object)pair.v1));
            for (int m = 0; m < ((int[])pair.v2)[1]; ++m) {
                String name = ((int[])pair.v2)[1] > 1 ? String.format("%s [%d]", baseName, m + 1) : baseName;
                faceNames.add(name);
            }
        }
        return faceNames.toArray(new String[faceNames.size()]);
    }

    private static String getNameForFaceType(WallGeom.Face faceType) {
        switch (faceType) {
            case BOTTOM: {
                return Intl.intl("Bottom");
            }
            case TOP: {
                return Intl.intl("Top");
            }
            case ENDCAP_START: {
                return Intl.intl("Endcap 1");
            }
            case ENDCAP_END: {
                return Intl.intl("Endcap 2");
            }
            case SIDE1: {
                return Intl.intl("Side 1");
            }
            case SIDE2: {
                return Intl.intl("Side 2");
            }
        }
        return "";
    }

    @Override
    public int getNumFaces() {
        WallGeom wg = this.getTempGeom();
        if (wg == null) {
            return -1;
        }
        return wg.getNumPrims(1);
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }

    private ICurve toCurve(List<Point3d> points) {
        if (points.size() < 2) {
            return null;
        }
        ACurve curve = points.size() == 2 ? new LineSeg(points.get(0), points.get(1)) : new PolyLine(theUtil.toArray(points, Point3d.class));
        if (this.d_loadedClosed && points.get(0).epsilonEquals(points.get(points.size() - 1), 1.0E-9)) {
            curve = new ClosedLinearCurve((ILinearCurve)((Object)curve));
        }
        return curve;
    }

    private WallGeom getTempGeom() {
        List<Point3d> points = this.d_pointEditor.save();
        if (points == null || points.size() < 2) {
            return null;
        }
        WallGeom.Alignment alignment = this.d_alignmentCB.getSelectedItem();
        if (alignment == null) {
            alignment = WallGeom.Alignment.LEFT;
        }
        WallGeom wg = new WallGeom(this.toCurve(points), alignment, 0.2, 3.0);
        return wg;
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        List<Point3d> points = this.d_pointEditor.save();
        if (points != null && points.size() == 1) {
            this.error(showWarn, Intl.intl("At least 2 points must be specified."));
            return false;
        }
        return true;
    }

    private void error(boolean show, String msg) {
        JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid Wall"), 0);
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] vals = GeomGuiUtil.getDataVals(geoms, new DataProp(), 2, Geometry.LU);
        this.d_thicknessFld.setValue(vals[0]);
        this.d_heightFld.setValue(vals[1]);
        Object curve = PropertyUtil.getProperty(new CurveProp(), geoms);
        if (curve instanceof ILinearCurve) {
            this.d_pointEditor.load(this.getPoints((ILinearCurve)curve));
        } else {
            this.d_pointEditor.load(Collections.EMPTY_LIST);
        }
        this.d_loadedClosed = curve instanceof ICurve && ((ICurve)curve).isClosed();
        Object alignment = PropertyUtil.getProperty(new AlignmentProp(), geoms);
        if (alignment instanceof WallGeom.Alignment) {
            this.d_alignmentCB.setSelectedItem(alignment);
        } else {
            this.d_alignmentCB.setSelectedItem(null);
        }
    }

    private List<Point3d> getPoints(ILinearCurve lc) {
        ArrayList<Point3d> points = new ArrayList<Point3d>(lc.getNumVerts());
        for (int m = 0; m < lc.getNumVerts(); ++m) {
            points.add(lc.getVert(m));
        }
        return points;
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        WallGeom.Alignment alignment;
        ICurve curve;
        GeomGuiUtil.setDataVals(geoms, new DataProp(), Geometry.LU, (UnitDouble)this.d_thicknessFld.getValue(), (UnitDouble)this.d_heightFld.getValue());
        List<Point3d> points = this.d_pointEditor.save();
        if (points != null && (curve = this.toCurve(points)) != null) {
            PropertyUtil.setProperty(new CurveProp(), curve, geoms);
        }
        if ((alignment = this.d_alignmentCB.getSelectedItem()) != null) {
            PropertyUtil.setProperty(new AlignmentProp(), alignment, geoms);
        }
    }

    private static abstract class WallProp<T>
    extends PropertyUtil.AProp<IPyroGeomSrc, T> {
        public WallProp() {
            super(IPyroGeomSrc.class);
        }

        @Override
        protected abstract Object get(WallGeom var1);

        protected abstract WallGeom apply(IPyroGeomSrc var1, WallGeom var2, T var3);

        @Override
        public Object get(IPyroGeomSrc obj) {
            WallGeom geom = (WallGeom)obj.getGeom().getLocalGeom();
            return this.get(geom);
        }

        @Override
        public void set(IPyroGeomSrc obj, T prop) {
            IGeomNode node = obj.getGeom();
            WallGeom geom = this.apply(obj, (WallGeom)node.getLocalGeom(), prop);
            obj.setGeom(node.applyLocalGeom(geom));
        }
    }

    private static class AlignmentProp
    extends WallProp<WallGeom.Alignment> {
        private AlignmentProp() {
        }

        @Override
        protected WallGeom apply(IPyroGeomSrc obj, WallGeom geom, WallGeom.Alignment newVal) {
            return new WallGeom(geom.refCurve, newVal, geom.thickness, geom.height);
        }

        @Override
        protected Object get(WallGeom geom) {
            return geom.alignment;
        }
    }

    private static class CurveProp
    extends WallProp<ICurve> {
        private CurveProp() {
        }

        @Override
        protected Object get(WallGeom geom) {
            return geom.refCurve;
        }

        @Override
        protected WallGeom apply(IPyroGeomSrc obj, WallGeom geom, ICurve prop) {
            return new WallGeom(prop, geom.alignment, geom.thickness, geom.height);
        }

        @Override
        public boolean equal(ICurve obj1, ICurve obj2) {
            if (obj1 instanceof ILinearCurve && obj2 instanceof ILinearCurve) {
                if (obj1.isClosed() != obj2.isClosed()) {
                    return false;
                }
                ILinearCurve lc1 = (ILinearCurve)obj1;
                ILinearCurve lc2 = (ILinearCurve)obj2;
                int numPoints = lc1.getNumVerts();
                if (numPoints != lc2.getNumVerts()) {
                    return false;
                }
                for (int m = 0; m < numPoints; ++m) {
                    if (lc1.getVert(m).equals(lc2.getVert(m))) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class DataProp
    extends GeomGuiUtil.AGeomProp<WallGeom> {
        @Override
        protected WallGeom constructGeom(WallGeom arg0, double[] data) {
            return new WallGeom(arg0.refCurve, arg0.alignment, data[0], data[1]);
        }

        @Override
        protected double[] saveData(WallGeom geom) {
            return new double[]{geom.thickness, geom.height};
        }
    }
}

