/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.vecmath.Point2d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.gui.geom.Point3DPanel;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitPoint3D;

public class TexMapperPnl
extends guiPanel {
    private static final long serialVersionUID = -1965219916619717061L;
    private final guiMultiStateCheckBox d_customMapperCB;
    private final TitleSeparator d_texOriginLbl;
    private final guiMultiStateCheckBox d_objRelativeCB;
    private final Point3DPanel d_loc;

    public TexMapperPnl() {
        this.setLayout(new GridBagLayout());
        this.d_customMapperCB = new guiMultiStateCheckBox(Intl.intl("Use Imported Texture Coordinates"));
        this.d_texOriginLbl = new TitleSeparator(Intl.intl("Texture Origin"));
        this.d_loc = new Point3DPanel(null, true);
        this.d_objRelativeCB = new guiMultiStateCheckBox(Intl.intl("Relative to object"));
        LinkStatus.link((AbstractButton)this.d_customMapperCB, true, this.d_texOriginLbl, this.d_loc, this.d_objRelativeCB);
        this.addToPanel(this, 0);
    }

    public int addToPanel(guiPanel panel, int beginRow) {
        int row = beginRow;
        GridBagUtil.add(panel, this.d_customMapperCB, 0, row, 10, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.d_texOriginLbl, 0, ++row, 10, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(panel, this.d_objRelativeCB, 0, ++row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.d_loc, 0, ++row, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
        return row;
    }

    public void load(Collection<? extends ISurfObj> objs) {
        TexOrigin origin;
        Object mapperProp = Composite.getProperty(ISurfObj.texMapperProp, objs);
        if (!(mapperProp instanceof Map)) {
            this.d_customMapperCB.setState(2);
        } else {
            this.d_customMapperCB.setSelected(((Map)mapperProp).values().stream().anyMatch(uv -> !FDSUtil.isDefaultTexMapper(uv)));
        }
        this.d_customMapperCB.setVisible(this.d_customMapperCB.getState() != 0);
        Object originProp = Composite.getProperty(ISurfObj.texOriginProp, objs);
        TexOrigin texOrigin = origin = originProp instanceof TexOrigin ? (TexOrigin)originProp : null;
        if (origin != null) {
            this.d_loc.load(origin.getLocal());
            this.d_objRelativeCB.setSelected(origin.isRelativeToObj());
        } else {
            this.d_loc.load(null);
            this.d_objRelativeCB.setState(2);
        }
    }

    public UnitPoint3D getTexOrigin() {
        return this.d_loc.save();
    }

    public Optional<Boolean> isRelativeToObj() {
        switch (this.d_objRelativeCB.getState()) {
            case 1: {
                return Optional.of(true);
            }
            case 0: {
                return Optional.of(false);
            }
            case 2: {
                return Optional.empty();
            }
        }
        assert (false);
        return Optional.empty();
    }

    public Optional<Boolean> isCustomMapper() {
        switch (this.d_customMapperCB.getState()) {
            case 1: {
                return Optional.of(true);
            }
            case 0: {
                return Optional.of(false);
            }
            case 2: {
                return Optional.empty();
            }
        }
        assert (false);
        return Optional.empty();
    }

    public void save(PyroMod mediator, Collection<? extends ISurfObj> objs) {
        this.isCustomMapper().ifPresent(isCustom -> {
            if (isCustom.booleanValue()) {
                Map<String, IElemSource<Point2d>> mapper = FDSUtil.getDefaultTexMapperSets();
                Composite.setProperty(ISurfObj.texMapperProp, mapper, objs);
            }
        });
        UnitPoint3D loc = this.getTexOrigin();
        this.isRelativeToObj().ifPresent(isRelative -> {
            if (loc != null) {
                TexOrigin origin = new TexOrigin(loc, (boolean)isRelative);
                Composite.setProperty(ISurfObj.texOriginProp, origin, objs);
            }
        });
    }
}

