/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.JButton;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.ScaleTask;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.gui.geom.TransformDialog;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;

public class ScaleDialog
extends TransformDialog {
    private static final long serialVersionUID = 1518400242791892604L;
    private final ValueField<Double> d_bx;
    private final ValueField<Double> d_by;
    private final ValueField<Double> d_bz;
    private final JButton d_centerButton;
    private final ValueField<Double> d_sx;
    private final ValueField<Double> d_sy;
    private final ValueField<Double> d_sz;
    private final Unit d_lu;
    private JButton d_okButton;

    public ScaleDialog(PyroMod mediator, Collection<? extends IPyroObject> objs) {
        super(Intl.intl("Scale Objects"), mediator, objs, true, true);
        UnitSystem currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
        this.d_lu = currentUS.getLengthUnit();
        this.d_bx = ValueFields.doubleFld(0.0);
        this.d_by = ValueFields.doubleFld(0.0);
        this.d_bz = ValueFields.doubleFld(0.0);
        this.d_centerButton = this.getCenterForBaseButton();
        this.d_okButton = super.getButton(1);
        DoubleVR scaleRange = DoubleVR.above(0.0, false);
        this.d_sx = ValueFields.doubleFld(1.0, scaleRange);
        this.d_sy = ValueFields.doubleFld(1.0, scaleRange);
        this.d_sz = ValueFields.doubleFld(1.0, scaleRange);
        int numCols = 6;
        this.d_bx.setColumns(numCols);
        this.d_by.setColumns(numCols);
        this.d_bz.setColumns(numCols);
        this.d_sx.setColumns(numCols);
        this.d_sy.setColumns(numCols);
        this.d_sz.setColumns(numCols);
        guiLabel bxLab = new guiLabel("X:");
        guiLabel byLab = new guiLabel("Y:");
        guiLabel bzLab = new guiLabel("Z:");
        guiLabel sxLab = new guiLabel("X:");
        guiLabel syLab = new guiLabel("Y:");
        guiLabel szLab = new guiLabel("Z:");
        TitleSeparator bTS = new TitleSeparator(Intl.intl("Base Point") + " (" + this.d_lu + ")");
        TitleSeparator sTS = new TitleSeparator(Intl.intl("Scale"));
        guiPanel basePanel = new guiPanel(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(basePanel, bTS, 0, row, 6, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(basePanel, bxLab, 0, ++row, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(basePanel, this.d_bx, 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(basePanel, byLab, 0, ++row, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(basePanel, this.d_by, 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(basePanel, this.getCenterForBaseButton(), 2, row, 1, 1, 0, 6, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(basePanel, bzLab, 0, ++row, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(basePanel, this.d_bz, 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        guiPanel scalePanel = new guiPanel(new GridBagLayout());
        row = 0;
        GridBagUtil.add(scalePanel, sTS, 0, ++row, 6, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(scalePanel, sxLab, 0, ++row, 1, 1, 0, 12, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(scalePanel, this.d_sx, 1, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(scalePanel, syLab, 2, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(scalePanel, this.d_sy, 3, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(scalePanel, szLab, 4, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(scalePanel, this.d_sz, 5, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        guiPanel dlgPane = super.getDialogPane();
        dlgPane.setLayout(new GridBagLayout());
        row = 0;
        GridBagUtil.add(dlgPane, this.getModePanel(), 0, row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(dlgPane, scalePanel, 0, ++row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(dlgPane, basePanel, 0, ++row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        CustomFocusTraversalPolicy newPolicy = new CustomFocusTraversalPolicy(this.getFocusTraversalPolicy());
        this.setFocusTraversalPolicy(newPolicy);
        super.init();
    }

    @Override
    protected String getTaskDesc() {
        return this.getNumCopies() > 0 ? Intl.intl("Copy/Scale Objects") : Intl.intl("Scale Objects");
    }

    private UnitPoint3D getBasePoint() {
        return new UnitPoint3D((Double)this.d_bx.getValue(), (Double)this.d_by.getValue(), (Double)this.d_bz.getValue(), this.d_lu);
    }

    private Tuple3d getScale() {
        return new Vector3d((Double)this.d_sx.getValue(), (Double)this.d_sy.getValue(), (Double)this.d_sz.getValue());
    }

    @Override
    protected void setBase(UnitPoint3D base) {
        this.d_bx.setValue(base.x(this.d_lu));
        this.d_by.setValue(base.y(this.d_lu));
        this.d_bz.setValue(base.z(this.d_lu));
    }

    @Override
    protected TransformTask taskTransform(Collection<? extends IPyroObject> objs) {
        UnitPoint3D basePoint = this.getBasePoint();
        Tuple3d scale = this.getScale();
        return new ScaleTask(this.getMediator(), objs, this.getNumCopies(), basePoint, scale);
    }

    private class CustomFocusTraversalPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private static final long serialVersionUID = -2723723486849775357L;
        private final FocusTraversalPolicy oldPolicy;

        public CustomFocusTraversalPolicy(FocusTraversalPolicy old) {
            this.oldPolicy = old;
        }

        @Override
        public Component getComponentAfter(Container c1, Component c2) {
            if (c2.equals(ScaleDialog.this.d_by)) {
                return ScaleDialog.this.d_bz;
            }
            if (c2.equals(ScaleDialog.this.d_bz)) {
                return ScaleDialog.this.d_centerButton;
            }
            if (c2.equals(ScaleDialog.this.d_centerButton)) {
                return ScaleDialog.this.d_okButton;
            }
            return this.oldPolicy.getComponentAfter(c1, c2);
        }

        @Override
        public Component getComponentBefore(Container c1, Component c2) {
            if (c2.equals(ScaleDialog.this.d_okButton)) {
                return ScaleDialog.this.d_centerButton;
            }
            if (c2.equals(ScaleDialog.this.d_centerButton)) {
                return ScaleDialog.this.d_bz;
            }
            if (c2.equals(ScaleDialog.this.d_bz)) {
                return ScaleDialog.this.d_by;
            }
            return this.oldPolicy.getComponentBefore(c1, c2);
        }

        @Override
        public Component getFirstComponent(Container c) {
            return this.oldPolicy.getFirstComponent(c);
        }
    }
}

