/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.RotateTask;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.gui.geom.TransformDialog;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.theUtil;

public class RotateDialog
extends TransformDialog {
    private static final long serialVersionUID = -5714521430471622522L;
    private final ValueField<UnitDouble> d_bx;
    private final ValueField<UnitDouble> d_by;
    private final ValueField<UnitDouble> d_bz;
    private final guiRadioButton d_ax;
    private final guiRadioButton d_ay;
    private final guiRadioButton d_az;
    private final JButton d_centerButton;
    private final guiComboBox<UnitDouble> d_angleCB;
    private final ValueField<UnitDouble> d_angle;
    private JButton d_okButton;
    private RotType d_allowedRotX;
    private RotType d_allowedRotY;
    private RotType d_allowedRotZ;

    public RotateDialog(PyroMod mediator, Collection<? extends IPyroObject> objs) {
        super(Intl.intl("Rotate Objects"), mediator, objs, true, true);
        ActionListener ctrlUpdateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RotateDialog.this.updateControls();
            }
        };
        this.d_bx = ValueFields.udFld(0.0, (Unit)SI.METER, UnitSystem.getSource(0));
        this.d_by = ValueFields.udFld(0.0, (Unit)SI.METER, UnitSystem.getSource(0));
        this.d_bz = ValueFields.udFld(0.0, (Unit)SI.METER, UnitSystem.getSource(0));
        this.d_centerButton = this.getCenterForBaseButton();
        this.d_okButton = super.getButton(1);
        this.d_angle = ValueFields.udFld(new UnitDouble(0.0, UnitSystem.getSource(29).getUnit()), UnitSystem.getSource(29));
        int numCols = 8;
        this.d_bx.setColumns(8);
        this.d_by.setColumns(8);
        this.d_bz.setColumns(8);
        this.d_angle.setColumns(8);
        this.d_ax = new guiRadioButton("X");
        this.d_ay = new guiRadioButton("Y");
        this.d_az = new guiRadioButton("Z", true);
        this.d_ax.addActionListener(ctrlUpdateListener);
        this.d_ay.addActionListener(ctrlUpdateListener);
        this.d_az.addActionListener(ctrlUpdateListener);
        ButtonGroup axisGroup = new ButtonGroup();
        axisGroup.add(this.d_ax);
        axisGroup.add(this.d_ay);
        axisGroup.add(this.d_az);
        Unit deg = NonSI.DEGREE_ANGLE;
        UnitDouble[] d_90Angles = new UnitDouble[]{new UnitDouble(-270.0, deg), new UnitDouble(-180.0, deg), new UnitDouble(-90.0, deg), new UnitDouble(0.0, deg), new UnitDouble(90.0, deg), new UnitDouble(180.0, deg), new UnitDouble(270.0, deg)};
        this.d_angleCB = new guiComboBox<UnitDouble>((T[])d_90Angles);
        this.d_angleCB.setVisible(false);
        this.d_angle.setPreferredSize(this.d_angleCB.getPreferredSize());
        guiPanel rotPanel = new guiPanel();
        GridBagHelper gb = new GridBagHelper(rotPanel);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Rotation")));
        gb.addIdentRow(Intl.intl("Axis:"), this.d_ax, this.d_ay, this.d_az, 0);
        gb.addIdentRow(Intl.intl("Angle:"), this.d_angle, 0, this.d_angleCB, 0);
        gb.finalizeRows();
        guiPanel basePanel = new guiPanel();
        gb = new GridBagHelper(basePanel);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Base Point")));
        gb.indent();
        gb.addRow(Intl.intl("X:"), this.d_bx);
        gb.addRow(Intl.intl("Y:"), this.d_by, this.d_centerButton);
        gb.addRow(Intl.intl("Z:"), this.d_bz);
        gb.finalizeRows();
        guiPanel dlgPane = super.getDialogPane();
        gb = new GridBagHelper(dlgPane);
        gb.addFilledRow(this.getModePanel());
        gb.addFilledRow(rotPanel);
        gb.addFilledRow(basePanel);
        gb.finalizeRows();
        CustomFocusTraversalPolicy newPolicy = new CustomFocusTraversalPolicy(this.getFocusTraversalPolicy());
        this.setFocusTraversalPolicy(newPolicy);
        this.updateSelection(objs);
        super.init();
    }

    @Override
    protected String getTaskDesc() {
        return this.getNumCopies() > 0 ? Intl.intl("Copy/Rotate Objects") : Intl.intl("Rotate Objects");
    }

    private UnitPoint3D getBasePoint() {
        return new UnitPoint3D((UnitDouble)this.d_bx.getValue(), (UnitDouble)this.d_by.getValue(), (UnitDouble)this.d_bz.getValue());
    }

    private UnitDouble getRotateAngle() {
        if (this.d_angle.isVisible()) {
            return (UnitDouble)this.d_angle.getValue();
        }
        return this.d_angleCB.getSelectedItem();
    }

    private Vector3d getRotateAxis() {
        if (this.d_ax.isSelected()) {
            return GeomConstants.VEC3D_XPOS;
        }
        if (this.d_ay.isSelected()) {
            return GeomConstants.VEC3D_YPOS;
        }
        return GeomConstants.VEC3D_ZPOS;
    }

    private void updateSelection(Collection<? extends IPyroObject> selObjects) {
        IDOF dof = this.getDOF();
        this.d_allowedRotY = this.d_allowedRotZ = RotType.FREE;
        this.d_allowedRotX = this.d_allowedRotZ;
        if (dof == IDOF.ALIGNED) {
            this.d_allowedRotY = this.d_allowedRotZ = RotType.ALIGNED;
            this.d_allowedRotX = this.d_allowedRotZ;
        } else if (dof == WallGeom.DOF) {
            this.d_allowedRotX = this.d_allowedRotY = RotType.NONE;
        } else if (dof == IDOF.NONE) {
            this.d_allowedRotY = this.d_allowedRotZ = RotType.NONE;
            this.d_allowedRotX = this.d_allowedRotZ;
        }
        this.d_ax.setEnabled(true);
        this.d_ay.setEnabled(true);
        this.d_az.setEnabled(true);
        if (this.d_allowedRotX == RotType.NONE) {
            this.d_ax.setEnabled(false);
        }
        if (this.d_allowedRotY == RotType.NONE) {
            this.d_ay.setEnabled(false);
        }
        if (this.d_allowedRotZ == RotType.NONE) {
            this.d_az.setEnabled(false);
        }
        this.updateControls();
    }

    private void updateControls() {
        this.updateControls(this.d_ax, this.d_bx, this.d_allowedRotX);
        this.updateControls(this.d_ay, this.d_by, this.d_allowedRotY);
        this.updateControls(this.d_az, this.d_bz, this.d_allowedRotZ);
    }

    private void updateControls(guiRadioButton btn, ValueField<UnitDouble> baseFld, RotType freedom) {
        if (!btn.isSelected()) {
            baseFld.setEnabled(true);
            return;
        }
        baseFld.setEnabled(false);
        if (freedom == RotType.ALIGNED) {
            if (!this.d_angleCB.isVisible()) {
                UnitDouble angle = this.getRotateAngle();
                angle = theUtil.roundAngle(angle, new UnitDouble(90.0, NonSI.DEGREE_ANGLE), NonSI.DEGREE_ANGLE);
                this.d_angleCB.setSelectedItem(angle);
                this.d_angle.setVisible(false);
                this.d_angleCB.setVisible(true);
            }
        } else {
            assert (freedom == RotType.FREE);
            if (!this.d_angle.isVisible()) {
                this.d_angle.setValue(this.d_angleCB.getSelectedItem().getValue(NonSI.DEGREE_ANGLE));
                this.d_angleCB.setVisible(false);
                this.d_angle.setVisible(true);
            }
        }
    }

    @Override
    protected void setBase(UnitPoint3D base) {
        this.d_bx.setValue(base.xu());
        this.d_by.setValue(base.yu());
        this.d_bz.setValue(base.zu());
    }

    @Override
    protected TransformTask taskTransform(Collection<? extends IPyroObject> objs) {
        return new RotateTask(this.getMediator(), objs, this.getNumCopies(), this.getBasePoint(), this.getRotateAxis(), this.getRotateAngle());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return super.validateData(showWarn, allowModify);
    }

    private class CustomFocusTraversalPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private static final long serialVersionUID = 8256955949344273427L;
        private final FocusTraversalPolicy oldPolicy;

        public CustomFocusTraversalPolicy(FocusTraversalPolicy old) {
            this.oldPolicy = old;
        }

        @Override
        public Component getComponentAfter(Container c1, Component c2) {
            if (c2.equals(RotateDialog.this.d_by)) {
                return RotateDialog.this.d_bz;
            }
            if (c2.equals(RotateDialog.this.d_bz)) {
                return RotateDialog.this.d_centerButton;
            }
            if (c2.equals(RotateDialog.this.d_centerButton)) {
                return RotateDialog.this.d_okButton;
            }
            return this.oldPolicy.getComponentAfter(c1, c2);
        }

        @Override
        public Component getComponentBefore(Container c1, Component c2) {
            if (c2.equals(RotateDialog.this.d_okButton)) {
                return RotateDialog.this.d_centerButton;
            }
            if (c2.equals(RotateDialog.this.d_centerButton)) {
                return RotateDialog.this.d_bz;
            }
            if (c2.equals(RotateDialog.this.d_bz)) {
                return RotateDialog.this.d_by;
            }
            return this.oldPolicy.getComponentBefore(c1, c2);
        }

        @Override
        public Component getFirstComponent(Container c) {
            return this.oldPolicy.getFirstComponent(c);
        }
    }

    private static enum RotType {
        FREE,
        ALIGNED,
        NONE;

    }
}

