/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class Point3DPanel
extends guiPanel {
    private static final long serialVersionUID = -6913201894682830905L;
    private final guiLabel d_locLabel;
    private final ValueField<UnitDouble> d_xLoc;
    private final ValueField<UnitDouble> d_yLoc;
    private final ValueField<UnitDouble> d_zLoc;
    private boolean d_emptyAllowed;

    public Point3DPanel(String label) {
        this(label, false);
    }

    public Point3DPanel(String label, boolean emptyAllowed) {
        this(label, emptyAllowed, 0, false, true);
    }

    public Point3DPanel(String label, boolean emptyAllowed, int unitType) {
        this(label, emptyAllowed, unitType, false, true);
    }

    public Point3DPanel(String label, boolean emptyAllowed, int unitType, boolean useMig, boolean addToPanel) {
        if (useMig) {
            this.setLayout((LayoutManager)new MigLayout());
        } else {
            this.setLayout(new GridBagLayout());
        }
        this.d_locLabel = label != null ? new guiLabel(label) : null;
        this.d_xLoc = Point3DPanel.newField(0.0, unitType);
        this.d_yLoc = Point3DPanel.newField(0.0, unitType);
        this.d_zLoc = Point3DPanel.newField(0.0, unitType);
        this.d_emptyAllowed = emptyAllowed;
        if (addToPanel) {
            this.addToPanel(this, 0, 0);
        }
    }

    private static ValueField<UnitDouble> newField(double initVal, int unitType) {
        IUnitSrc src = UnitSystem.getSource(unitType);
        ValueField<UnitDouble> fld = ValueFields.udFld(new UnitDouble(initVal, src.getUnit()), src);
        fld.setNullAllowed(true);
        return fld;
    }

    public void addToPanel(guiPanel panel, int beginCol, int beginRow) {
        guiLabel xLocLab = new guiLabel(Intl.intl("X") + ":");
        guiLabel yLocLab = new guiLabel(Intl.intl("Y") + ":");
        guiLabel zLocLab = new guiLabel(Intl.intl("Z") + ":");
        if (panel.getLayout() instanceof MigLayout) {
            if (this.d_locLabel != null) {
                panel.add((Component)this.d_locLabel, "gaptop 0, gapleft 0, gapbottom 6, gapright 6");
            }
            panel.add((Component)xLocLab, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
            panel.add(this.d_xLoc, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
            panel.add((Component)yLocLab, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
            panel.add(this.d_yLoc, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
            panel.add((Component)zLocLab, "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
            panel.add(this.d_zLoc, "gaptop 0, gapleft 0, gapbottom 3, gapright 0, wrap");
        } else if (panel.getLayout() instanceof GridBagLayout) {
            int row = beginRow;
            int col = beginCol;
            if (this.d_locLabel != null) {
                GridBagUtil.add(panel, this.d_locLabel, col++, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            }
            GridBagUtil.add(panel, xLocLab, col++, row, 1, 1, 0, 0, 3, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_xLoc, col++, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, yLocLab, col++, row, 1, 1, 0, 0, 3, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_yLoc, col++, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, zLocLab, col++, row, 1, 1, 0, 0, 3, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_zLoc, col++, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        } else assert (false) : "Unsupported layout manager";
    }

    public void addToPanel(GridBagHelper gb) {
        gb.addRow(this.d_locLabel, Intl.intl("X:"), this.d_xLoc, Intl.intl("Y:"), this.d_yLoc, Intl.intl("Z:"), this.d_zLoc);
    }

    public void load(UnitPoint3D fpl) {
        if (fpl == null) {
            this.d_xLoc.setValue(null);
            this.d_yLoc.setValue(null);
            this.d_zLoc.setValue(null);
        } else {
            this.d_xLoc.setValue(fpl.xu());
            this.d_yLoc.setValue(fpl.yu());
            this.d_zLoc.setValue(fpl.zu());
        }
    }

    public UnitDouble x() {
        return (UnitDouble)this.d_xLoc.getValue();
    }

    public UnitDouble y() {
        return (UnitDouble)this.d_yLoc.getValue();
    }

    public UnitDouble z() {
        return (UnitDouble)this.d_zLoc.getValue();
    }

    public void setX(UnitDouble x) {
        this.d_xLoc.setValue(x);
    }

    public void setY(UnitDouble y) {
        this.d_yLoc.setValue(y);
    }

    public void setZ(UnitDouble z) {
        this.d_zLoc.setValue(z);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (!this.d_emptyAllowed && (this.d_xLoc.isEmpty() || this.d_yLoc.isEmpty() || this.d_zLoc.isEmpty())) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Error: Empty value field detected."));
            }
            return false;
        }
        return true;
    }

    public UnitPoint3D save() {
        if (this.d_xLoc.isEmpty() || this.d_yLoc.isEmpty() || this.d_zLoc.isEmpty()) {
            return null;
        }
        return new UnitPoint3D((UnitDouble)this.d_xLoc.getValue(), (UnitDouble)this.d_yLoc.getValue(), (UnitDouble)this.d_zLoc.getValue());
    }

    public void setEditable(boolean flag) {
        this.d_xLoc.setEditable(flag);
        this.d_yLoc.setEditable(flag);
        this.d_zLoc.setEditable(flag);
    }
}

