/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.MirrorTask;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.gui.geom.TransformDialog;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class MirrorDialog
extends TransformDialog {
    private static final long serialVersionUID = -8107052336669228562L;
    private final guiCheckBox d_cbX;
    private final guiCheckBox d_cbY;
    private final guiCheckBox d_cbZ;
    private final ValueField<UnitDouble> d_valueX;
    private final ValueField<UnitDouble> d_valueY;
    private final ValueField<UnitDouble> d_valueZ;
    private final guiPanel d_dlgPane;

    public MirrorDialog(PyroMod mediator, Collection<? extends IPyroObject> objs) {
        super(Intl.intl("Mirror"), mediator, objs, false, true);
        TitleSeparator mirrorLabel = new TitleSeparator(Intl.intl("Mirror Plane"));
        this.d_cbX = new guiCheckBox("X");
        this.d_cbY = new guiCheckBox("Y");
        this.d_cbZ = new guiCheckBox("Z");
        this.d_valueX = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_valueY = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_valueZ = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_cbX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MirrorDialog.this.d_valueX.setEnabled(MirrorDialog.this.d_cbX.isSelected());
                if (MirrorDialog.this.d_valueX.isEnabled()) {
                    MirrorDialog.this.d_valueX.grabFocus();
                }
            }
        });
        this.d_cbY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MirrorDialog.this.d_valueY.setEnabled(MirrorDialog.this.d_cbY.isSelected());
                if (MirrorDialog.this.d_valueY.isEnabled()) {
                    MirrorDialog.this.d_valueY.grabFocus();
                }
            }
        });
        this.d_cbZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MirrorDialog.this.d_valueZ.setEnabled(MirrorDialog.this.d_cbZ.isSelected());
                if (MirrorDialog.this.d_valueZ.isEnabled()) {
                    MirrorDialog.this.d_valueZ.grabFocus();
                }
            }
        });
        guiPanel planePanel = new guiPanel(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(planePanel, mirrorLabel, 0, row, 3, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(planePanel, this.d_cbX, 0, ++row, 1, 1, 0, 18, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(planePanel, new guiLabel("="), 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(planePanel, this.d_valueX, 2, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(planePanel, this.d_cbY, 0, ++row, 1, 1, 0, 18, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(planePanel, new guiLabel("="), 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(planePanel, this.d_valueY, 2, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(planePanel, this.d_cbZ, 0, ++row, 1, 1, 0, 18, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(planePanel, new guiLabel("="), 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(planePanel, this.d_valueZ, 2, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(planePanel, this.getCenterForBaseButton(), 0, ++row, 0, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
        this.d_dlgPane = super.getDialogPane();
        this.d_dlgPane.setLayout(new GridBagLayout());
        row = 0;
        GridBagUtil.add(this.d_dlgPane, this.getModePanel(), 0, row, 0, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_dlgPane, planePanel, 0, ++row, 0, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.addGlue(this.d_dlgPane);
        this.d_valueX.setEnabled(false);
        this.d_valueY.setEnabled(false);
        this.d_valueZ.setEnabled(false);
        super.init();
    }

    @Override
    protected String getTaskDesc() {
        return this.getNumCopies() > 0 ? Intl.intl("Copy/Mirror Objects") : Intl.intl("Mirror Objects");
    }

    private UnitDouble getXVal() {
        if (this.d_cbX.isSelected()) {
            return (UnitDouble)this.d_valueX.getValue();
        }
        return null;
    }

    private UnitDouble getYVal() {
        if (this.d_cbY.isSelected()) {
            return (UnitDouble)this.d_valueY.getValue();
        }
        return null;
    }

    private UnitDouble getZVal() {
        if (this.d_cbZ.isSelected()) {
            return (UnitDouble)this.d_valueZ.getValue();
        }
        return null;
    }

    @Override
    protected void setBase(UnitPoint3D base) {
        this.d_valueX.setValue(base.xu());
        this.d_valueY.setValue(base.yu());
        this.d_valueZ.setValue(base.zu());
    }

    @Override
    protected TransformTask taskTransform(Collection<? extends IPyroObject> objs) {
        UnitDouble x = this.getXVal();
        UnitDouble y = this.getYVal();
        UnitDouble z = this.getZVal();
        return new MirrorTask(this.getMediator(), objs, this.getNumCopies(), x, y, z);
    }
}

