/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitLineSeg3D;
import thunderheadeng.units.UnitPoint3D;

public class LineSegEditor
extends guiPanel
implements IGeomEditor<LineSeg> {
    private static final long serialVersionUID = -3108590421712295087L;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private Point3DPanel d_p1Panel;
    private Point3DPanel d_p2Panel;

    public LineSegEditor() {
        this.setLayout(new GridBagLayout());
        this.d_p1Panel = new Point3DPanel(Intl.intl("End Point 1"));
        this.d_p2Panel = new Point3DPanel(Intl.intl("End Point 2"));
        this.d_p1Panel.addToPanel(this, 0, 0);
        this.d_p2Panel.addToPanel(this, 0, 1);
        GridBagUtil.addGlue(this);
        this.load(new UnitLineSeg3D(0.0, 0.0, 0.0, 0.0, 0.0, 3.0, (Unit)SI.METER));
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Line");
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return null;
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] coords = GeomGuiUtil.getDataVals(geoms, new DataProp(), 6, Geometry.LU);
        this.d_p1Panel.setX(coords[0]);
        this.d_p1Panel.setY(coords[1]);
        this.d_p1Panel.setZ(coords[2]);
        this.d_p2Panel.setX(coords[3]);
        this.d_p2Panel.setY(coords[4]);
        this.d_p2Panel.setZ(coords[5]);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        UnitDouble[] coords = new UnitDouble[]{this.d_p1Panel.x(), this.d_p1Panel.y(), this.d_p1Panel.z(), this.d_p2Panel.x(), this.d_p2Panel.y(), this.d_p2Panel.z()};
        GeomGuiUtil.setDataVals(geoms, new DataProp(), Geometry.LU, coords);
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        return true;
    }

    public void load(UnitLineSeg3D uls) {
        this.d_p1Panel.load(uls.getP1());
        this.d_p2Panel.load(uls.getP2());
    }

    public UnitLineSeg3D getBeamLoc() {
        UnitPoint3D p1 = this.d_p1Panel.save();
        UnitPoint3D p2 = this.d_p2Panel.save();
        return new UnitLineSeg3D(p1, p2);
    }

    private static class DataProp
    extends GeomGuiUtil.AGeomProp<LineSeg> {
        private DataProp() {
        }

        @Override
        protected LineSeg constructGeom(LineSeg baseGeom, double[] data) {
            return new LineSeg(new Point3d(data[0], data[1], data[2]), new Point3d(data[3], data[4], data[5]));
        }

        @Override
        protected double[] saveData(LineSeg geom) {
            return new double[]{geom.p1.x, geom.p1.y, geom.p1.z, geom.p2.x, geom.p2.y, geom.p2.z};
        }
    }
}

