/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.geom.Vent;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.gui.geom.AARectangleEditor;
import pyrosim.gui.geom.ExtrudedPolyEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.PointGeomEditor;
import pyrosim.gui.geom.PolygonEditor;
import pyrosim.gui.geom.TransformEditor;
import pyrosim.gui.geom.VentGeomEditor;
import pyrosim.gui.geom.WallGeomEditor;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertyUtil;

public class GeomGuiUtil {
    private static final List<Pair<Predicate<IGeomNode>, IEditorSupplier>> EDITOR_FACTORY = new ArrayList<Pair<Predicate<IGeomNode>, IEditorSupplier>>();

    private static <T extends IGeom> void addEditor(Class<T> clazz, IEditorSupplier supplier) {
        GeomGuiUtil.addEditor(clazz, Predicates.alwaysTrue(), supplier);
    }

    private static <T extends IGeom> void addEditor(Class<T> clazz, Predicate<T> filter, IEditorSupplier supplier) {
        GeomGuiUtil.addEditor((IGeomNode node) -> clazz.isInstance(node.getLocalGeom()) && node.getChildren().isEmpty() && filter.test(node.getLocalGeom()), supplier);
    }

    private static <T extends IGeom> void addEditor(Predicate<IGeomNode> filter, IEditorSupplier supplier) {
        EDITOR_FACTORY.add(new Pair<Predicate<IGeomNode>, IEditorSupplier>(filter, supplier));
    }

    public static IGeomEditor newEditor(Collection<? extends IPyroGeomSrc> objs) {
        if (objs.isEmpty()) {
            return null;
        }
        ArrayList<IGeomNode> allGeom = new ArrayList<IGeomNode>(objs.size());
        for (IPyroGeomSrc iPyroGeomSrc : objs) {
            allGeom.add(iPyroGeomSrc.getGeom());
        }
        IGeomEditor geomEditor = null;
        for (Pair<Predicate<IGeomNode>, IEditorSupplier> pair : EDITOR_FACTORY) {
            if (!allGeom.stream().allMatch((Predicate)pair.v1)) continue;
            geomEditor = (IGeomEditor)((IEditorSupplier)pair.v2).apply(objs);
            break;
        }
        boolean bl = TransformEditor.isNeeded(objs);
        if (geomEditor != null && bl) {
            return new XformedGeomNodeEditor(geomEditor);
        }
        if (geomEditor != null) {
            return geomEditor;
        }
        if (bl) {
            return new TransformEditor();
        }
        return null;
    }

    public static <T extends IGeom> double[] getValueRange(final AGeomProp<T> propEditor, int propIx, Collection<? extends IPyroGeomSrc> geoms) {
        propEditor.setIndex(propIx);
        final double[] valRange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        PropertyUtil.getProperty(new PropertyUtil.AProp<IPyroGeomSrc, Double>(IPyroGeomSrc.class){

            @Override
            public Object get(IPyroGeomSrc obj) {
                double val = (Double)propEditor.get(obj);
                if (val < valRange[0]) {
                    valRange[0] = val;
                }
                if (val > valRange[1]) {
                    valRange[1] = val;
                }
                return val;
            }

            @Override
            public void set(IPyroGeomSrc obj, Double prop) {
            }
        }, geoms);
        return valRange;
    }

    public static <T extends IGeom> boolean validateMinMax(Component parent, ValueField<UnitDouble> min, ValueField<UnitDouble> max, String minLbl, String maxLbl, boolean equalAllowed, AGeomProp<T> propEditor, int minix, int maxix, Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        UnitDouble maxVal;
        UnitDouble minVal;
        if (min.isEmpty() && max.isEmpty()) {
            return true;
        }
        if (min.isEmpty() || max.isEmpty()) {
            if (!min.isEmpty()) {
                double[] maxValRange = GeomGuiUtil.getValueRange(propEditor, maxix, geoms);
                minVal = (UnitDouble)min.getValue();
                maxVal = new UnitDouble(maxValRange[0], Geometry.LU);
                maxLbl = Global.format(maxVal);
            } else {
                double[] minValRange = GeomGuiUtil.getValueRange(propEditor, minix, geoms);
                minVal = new UnitDouble(minValRange[1], Geometry.LU);
                maxVal = (UnitDouble)max.getValue();
                minLbl = Global.format(minVal);
            }
        } else {
            minVal = (UnitDouble)min.getValue();
            maxVal = (UnitDouble)max.getValue();
        }
        boolean result = GeomGuiUtil.validateMinMax(parent, minVal, maxVal, minLbl, maxLbl, equalAllowed, showWarn, allowModify);
        if (!result && allowModify) {
            min.requestFocus();
        }
        return result;
    }

    public static <T extends IGeom> boolean validateMinMax(Component parent, UnitDouble minVal, UnitDouble maxVal, String minLbl, String maxLbl, boolean equalAllowed, boolean showWarn, boolean allowModify) {
        int compare = minVal.compareTo(maxVal);
        if (equalAllowed && compare > 0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(parent, String.format(Intl.intl("%1$s must be less than or equal to %2$s."), minLbl, maxLbl));
            }
            return false;
        }
        if (!equalAllowed && compare >= 0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(parent, String.format(Intl.intl("%1$s must be less than %2$s."), minLbl, maxLbl));
            }
            return false;
        }
        return true;
    }

    public static <T extends IGeom> UnitDouble[] getDataVals(Collection<? extends IPyroGeomSrc> objs, AGeomProp<T> prop, int numVals, Unit srcUnit) {
        UnitDouble[] props = new UnitDouble[numVals];
        for (int m = 0; m < numVals; ++m) {
            prop.setIndex(m);
            Object val = PropertyUtil.getProperty(prop, objs);
            props[m] = !(val instanceof Double) ? null : new UnitDouble((Double)val, srcUnit);
        }
        return props;
    }

    public static <T extends IGeom> void setDataVals(Collection<? extends IPyroGeomSrc> objs, AGeomProp<T> prop, Unit dstUnit, UnitDouble ... vals) {
        for (int m = 0; m < vals.length; ++m) {
            UnitDouble ud = vals[m];
            if (ud == null) continue;
            prop.setIndex(m);
            PropertyUtil.setProperty(prop, ud.getValue(dstUnit), objs);
        }
    }

    public static <T extends IGeom> Double[] getDoubleDataVals(Collection<? extends IPyroGeomSrc> objs, AGeomProp<T> prop, int numVals) {
        return GeomGuiUtil.getDoubleDataVals(objs, prop, numVals, Unit.ONE, Unit.ONE);
    }

    public static <T extends IGeom> Double[] getDoubleDataVals(Collection<? extends IPyroGeomSrc> objs, AGeomProp<T> prop, int numVals, Unit srcUnit, Unit dstUnit) {
        Double[] props = new Double[numVals];
        for (int m = 0; m < numVals; ++m) {
            prop.setIndex(m);
            Object val = PropertyUtil.getProperty(prop, objs);
            props[m] = !(val instanceof Double) ? null : Double.valueOf(UnitDouble.convert((Double)val, srcUnit, dstUnit));
        }
        return props;
    }

    public static <T extends IGeom> void setDoubleDataVals(Collection<? extends IPyroGeomSrc> objs, AGeomProp<T> prop, Double ... vals) {
        GeomGuiUtil.setDoubleDataVals(objs, prop, Unit.ONE, Unit.ONE, vals);
    }

    public static <T extends IGeom> void setDoubleDataVals(Collection<? extends IPyroGeomSrc> objs, AGeomProp<T> prop, Unit srcUnit, Unit dstUnit, Double ... vals) {
        for (int m = 0; m < vals.length; ++m) {
            Double ud = vals[m];
            if (ud == null) continue;
            prop.setIndex(m);
            PropertyUtil.setProperty(prop, UnitDouble.convert(ud, srcUnit, dstUnit), objs);
        }
    }

    static {
        GeomGuiUtil.addEditor(Point.class, objs -> new PointGeomEditor());
        GeomGuiUtil.addEditor(AABoxGeom.class, objs -> new AABoxGeomEditor(true, true));
        GeomGuiUtil.addEditor(WallGeom.class, objs -> new WallGeomEditor());
        GeomGuiUtil.addEditor(Vent.VentGeom.class, objs -> new VentGeomEditor());
        GeomGuiUtil.addEditor(AARectangle.class, objs -> new AARectangleEditor(true));
        GeomGuiUtil.addEditor(IPolygon.class, p -> p.getNumLoops() == 1, objs -> new PolygonEditor());
        GeomGuiUtil.addEditor(ExtrudedPoly.class, objs -> new ExtrudedPolyEditor());
    }

    private static class XformedGeomNodeEditor
    extends guiPanel
    implements IGeomEditor {
        private static final long serialVersionUID = -6235819727843229411L;
        public final TransformEditor d_xformEditor = new TransformEditor();
        public final IGeomEditor d_baseEditor;

        public XformedGeomNodeEditor(IGeomEditor baseEditor) {
            this.d_baseEditor = baseEditor;
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Transformation")));
            gb.addIdentRow(this.d_xformEditor.getPanel(), 1.0, 0);
            gb.addFilledRow(new TitleSeparator(String.format(Intl.intl("%s Properties"), this.d_baseEditor.getGeomName())));
            gb.addIdentRow(this.d_baseEditor.getPanel(), 1.0, 0);
            gb.finalizeRows();
        }

        @Override
        public String getGeomName() {
            return this.d_baseEditor.getGeomName();
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        public void load(Collection geoms) {
            this.d_xformEditor.load(geoms);
            this.d_baseEditor.load(geoms);
        }

        public void save(Collection geoms) {
            this.d_xformEditor.save(geoms);
            this.d_baseEditor.save(geoms);
        }

        public boolean validateData(Collection geoms, boolean showWarn, boolean allowModify) {
            return this.d_xformEditor.validateData(showWarn, allowModify) && this.d_baseEditor.validateData(geoms, showWarn, allowModify);
        }

        @Override
        public int getNumFaces() {
            return this.d_baseEditor.getNumFaces();
        }

        @Override
        public String[] getFaceNames() {
            return this.d_baseEditor.getFaceNames();
        }

        @Override
        public int[] getFaceOrder(IGeomNode geom) {
            return this.d_baseEditor.getFaceOrder(geom);
        }
    }

    public static abstract class AGeomProp<T extends IGeom>
    extends PropertyUtil.AProp<IPyroGeomSrc, Double> {
        private int d_dataIx;

        public AGeomProp() {
            this(0);
        }

        public AGeomProp(int dataIx) {
            super(IPyroGeomSrc.class);
            this.d_dataIx = dataIx;
        }

        public void setIndex(int ix) {
            this.d_dataIx = ix;
        }

        protected abstract double[] saveData(T var1);

        protected abstract T constructGeom(T var1, double[] var2);

        @Override
        public Object get(IPyroGeomSrc obj) {
            IGeomNode geom = obj.getGeom();
            double[] data = this.saveData(geom.getLocalGeom());
            return data[this.d_dataIx];
        }

        @Override
        public void set(IPyroGeomSrc obj, Double prop) {
            IGeomNode node = obj.getGeom();
            double[] data = this.saveData(node.getLocalGeom());
            data[this.d_dataIx] = prop;
            IGeom newGeom = this.constructGeom(node.getLocalGeom(), data);
            obj.setGeom(node.applyLocalGeom(newGeom));
        }
    }

    private static interface IEditorSupplier
    extends Function<Collection<? extends IPyroGeomSrc>, IGeomEditor<? extends IGeom>> {
    }
}

