/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;

public class SmokeLinkModelEditor
implements IEditor<SmokeLinkModel> {
    private final guiPanel d_edPanel;
    private final guiTextField d_fyi;
    private final ValueField<UnitDouble> d_ot;
    private final ExSpecComboBox d_smokeSpecies;
    private final guiComboBox<String> d_cb;
    private final ValueField<UnitDouble> d_hlen;
    private final ValueField<Double> d_cAlphaC;
    private final ValueField<Double> d_cBetaC;
    private final ValueField<Double> d_cAlphaE;
    private final ValueField<Double> d_cBetaE;
    private final CustomFDSPanel d_customPanel;
    private static final String HESKESTAD = Intl.intl("Heskestad Model");
    private static final String CLEARY = Intl.intl("Cleary Model");

    private static UnitSystem getUnits() {
        return PyroSim.getApp().getUnitSystem();
    }

    public SmokeLinkModelEditor() {
        guiPanel propPnl = new guiPanel(new GridBagLayout());
        guiLabel fyiLbl = new guiLabel(Intl.intl("Description:"));
        this.d_fyi = new guiTextField();
        this.d_customPanel = new CustomFDSPanel(6);
        this.d_ot = ValueFields.udFld(UnitSystem.getSource(31));
        int r = 1;
        GridBagUtil.add(propPnl, fyiLbl, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_fyi, 1, r, 5, 1, 0, 0, 6, 6, 2, 1.0, 0.0, 17);
        guiLabel otLab = new guiLabel(Intl.intl("Obscuration Threshold") + ":");
        GridBagUtil.add(propPnl, otLab, 0, ++r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_ot, 1, r, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        guiLabel smokeSpecLbl = new guiLabel(Intl.intl("Smoke Species:"));
        this.d_smokeSpecies = new ExSpecComboBox(PyroSim.getApp().getMediator().getExSpecList(), null, Intl.intl("Default"));
        GridBagUtil.add(propPnl, smokeSpecLbl, 0, ++r, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_smokeSpecies, 1, r, 2, 1, 0, 0, 6, 0, 0, 1.0, 0.0, 17);
        ++r;
        guiLabel optLab = new guiLabel(Intl.intl("Detector Specification") + ":");
        String[] options = new String[]{HESKESTAD, CLEARY};
        this.d_cb = new guiComboBox<String>((T[])options);
        final CardLayout cards = new CardLayout(0, 0);
        final guiPanel cardPanel = new guiPanel(cards);
        guiPanel hPanel = new guiPanel(new GridBagLayout());
        guiPanel cPanel = new guiPanel(new GridBagLayout());
        cardPanel.add((Component)hPanel, HESKESTAD);
        cardPanel.add((Component)cPanel, CLEARY);
        cards.addLayoutComponent(hPanel, HESKESTAD);
        cards.addLayoutComponent(cPanel, CLEARY);
        GridBagUtil.add(propPnl, optLab, 0, r, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_cb, 1, r, 2, 1, 0, 0, 12, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, cardPanel, 0, ++r, 3, 1, 0, 30, 0, 0, 1, 1.0, 1.0, 18);
        this.d_cb.addActionListener(new ActionListener(){
            private Object last = SmokeLinkModelEditor.access$000();

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object cur = SmokeLinkModelEditor.this.d_cb.getSelectedItem();
                if (cur != this.last) {
                    cards.show(cardPanel, ((String)SmokeLinkModelEditor.this.d_cb.getSelectedItem()).toString());
                    SmokeLinkModelEditor.this.d_edPanel.setModified(true);
                    this.last = cur;
                }
            }
        });
        this.d_hlen = ValueFields.udFld(UnitSystem.getSource(0));
        guiLabel hlenLab = new guiLabel(Intl.intl("Characteristic Length") + ":");
        GridBagUtil.add(hPanel, hlenLab, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(hPanel, this.d_hlen, 1, 0, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 13);
        GridBagUtil.addGlue(hPanel);
        this.d_cAlphaC = ValueFields.doubleFld();
        this.d_cBetaC = ValueFields.doubleFld();
        this.d_cAlphaE = ValueFields.doubleFld();
        this.d_cBetaE = ValueFields.doubleFld();
        guiLabel alphaCLab = new guiLabel("Alpha C:");
        guiLabel betaCLab = new guiLabel("Beta C:");
        guiLabel alphaELab = new guiLabel("Alpha E:");
        guiLabel betaELab = new guiLabel("Beta E:");
        GridBagUtil.add(cPanel, alphaCLab, 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(cPanel, this.d_cAlphaC, 1, 0, 1, 1, 0, 0, 6, 30, 2, 0.0, 0.0, 17);
        GridBagUtil.add(cPanel, betaCLab, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(cPanel, this.d_cBetaC, 1, 1, 1, 1, 0, 0, 0, 30, 2, 0.0, 0.0, 17);
        GridBagUtil.add(cPanel, alphaELab, 2, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(cPanel, this.d_cAlphaE, 3, 0, 1, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 17);
        GridBagUtil.add(cPanel, betaELab, 2, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(cPanel, this.d_cBetaE, 3, 1, 1, 1, 0, 0, 0, 0, 2, 0.0, 0.0, 17);
        GridBagUtil.addGlue(cPanel);
        propPnl.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab(Intl.intl("Properties"), propPnl);
        tabs.addTab(Intl.intl("Advanced"), this.d_customPanel);
        this.d_edPanel = new guiPanel(new BorderLayout());
        this.d_edPanel.add((Component)tabs, "Center");
        this.init(null);
    }

    @Override
    public void addObserver(Observer o) {
        this.d_edPanel.addObserver(o);
    }

    @Override
    public void removeObserver(Observer o) {
        this.d_edPanel.removeObserver(o);
    }

    @Override
    public void init(SmokeLinkModel model) {
        this.d_edPanel.setEnabled(model != null);
        if (model != null) {
            this.d_fyi.setText(model.getFYI());
            this.initSpec(new SmokeLinkModel.Cleary());
            this.initSpec(new SmokeLinkModel.Heskestad());
            this.d_ot.setValue(model.getActivationObscuration());
            this.initSpec(model.getSpec());
            this.d_smokeSpecies.setSelectedItem(model.getSmokeSpecies());
            this.d_customPanel.load(model);
        }
        this.d_edPanel.setModified(false);
    }

    private void initSpec(SmokeLinkModel.ISpec spec) {
        if (spec instanceof SmokeLinkModel.Heskestad) {
            SmokeLinkModel.Heskestad hmodel = (SmokeLinkModel.Heskestad)spec;
            this.d_cb.setSelectedItem(HESKESTAD);
            this.d_hlen.setValue(hmodel.d_length);
        } else if (spec instanceof SmokeLinkModel.Cleary) {
            SmokeLinkModel.Cleary cmodel = (SmokeLinkModel.Cleary)spec;
            this.d_cb.setSelectedItem(CLEARY);
            this.d_cAlphaC.setValue(cmodel.d_cAlpha);
            this.d_cBetaC.setValue(cmodel.d_cBeta);
            this.d_cAlphaE.setValue(cmodel.d_eAlpha);
            this.d_cBetaE.setValue(cmodel.d_eBeta);
        }
    }

    @Override
    public boolean isModified() {
        return this.d_edPanel.isModified();
    }

    @Override
    public SmokeLinkModel commit(final SmokeLinkModel model) {
        assert (model != null);
        assert (this.isModified());
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                SmokeLinkModelEditor.this.save(model);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit Smoke Detector Model"));
        this.d_edPanel.setModified(false);
        return model;
    }

    public boolean validateData(boolean showWarn, boolean allowModify) {
        return this.d_edPanel.validateData(showWarn, allowModify);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this.d_edPanel;
    }

    @Override
    public SmokeLinkModel preview(SmokeLinkModel previewObj) {
        this.save(previewObj);
        return previewObj;
    }

    private void save(SmokeLinkModel model) {
        model.setFYI(this.d_fyi.getText());
        UnitDouble obs = (UnitDouble)this.d_ot.getValue();
        model.setActivationObscuration(obs);
        ExSpec spec = this.d_smokeSpecies.getSelectedItem();
        model.setSmokeSpecies(spec);
        if (this.d_cb.getSelectedItem() == HESKESTAD) {
            model.setSpec(new SmokeLinkModel.Heskestad((UnitDouble)this.d_hlen.getValue()));
        } else if (this.d_cb.getSelectedItem() == CLEARY) {
            model.setSpec(new SmokeLinkModel.Cleary((Double)this.d_cAlphaC.getValue(), (Double)this.d_cBetaC.getValue(), (Double)this.d_cAlphaE.getValue(), (Double)this.d_cBetaE.getValue()));
        }
        this.d_customPanel.save(model);
    }

    static /* synthetic */ String access$000() {
        return HESKESTAD;
    }
}

