/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JSeparator;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.gui.IGridBagAdder;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.NamePnl;
import pyrosim.gui.devices.TripFlagsPanel;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.guiListBuilder;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiPanel;

public class DevicePnl<T extends IDevice>
extends guiPanel {
    private static final long serialVersionUID = 1967996334902404556L;
    public static final int OPT_NAME = 1;
    public static final int OPT_GEOM = 2;
    public static final int OPT_ALL = 3;
    private final PyroMod d_pyMod;
    private final Class<T> d_type;
    private final IDevcEditor<T> d_editor;
    private final NamePnl d_namePnl;
    private final IGeomEditor<? extends IGeom> d_geomEditor;
    private final AlarmInfoPanel d_alarmPanel;
    private final TripFlagsPanel d_tripFlagsPanel;
    private final ControlSelPnl d_eventPanel;
    private T d_loadedObj;
    private List<Validateable> d_toValidate = new ArrayList<Validateable>();

    public DevicePnl(PyroMod pyMod, Class<T> type, IDevcEditor<T> editor, int options) {
        AlarmInfoPanel alarmPnl;
        this.d_pyMod = pyMod;
        this.d_editor = editor;
        this.d_type = type;
        this.d_geomEditor = DevicePnl.test(options, 2) ? this.d_editor.createGeomEditor() : null;
        this.d_namePnl = DevicePnl.test(options, 1) ? new NamePnl(pyMod, editor.getDefName()) : null;
        this.d_alarmPanel = alarmPnl = IMeasurer.class.isAssignableFrom(type) ? editor.createAlarmPanel() : null;
        this.d_tripFlagsPanel = IDetector.class.isAssignableFrom(type) ? editor.createTripPanel() : null;
        this.d_eventPanel = ISignalSink.class.isAssignableFrom(type) ? editor.createCtrlInputPanel(pyMod, this.d_namePnl) : null;
        guiListBuilder<Object> panels = new guiListBuilder<Object>();
        panels.add(this.d_namePnl);
        panels.add(this.d_eventPanel);
        panels.add(editor.getDataPanel());
        panels.addSeparator();
        panels.add(this.d_alarmPanel);
        panels.addSeparator();
        panels.add(this.d_tripFlagsPanel);
        panels.addSeparator();
        panels.add(this.d_geomEditor);
        GridBagHelper gb = new GridBagHelper(this);
        for (Object panel : panels.finalizeList()) {
            if (panel instanceof IGridBagAdder) {
                ((IGridBagAdder)panel).add(gb);
                if (!(panel instanceof Validateable)) continue;
                this.d_toValidate.add((Validateable)panel);
                continue;
            }
            if (panel instanceof Component) {
                gb.addFilledRow(panel);
                continue;
            }
            if (panel != null) continue;
            gb.addFilledRow(new JSeparator());
        }
        gb.finalizeRows();
        if (this.d_eventPanel != null) {
            this.setMinimumSize(new Dimension(400, 0));
        }
    }

    public IDevcEditor<T> getDevcEditor() {
        return this.d_editor;
    }

    public Class<T> getDevcType() {
        return this.d_type;
    }

    private static final boolean test(int flags, int flag) {
        return (flags & flag) == flag;
    }

    public void load(T devc) {
        this.d_loadedObj = devc;
        if (this.d_namePnl != null) {
            this.d_namePnl.load(devc.getName());
        }
        this.d_editor.load(devc);
        if (this.d_eventPanel != null) {
            if (this.d_namePnl != null) {
                this.d_eventPanel.setNameSrc(this.d_namePnl.getNameField(), Arrays.asList(devc));
            }
            this.d_eventPanel.load(Arrays.asList((OneLogicInPin)((ISignalSink)devc).getInputPin()));
        }
        if (this.d_alarmPanel != null) {
            IMeasurer msr = (IMeasurer)devc;
            assert (msr.getNumMeasurements() == 1);
            this.d_alarmPanel.load(msr.getQuantity(0), msr.getMsrInfo(0).getAlarmInfo());
        }
        if (this.d_tripFlagsPanel != null) {
            IDetector det = (IDetector)devc;
            this.d_tripFlagsPanel.load(det.getTripFlags());
        }
        if (this.d_geomEditor != null) {
            this.d_geomEditor.load(Arrays.asList(devc));
        }
    }

    public T save(T devc) {
        if (devc == null) {
            devc = this.d_editor.create();
        }
        if (this.d_namePnl != null) {
            devc.setName(this.d_namePnl.save());
        }
        this.d_editor.save(devc);
        if (this.d_eventPanel != null) {
            this.d_eventPanel.save(Arrays.asList((OneLogicInPin)((ISignalSink)devc).getInputPin()));
            devc.changedEvt(new Object[0]);
        }
        if (this.d_alarmPanel != null) {
            IMeasurer msr = (IMeasurer)devc;
            assert (msr.getNumMeasurements() == 1);
            msr.getMsrInfo(0).setAlarmInfo(this.d_alarmPanel.save());
        }
        if (this.d_tripFlagsPanel != null) {
            IDetector det = (IDetector)devc;
            det.setTripFlags(this.d_tripFlagsPanel.save());
        }
        if (this.d_geomEditor != null) {
            this.d_geomEditor.save(Arrays.asList(devc));
            devc.setGeom(devc.getGeom().bakeIfRecommended());
        }
        return devc;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        for (Validateable v : this.d_toValidate) {
            if (v.validateData(showWarn, allowModify)) continue;
            return false;
        }
        if (!this.d_editor.validateData(this, this.d_loadedObj, showWarn, allowModify)) {
            return false;
        }
        if (this.d_geomEditor != null && this.d_loadedObj != null && !this.d_geomEditor.validateData(Arrays.asList(this.d_loadedObj), showWarn, allowModify)) {
            return false;
        }
        return this.d_eventPanel == null || this.d_loadedObj == null || this.d_eventPanel.validateData(this, (ISignalSink)this.d_loadedObj, showWarn, allowModify);
    }
}

