/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.devices.IDevice;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.FDSRecordPreviewPanel;
import pyrosim.gui.InvisibleSplitPane;
import pyrosim.gui.devices.DevicePnl;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSRenderRecord;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;

public class DeviceDlg<T extends IDevice>
extends guiDialog {
    private static final long serialVersionUID = -6407963949610169818L;
    private final DevicePnl<T> d_pnl;
    private final CustomFDSPanel d_customPnl;
    private final FDSRecordPreviewPanel d_previewPnl;
    private final int d_advancedIx;
    private T d_loaded = null;
    private static final String ADVANCED = Intl.intl("Advanced");

    public DeviceDlg(JFrame owner, PyroMod pyMod, Class<T> type, IDevcEditor<T> editor) {
        super((Window)owner, editor.getDesc(), 9);
        JComponent topPanel;
        this.d_pnl = new DevicePnl<T>(pyMod, type, editor, 3);
        guiPanel panel = this.getDialogPane();
        panel.setLayout(new BorderLayout());
        if (editor.getCustomEnabled()) {
            this.d_pnl.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.d_customPnl = new CustomFDSPanel(6);
            JTabbedPane tabs = new JTabbedPane();
            tabs.add(Intl.intl("Properties"), this.d_pnl);
            this.d_advancedIx = tabs.getTabCount();
            tabs.add(ADVANCED, this.d_customPnl);
            tabs.addChangeListener(evt -> tabs.setTitleAt(this.d_advancedIx, ADVANCED));
            Semaphore customLock = new Semaphore(1);
            panel.addObserver((o, evt) -> {
                if (!customLock.tryAcquire()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    this.updateCustomTypes(tabs);
                    customLock.release();
                });
            });
            topPanel = tabs;
            this.d_customPnl.load(Arrays.asList(editor.create()));
            this.updateCustomTypes(tabs);
        } else {
            topPanel = this.d_pnl;
            this.d_customPnl = null;
            this.d_advancedIx = -1;
        }
        if (editor.getPreviewEnabled() && PyroPrefs.getBoolean(PyroPrefs.PREF_RECORD_PREVIEW)) {
            Set<String> previewTypes = editor.getFDSPreviewTypes();
            Predicate<FDSRenderRecord> recFilter = r -> previewTypes.contains(r.getType());
            this.d_previewPnl = new FDSRecordPreviewPanel(FDS.newRenderer(PyroSim.getApp().getMediator(), PyroSim.getApp().getFDSRenderProps()), recFilter);
            this.d_previewPnl.setRenderDeps(true);
            InvisibleSplitPane splitPane = new InvisibleSplitPane(0, true, topPanel, this.d_previewPnl);
            panel.add((Component)splitPane, "Center");
            panel.addObserver((evt, args) -> this.preview());
            this.preview();
        } else {
            this.d_previewPnl = null;
            panel.add(topPanel, "Center");
        }
        this.setResizable(true);
    }

    private void updateCustomTypes(JTabbedPane tabs) {
        Collection<String> types = this.d_pnl.getDevcEditor().getCustomTypes();
        boolean modified = this.d_customPnl.setTypes(types);
        if (modified) {
            tabs.setTitleAt(this.d_advancedIx, "<html><i>" + ADVANCED);
        }
    }

    public void load(T devc) {
        this.d_pnl.load(devc);
        if (this.d_customPnl != null) {
            this.d_customPnl.load(Arrays.asList(devc));
        }
        this.d_loaded = devc;
        this.preview();
    }

    public T save(T devc) {
        T result = this.d_pnl.save(devc);
        if (this.d_customPnl != null) {
            this.d_customPnl.save(Arrays.asList(result));
        }
        return result;
    }

    private void preview() {
        if (this.d_previewPnl == null) {
            return;
        }
        if (!this.getDialogPane().validateData(false, false)) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            try {
                IDevice devc = null;
                if (this.d_loaded != null) {
                    devc = (IDevice)this.d_loaded.clone();
                }
                devc = this.save(devc);
                this.d_previewPnl.setRecord(devc, true);
            }
            catch (Throwable t) {
                System.err.println("[02338fc] FDS Preview Failed: " + t.getMessage());
                t.printStackTrace();
            }
        });
    }
}

