/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.gui.boundcond.SurfacePanel;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;

public class NewSurfaceDlg
extends guiDialog {
    private static final long serialVersionUID = -785877814498679308L;
    private SurfaceManager d_surfMgr = null;
    private guiTextField d_name = null;
    private guiComboBox<Surface> d_baseMat = null;
    private guiComboBox<Surface> d_surfType = null;

    public NewSurfaceDlg(Window parent, SurfaceManager surfMgr, Surface init) {
        super(parent, Intl.intl("New Surface"), 9);
        this.d_surfMgr = surfMgr;
        this.d_baseMat = this.getSurfCombo(this.d_surfMgr, init);
        boolean hasSurface = false;
        for (Surface s : this.d_surfMgr.flatten()) {
            if (s.isPredefined()) {
                this.d_baseMat.removeItem(s);
                continue;
            }
            hasSurface = true;
        }
        Surface inert = surfMgr.get(PredefSurf.INERT);
        this.d_surfType = new guiComboBox();
        this.d_baseMat.setEnabled(hasSurface);
        this.d_surfType.setRenderer(new typeCBRenderer());
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.BASIC, inert.getColor(), null, Surface.newBasicDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.BURNER, new Color(1.0f, 0.0f, 0.0f), null, new BurnerSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.GENERAL, new Color(1.0f, 0.4f, 0.0f), null, new GeneralSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.CONSTANT_TEMP, new Color(1.0f, 0.4f, 0.0f), null, new ConstantTempSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.SUPPLY, new Color(0.1f, 0.8f, 0.1f), null, new BlowerSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.EXHAUST, new Color(0.1f, 0.5f, 0.1f), null, new InFlowSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.LAYERED, new Color(146, 202, 166), null, new LayeredSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.LEAK, new Color(127, 221, 255), null, new LeakSurfDesc(new ZonePath(null, null))));
        this.d_name = new guiTextField(this.generateUniqueName());
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(dlgPanel, new guiLabel(Intl.intl("Surface Name") + ":"), 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, this.d_name, 1, row++, 1, 1, 0, 0, 6, 0);
        if (hasSurface) {
            guiRadioButton typeSurfRB = new guiRadioButton(Intl.intl("Surface Type") + ":");
            GridBagUtil.add(dlgPanel, typeSurfRB, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_surfType, 1, row++, 1, 1, 0, 0, 6, 0);
            guiRadioButton tempSurfRB = new guiRadioButton(Intl.intl("Template Surface") + ":");
            GridBagUtil.add(dlgPanel, tempSurfRB, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_baseMat, 1, row++, 1, 1, 0, 0, 6, 0);
            LinkStatus.link((AbstractButton)tempSurfRB, this.d_baseMat);
            LinkStatus.link((AbstractButton)typeSurfRB, this.d_surfType);
            ButtonGroup group = new ButtonGroup();
            group.add(typeSurfRB);
            group.add(tempSurfRB);
            typeSurfRB.setSelected(true);
        } else {
            guiLabel typeSurfLab = new guiLabel(Intl.intl("Surface Type") + ":");
            GridBagUtil.add(dlgPanel, typeSurfLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlgPanel, this.d_surfType, 1, row++, 1, 1, 0, 0, 6, 0);
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        String reqName = this.d_name.getText();
        if (this.nameInUse(reqName)) {
            String msg = Intl.intl("Surface name already in use.") + "\n" + Intl.intl("Each surface must have a unique name.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            String msg = Intl.intl("You must name the surface.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    private guiComboBox<Surface> getSurfCombo(SurfaceManager surfMgr, Surface init) {
        SurfaceComboBox cbSurfs = new SurfaceComboBox(surfMgr, init);
        return cbSurfs;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    public Surface getBaseMat() {
        if (this.d_baseMat.isEnabled()) {
            return this.d_baseMat.getSelectedItem();
        }
        if (this.d_surfType.isEnabled()) {
            return this.d_surfType.getSelectedItem();
        }
        return null;
    }

    private String generateUniqueName() {
        return ((PyroMod)this.d_surfMgr.getDomain()).getNames(Surface.class).generateName();
    }

    private boolean nameInUse(String name) {
        return ((PyroMod)this.d_surfMgr.getDomain()).getNames(Surface.class).isRegistered(name);
    }

    protected class typeCBRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 6096926854130472386L;
        private Font d_normalFont = new Font("Sans Serif", 1, 11);

        protected typeCBRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Surface surf = (Surface)value;
            if (surf == null) {
                return this;
            }
            String name = ((Surface)value).getName();
            this.setText(name);
            this.setFont(this.d_normalFont);
            return this;
        }
    }
}

