/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.appearance;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.appearance.ImageBtnListener;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.DlgListener;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.ImageBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class MaterialDlg
extends guiDialog
implements IEventObserver,
DlgListener {
    private static final long serialVersionUID = 2884804570534305967L;
    public static final String MATERIAL_DLG_VIEW = "MaterialDlg.View";
    public static final String LIST_OPTION = "list option";
    public static final String ICONS_OPTION = "icons option";
    private List<Material> d_materials;
    private Material d_choice;
    private final MaterialDB d_texDB;
    private final EditorPnl d_editor;
    private final IconsPanel d_iconsPanel;
    private final JButton d_removeBtn;

    public MaterialDlg(JFrame parent, String title, MaterialDB texDB, Material init, boolean includeNull) {
        super((Window)parent, title, 11);
        super.setResizable(true);
        this.d_choice = null;
        this.d_texDB = texDB;
        this.d_editor = new EditorPnl();
        this.d_removeBtn = new JButton(new RemoveAction());
        JButton importBtn = new JButton(new ImportAction());
        this.d_iconsPanel = new IconsPanel(this.d_editor);
        this.d_iconsPanel.setPreferredSize(new Dimension(200, 400));
        JSplitPane splitPane = new JSplitPane(1, this.d_iconsPanel, this.d_editor);
        guiPanel content = super.getDialogPane();
        content.setLayout(new GridBagLayout());
        GridBagUtil.add(content, splitPane, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        GridBagUtil.add(content, importBtn, 0, 1, 1, 1, 12, 12, 0, 0, 0, 0.0, 0.0);
        GridBagUtil.add(content, this.d_removeBtn, 1, 1, 1, 1, 12, 6, 0, 0, 0, 0.0, 0.0);
        this.addDlgListener(this);
        CloseListener closeLis = new CloseListener();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().unregisterKeyboardAction(ks);
        this.getRootPane().registerKeyboardAction(closeLis, ks, 2);
        this.setDefaultCloseOperation(0);
        this.removeWindowListener(this.d_cancelListener);
        this.addWindowListener(closeLis);
        this.d_iconsPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                Material newMat = (Material)e.getItem();
                if (newMat == MaterialDlg.this.d_choice) {
                    return;
                }
                if (MaterialDlg.this.d_choice != null && MaterialDlg.this.d_editor.isModified()) {
                    switch (MaterialDlg.this.showConfirm()) {
                        case 0: {
                            boolean isValid = MaterialDlg.this.handleYes();
                            if (!isValid) {
                                MaterialDlg.this.setChoice(MaterialDlg.this.d_choice);
                                break;
                            }
                        }
                        case 1: {
                            MaterialDlg.this.setChoice(newMat);
                            break;
                        }
                        default: {
                            MaterialDlg.this.setChoice(MaterialDlg.this.d_choice);
                            break;
                        }
                    }
                } else {
                    MaterialDlg.this.setChoice(newMat);
                }
            }
        });
        this.updateMaterialsList(includeNull);
        this.setChoice(init);
    }

    @Override
    public int doModal() {
        PyroSim.getApp().getMediator().getEvents().addObserver(this);
        int result = super.doModal();
        PyroSim.getApp().getMediator().getEvents().removeObserver(this);
        return result;
    }

    @Override
    public boolean doModeless() {
        PyroSim.getApp().getMediator().getEvents().addObserver(this);
        boolean result = super.doModeless();
        PyroSim.getApp().getMediator().getEvents().removeObserver(this);
        return result;
    }

    protected final boolean preSave() {
        if (this.d_editor.isModified()) {
            int opt = this.showConfirm();
            if (opt == 1) {
                this.d_editor.init(this.d_choice);
            } else if (opt == 0) {
                if (!this.handleYes()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public int showConfirm() {
        Material edObj = this.d_choice;
        String msg = String.format(Intl.intl("Save changes to: %s?"), edObj.getName());
        return JOptionPane.showConfirmDialog(this, msg);
    }

    protected boolean handleYes() {
        if (!this.d_editor.validateData(true, true)) {
            this.setChoice(this.d_choice);
            return false;
        }
        this.d_editor.commit(this.d_choice, false);
        return true;
    }

    @Override
    public void okPressed() {
        this.applyPressed();
    }

    @Override
    public void applyPressed() {
        if (this.d_editor.isModified()) {
            this.d_editor.commit(this.d_choice, false);
            this.d_iconsPanel.repaint();
        }
    }

    @Override
    public void cancelPressed() {
    }

    @Override
    public void helpPressed() {
    }

    @Override
    public void resetPressed() {
    }

    @Override
    public void closePressed() {
        if (this.d_editor.isModified()) {
            switch (this.showConfirm()) {
                case 0: {
                    if (this.handleYes()) {
                        this.setChoice(this.d_choice);
                        this.setVisible(false);
                        break;
                    }
                    this.setChoice(this.d_choice);
                    break;
                }
                case 1: {
                    this.setChoice(this.d_choice);
                    this.setVisible(false);
                    break;
                }
                default: {
                    this.setChoice(this.d_choice);
                    break;
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    public Material getSelectedEntry() {
        return this.d_choice;
    }

    private void setChoice(Material choice) {
        this.d_choice = choice;
        this.d_removeBtn.setEnabled(this.d_choice != null);
        this.d_iconsPanel.setSelectedItem(choice);
        this.d_editor.init(choice);
    }

    protected void showException(Exception e, String msg) {
        PyroGuiUtil.showError(this, Intl.intl("Error"), msg, (Throwable)e);
    }

    protected void updateMaterialsList(boolean includeNull) {
        this.d_materials = new ArrayList(this.d_texDB.flatten());
        if (includeNull) {
            this.d_materials.add(null);
        }
        this.sortMaterials();
        this.d_iconsPanel.update(this.d_materials);
    }

    private void sortMaterials() {
        Collections.sort(this.d_materials, new Comparator<Material>(){

            @Override
            public int compare(Material o1, Material o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }

    @Override
    public void update(Events events) {
        IEventRecord<Material> mevts = events.getEvents(Material.class, new Class[0]);
        if (!mevts.isModified()) {
            return;
        }
        boolean sort = false;
        boolean updatePnl = false;
        Material newSel = this.d_choice;
        for (Material mat : mevts.getAddedObjs()) {
            if (newSel == null) {
                newSel = mat;
            }
            this.d_materials.add(mat);
            updatePnl = true;
            sort = true;
        }
        for (Material mat : mevts.getRemovedObjs()) {
            if (mat.equals(this.d_choice)) {
                newSel = null;
            }
            this.d_materials.remove(mat);
            updatePnl = true;
        }
        if (sort) {
            this.sortMaterials();
        }
        if (updatePnl) {
            this.d_iconsPanel.update(this.d_materials);
            this.repaint();
        }
        this.setChoice(newSel);
    }

    private class RemoveAction
    extends guiAction {
        private static final long serialVersionUID = 3516972269513761812L;

        public RemoveAction() {
            super(Intl.intl("Remove") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Task delTask;
            if (MaterialDlg.this.d_choice == null) {
                return;
            }
            String id = MaterialDlg.this.d_choice.getName();
            if (MaterialDlg.this.d_texDB.isPermanent(MaterialDlg.this.d_choice)) {
                String title;
                String msg = String.format(Intl.intl("Permanently remove database appearance: %s?<br><b>NOTE:</b> This operation cannot be undone."), id);
                msg = "<html>" + msg + "</html>";
                int choice = JOptionPane.showConfirmDialog(null, msg, title = Intl.intl("Remove Appearance?"), 0, 2);
                if (choice != 0) {
                    return;
                }
            }
            if ((delTask = Actions.getDeleteTask((PyroMod)MaterialDlg.this.d_texDB.getDomain(), Arrays.asList(MaterialDlg.this.d_choice))) == null) {
                return;
            }
            if (MaterialDlg.this.d_texDB.isPermanent(MaterialDlg.this.d_choice)) {
                final Task undoableTsk = delTask;
                delTask = new AOneTimeTask(){

                    @Override
                    public void run() {
                        undoableTsk.run();
                    }
                };
            }
            PyroMod mod = PyroSim.getApp().getMediator();
            mod.getTaskManager().exec(delTask, Intl.intl("Remove Appearance"), 1);
        }
    }

    private class ImportAction
    extends guiAction {
        private static final long serialVersionUID = 4515572153163001586L;

        public ImportAction() {
            super(Intl.intl("Import") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            guiFileChooser chooser = PyroSim.getFilenames().getFileChooser(MaterialDlg.this.d_texDB.getFileFilters());
            chooser.setMultiSelectionEnabled(true);
            if (chooser.showOpenDialog(MaterialDlg.this) != 0) {
                return;
            }
            final File[] texfiles = chooser.getSelectedFiles();
            final ArrayList newMaterials = new ArrayList(texfiles.length);
            final ArrayList exceptions = new ArrayList();
            PyroMod mod = PyroSim.getApp().getMediator();
            AOneTimeTask op = new AOneTimeTask(){

                @Override
                public void run() {
                    try {
                        for (File texFile : texfiles) {
                            IImage img = ImageManager.getImage(texFile.getAbsolutePath(), 3, 0);
                            String name = FilenameManager.splitFilename(texFile.getName())[0];
                            Texture diffTex = Texture.repeated(img, "uvset");
                            MatAttrs matAttrs = new MatAttrs(Color.WHITE, diffTex, 1.0);
                            Material newMat = new Material(name, matAttrs);
                            MaterialDlg.this.d_texDB.add(newMat);
                            MaterialDlg.this.d_texDB.importToDB(newMat);
                            newMaterials.add(newMat);
                        }
                    }
                    catch (Exception exp) {
                        exceptions.add(exp);
                    }
                }
            };
            mod.getTaskManager().exec((Task)op, Intl.intl("Import Appearances"), 1);
            if (!exceptions.isEmpty()) {
                MaterialDlg.this.showException((Exception)exceptions.get(0), Intl.intl("Error importing appearance."));
            }
        }
    }

    private static class TiledPanel
    extends guiPanel {
        private static final long serialVersionUID = 5351990684840771048L;
        private final MatChannel d_channel;
        private Material d_choice;

        public TiledPanel(MatChannel channel) {
            this.d_channel = channel;
        }

        public void setMaterial(Material choice) {
            this.d_choice = choice;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Rectangle visrect = this.getBounds();
            if (this.d_choice == null) {
                FontMetrics fm = g2d.getFontMetrics();
                String str = Intl.intl("No Material");
                Rectangle2D bnds = fm.getStringBounds(str, g2d);
                int x = visrect.width / 2 - (int)(bnds.getWidth() / 2.0);
                int y = visrect.height / 2 - (int)(bnds.getHeight() / 2.0);
                g2d.setColor(Color.BLACK);
                g2d.drawString(str, x, y);
            } else if (this.d_choice.getAttributes().getTexture(this.d_channel) != null) {
                Texture tex = this.d_choice.getAttributes().getTexture(this.d_channel);
                BufferedImage img = PyroGuiUtil.getBufferedImage(tex.image);
                if (img == null) {
                    return;
                }
                int wid = img.getWidth();
                int ht = img.getHeight();
                int tx = (visrect.width + wid - 1) / wid;
                int ty = (visrect.height + ht - 1) / ht;
                for (int i = 0; i < tx; ++i) {
                    for (int j = 0; j < ty; ++j) {
                        g2d.drawImage(img, null, i * wid, j * ht);
                    }
                }
            } else {
                Color color = this.d_choice.getAttributes().getColor(this.d_channel);
                g2d.setColor(color);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private static class ImagePanel
    extends guiPanel {
        private static final long serialVersionUID = -4248122173336772028L;
        private Material d_choice;
        private final MatChannel d_channel;

        public ImagePanel(MatChannel channel) {
            this.d_channel = channel;
        }

        public void setMaterial(Material mat) {
            this.d_choice = mat;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Rectangle visrect = this.getBounds();
            if (this.d_choice == null) {
                FontMetrics fm = g2d.getFontMetrics();
                String str = Intl.intl("No Material");
                Rectangle2D bnds = fm.getStringBounds(str, g2d);
                int x = visrect.width / 2 - (int)(bnds.getWidth() / 2.0);
                int y = visrect.height / 2 - (int)(bnds.getHeight() / 2.0);
                g2d.setColor(Color.BLACK);
                g2d.drawString(str, x, y);
            } else if (this.d_choice.getAttributes().getTexture(this.d_channel) != null) {
                Texture tex = this.d_choice.getAttributes().getTexture(this.d_channel);
                BufferedImage img = PyroGuiUtil.getBufferedImage(tex.image);
                if (img == null) {
                    return;
                }
                int wid = img.getWidth();
                int ht = img.getHeight();
                double sx = Math.min(1.0, (double)this.getWidth() / (double)wid);
                double sy = Math.min(1.0, (double)this.getHeight() / (double)ht);
                double scale = Math.min(sx, sy);
                double swid = scale * (double)wid;
                double sht = scale * (double)ht;
                double tx = Math.max(0.0, ((double)this.getWidth() - swid) / 2.0);
                double ty = Math.max(0.0, ((double)this.getHeight() - sht) / 2.0);
                AffineTransform xform = new AffineTransform();
                xform.translate(tx, ty);
                xform.scale(scale, scale);
                g2d.drawImage(img, xform, this);
            } else {
                Color color = this.d_choice.getAttributes().getColor(this.d_channel);
                double wid = 128.0;
                double ht = 128.0;
                double centerx = (double)this.getWidth() * 0.5;
                double centery = (double)this.getHeight() * 0.5;
                g2d.setColor(color);
                g2d.fillRect((int)Math.round(centerx - wid * 0.5), (int)Math.round(centery - ht * 0.5), (int)wid, (int)ht);
            }
        }
    }

    private static class EditorPnl
    extends guiPanel
    implements Observer {
        private static final long serialVersionUID = -2568401929296596028L;
        private final guiLabel d_title;
        private final guiRadioButton d_colorRB;
        private final guiRadioButton d_imgRB;
        private final ColorButton d_colorBtn;
        private final ImageBtn d_imgBtn;
        private final ImageBtnListener d_imgBtnLnr;
        private final ValueField<UnitDouble> d_opacityFld;
        private final ValueField<UnitDouble> d_wid;
        private final ValueField<UnitDouble> d_ht;
        private final ImagePanel d_preview = new ImagePanel(MatChannel.DIFFUSE);
        private final TiledPanel d_tiled;
        private Material d_previewObj;

        public EditorPnl() {
            this.d_preview.setPreferredSize(new Dimension(400, 300));
            this.d_tiled = new TiledPanel(MatChannel.DIFFUSE);
            this.d_tiled.setPreferredSize(new Dimension(400, 300));
            this.d_title = new guiLabel();
            this.d_title.setFont(new Font("Sans Serif", 1, 11));
            this.d_colorRB = new guiRadioButton(Intl.intl("Color:"));
            this.d_imgRB = new guiRadioButton(Intl.intl("Texture Image:"));
            this.d_imgRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!this.chooseImage()) {
                        d_colorRB.setSelected(true);
                    }
                }
            });
            new guiButtonGroup(this.d_colorRB, this.d_imgRB);
            this.d_colorBtn = new ColorButton(1);
            this.d_colorBtn.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.setModified(true);
                }
            });
            this.d_imgBtn = new ImageBtn();
            this.d_imgBtn.addObserver(new IObserver(){

                @Override
                public void update(IObservable source, Object arg) {
                    this.setModified(true);
                }
            }, false);
            this.d_imgBtnLnr = new ImageBtnListener();
            this.d_imgBtn.addActionListener(this.d_imgBtnLnr);
            IUnitSrc ltype = UnitSystem.getSource(0);
            guiLabel widLbl = new guiLabel(Intl.intl("Width:"));
            this.d_wid = ValueFields.udFld(ltype);
            guiLabel htLbl = new guiLabel(Intl.intl("Height:"));
            this.d_ht = ValueFields.udFld(ltype);
            this.d_wid.setMinimumSize(this.d_wid.getPreferredSize());
            this.d_ht.setMinimumSize(this.d_ht.getPreferredSize());
            IUnitSrc ptype = UnitSystem.getSource(84);
            this.d_opacityFld = ValueFields.udFld(ptype, UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true));
            LinkStatus.link((AbstractButton)this.d_colorRB, this.d_colorBtn);
            LinkStatus.link((AbstractButton)this.d_imgRB, this.d_imgBtn, this.d_wid, this.d_ht, widLbl, htLbl);
            JTabbedPane jtp = new JTabbedPane();
            jtp.setTabPlacement(3);
            jtp.add(Intl.intl("Image"), this.d_preview);
            jtp.add(Intl.intl("Tiled"), this.d_tiled);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Name:"), this.d_title, 0);
            gb.addRow(this.d_colorRB, this.d_colorBtn, 0);
            gb.addRow(this.d_imgRB, this.d_imgBtn, 0);
            gb.indent();
            gb.addRow(widLbl, this.d_wid, 0);
            gb.addRow(htLbl, this.d_ht, 0);
            gb.unindent();
            gb.addRow(Intl.intl("Opacity:"), this.d_opacityFld, 0);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Preview")));
            gb.addIdentRow(jtp, new double[]{1.0, 1.0}, new int[]{0, 0});
            gb.finalizeRows();
            this.d_comm.addObserver(this);
        }

        private boolean chooseImage() {
            if (this.d_imgBtn.getImage() != null) {
                return true;
            }
            return this.d_imgBtnLnr.chooseNewImage(this.d_imgBtn);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (this.d_previewObj != null && this.validateData(false, false)) {
                this.commit(this.d_previewObj, true);
                this.d_preview.repaint();
                this.d_tiled.repaint();
            }
        }

        public void init(Material entry) {
            this.d_previewObj = entry != null ? entry.clone() : null;
            this.setEnabled(entry != null && entry.getAttributes() instanceof MatAttrs);
            if (entry == null) {
                this.d_title.setText(Intl.intl("no material"));
                this.d_wid.setValue(new UnitDouble(0.0, (Unit)SI.METER));
                this.d_ht.setValue(new UnitDouble(0.0, (Unit)SI.METER));
                this.d_colorBtn.setSelected(true);
                this.d_colorBtn.setColor(Color.WHITE);
                this.d_opacityFld.setValue(new UnitDouble(100.0, NonSI.PERCENT));
                this.d_imgBtn.setImage(null);
            } else {
                String name = entry.getName();
                this.d_title.setText(name);
                this.d_wid.setValue(entry.getWidth());
                this.d_ht.setValue(entry.getHeight());
                IMatAttrs attrs = entry.getAttributes();
                Texture diffTex = attrs.getTexture(MatChannel.DIFFUSE);
                this.d_colorBtn.setColor(attrs.getColor(MatChannel.DIFFUSE));
                if (diffTex == null) {
                    this.d_colorRB.setSelected(true);
                    this.d_imgBtn.setImage(null);
                } else {
                    this.d_imgRB.setSelected(true);
                    this.d_imgBtn.setImage(diffTex.image);
                }
                double alpha = 1.0;
                if (diffTex == null) {
                    alpha *= (double)attrs.getColor(MatChannel.DIFFUSE).getAlpha() / 255.0;
                }
                this.d_opacityFld.setValue(new UnitDouble(alpha *= (double)attrs.getColor(MatChannel.OPACITY).getRed() / 255.0, Unit.ONE));
            }
            this.d_preview.setMaterial(this.d_previewObj);
            this.d_tiled.setMaterial(this.d_previewObj);
            this.setModified(false);
        }

        public void commit(final Material entry, boolean preview) {
            if (preview) {
                this.apply(entry);
                return;
            }
            final PyroMod mod = PyroSim.getApp().getMediator();
            AOneTimeTask op = new AOneTimeTask(){

                @Override
                public void run() {
                    try {
                        this.apply(entry);
                        mod.getAppearances().updateFile(entry);
                    }
                    catch (IOException exp) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PyroGuiUtil.showError(this, Intl.intl("Error"), Intl.intl("Error saving appearance to file."), (Throwable)exp);
                            }
                        });
                    }
                }
            };
            mod.getTaskManager().exec((Task)op, Intl.intl("Edit Appearance"), 1);
        }

        private void apply(Material entry) {
            MatAttrs attrs = (MatAttrs)entry.getAttributes();
            entry.setSize((UnitDouble)this.d_wid.getValue(), (UnitDouble)this.d_ht.getValue());
            Texture oldDiffTex = attrs.getTexture(MatChannel.DIFFUSE);
            Texture diffTex = null;
            if (this.d_imgRB.isSelected() && this.d_imgBtn.getImage() != null) {
                String uvset = oldDiffTex != null ? oldDiffTex.uvSet : "uvset";
                diffTex = Texture.repeated(this.d_imgBtn.getImage(), uvset);
            }
            Color diffColor = this.d_colorBtn.getColor();
            diffColor = new Color(diffColor.getRed(), diffColor.getGreen(), diffColor.getBlue(), 255);
            int a = (int)(((UnitDouble)this.d_opacityFld.getValue()).getValue(Unit.ONE) * 255.0);
            Color opacColor = new Color(a, a, a, 255);
            attrs = attrs.apply(IMatAttrs.OPACITY_COLOR, opacColor, IMatAttrs.DIFFUSE_COLOR, diffColor, IMatAttrs.DIFFUSE_TEXTURE, diffTex);
            entry.setAttributes(attrs);
        }
    }

    private static class FlowPanel
    extends guiPanel
    implements IconView,
    ItemListener {
        private static final long serialVersionUID = 7909428469657713465L;
        private final guiPanel d_changeTrackPnl;
        private final List<ItemListener> d_listeners;

        public FlowPanel(guiPanel changeTrackPnl) {
            super(new FlowLayout(0));
            this.d_changeTrackPnl = changeTrackPnl;
            this.d_changeTrackPnl.getComm().addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.updateModified();
                }
            });
            this.setBackground(UIManager.getDefaults().getColor("List.background"));
            this.d_listeners = new ArrayList<ItemListener>();
        }

        private void updateModified() {
            for (MaterialButton btn : this.getButtons()) {
                btn.setModified(btn.isSelected() && this.d_changeTrackPnl.isModified());
            }
        }

        @Override
        public Object[] getSelectedObjects() {
            Object[] objectArray;
            MaterialButton tb = (MaterialButton)this.getSelectedButton().v1;
            if (tb != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = tb.d_ti;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = null;
            }
            return objectArray;
        }

        @Override
        public void addItemListener(ItemListener listener) {
            this.d_listeners.add(listener);
        }

        @Override
        public void removeItemListener(ItemListener listener) {
            this.d_listeners.remove(listener);
        }

        @Override
        public JComponent getPanel() {
            JScrollPane comp = new JScrollPane(this){
                private static final long serialVersionUID = -8464848771729576789L;

                @Override
                public void setBounds(int x, int y, int width, int height) {
                    int flowPanelHeight;
                    int rows;
                    int cols;
                    super.setBounds(x, y, width, height);
                    int numButtons = this.getButtons().size();
                    int hGap = ((FlowLayout)this.getLayout()).getHgap();
                    int vGap = ((FlowLayout)this.getLayout()).getVgap();
                    int flowPanelMaxWidth = width;
                    int buttonWidth = 0;
                    int buttonHeight = 0;
                    if (this.getComponentCount() != 0) {
                        Component c = this.getComponent(0);
                        Dimension d = c.getPreferredSize();
                        buttonWidth = (int)d.getWidth();
                        buttonHeight = (int)d.getHeight();
                    }
                    if ((cols = (flowPanelMaxWidth - hGap) / (buttonWidth + hGap)) < 1) {
                        cols = 1;
                    }
                    if ((rows = numButtons / cols) * cols != numButtons) {
                        ++rows;
                    }
                    if ((flowPanelHeight = rows * buttonHeight + (rows + 1) * vGap) > height) {
                        flowPanelMaxWidth = width - this.getVerticalScrollBar().getPreferredSize().width;
                        cols = (flowPanelMaxWidth - hGap) / (buttonWidth + hGap);
                        if (cols < 1) {
                            cols = 1;
                        }
                        if ((rows = numButtons / cols) * cols != numButtons) {
                            ++rows;
                        }
                        flowPanelHeight = rows * buttonHeight + (rows + 1) * vGap;
                    }
                    int flowPanelWidth = cols * buttonWidth + (cols + 1) * hGap;
                    this.setPreferredSize(new Dimension(flowPanelWidth, flowPanelHeight));
                }
            };
            comp.setHorizontalScrollBarPolicy(31);
            return comp;
        }

        @Override
        public void update(List<Material> materials) {
            this.removeAll();
            ButtonGroup bg = new ButtonGroup();
            for (Material mat : materials) {
                MaterialButton button = new MaterialButton(mat);
                button.addItemListener(this);
                this.add(button);
                bg.add(button);
            }
        }

        @Override
        public void updateSel(Material choice) {
            for (MaterialButton tb : this.getButtons()) {
                if (!theUtil.equal(tb.d_ti, choice)) continue;
                IListenerStripper listeners = PyroGuiUtil.stripListeners(tb);
                tb.setSelected(true);
                listeners.restore();
                Rectangle bounds = tb.getBounds();
                this.scrollRectToVisible(bounds);
                break;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                MaterialButton tb = (MaterialButton)e.getItem();
                Material item = tb != null ? tb.d_ti : null;
                ItemEvent evt = new ItemEvent(this, e.getID(), item, e.getStateChange());
                for (ItemListener listener : this.d_listeners) {
                    listener.itemStateChanged(evt);
                }
            }
        }

        private Pair<MaterialButton, Integer> getSelectedButton() {
            int ix = 0;
            for (MaterialButton btn : this.getButtons()) {
                if (btn.isSelected()) {
                    return new Pair<MaterialButton, Integer>(btn, ix);
                }
                ++ix;
            }
            return new Pair<Object, Integer>(null, -1);
        }

        private List<MaterialButton> getButtons() {
            ArrayList<MaterialButton> buttons = new ArrayList<MaterialButton>();
            for (int m = 0; m < this.getComponentCount(); ++m) {
                Component c = this.getComponent(m);
                if (!(c instanceof MaterialButton)) continue;
                MaterialButton tb = (MaterialButton)c;
                buttons.add(tb);
            }
            return buttons;
        }

        private static class MaterialButton
        extends JToggleButton {
            private static final long serialVersionUID = -8285533984506071661L;
            private final Material d_ti;

            public MaterialButton(Material ti) {
                this.d_ti = ti;
                PyroGuiUtil.initButton((AbstractButton)this, ti, 32, 32);
            }

            public void setModified(boolean modified) {
                if (modified) {
                    this.setFont(this.getFont().deriveFont(2));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                }
            }
        }
    }

    private static class ListPanel
    extends guiPanel
    implements IconView {
        private static final long serialVersionUID = 299773869766294421L;
        private final guiPanel d_changeTrackPnl;
        private final JList d_selList;

        public ListPanel(guiPanel changeTrackPnl) {
            super(new GridBagLayout());
            this.d_changeTrackPnl = changeTrackPnl;
            this.d_changeTrackPnl.getComm().addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.repaint();
                }
            });
            this.d_selList = new JList();
        }

        @Override
        public Object[] getSelectedObjects() {
            return new Object[]{this.d_selList.getSelectedValue()};
        }

        @Override
        public JComponent getPanel() {
            return new JScrollPane(this);
        }

        @Override
        public void addItemListener(ItemListener listener) {
            this.d_selList.addListSelectionListener(new SelListener(listener));
        }

        @Override
        public void removeItemListener(ItemListener listener) {
            for (ListSelectionListener llistener : this.d_selList.getListSelectionListeners()) {
                if (!(llistener instanceof SelListener) || ((SelListener)llistener).ilistener != listener) continue;
                this.d_selList.removeListSelectionListener(llistener);
                break;
            }
        }

        @Override
        public void update(List<Material> materials) {
            this.remove(this.d_selList);
            this.d_selList.setListData(new Vector<Material>(materials));
            this.d_selList.setSelectionMode(0);
            this.d_selList.setCellRenderer(new MaterialListCellRenderer());
            GridBagUtil.add(this, this.d_selList, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        }

        @Override
        public void updateSel(Material choice) {
            IListenerStripper listeners = PyroGuiUtil.stripListeners(this.d_selList);
            if (choice == null && this.d_selList.getModel().getSize() > 0 && this.d_selList.getModel().getElementAt(0) == null) {
                this.d_selList.setSelectedIndex(0);
            } else {
                this.d_selList.setSelectedValue(choice, true);
            }
            listeners.restore();
        }

        private class MaterialListCellRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = -213431178399783403L;

            private MaterialListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text;
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Material mat = (Material)value;
                Font font = this.getFont();
                if (mat == null) {
                    font = font.deriveFont(1);
                    text = Intl.intl("<No Material>");
                } else {
                    text = mat.getName();
                }
                if (ListPanel.this.d_changeTrackPnl.isModified() && isSelected) {
                    font = font.deriveFont(2);
                }
                Icon[] icon = PyroGuiUtil.getIcons((Material)value, 32, 32, 0, guiUtil.ImageFilter.NORMAL);
                this.setIcon(icon[0]);
                this.setFont(font);
                this.setText(text);
                return this;
            }
        }

        private class SelListener
        implements ListSelectionListener {
            public final ItemListener ilistener;

            public SelListener(ItemListener listener) {
                this.ilistener = listener;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Material mat = (Material)ListPanel.this.d_selList.getSelectedValue();
                ItemEvent evt = new ItemEvent(ListPanel.this, 701, mat, 1);
                this.ilistener.itemStateChanged(evt);
            }
        }
    }

    private static interface IconView
    extends ItemSelectable {
        public void update(List<Material> var1);

        public void updateSel(Material var1);

        public JComponent getPanel();
    }

    private static class IconsPanel
    extends guiPanel
    implements ItemSelectable {
        private static final long serialVersionUID = 3019442386619546185L;
        private final CardLayout d_cards;
        private final guiPanel d_cardPanel;
        private final List<View> d_views;
        private View d_currView;
        private List<Material> d_materials = Collections.EMPTY_LIST;

        public IconsPanel(guiPanel changeTrackPnl) {
            this.d_views = Arrays.asList(new View(Intl.intl("List"), new ListPanel(changeTrackPnl), MaterialDlg.LIST_OPTION), new View(Intl.intl("Icons"), new FlowPanel(changeTrackPnl), MaterialDlg.ICONS_OPTION));
            this.d_cards = new CardLayout(0, 0);
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.setLayout(new GridBagLayout());
            ButtonGroup bg = new ButtonGroup();
            int col = 0;
            for (final View view : this.d_views) {
                bg.add(view.btn);
                view.btn.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            this.selectedPanel(view);
                        }
                    }
                });
                JComponent comp = view.iv.getPanel();
                this.d_cardPanel.add((Component)comp, view.pref);
                this.d_cards.addLayoutComponent(comp, view.pref);
                GridBagUtil.add(this, view.btn, col++, 0, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0);
            }
            GridBagUtil.add(this, this.d_cardPanel, 0, 1, 2, 1, 12, 6, 6, 6, 1, 1.0, 1.0);
            this.d_currView = this.d_views.get(0);
            String viewPref = Application.getApp().getPreference(MaterialDlg.MATERIAL_DLG_VIEW);
            for (View view : this.d_views) {
                if (!view.pref.equals(viewPref)) continue;
                view.btn.setSelected(true);
                break;
            }
            this.selectedPanel(this.d_currView);
        }

        @Override
        public void addItemListener(ItemListener l) {
            for (View view : this.d_views) {
                view.iv.addItemListener(l);
            }
        }

        @Override
        public void removeItemListener(ItemListener l) {
            for (View view : this.d_views) {
                view.iv.removeItemListener(l);
            }
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.d_currView.iv.getSelectedObjects();
        }

        private void selectedPanel(View view) {
            Object[] objectArray;
            if (this.d_currView != null) {
                objectArray = this.d_currView.iv.getSelectedObjects();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = null;
            }
            Object[] sel = objectArray;
            this.d_currView = view;
            this.update(this.d_materials);
            this.setSelectedItem((Material)sel[0]);
            this.d_cards.show(this.d_cardPanel, this.d_currView.pref);
            Application.getApp().setPreference(MaterialDlg.MATERIAL_DLG_VIEW, this.d_currView.pref);
        }

        public void update(List<Material> materials) {
            this.d_materials = materials;
            this.d_currView.iv.update(this.d_materials);
        }

        public void setSelectedItem(Material mat) {
            this.d_currView.iv.updateSel(mat);
        }

        private class View {
            public final guiRadioButton btn;
            public final IconView iv;
            public final String pref;

            public View(String desc, IconView iv, String pref) {
                this.btn = new guiRadioButton(desc);
                this.iv = iv;
                this.pref = pref;
            }
        }
    }

    private class CloseListener
    extends WindowAdapter
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.close();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.close();
        }

        private void close() {
            MaterialDlg.this.d_status = 16;
            MaterialDlg.this.fireButtonPressed(16);
        }
    }
}

