/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.gui.actions.ARunFDSValidation;

public class AspiratorSamplerValidation
extends ARunFDSValidation {
    @Override
    public Collection<IPyroObject> validateModel(PyroSim app, PyroMod pyMod) {
        Collection<IDevice> aspirators = pyMod.getDevices().flatten(devc -> devc instanceof Aspirator);
        Collection<IDevice> samplers = pyMod.getDevices().flatten(devc -> devc instanceof AspiratorSampler);
        if (aspirators.isEmpty() && !samplers.isEmpty()) {
            return samplers.stream().map(devc -> devc).collect(Collectors.toList());
        }
        if (!aspirators.isEmpty() && samplers.isEmpty()) {
            return aspirators.stream().map(devc -> devc).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = Intl.intl("Aspiration detection systems in FDS require two \ncomponents, an aspirator, and an aspirator sampler.\nPyroSim has detected that the current model has \nincompletely defined aspiration systems. \n\nClick OK to select the incomplete devices.\n\nClick Ignore to disregard the problem and run FDS.");
        return new ARunFDSValidation.Prompt(owner, instructions);
    }
}

