/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.SimParams;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.variant.Variant;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.FDSRecordPreviewPanel;
import pyrosim.gui.VariantEditor;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.geom.RastOptionsPnl;
import pyrosim.io.fds.FDS;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SimulationPropertiesDlg
extends guiDialog {
    private static final long serialVersionUID = 888724414754473579L;
    private final PyroMod d_mediator = ((PyroSim)Application.getApp()).getMediator();
    private final guiPanel d_dlgPanel = super.getDialogPane();
    private final TimePanel d_timePanel;
    private final EnvironmentPanel d_envPanel;
    private final ParticlePanel d_particlePanel;
    private final SimulatorPanel d_simPanel;
    private final RadPanel d_radPanel;
    private final OutputPanel d_outputPanel;
    private final MiscPanel d_miscPanel;
    private final guiTextField d_tfSimTitle;
    private final AngledGeomPanel d_angledGeomPnl;
    private final FDSRecordPreviewPanel d_preview;
    private boolean d_previewLock;
    private SimParams d_tempParams;

    public SimulationPropertiesDlg(JFrame owner) {
        super((Window)owner, Intl.intl("Simulation Parameters"), 9);
        this.d_dlgPanel.setLayout(new GridBagLayout());
        this.d_timePanel = new TimePanel(this.d_mediator);
        this.d_envPanel = new EnvironmentPanel(this.d_mediator);
        this.d_particlePanel = new ParticlePanel(this.d_mediator);
        this.d_simPanel = new SimulatorPanel(this.d_mediator);
        this.d_radPanel = new RadPanel(this.d_mediator);
        this.d_outputPanel = new OutputPanel(this.d_mediator);
        this.d_miscPanel = new MiscPanel(this.d_mediator);
        this.d_tfSimTitle = new guiTextField();
        this.d_angledGeomPnl = new AngledGeomPanel();
        this.d_preview = PyroPrefs.getBoolean(PyroPrefs.PREF_RECORD_PREVIEW) ? new FDSRecordPreviewPanel(FDS.newRenderer(PyroSim.getApp().getMediator(), PyroSim.getApp().getFDSRenderProps())) : null;
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab(Intl.intl("Time"), this.d_timePanel.getPanel());
        tabPane.addTab(Intl.intl("Output"), this.d_outputPanel.getPanel());
        tabPane.addTab(Intl.intl("Environment"), this.d_envPanel.getPanel());
        tabPane.addTab(Intl.intl("Particles"), this.d_particlePanel.getPanel());
        tabPane.addTab(Intl.intl("Simulator"), this.d_simPanel.getPanel());
        tabPane.addTab(Intl.intl("Radiation"), this.d_radPanel.getPanel());
        tabPane.addTab(Intl.intl("Angled Geometry"), this.d_angledGeomPnl);
        tabPane.addTab(Intl.intl("Misc."), this.d_miscPanel.getPanel());
        Dimension sz = this.d_tfSimTitle.getPreferredSize();
        this.d_tfSimTitle.setPreferredSize(new Dimension(280, sz.height));
        guiLabel labTitle = new guiLabel(Intl.intl("Simulation Title") + ":");
        GridBagUtil.add(this.d_dlgPanel, labTitle, 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_dlgPanel, this.d_tfSimTitle, 1, 0, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_dlgPanel, tabPane, 0, 1, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        if (this.d_preview != null) {
            GridBagUtil.add(this.d_dlgPanel, this.d_preview, 0, 2, 2, 1, 12, 0, 0, 0, 2, 1.0, 0.0, 17);
        }
        this.d_previewLock = true;
        this.d_timePanel.loadData();
        this.d_envPanel.loadData();
        this.d_particlePanel.loadData();
        this.d_simPanel.loadData();
        this.d_radPanel.loadData();
        this.d_outputPanel.loadData();
        this.d_miscPanel.loadData();
        this.d_angledGeomPnl.load(this.d_mediator.getRastOptions());
        this.loadData();
        this.d_previewLock = false;
        if (this.d_preview != null) {
            this.d_tempParams = (SimParams)this.d_mediator.getSimParams().clone();
            this.d_mediator.pauseUpdates(false);
            this.d_tempParams.setDomain(this.d_mediator, this.d_mediator);
            try {
                this.d_preview.setRecord(this.d_tempParams, false);
            }
            catch (Throwable t) {
                System.err.println("[0x923843] FDS Preview Failed: " + t.getMessage());
                t.printStackTrace();
            }
            this.d_tempParams.setDomain(null, null);
            this.d_mediator.resumeUpdates();
            this.d_dlgPanel.addObserver((o, arg) -> {
                if (this.d_previewLock) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    try {
                        if (this.validateData(false, false)) {
                            this.saveData(this.d_tempParams);
                            this.d_mediator.pauseUpdates(false);
                            this.d_tempParams.setDomain(this.d_mediator, this.d_mediator);
                            this.d_preview.setRecord(this.d_tempParams, true);
                            this.d_tempParams.setDomain(null, null);
                            this.d_mediator.resumeUpdates();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                });
            });
        }
    }

    public void saveData() {
        this.d_mediator.pauseUpdates();
        this.saveData(this.d_mediator.getSimParams());
        this.d_mediator.setRastProps(this.d_angledGeomPnl.save());
        this.d_mediator.resumeUpdates();
    }

    public void saveData(SimParams sp) {
        String headTitle = this.d_tfSimTitle.getText();
        if (headTitle != null) {
            if (!(headTitle = headTitle.trim()).equals("")) {
                sp.setJobTitle(headTitle);
            } else {
                sp.setJobTitle(null);
            }
        } else {
            sp.setJobTitle(null);
        }
        this.d_timePanel.saveData(sp.getTime(), sp.getOpenMp());
        this.d_envPanel.saveData(sp.getEnvironment(), sp.getWind());
        this.d_particlePanel.saveData(sp.getParticles());
        this.d_simPanel.saveData(sp.getCalculations());
        this.d_radPanel.saveData(sp.getRadiTransport());
        this.d_outputPanel.saveData(sp.getFileOutput());
        this.d_miscPanel.saveData(sp, sp.getMisc());
    }

    private void loadData() {
        String headTitle = this.d_mediator.getSimParams().getJobTitle();
        if (headTitle != null) {
            this.d_tfSimTitle.setText(headTitle);
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        return this.d_simPanel.validateData(showWarn, allowModify) && this.d_envPanel.validateData(showWarn, allowModify);
    }

    private void addDefault() {
    }

    private static void addVariantToPanel(GridBagHelper gbh, VariantEditor ve) {
        ve.addToPanel(gbh, GridBagHelper.Fill.NONE, GridBagHelper.Fill.BOTH, GridBagHelper.Fill.NONE);
    }

    public static boolean validateVariant(Component parent, VariantEditor ve, boolean showWarn, String warnName) {
        if (ve.getValue().isRamp() && ((Ramp)ve.getValue().val).isEmpty()) {
            if (showWarn) {
                String msg = String.format(Intl.intl("Ramp, %s, is empty."), warnName);
                guiDialog.showInvalidEntryMessage(parent, msg);
            }
            return false;
        }
        return true;
    }

    private static class WindPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final CustomWindProfile d_customProfile;
        private final SimilarityWindProfile d_simProfile;
        private final guiComboBox<IWindProfile> d_windProfile;
        private final guiRadioButton d_speedDirTRB;
        private final guiRadioButton d_speedCompsTRB;
        private final VariantEditor d_speedRamp;
        private final VariantEditor d_dirRamp;
        private final VariantEditor d_u0t;
        private final VariantEditor d_v0t;
        private final VariantEditor d_w0t;
        private final VariantEditor d_forceX;
        private final VariantEditor d_forceY;
        private final VariantEditor d_forceZ;
        private final JTabbedPane d_tabPane = new JTabbedPane();

        public WindPanel() {
            guiPanel genTab = new guiPanel();
            this.d_tabPane.addTab(Intl.intl("Wind Profile"), genTab);
            guiPanel velVarianceTab = new guiPanel();
            this.d_tabPane.addTab(Intl.intl("Speed Change over Time"), velVarianceTab);
            guiPanel forceTab = new guiPanel();
            this.d_tabPane.addTab(Intl.intl("Natural Wind"), forceTab);
            this.d_customProfile = new CustomWindProfile();
            this.d_simProfile = new SimilarityWindProfile();
            this.d_windProfile = guiUtil.newCombo(p -> new Pair<String, Object>(p.getName(), null), this.d_customProfile, this.d_simProfile);
            CardLayout profileCards = new CardLayout();
            guiPanel profilePnl = new guiPanel(profileCards);
            profilePnl.add((Component)this.d_customProfile, this.d_customProfile.getName());
            profilePnl.add((Component)this.d_simProfile, this.d_simProfile.getName());
            this.d_windProfile.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                profileCards.show(profilePnl, this.d_windProfile.getSelectedItem().getName());
            });
            this.d_speedDirTRB = new guiRadioButton(Intl.intl("Horizontal Speed"));
            this.d_speedCompsTRB = new guiRadioButton(Intl.intl("UV Components"));
            guiUtil.group(new AbstractButton[]{this.d_speedDirTRB, this.d_speedCompsTRB});
            this.d_speedDirTRB.setSelected(true);
            String speedRampLbl = Intl.intl("Speed Fraction");
            this.d_dirRamp = new VariantEditor(Intl.intl("Direction"), Intl.intl("Direction"), SimParams.Wind.DIRECTION_RAMP_PROFILE);
            this.d_speedRamp = new VariantEditor(Intl.intl("Speed"), speedRampLbl, SimParams.Wind.SPEED_TIME_RAMP_PROFILE);
            this.d_u0t = new VariantEditor(Intl.intl("X Velocity"), speedRampLbl, SimParams.Wind.SPEED_TIME_RAMP_PROFILE);
            this.d_v0t = new VariantEditor(Intl.intl("Y Velocity"), speedRampLbl, SimParams.Wind.SPEED_TIME_RAMP_PROFILE);
            this.d_w0t = new VariantEditor(Intl.intl("Z Velocity"), speedRampLbl, SimParams.Wind.SPEED_TIME_RAMP_PROFILE);
            String forceX = Intl.intl("X Force");
            String forceY = Intl.intl("Y Force");
            String forceZ = Intl.intl("Z Force");
            this.d_forceX = new VariantEditor(forceX, Intl.intl("Force Fraction"), SimParams.Wind.FORCE_PROFILE);
            this.d_forceY = new VariantEditor(forceY, Intl.intl("Force Fraction"), SimParams.Wind.FORCE_PROFILE);
            this.d_forceZ = new VariantEditor(forceZ, Intl.intl("Force Fraction"), SimParams.Wind.FORCE_PROFILE);
            GridBagHelper gbh = new GridBagHelper(genTab, true);
            gbh.addRow(Intl.intl("Wind Profile:"), this.d_windProfile);
            gbh.addFilledRow(profilePnl);
            gbh.finalizeRows();
            gbh = new GridBagHelper(velVarianceTab, true);
            gbh.addRow(this.d_speedDirTRB, 0);
            gbh.indent();
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_speedRamp);
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_dirRamp);
            gbh.unindent();
            gbh.addRow(this.d_speedCompsTRB, 0);
            gbh.indent();
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_u0t);
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_v0t);
            gbh.unindent();
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_w0t);
            gbh.finalizeRows();
            gbh = new GridBagHelper(forceTab, true);
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_forceX);
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_forceY);
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_forceZ);
            gbh.finalizeRows();
            gbh = new GridBagHelper(this);
            gbh.addFilledRow(this.d_tabPane);
            gbh.finalizeRows();
            guiUtil.link((AbstractButton)this.d_speedDirTRB, this.d_speedRamp.getComponents());
            guiUtil.link((AbstractButton)this.d_speedDirTRB, this.d_dirRamp.getComponents());
            guiUtil.link((AbstractButton)this.d_speedCompsTRB, this.d_u0t.getComponents());
            guiUtil.link((AbstractButton)this.d_speedCompsTRB, this.d_v0t.getComponents());
            this.load(new SimParams.Wind());
        }

        public void load(SimParams.Wind wind) {
            boolean simEnabled;
            UnitDouble l = wind.get(SimParams.Wind.L);
            boolean bl = simEnabled = !l.epsilonEquals(new UnitDouble(0.0, (Unit)SI.METER), 1.0E-10);
            if (simEnabled) {
                this.d_windProfile.setSelectedItem(this.d_simProfile);
            } else {
                this.d_windProfile.setSelectedItem(this.d_customProfile);
            }
            this.d_simProfile.load(wind);
            this.d_customProfile.load(wind);
            this.d_speedRamp.init(wind.get(SimParams.Wind.SPEED_RAMP));
            this.d_dirRamp.init(wind.get(SimParams.Wind.DIRECTION_RAMP));
            Variant u0t = wind.get(SimParams.Wind.U0T);
            Variant v0t = wind.get(SimParams.Wind.V0T);
            if (!u0t.equals(SimParams.Wind.U0T.defVal) || !v0t.equals(SimParams.Wind.V0T.defVal)) {
                this.d_speedCompsTRB.setSelected(true);
            } else {
                this.d_speedDirTRB.setSelected(true);
            }
            this.d_u0t.init(u0t);
            this.d_v0t.init(v0t);
            this.d_w0t.init(wind.get(SimParams.Wind.W0T));
            this.d_forceX.init(wind.get(SimParams.Wind.FORCEX));
            this.d_forceY.init(wind.get(SimParams.Wind.FORCEY));
            this.d_forceZ.init(wind.get(SimParams.Wind.FORCEZ));
        }

        public void save(SimParams.Wind wind) {
            SimParams.Wind result = wind;
            wind = new SimParams.Wind();
            this.d_windProfile.getSelectedItem().save(wind);
            if (this.d_speedDirTRB.isSelected()) {
                wind.set(SimParams.Wind.SPEED_RAMP, this.d_speedRamp.getValue());
                wind.set(SimParams.Wind.DIRECTION_RAMP, this.d_dirRamp.getValue());
                wind.set(SimParams.Wind.U0T, SimParams.Wind.U0T.defVal);
                wind.set(SimParams.Wind.V0T, SimParams.Wind.V0T.defVal);
            } else {
                wind.set(SimParams.Wind.SPEED_RAMP, SimParams.Wind.SPEED_RAMP.defVal);
                wind.set(SimParams.Wind.DIRECTION_RAMP, SimParams.Wind.DIRECTION_RAMP.defVal);
                wind.set(SimParams.Wind.U0T, this.d_u0t.getValue());
                wind.set(SimParams.Wind.V0T, this.d_v0t.getValue());
            }
            wind.set(SimParams.Wind.W0T, this.d_w0t.getValue());
            wind.set(SimParams.Wind.FORCEX, this.d_forceX.getValue());
            wind.set(SimParams.Wind.FORCEY, this.d_forceY.getValue());
            wind.set(SimParams.Wind.FORCEZ, this.d_forceZ.getValue());
            result.copyVals(wind);
        }
    }

    private static class CustomWindProfile
    extends guiPanel
    implements IWindProfile {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<LandscapeClass> d_landscape;
        private final ValueField<UnitDouble> d_z0;
        private final ValueField<UnitDouble> d_zref;
        private final ValueField<UnitDouble> d_groundLevel = ValueFields.udFld(UnitSystem.getSource(0));
        private final ValueField<UnitDouble> d_lapseRate = ValueFields.udFld(UnitSystem.getSource(5));
        private final VariantEditor d_tmp0zRamp = new VariantEditor(Intl.intl("Z Temperature Profile"), Intl.intl("Ratio of Ambient Temperature"), SimParams.Wind.TMP0_Z_RAMP_PROFILE);
        private final guiRadioButton d_initSpeedUStar = new guiRadioButton("<html>" + Intl.intl("Friction Velocity (u*):"));
        private final guiRadioButton d_initSpeedConstant = new guiRadioButton(Intl.intl("Speed:"));
        private final guiRadioButton d_initSpeedComps = new guiRadioButton(Intl.intl("UV Components"));
        private final ValueField<UnitDouble> d_uStar;
        private final ValueField<UnitDouble> d_directionUStar;
        private final ValueField<UnitDouble> d_speed;
        private final ValueField<UnitDouble> d_directionSpeed;
        private final ValueField<UnitDouble> d_u0;
        private final ValueField<UnitDouble> d_v0;
        private final ValueField<UnitDouble> d_w0;
        private final VariantEditor d_u0z;
        private final VariantEditor d_v0z;
        private final VariantEditor d_w0z;

        public CustomWindProfile() {
            guiUtil.group(new AbstractButton[]{this.d_initSpeedUStar, this.d_initSpeedConstant, this.d_initSpeedComps});
            this.d_initSpeedConstant.setSelected(true);
            this.d_landscape = guiUtil.newCombo(s -> new Pair<String, String>(s.classDesc, s.landscape), LandscapeClass.values());
            this.d_z0 = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.METER, UnitSystem.getSource(0));
            this.d_uStar = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(8), UnitSystem.getSource(8));
            String speedRampLbl = Intl.intl("Speed Fraction");
            this.d_speed = ValueFields.udFld(0.0, SIUS.getInstance().getVelocityUnit());
            this.d_directionSpeed = ValueFields.udFld(0.0, NonSI.DEGREE_ANGLE, UnitSystem.getSource(29));
            this.d_directionUStar = ValueFields.udFld(0.0, NonSI.DEGREE_ANGLE, UnitSystem.getSource(29));
            this.d_u0 = ValueFields.udFld(0.0, SIUS.unit(8));
            this.d_v0 = ValueFields.udFld(0.0, SIUS.unit(8));
            this.d_w0 = ValueFields.udFld(0.0, SIUS.unit(8));
            guiLabel velZLbl = new guiLabel(Intl.intl("Z Velocity:"));
            this.d_u0z = new VariantEditor(Intl.intl("X Velocity"), speedRampLbl, SimParams.Wind.SPEED_Z_RAMP_PROFILE);
            this.d_v0z = new VariantEditor(Intl.intl("Y Velocity"), speedRampLbl, SimParams.Wind.SPEED_Z_RAMP_PROFILE);
            this.d_w0z = new VariantEditor(Intl.intl("Z Velocity"), speedRampLbl, SimParams.Wind.SPEED_Z_RAMP_PROFILE);
            this.d_zref = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.METER, UnitSystem.getSource(0));
            Supplier<guiLabel> newDirLbl = () -> {
                guiLabel dirLbl = new guiLabel(Intl.intl("Direction:"));
                dirLbl.setToolTipText("<html>" + Intl.intl("Specifies the speed direction.<br>0&deg; indicates a northerly wind (blows toward the south)<br>90&deg; indicates an easterly wind (blows toward the west)"));
                return dirLbl;
            };
            BiFunction<String, String, guiLabel> groupToPanel = (lbl, tooltip) -> {
                guiLabel glbl = new guiLabel((String)lbl);
                glbl.setToolTipText((String)tooltip);
                return glbl;
            };
            guiLabel z0lbl = groupToPanel.apply("<html>" + Intl.intl("z<sub>0</sub> ="), Intl.intl("Aerodynamic Roughness Length"));
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addTitle(Intl.intl("Initial Wind Velocity"));
            gbh.indent();
            gbh.addRow(this.d_initSpeedConstant, this.d_speed, 1.0);
            gbh.indent();
            String SPEED_GROUP = "SPEED_GROUP";
            gbh.beginGroup(SPEED_GROUP);
            gbh.addRow(newDirLbl.get(), this.d_directionSpeed, 1.0);
            gbh.endGroup();
            gbh.unindent();
            gbh.addRow(this.d_initSpeedUStar, this.d_uStar, 1.0);
            gbh.indent();
            String USTAR_GROUP = "USTAR_GROUP";
            gbh.beginGroup(USTAR_GROUP);
            gbh.addRow(newDirLbl.get(), this.d_directionUStar, 1.0);
            gbh.addRow(Intl.intl("Landscape:"), this.d_landscape, z0lbl, this.d_z0, 1.0);
            gbh.addRow("<html>" + Intl.intl("Reference Height (z<sub>ref</sub>):"), this.d_zref, 1.0);
            gbh.endGroup();
            gbh.unindent();
            gbh.addRow(this.d_initSpeedComps, 0);
            gbh.indent();
            String GROUP_VCOMPS = "VCOMPS";
            gbh.beginGroup(GROUP_VCOMPS);
            gbh.addRow(Intl.intl("X Velocity:"), this.d_u0, 1.0);
            gbh.addRow(Intl.intl("Y Velocity:"), this.d_v0, 1.0);
            gbh.endGroup();
            gbh.unindent();
            gbh.addRow(velZLbl, this.d_w0, 1.0);
            gbh.unindent();
            gbh.addTitle(Intl.intl("Speed Profile"));
            gbh.indent();
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_u0z);
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_v0z);
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_w0z);
            gbh.unindent();
            gbh.addTitle(Intl.intl("Temperature Profile"));
            gbh.indent();
            gbh.addRow(Intl.intl("Ground Level:"), this.d_groundLevel, 1.0);
            gbh.addRow(Intl.intl("Lapse Rate:"), this.d_lapseRate, 1.0);
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_tmp0zRamp);
            gbh.unindent();
            gbh.finalizeRows();
            Runnable updateState = () -> {
                this.d_uStar.setEnabled(this.d_initSpeedUStar.isSelected());
                this.getGroup(USTAR_GROUP).setEnabled(this.d_initSpeedUStar.isSelected());
                this.d_z0.setEnabled(this.d_initSpeedUStar.isSelected() && this.d_landscape.getSelectedItem() == LandscapeClass.CUSTOM);
            };
            this.d_landscape.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.d_landscape.getSelectedItem() != LandscapeClass.CUSTOM) {
                    this.d_z0.setValue(this.d_landscape.getSelectedItem().value);
                }
                updateState.run();
            });
            guiUtil.link((AbstractButton)this.d_initSpeedConstant, this.d_speed);
            guiUtil.link((AbstractButton)this.d_initSpeedComps, this.getGroup(GROUP_VCOMPS));
            guiUtil.link((AbstractButton)this.d_initSpeedConstant, this.getGroup(SPEED_GROUP));
            this.d_initSpeedUStar.addItemListener(e -> updateState.run());
            this.load(new SimParams.Wind());
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public String getName() {
            return Intl.intl("Custom");
        }

        @Override
        public void load(SimParams.Wind wind) {
            if (wind.get(SimParams.Wind.USTAR) != null) {
                this.d_initSpeedUStar.setSelected(true);
            } else {
                switch (wind.get(SimParams.Wind.INITSPEEDOPT)) {
                    case SPEED: {
                        this.d_initSpeedConstant.setSelected(true);
                        break;
                    }
                    case UV: {
                        this.d_initSpeedComps.setSelected(true);
                    }
                }
            }
            LandscapeClass landscape = LandscapeClass.CUSTOM;
            for (LandscapeClass ls : LandscapeClass.values()) {
                if (ls == LandscapeClass.CUSTOM || !ls.value.epsilonEquals(wind.get(SimParams.Wind.Z0), 1.0E-9)) continue;
                landscape = ls;
                break;
            }
            this.d_landscape.setSelectedItem((Object)landscape);
            this.d_z0.setValue(wind.get(SimParams.Wind.Z0));
            UnitDouble ustar = wind.get(SimParams.Wind.USTAR);
            this.d_initSpeedUStar.setSelected(ustar != null);
            if (ustar != null) {
                this.d_uStar.setValue(ustar);
            }
            this.d_directionSpeed.setValue(wind.get(SimParams.Wind.DIRECTION));
            this.d_directionUStar.setValue(wind.get(SimParams.Wind.DIRECTION));
            this.d_groundLevel.setValue(wind.get(SimParams.Wind.GROUND_LEVEL));
            this.d_lapseRate.setValue(wind.get(SimParams.Wind.LAPSE_RATE));
            this.d_tmp0zRamp.init(wind.get(SimParams.Wind.TMP0Z_RAMP));
            this.d_speed.setValue(wind.get(SimParams.Wind.SPEED));
            this.d_u0.setValue(wind.get(SimParams.Wind.U0));
            this.d_v0.setValue(wind.get(SimParams.Wind.V0));
            this.d_w0.setValue(wind.get(SimParams.Wind.W0));
            this.d_u0z.init(wind.get(SimParams.Wind.U0Z));
            this.d_v0z.init(wind.get(SimParams.Wind.V0Z));
            this.d_w0z.init(wind.get(SimParams.Wind.W0Z));
            this.d_zref.setValue(wind.get(SimParams.Wind.ZREF));
        }

        @Override
        public void save(SimParams.Wind wind) {
            wind.set(SimParams.Wind.L, new UnitDouble(0.0, (Unit)SI.METER));
            wind.set(SimParams.Wind.GROUND_LEVEL, this.d_groundLevel.getValue());
            wind.set(SimParams.Wind.LAPSE_RATE, this.d_lapseRate.getValue());
            wind.set(SimParams.Wind.TMP0Z_RAMP, this.d_tmp0zRamp.getValue());
            if (this.d_initSpeedConstant.isSelected()) {
                wind.set(SimParams.Wind.INITSPEEDOPT, SimParams.Wind.InitSpeedOptions.SPEED);
                wind.set(SimParams.Wind.SPEED, this.d_speed.getValue());
                wind.set(SimParams.Wind.DIRECTION, this.d_directionSpeed.getValue());
            } else if (this.d_initSpeedUStar.isSelected()) {
                wind.set(SimParams.Wind.USTAR, this.d_uStar.getValue());
                wind.set(SimParams.Wind.Z0, this.d_z0.getValue());
                wind.set(SimParams.Wind.DIRECTION, this.d_directionUStar.getValue());
                wind.set(SimParams.Wind.ZREF, this.d_zref.getValue());
            } else if (this.d_initSpeedComps.isSelected()) {
                wind.set(SimParams.Wind.INITSPEEDOPT, SimParams.Wind.InitSpeedOptions.UV);
                wind.set(SimParams.Wind.U0, this.d_u0.getValue());
                wind.set(SimParams.Wind.V0, this.d_v0.getValue());
            }
            wind.set(SimParams.Wind.W0, this.d_w0.getValue());
            wind.set(SimParams.Wind.U0Z, this.d_u0z.getValue());
            wind.set(SimParams.Wind.V0Z, this.d_v0z.getValue());
            wind.set(SimParams.Wind.W0Z, this.d_w0z.getValue());
        }
    }

    private static class SimilarityWindProfile
    extends guiPanel
    implements IWindProfile {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<Stability> d_stability;
        private final guiComboBox<LandscapeClass> d_landscape;
        private final ValueField<UnitDouble> d_l;
        private final ValueField<UnitDouble> d_z0;
        private final ValueField<UnitDouble> d_zref;
        private final ValueField<UnitDouble> d_uStar;
        private final guiCheckBox d_thetaStarCB;
        private final ValueField<UnitDouble> d_thetaStar;
        private final ValueField<UnitDouble> d_groundLevel = ValueFields.udFld(UnitSystem.getSource(0));
        private final ValueField<UnitDouble> d_lapseRate = ValueFields.udFld(UnitSystem.getSource(5));
        private final guiRadioButton d_uStarRB;
        private final guiRadioButton d_speedRB;
        private final ValueField<UnitDouble> d_speed;
        private final ValueField<UnitDouble> d_direction;
        private final ValueField<UnitDouble> d_w0;
        private final VariantEditor d_w0z;

        public SimilarityWindProfile() {
            this.d_stability = guiUtil.newCombo(s -> new Pair<String, String>(s.desc, s.getTooltip()), Stability.values());
            this.d_landscape = guiUtil.newCombo(s -> new Pair<String, String>(s.classDesc, s.landscape), LandscapeClass.values());
            this.d_l = ValueFields.udFld(new UnitDouble(0.0, (Unit)SI.METER), new NotZero("L", (Unit)SI.METER), UnitSystem.getSource(0));
            this.d_z0 = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.METER, UnitSystem.getSource(0));
            this.d_thetaStarCB = new guiCheckBox("<html>" + Intl.intl("Scaling Potential Temperature (&Theta;*):"));
            this.d_thetaStar = ValueFields.udFld(new UnitDouble(0.0, (Unit)SI.KELVIN), new NotZero("&Theta;*", (Unit)SI.KELVIN), UnitSystem.getSource(93));
            LinkStatus.link((AbstractButton)this.d_thetaStarCB, this.d_thetaStar);
            this.d_uStarRB = new guiRadioButton("<html>" + Intl.intl("Friction Velocity (u*):"));
            this.d_uStar = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(8), UnitSystem.getSource(8));
            this.d_speedRB = new guiRadioButton(Intl.intl("Speed:"));
            this.d_speed = ValueFields.udFld(DoubleVR.above(0.0, false), SIUS.unit(8), UnitSystem.getSource(8));
            this.d_direction = ValueFields.udFld(0.0, NonSI.DEGREE_ANGLE, UnitSystem.getSource(29));
            this.d_w0 = ValueFields.udFld(0.0, SIUS.unit(8));
            this.d_w0z = new VariantEditor(Intl.intl("Z Speed Change with Elevation"), Intl.intl("Speed Fraction"), SimParams.Wind.SPEED_Z_RAMP_PROFILE);
            this.d_zref = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.METER, UnitSystem.getSource(0));
            guiLabel dirLbl = new guiLabel(Intl.intl("Direction:"));
            dirLbl.setToolTipText("<html>" + Intl.intl("Specifies the speed direction.<br>0&deg; indicates a northerly wind (blows toward the south)<br>90&deg; indicates an easterly wind (blows toward the west)"));
            BiFunction<String, String, guiLabel> groupToPanel = (lbl, tooltip) -> {
                guiLabel glbl = new guiLabel((String)lbl);
                glbl.setToolTipText((String)tooltip);
                return glbl;
            };
            guiLabel llbl = groupToPanel.apply(Intl.intl("L ="), Intl.intl("Obukhov Length"));
            guiLabel z0lbl = groupToPanel.apply("<html>" + Intl.intl("z<sub>0</sub> ="), Intl.intl("Aerodynamic Roughness Length"));
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addSeparator();
            gbh.addRow(Intl.intl("Thermal Stability:"), this.d_stability, llbl, this.d_l, 1.0);
            gbh.addRow(Intl.intl("Landscape"), this.d_landscape, z0lbl, this.d_z0, 1.0);
            gbh.addRow("<html>" + Intl.intl("Reference Height (z<sub>ref</sub>):"), this.d_zref, 1.0);
            gbh.addRow(this.d_thetaStarCB, this.d_thetaStar, 1.0);
            gbh.addTitle(Intl.intl("Initial Horizontal Velocity"));
            gbh.indent();
            gbh.addRow(this.d_speedRB, this.d_speed, 1.0);
            gbh.addRow(this.d_uStarRB, this.d_uStar, 1.0);
            gbh.addRow(dirLbl, this.d_direction, 1.0);
            gbh.unindent();
            gbh.addRow(Intl.intl("Initial Z Velocity:"), this.d_w0, 1.0);
            SimulationPropertiesDlg.addVariantToPanel(gbh, this.d_w0z);
            gbh.addTitle(Intl.intl("Temperature Profile"));
            gbh.indent();
            gbh.addRow(Intl.intl("Ground Level:"), this.d_groundLevel, 1.0);
            gbh.addRow(Intl.intl("Lapse Rate:"), this.d_lapseRate, 1.0);
            gbh.unindent();
            gbh.finalizeRows();
            Runnable updateState = () -> {
                this.d_l.setEnabled(this.d_stability.getSelectedItem() == Stability.CUSTOM);
                this.d_z0.setEnabled(this.d_landscape.getSelectedItem() == LandscapeClass.CUSTOM);
            };
            this.d_stability.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.d_stability.getSelectedItem() != Stability.CUSTOM) {
                    this.d_l.setValue(this.d_stability.getSelectedItem().value);
                }
                updateState.run();
            });
            this.d_landscape.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.d_landscape.getSelectedItem() != LandscapeClass.CUSTOM) {
                    this.d_z0.setValue(this.d_landscape.getSelectedItem().value);
                }
                updateState.run();
            });
            guiUtil.group(new AbstractButton[]{this.d_uStarRB, this.d_speedRB});
            guiUtil.link((AbstractButton)this.d_uStarRB, this.d_uStar);
            guiUtil.link((AbstractButton)this.d_speedRB, this.d_speed);
            this.load(new SimParams.Wind());
        }

        @Override
        public String getName() {
            return Intl.intl("Monin-Obukhov Similarity");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void load(SimParams.Wind wind) {
            UnitDouble thetaStar;
            UnitDouble l = wind.get(SimParams.Wind.L);
            if (l.epsilonEquals(new UnitDouble(0.0, (Unit)SI.METER), 1.0E-10)) {
                l = Stability.STABLE.value;
            }
            Stability stab = Stability.CUSTOM;
            for (Stability s : Stability.values()) {
                if (s == Stability.CUSTOM || !s.value.epsilonEquals(l, 1.0E-6)) continue;
                stab = s;
                break;
            }
            this.d_stability.setSelectedItem((Object)stab);
            this.d_l.setValue(l);
            LandscapeClass landscape = LandscapeClass.CUSTOM;
            for (LandscapeClass ls : LandscapeClass.values()) {
                if (ls == LandscapeClass.CUSTOM || !ls.value.epsilonEquals(wind.get(SimParams.Wind.Z0), 1.0E-9)) continue;
                landscape = ls;
                break;
            }
            this.d_landscape.setSelectedItem((Object)landscape);
            this.d_z0.setValue(wind.get(SimParams.Wind.Z0));
            UnitDouble ustar = wind.get(SimParams.Wind.USTAR);
            this.d_uStarRB.setSelected(ustar != null);
            if (ustar != null) {
                this.d_uStar.setValue(ustar);
            }
            this.d_thetaStarCB.setSelected((thetaStar = wind.get(SimParams.Wind.THETASTAR)) != null);
            if (thetaStar != null) {
                this.d_thetaStar.setValue(thetaStar);
            }
            this.d_uStarRB.setSelected(wind.get(SimParams.Wind.USTAR) != null);
            this.d_speedRB.setSelected(wind.get(SimParams.Wind.USTAR) == null);
            this.d_groundLevel.setValue(wind.get(SimParams.Wind.GROUND_LEVEL));
            this.d_lapseRate.setValue(wind.get(SimParams.Wind.LAPSE_RATE));
            this.d_speed.setValue(wind.get(SimParams.Wind.SPEED));
            this.d_direction.setValue(wind.get(SimParams.Wind.DIRECTION));
            this.d_w0.setValue(wind.get(SimParams.Wind.W0));
            this.d_w0z.init(wind.get(SimParams.Wind.W0Z));
            this.d_zref.setValue(wind.get(SimParams.Wind.ZREF));
        }

        @Override
        public void save(SimParams.Wind wind) {
            wind.set(SimParams.Wind.L, this.d_l.getValue());
            wind.set(SimParams.Wind.Z0, this.d_z0.getValue());
            wind.set(SimParams.Wind.USTAR, this.d_uStarRB.isSelected() ? (UnitDouble)this.d_uStar.getValue() : null);
            wind.set(SimParams.Wind.THETASTAR, this.d_thetaStarCB.isSelected() ? (UnitDouble)this.d_thetaStar.getValue() : null);
            wind.set(SimParams.Wind.GROUND_LEVEL, this.d_groundLevel.getValue());
            wind.set(SimParams.Wind.LAPSE_RATE, this.d_lapseRate.getValue());
            if (this.d_speedRB.isSelected()) {
                wind.set(SimParams.Wind.SPEED, this.d_speed.getValue());
            }
            wind.set(SimParams.Wind.DIRECTION, this.d_direction.getValue());
            wind.set(SimParams.Wind.W0, this.d_w0.getValue());
            wind.set(SimParams.Wind.W0Z, this.d_w0z.getValue());
            wind.set(SimParams.Wind.ZREF, this.d_zref.getValue());
        }

        private static class NotZero
        implements Predicate<UnitDouble> {
            public final String x;
            public final Unit zeroUnit;

            public NotZero(String x, Unit zeroUnit) {
                this.x = x;
                this.zeroUnit = zeroUnit;
            }

            @Override
            public boolean test(UnitDouble t) {
                return !t.epsilonEquals(new UnitDouble(0.0, this.zeroUnit), 1.0E-10);
            }

            public String toString() {
                return "<html>" + String.format(Intl.intl("%s must not be 0."), this.x);
            }
        }
    }

    private static interface IWindProfile {
        public String getName();

        public guiPanel getPanel();

        public void load(SimParams.Wind var1);

        public void save(SimParams.Wind var1);
    }

    private static enum LandscapeClass {
        SEA(2.0E-4, Intl.intl("Sea"), Intl.intl("Sea, paved areas, snow-covered flat plain, tidal flats, smooth desert")),
        SMOOTH(0.005, Intl.intl("Smooth"), Intl.intl("Beaches, pack ice, snow-covered fields")),
        OPEN(0.03, Intl.intl("Open"), Intl.intl("Grass prairie, farm fields, tundra, airports, heather")),
        ROUGHLY_OPEN(0.1, Intl.intl("Roughly Open"), Intl.intl("Low crops and occasional obstacles (single bushes)")),
        ROUGH(0.25, Intl.intl("Rough"), Intl.intl("High crops, scattered obstacles such as trees or hedgerows, vineyards")),
        VERY_ROUGH(0.5, Intl.intl("Very Rough"), Intl.intl("Mixed farm fields and forest clumps, orchards, scattered buildings")),
        CLOSED(1.0, Intl.intl("Closed"), Intl.intl("Suburbs, villages, forests")),
        CHAOTIC(2.0, Intl.intl("Chaotic"), Intl.intl("Large towns and cities, irregular forests")),
        CUSTOM(null, Intl.intl("<custom>"), null);

        public final String classDesc;
        public final String landscape;
        public final UnitDouble value;

        private LandscapeClass(double value, String classDesc, String landscape) {
            this(new UnitDouble(value, (Unit)SI.METER), classDesc, landscape);
        }

        private LandscapeClass(UnitDouble value, String classDesc, String landscape) {
            this.value = value;
            this.classDesc = classDesc;
            this.landscape = landscape;
        }
    }

    private static enum Stability {
        VERY_UNSTABLE(Intl.intl("Very Unstable"), DoubleVR.between(-200.0, 0.0, true, false), -100.0),
        UNSTABLE(Intl.intl("Unstable"), DoubleVR.between(-500.0, -200.0, true, false), -350.0),
        NEUTRAL(Intl.intl("Neutral"), DoubleVR.above(500.0, false), 1000000.0),
        STABLE(Intl.intl("Stable"), DoubleVR.between(200.0, 500.0, false, true), 350.0),
        VERY_STABLE(Intl.intl("Very Stable"), DoubleVR.between(0.0, 200.0, false, true), 100.0),
        CUSTOM(Intl.intl("<custom>"), null, null);

        public final String desc;
        public final UnitDoubleVR range;
        public final UnitDouble value;

        private Stability(String desc, DoubleVR range, double value) {
            this(desc, UnitDoubleVR.from(range, (Unit)SI.METER), new UnitDouble(value, (Unit)SI.METER));
        }

        private Stability(String desc, UnitDoubleVR range, UnitDouble value) {
            this.desc = desc;
            this.range = range;
            this.value = value;
        }

        public String getTooltip() {
            return null;
        }
    }

    private static class AngledGeomPanel
    extends guiPanel {
        private static final long serialVersionUID = -1528674367031251720L;
        private final guiCheckBox d_immersedBoundaryCB = new guiCheckBox(Intl.intl("Use the Immersed Boundary Method (does not require conversion to blocks)"));
        private final RastOptionsPnl d_rastOptions = new RastOptionsPnl(29);

        public AngledGeomPanel() {
            LinkStatus.link((AbstractButton)this.d_immersedBoundaryCB, true, this.d_rastOptions);
            GridBagHelper gb = new GridBagHelper(this, true);
            if (PyroSim.FDS7) {
                gb.addRow(this.d_immersedBoundaryCB);
                gb.addFilledRow(new TitleSeparator(Intl.intl("Block Conversion")));
                gb.addIdentRow(this.d_rastOptions, new double[]{1.0, 1.0});
            } else {
                gb.addRow(this.d_rastOptions, new double[]{1.0, 1.0});
            }
            gb.finalizeRows();
        }

        public void load(RasterizationOptions options) {
            this.d_rastOptions.load(options);
            this.d_immersedBoundaryCB.setSelected(options.immersedBoundary);
        }

        public RasterizationOptions save() {
            RasterizationOptions options = this.d_rastOptions.save();
            return options.setImmersedBoundary(this.d_immersedBoundaryCB.isSelected());
        }
    }

    public class CheckedListener<T>
    implements ActionListener {
        private ValueField<T> d_field;

        public CheckedListener(ValueField<T> gvf) {
            this.d_field = gvf;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.d_field.requestFocusInWindow();
        }
    }

    private class MiscPanel
    extends guiPanel {
        private static final long serialVersionUID = 6305527014838058481L;
        private final PyroMod d_pyroMod;
        private final guiCheckBox d_cbTexOrigin;
        private final guiComboBox<Surface> d_surfCombo;
        private final guiComboBox<SimParams.Misc.SUPPRESSION> d_suppressionCombo;
        private final ValueField<UnitDouble> d_dfTexOriginX;
        private final ValueField<UnitDouble> d_dfTexOriginY;
        private final ValueField<UnitDouble> d_dfTexOriginZ;
        private final CustomFDSPanel d_customPnl;

        public MiscPanel(PyroMod mod) {
            this.d_pyroMod = mod;
            SimParams.Misc tempMisc = this.d_pyroMod.getSimParams().getMisc();
            this.d_cbTexOrigin = new guiCheckBox(Intl.intl("Specify Texture Origin"));
            ArrayList<Surface> surfs = new ArrayList<Surface>();
            for (Surface surf : this.d_pyroMod.getSurfaceMgr().flatten()) {
                if (surf.isPredefined() && !surf.equals(this.d_pyroMod.getSurfaceMgr().get(PredefSurf.INERT.name())) && !surf.equals(this.d_pyroMod.getSurfaceMgr().get(PredefSurf.ADIABATIC.name()))) continue;
                surfs.add(surf);
            }
            SurfaceComboBox defCombo = new SurfaceComboBox(this.d_pyroMod.getSurfaceMgr(), tempMisc.getSurfDefault());
            this.d_surfCombo = new guiComboBox(surfs);
            this.d_surfCombo.setRenderer(defCombo.getRenderer());
            this.d_suppressionCombo = new guiComboBox();
            this.d_suppressionCombo.addItem((SimParams.Misc.SUPPRESSION)SimParams.Misc.SUPPRESSION.AUTO);
            this.d_suppressionCombo.addItem((SimParams.Misc.SUPPRESSION)SimParams.Misc.SUPPRESSION.TRUE);
            this.d_suppressionCombo.addItem((SimParams.Misc.SUPPRESSION)SimParams.Misc.SUPPRESSION.FALSE);
            this.d_suppressionCombo.setRenderer(this.getSuppressionRenderer());
            JTextField temp = new JTextField(6);
            IUnitSrc lu = UnitSystem.getSource(0);
            this.d_dfTexOriginX = ValueFields.udFld(tempMisc.getTextureOrigin().xu(), lu);
            this.d_dfTexOriginY = ValueFields.udFld(tempMisc.getTextureOrigin().yu(), lu);
            this.d_dfTexOriginZ = ValueFields.udFld(tempMisc.getTextureOrigin().zu(), lu);
            this.d_dfTexOriginX.setPreferredSize(temp.getPreferredSize());
            this.d_dfTexOriginY.setPreferredSize(temp.getPreferredSize());
            this.d_dfTexOriginZ.setPreferredSize(temp.getPreferredSize());
            this.d_cbTexOrigin.addActionListener(new CheckedListener<UnitDouble>(this.d_dfTexOriginX));
            this.d_customPnl = new CustomFDSPanel(2);
            guiLabel xlbl = new guiLabel(Intl.intl("X dir") + ":");
            guiLabel ylbl = new guiLabel(Intl.intl("Y dir") + ":");
            guiLabel zlbl = new guiLabel(Intl.intl("Z dir") + ":");
            LinkStatus.link((AbstractButton)this.d_cbTexOrigin, xlbl, ylbl, zlbl, this.d_dfTexOriginX, this.d_dfTexOriginY, this.d_dfTexOriginZ);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Default Surface Type:"), this.d_surfCombo, 0);
            gb.addRow(Intl.intl("Reaction Suppression:"), this.d_suppressionCombo, 0);
            gb.addRow(this.d_cbTexOrigin, 0);
            gb.indent();
            gb.addRow(xlbl, this.d_dfTexOriginX);
            gb.addRow(ylbl, this.d_dfTexOriginY);
            gb.addRow(zlbl, this.d_dfTexOriginZ);
            gb.unindent();
            gb.addRow(this.d_customPnl, new double[]{1.0, 1.0}, new int[]{0, 0});
            gb.finalizeRows();
        }

        private ListCellRenderer getSuppressionRenderer() {
            return new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof SimParams.Misc.SUPPRESSION) {
                        this.setText(((SimParams.Misc.SUPPRESSION)((Object)value)).dispName);
                    }
                    return this;
                }
            };
        }

        public void saveData(SimParams sp, SimParams.Misc misc) {
            SimParams.Misc tempMisc = new SimParams(this.d_pyroMod.getSurfaceMgr()).getMisc();
            Surface selected = this.d_surfCombo.getSelectedItem();
            if (selected != null && !selected.equals(tempMisc.getSurfDefault())) {
                misc.setSurfDefault(this.d_surfCombo.getSelectedItem());
            } else {
                misc.setSurfDefault(tempMisc.getSurfDefault());
            }
            SimParams.Misc.SUPPRESSION suppression = this.d_suppressionCombo.getSelectedItem();
            if (suppression != null && !suppression.equals((Object)tempMisc.getSuppression())) {
                misc.setSuppression(this.d_suppressionCombo.getSelectedItem());
            } else {
                misc.setSuppression(tempMisc.getSuppression());
            }
            UnitPoint3D texOrigin = new UnitPoint3D((UnitDouble)this.d_dfTexOriginX.getValue(), (UnitDouble)this.d_dfTexOriginY.getValue(), (UnitDouble)this.d_dfTexOriginZ.getValue());
            if (this.d_cbTexOrigin.isSelected() && !texOrigin.equals(tempMisc.getTextureOrigin())) {
                misc.setTextureOrigin(texOrigin);
            } else {
                misc.setTextureOrigin(tempMisc.getTextureOrigin());
            }
            this.d_customPnl.save(Collections.singleton(sp));
        }

        public void loadData() {
            UnitPoint3D texOrigin;
            SimParams.Misc defMisc = new SimParams(this.d_pyroMod.getSurfaceMgr()).getMisc();
            SimParams.Misc misc = this.d_pyroMod.getSimParams().getMisc();
            Surface selected = misc.getSurfDefault();
            if (selected != null) {
                this.d_surfCombo.setSelectedItem(selected);
            } else {
                this.d_surfCombo.setSelectedItem(this.d_pyroMod.getDefaultSurface());
            }
            SimParams.Misc.SUPPRESSION suppression = misc.getSuppression();
            if (!suppression.equals((Object)defMisc.getSuppression())) {
                this.d_suppressionCombo.setSelectedItem((Object)suppression);
            }
            if ((texOrigin = misc.getTextureOrigin()) != null && !texOrigin.equals(defMisc.getTextureOrigin())) {
                this.d_cbTexOrigin.setSelected(true);
                this.d_dfTexOriginX.setValue(texOrigin.xu());
                this.d_dfTexOriginY.setValue(texOrigin.yu());
                this.d_dfTexOriginZ.setValue(texOrigin.zu());
            } else {
                this.d_cbTexOrigin.setSelected(false);
            }
            this.d_customPnl.load(Collections.singleton(this.d_pyroMod.getSimParams()));
        }

        public guiPanel getPanel() {
            return SimulationPropertiesDlg.this.d_miscPanel;
        }

        public void setDefaults() {
        }
    }

    private class OutputPanel
    extends guiPanel {
        private static final long serialVersionUID = 3432198331510818638L;
        private final guiCheckBox d_cbBoundaryFile;
        private final guiCheckBox d_cbDeviceFiles;
        private final guiCheckBox d_cbHeatReleaseRateFiles;
        private final guiCheckBox d_cbIsofFiles;
        private final guiCheckBox d_cbParticleFiles;
        private final guiCheckBox d_cbProfileDumpInterval;
        private final guiCheckBox d_cbRestartFile;
        private final guiCheckBox d_cbSliceFiles;
        private final guiCheckBox d_cbSlice3dFiles;
        private final guiCheckBox d_cbMassFiles;
        private final guiCheckBox d_cbSmokeView;
        private final guiCheckBox d_cbSpeciesMassFile;
        private final guiCheckBox d_cbColDumpLimit;
        private final guiCheckBox d_cbSuppressDiagnostics;
        private final guiCheckBox d_cbNumFrames;
        private final ValueField<UnitDouble> d_dfBoundaryFile;
        private final ValueField<UnitDouble> d_dfDeviceFiles;
        private final ValueField<UnitDouble> d_dfHeatReleaseRateFiles;
        private final ValueField<UnitDouble> d_dfIsofFiles;
        private final ValueField<UnitDouble> d_dfParticleFiles;
        private final ValueField<UnitDouble> d_dfProfileDumpInterval;
        private final ValueField<UnitDouble> d_dfRestartFile;
        private final ValueField<UnitDouble> d_dfSliceFiles;
        private final ValueField<UnitDouble> d_dfSlice3dFiles;
        private final ValueField<UnitDouble> d_dfMassFiles;
        private final ValueField<Integer> d_ifNumFrames;
        private final guiLabel d_timeLabel1;
        private final guiLabel d_timeLabel2;
        private final TitleSeparator d_fileWriteInterval;
        private final UnitSystem d_system;
        private final Unit d_timeUnit;
        private final PyroMod d_pyroMod;
        private final guiPanel d_outputPanel;
        private final guiPanel d_massPanel;
        private final guiPanel d_plotPanel;
        private final QuantityComboBox d_smokeQuantity;

        public OutputPanel(PyroMod mod) {
            this.d_pyroMod = mod;
            this.d_system = ((PyroSim)Application.getApp()).getUnitSystem();
            this.d_outputPanel = new guiPanel();
            this.d_massPanel = new guiPanel();
            this.d_plotPanel = new guiPanel();
            this.d_timeUnit = this.d_system.getTimeUnit();
            this.d_timeLabel1 = new guiLabel(this.d_timeUnit + "");
            this.d_timeLabel2 = new guiLabel(this.d_timeUnit + "");
            this.d_cbSmokeView = new guiCheckBox(Intl.intl("Enable 3D Smoke Visualization"));
            this.d_cbColDumpLimit = new guiCheckBox(Intl.intl("Limit Text Output to 255 Columns"));
            this.d_cbSuppressDiagnostics = new guiCheckBox(Intl.intl("Suppress Diagnostics"));
            this.d_cbNumFrames = new guiCheckBox(Intl.intl("Number of Output Data Frames") + ":");
            this.d_cbSpeciesMassFile = new guiCheckBox(Intl.intl("Write Gas Species Mass File"));
            this.d_fileWriteInterval = new TitleSeparator(Intl.intl("Output File Write Intervals"));
            this.d_cbBoundaryFile = new guiCheckBox(Intl.intl("Boundary") + ":");
            this.d_cbDeviceFiles = new guiCheckBox(Intl.intl("Device") + ":");
            this.d_cbHeatReleaseRateFiles = new guiCheckBox(Intl.intl("Heat Release Rate") + ":");
            this.d_cbIsofFiles = new guiCheckBox(Intl.intl("Isosurface") + ":");
            this.d_cbParticleFiles = new guiCheckBox(Intl.intl("Particles") + ":");
            this.d_cbProfileDumpInterval = new guiCheckBox(Intl.intl("Profile") + ":");
            this.d_cbRestartFile = new guiCheckBox(Intl.intl("Restart") + ":");
            this.d_cbSliceFiles = new guiCheckBox(Intl.intl("2D Slice") + ":");
            this.d_cbSlice3dFiles = new guiCheckBox(Intl.intl("3D Slice") + ":");
            this.d_cbMassFiles = new guiCheckBox(Intl.intl("Specify Write Interval") + ":");
            SimParams.FileOutput tempFo = this.d_pyroMod.getSimParams().getFileOutput();
            this.d_ifNumFrames = ValueFields.intFld(tempFo.getNumOutputFrames(), SimParams.FileOutput.NUM_FRAMES_RANGE);
            this.d_dfBoundaryFile = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfDeviceFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfHeatReleaseRateFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfIsofFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfParticleFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfProfileDumpInterval = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfRestartFile = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfSliceFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfSlice3dFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfMassFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_cbSpeciesMassFile.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    OutputPanel.this.d_cbMassFiles.setEnabled(OutputPanel.this.d_cbSpeciesMassFile.isSelected());
                    OutputPanel.this.d_dfMassFiles.setEnabled(OutputPanel.this.d_cbMassFiles.isSelected() && OutputPanel.this.d_cbSpeciesMassFile.isSelected());
                }
            });
            this.d_cbNumFrames.addActionListener(new CheckedListener<Integer>(this.d_ifNumFrames));
            this.d_cbMassFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfMassFiles));
            this.d_cbBoundaryFile.addActionListener(new CheckedListener<UnitDouble>(this.d_dfBoundaryFile));
            this.d_cbDeviceFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfDeviceFiles));
            this.d_cbHeatReleaseRateFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfHeatReleaseRateFiles));
            this.d_cbIsofFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfIsofFiles));
            this.d_cbParticleFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfParticleFiles));
            this.d_cbProfileDumpInterval.addActionListener(new CheckedListener<UnitDouble>(this.d_dfProfileDumpInterval));
            this.d_cbRestartFile.addActionListener(new CheckedListener<UnitDouble>(this.d_dfRestartFile));
            this.d_cbSliceFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfSliceFiles));
            this.d_cbSlice3dFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfSlice3dFiles));
            this.d_smokeQuantity = new QuantityComboBox(Intl.intl("Soot Mass Fraction") + " (" + Intl.intl("Default") + ")", SimParams.FileOutput.getSmokeQuantityFilter());
            this.d_smokeQuantity.setObjectMsrsExpanded(true);
            this.buildOutputPanel();
        }

        private void buildOutputPanel() {
            this.d_outputPanel.setLayout(new GridBagLayout());
            guiLabel smokeQuantLbl = new guiLabel(Intl.intl("Smoke Quantity:"));
            int row = 0;
            GridBagUtil.add(this.d_outputPanel, this.d_cbSmokeView, 0, row++, 1, 1, 12, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, smokeQuantLbl, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_smokeQuantity, 1, row++, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbSuppressDiagnostics, 0, row++, 1, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbColDumpLimit, 0, row++, 1, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbNumFrames, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_ifNumFrames, 1, row++, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbSpeciesMassFile, 0, row++, 1, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbMassFiles, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfMassFiles, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_fileWriteInterval, 0, row++, 3, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbBoundaryFile, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfBoundaryFile, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbDeviceFiles, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfDeviceFiles, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbHeatReleaseRateFiles, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfHeatReleaseRateFiles, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbIsofFiles, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfIsofFiles, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbParticleFiles, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfParticleFiles, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbProfileDumpInterval, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfProfileDumpInterval, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbRestartFile, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfRestartFile, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbSliceFiles, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfSliceFiles, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbSlice3dFiles, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfSlice3dFiles, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this.d_outputPanel);
            LinkStatus.link((AbstractButton)this.d_cbNumFrames, this.d_ifNumFrames);
            LinkStatus.link((AbstractButton)this.d_cbBoundaryFile, this.d_dfBoundaryFile);
            LinkStatus.link((AbstractButton)this.d_cbDeviceFiles, this.d_dfDeviceFiles);
            LinkStatus.link((AbstractButton)this.d_cbHeatReleaseRateFiles, this.d_dfHeatReleaseRateFiles);
            LinkStatus.link((AbstractButton)this.d_cbIsofFiles, this.d_dfIsofFiles);
            LinkStatus.link((AbstractButton)this.d_cbMassFiles, this.d_dfMassFiles);
            LinkStatus.link((AbstractButton)this.d_cbParticleFiles, this.d_dfParticleFiles);
            LinkStatus.link((AbstractButton)this.d_cbProfileDumpInterval, this.d_dfProfileDumpInterval);
            LinkStatus.link((AbstractButton)this.d_cbRestartFile, this.d_dfRestartFile);
            LinkStatus.link((AbstractButton)this.d_cbSliceFiles, this.d_dfSliceFiles);
            LinkStatus.link((AbstractButton)this.d_cbSlice3dFiles, this.d_dfSlice3dFiles);
            LinkStatus.link((AbstractButton)this.d_cbSpeciesMassFile, this.d_cbMassFiles);
            LinkStatus.link((AbstractButton)this.d_cbSmokeView, smokeQuantLbl, this.d_smokeQuantity);
        }

        private void saveData(SimParams.FileOutput fo) {
            SimParams.FileOutput tempfo = new SimParams(this.d_pyroMod.getSurfaceMgr()).getFileOutput();
            fo.setSmokeQuantity((IQuantity)this.d_smokeQuantity.getSelectedItem());
            if (this.d_cbBoundaryFile.isSelected()) {
                fo.setDtBoundaryFile((UnitDouble)this.d_dfBoundaryFile.getValue());
            } else {
                fo.setDtBoundaryFile(tempfo.getDtBoundaryFile());
            }
            if (this.d_cbDeviceFiles.isSelected()) {
                fo.setDtDeviceFiles((UnitDouble)this.d_dfDeviceFiles.getValue());
            } else {
                fo.setDtDeviceFiles(tempfo.getDtDeviceFiles());
            }
            if (this.d_cbHeatReleaseRateFiles.isSelected()) {
                fo.setDtHeatReleaseRateFiles((UnitDouble)this.d_dfHeatReleaseRateFiles.getValue());
            } else {
                fo.setDtHeatReleaseRateFiles(tempfo.getDtHeatReleaseRateFiles());
            }
            if (this.d_cbIsofFiles.isSelected()) {
                fo.setDtIsofFiles((UnitDouble)this.d_dfIsofFiles.getValue());
            } else {
                fo.setDtIsofFiles(tempfo.getDtIsofFiles());
            }
            if (this.d_cbParticleFiles.isSelected()) {
                fo.setDtParticleFiles((UnitDouble)this.d_dfParticleFiles.getValue());
            } else {
                fo.setDtParticleFiles(tempfo.getDtParticleFiles());
            }
            if (this.d_cbSliceFiles.isSelected()) {
                fo.setDtSliceFiles((UnitDouble)this.d_dfSliceFiles.getValue());
            } else {
                fo.setDtSliceFiles(tempfo.getDtSliceFiles());
            }
            if (this.d_cbSlice3dFiles.isSelected()) {
                fo.setDtSlice3dFiles((UnitDouble)this.d_dfSlice3dFiles.getValue());
            } else {
                fo.setDtSlice3dFiles(tempfo.getDtSliceFiles());
            }
            if (this.d_cbProfileDumpInterval.isSelected()) {
                fo.setDtProfileDumpInterval((UnitDouble)this.d_dfProfileDumpInterval.getValue());
            } else {
                fo.setDtProfileDumpInterval(tempfo.getDtProfileDumpInterval());
            }
            if (this.d_cbRestartFile.isSelected()) {
                fo.setDtRestartFile((UnitDouble)this.d_dfRestartFile.getValue());
            } else {
                fo.setDtRestartFile(null);
            }
            fo.setVisualize3dSmoke(this.d_cbSmokeView.isSelected());
            fo.setSuppressDiagnostics(this.d_cbSuppressDiagnostics.isSelected());
            fo.setLimitCSVColumns(this.d_cbColDumpLimit.isSelected());
            if (this.d_cbNumFrames.isSelected()) {
                fo.setNumOutputFrames((Integer)this.d_ifNumFrames.getValue());
            } else {
                fo.setNumOutputFrames(tempfo.getNumOutputFrames());
            }
            fo.setWriteSpeciesMassFile(this.d_cbSpeciesMassFile.isSelected());
            if (this.d_cbSpeciesMassFile.isSelected() && this.d_cbMassFiles.isSelected()) {
                fo.setDtMassFiles((UnitDouble)this.d_dfMassFiles.getValue());
            } else {
                fo.setDtMassFiles(tempfo.getDtMassFiles());
            }
        }

        private void loadData() {
            SimParams.FileOutput fo = this.d_pyroMod.getSimParams().getFileOutput();
            SimParams.FileOutput tempfo = new SimParams(this.d_pyroMod.getSurfaceMgr()).getFileOutput();
            this.d_cbSmokeView.setSelected(fo.isVisualize3dSmoke());
            this.d_smokeQuantity.setSelectedItem(fo.getSmokeQuantity());
            this.d_cbSuppressDiagnostics.setSelected(fo.isSuppressDiagnostics());
            this.d_cbColDumpLimit.setSelected(fo.isLimitCSVColumns());
            int numFrames = fo.getNumOutputFrames();
            if (numFrames != tempfo.getNumOutputFrames()) {
                this.d_cbNumFrames.setSelected(true);
                this.d_ifNumFrames.setValue(numFrames);
            } else {
                this.d_cbNumFrames.setSelected(false);
            }
            this.d_cbSpeciesMassFile.setSelected(fo.isWriteSpeciesMassFile());
            this.d_cbMassFiles.setEnabled(this.d_cbSpeciesMassFile.isSelected());
            this.d_dfMassFiles.setEnabled(this.d_cbMassFiles.isSelected() && this.d_cbSpeciesMassFile.isSelected());
            UnitDouble dtBoundaryFile = fo.getDtBoundaryFile();
            this.d_dfBoundaryFile.setValue(dtBoundaryFile);
            if (dtBoundaryFile != null && !dtBoundaryFile.equals(tempfo.getDtBoundaryFile())) {
                this.d_cbBoundaryFile.setSelected(true);
            } else {
                this.d_cbBoundaryFile.setSelected(false);
            }
            UnitDouble dtDeviceFiles = fo.getDtDeviceFiles();
            this.d_dfDeviceFiles.setValue(dtDeviceFiles);
            if (dtDeviceFiles != null && !dtDeviceFiles.equals(tempfo.getDtDeviceFiles())) {
                this.d_cbDeviceFiles.setSelected(true);
            } else {
                this.d_cbDeviceFiles.setSelected(false);
            }
            UnitDouble dtHeatReleaseRateFiles = fo.getDtHeatReleaseRateFiles();
            this.d_dfHeatReleaseRateFiles.setValue(dtHeatReleaseRateFiles);
            if (dtHeatReleaseRateFiles != null && !dtHeatReleaseRateFiles.equals(tempfo.getDtHeatReleaseRateFiles())) {
                this.d_cbHeatReleaseRateFiles.setSelected(true);
            } else {
                this.d_cbHeatReleaseRateFiles.setSelected(false);
            }
            UnitDouble dtIsofFiles = fo.getDtIsofFiles();
            this.d_dfIsofFiles.setValue(dtIsofFiles);
            if (dtIsofFiles != null && !dtIsofFiles.equals(tempfo.getDtIsofFiles())) {
                this.d_cbIsofFiles.setSelected(true);
            } else {
                this.d_cbIsofFiles.setSelected(false);
            }
            UnitDouble dtMassFiles = fo.getDtMassFiles();
            this.d_dfMassFiles.setValue(dtMassFiles);
            if (dtMassFiles != null && !dtMassFiles.equals(tempfo.getDtMassFiles())) {
                this.d_cbMassFiles.setSelected(true);
            } else {
                this.d_cbMassFiles.setSelected(false);
            }
            UnitDouble dtParticleFiles = fo.getDtParticleFiles();
            this.d_dfParticleFiles.setValue(dtParticleFiles);
            if (dtParticleFiles != null && !dtParticleFiles.equals(tempfo.getDtParticleFiles())) {
                this.d_cbParticleFiles.setSelected(true);
            } else {
                this.d_cbParticleFiles.setSelected(false);
            }
            UnitDouble dtProfileDumpInterval = fo.getDtProfileDumpInterval();
            this.d_dfProfileDumpInterval.setValue(dtProfileDumpInterval);
            if (dtProfileDumpInterval != null && !dtProfileDumpInterval.equals(tempfo.getDtProfileDumpInterval())) {
                this.d_cbProfileDumpInterval.setSelected(true);
            } else {
                this.d_cbProfileDumpInterval.setSelected(false);
            }
            UnitDouble dtRestartFile = fo.getDtRestartFile();
            this.d_dfRestartFile.setValue(dtRestartFile);
            if (dtRestartFile != null) {
                this.d_cbRestartFile.setSelected(true);
            } else {
                this.d_cbRestartFile.setSelected(false);
            }
            UnitDouble dtSliceFiles = fo.getDtSliceFiles();
            this.d_dfSliceFiles.setValue(dtSliceFiles);
            if (dtSliceFiles != null && !dtSliceFiles.equals(tempfo.getDtSliceFiles())) {
                this.d_cbSliceFiles.setSelected(true);
            } else {
                this.d_cbSliceFiles.setSelected(false);
            }
            UnitDouble dtSlice3dFiles = fo.getDtSlice3dFiles();
            this.d_dfSlice3dFiles.setValue(dtSlice3dFiles);
            if (dtSlice3dFiles != null) {
                this.d_cbSlice3dFiles.setSelected(true);
            } else {
                this.d_cbSlice3dFiles.setSelected(false);
            }
        }

        private guiPanel getPanel() {
            return this.d_outputPanel;
        }
    }

    private class RadPanel {
        private final PyroMod d_pyroMod;
        private final UnitSystem d_uSys;
        private final guiPanel d_panel;
        private final guiCheckBox d_radi;
        private final guiCheckBox d_wideBand;
        private final ValueField<Integer> d_radSolidAngs;
        private final ValueField<Integer> d_radPolarAngs;
        private final ValueField<Integer> d_tsInc;
        private final ValueField<Integer> d_angInc;
        private final ValueField<Double> d_srcTemp;
        private final ValueField<Double> d_absorbC;
        private final ValueField<UnitDouble> d_dfPathLen;

        public RadPanel(PyroMod pyMod) {
            this.d_pyroMod = pyMod;
            this.d_uSys = PyroSim.getApp().getUnitSystem();
            this.d_radi = new guiCheckBox(Intl.intl("Enable Radiation Transport Solver"));
            this.d_wideBand = new guiCheckBox(Intl.intl("Use Wide Band Model (slower)"));
            SimParams.RadiationTransport tempRad = new SimParams(this.d_pyroMod.getSurfaceMgr()).getRadiTransport();
            this.d_tsInc = ValueFields.intFld(tempRad.getTimeStepInc(), SimParams.RadiationTransport.TIME_STEP_RANGE);
            this.d_radSolidAngs = ValueFields.intFld(tempRad.getNumSolidAngles(), SimParams.RadiationTransport.ANGLE_NUM_RANGE);
            this.d_radPolarAngs = ValueFields.intFld(tempRad.getNumPolarAngles(), SimParams.RadiationTransport.ANGLE_NUM_RANGE);
            this.d_angInc = ValueFields.intFld(tempRad.getAngleIncrement(), SimParams.RadiationTransport.ANGLE_INCREMENT_RANGE);
            this.d_srcTemp = ValueFields.doubleFld(tempRad.getAssumedRadSourceTemp().getValue(this.d_uSys.getTempUnit()), SimParams.RadiationTransport.TEMPERATURE_RANGE.getDoubleRange(this.d_uSys.getTempUnit()));
            this.d_absorbC = ValueFields.doubleFld(tempRad.getConstAbsorptionCoef().getValue(this.d_uSys.getAbsorptionCoefficientUnit()));
            this.d_dfPathLen = ValueFields.udFld(UnitSystem.getSource(0));
            this.d_dfPathLen.setNullAllowed(true);
            guiLabel labTsInc = new guiLabel(Intl.intl("Time Step Increment") + ":");
            guiLabel labAngSkip = new guiLabel(Intl.intl("Angle Increment") + ":");
            guiLabel labRadAngs = new guiLabel(Intl.intl("Number of Solid Angles") + ":");
            guiLabel labPolarAngs = new guiLabel(Intl.intl("Number of Polar Angles") + ":");
            guiLabel labSrcTemp = new guiLabel(Intl.intl("Assumed Radiative Source Temp.") + ":");
            guiLabel labAbsorbC = new guiLabel(Intl.intl("Constant Absorption Coefficient") + ":");
            guiLabel labPathLen = new guiLabel(Intl.intl("Path Length") + ":");
            LinkStatus.link((AbstractButton)this.d_radi, this.d_wideBand, this.d_tsInc, this.d_angInc, this.d_radSolidAngs, this.d_radPolarAngs, this.d_srcTemp, this.d_absorbC, this.d_dfPathLen, labTsInc, labAngSkip, labRadAngs, labPolarAngs, labSrcTemp, labAbsorbC, labPathLen);
            boolean NONE = false;
            int WEST = 17;
            this.d_panel = new guiPanel(new GridBagLayout());
            int row = 0;
            GridBagUtil.add(this.d_panel, this.d_radi, 0, row++, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_wideBand, 0, row++, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, labTsInc, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_tsInc, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, labAngSkip, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_angInc, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, labRadAngs, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_radSolidAngs, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, labPolarAngs, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_radPolarAngs, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, labSrcTemp, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_srcTemp, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, labAbsorbC, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_absorbC, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, labPathLen, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_dfPathLen, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this.d_panel);
        }

        public guiPanel getPanel() {
            return this.d_panel;
        }

        public void saveData(SimParams.RadiationTransport radi) {
            Unit uTemp = this.d_uSys.getTempUnit();
            Unit uKappa = this.d_uSys.getKappa0Unit();
            radi.setRadiationOn(this.d_radi.isSelected());
            radi.setNonGrayGasAssumption(this.d_wideBand.isSelected());
            radi.setNumSolidAngles((Integer)this.d_radSolidAngs.getValue());
            radi.setTimeStepInc((Integer)this.d_tsInc.getValue());
            radi.setAngleIncrement((Integer)this.d_angInc.getValue());
            radi.setAssumedRadSourceTemp(this.ud(this.d_srcTemp, uTemp));
            radi.setNumPolarAngles((Integer)this.d_radPolarAngs.getValue());
            radi.setConstAbsorptionCoef(this.ud(this.d_absorbC, uKappa));
            radi.setRadCalcPathLen((UnitDouble)this.d_dfPathLen.getValue());
        }

        private UnitDouble ud(ValueField<Double> field, Unit u) {
            return new UnitDouble((Double)field.getValue(), u);
        }

        public void loadData() {
            Unit uTemp = this.d_uSys.getTempUnit();
            Unit uKappa = this.d_uSys.getKappa0Unit();
            SimParams.RadiationTransport radi = this.d_pyroMod.getSimParams().getRadiTransport();
            this.d_radi.setSelected(radi.isRadiationOn());
            this.d_wideBand.setSelected(radi.isNonGrayGasAssumption());
            this.d_radSolidAngs.setValue(radi.getNumSolidAngles());
            this.d_tsInc.setValue(radi.getTimeStepInc());
            this.d_angInc.setValue(radi.getAngleIncrement());
            this.d_srcTemp.setValue(radi.getAssumedRadSourceTemp().getValue(uTemp));
            this.d_radPolarAngs.setValue(radi.getNumPolarAngles());
            this.d_absorbC.setValue(radi.getConstAbsorptionCoef().getValue(uKappa));
            this.d_dfPathLen.setValue(radi.getRadCalcPathLen());
        }
    }

    private class SimulatorPanel
    extends guiPanel {
        private static final long serialVersionUID = -8192826770145073049L;
        private final PyroMod d_pyroMod;
        private final guiCheckBox d_cbSmag;
        private final guiCheckBox d_cbCFLStability;
        private final guiCheckBox d_cbVNStability;
        private final guiCheckBox d_cbSchmidt;
        private final guiCheckBox d_cbPrandtl;
        private final guiCheckBox d_cbInitUnmixedFraction;
        private final ValueField<Double> d_dfSmag;
        private final ValueField<Double> d_dfCFLMin;
        private final ValueField<Double> d_dfCFLMax;
        private final ValueField<Double> d_dfVNMin;
        private final ValueField<Double> d_dfVNMax;
        private final ValueField<Double> d_dfSchmidt;
        private final ValueField<Double> d_dfInitUnmixedFraction;
        private final ValueField<Double> d_dfPrandtl;
        private final guiComboBox<SimParams.Calculations.SimulationMode> d_cbSimulations;
        private final guiComboBox<SimParams.Calculations.BaroclinicState> d_cbBaroclinic;
        private final guiPanel d_simPanel;
        private final guiPanel d_cardPanel;
        private final guiPanel d_lesParamCard;
        private final guiPanel d_dnsParamCard;
        private final JPanel d_cflPanel;
        private final JPanel d_vonNeumannPanel;
        private final CardLayout d_cards;
        private final String LES;
        private final String DNS;
        private final Map<SimParams.Calculations.SimulationMode, String> d_simKeyLookup;

        public SimulatorPanel(PyroMod mod) {
            this.d_pyroMod = mod;
            this.LES = "LES";
            this.DNS = "DNS";
            this.d_simKeyLookup = new HashMap<SimParams.Calculations.SimulationMode, String>();
            this.d_simKeyLookup.put(SimParams.Calculations.SimulationMode.LES, this.LES);
            this.d_simKeyLookup.put(SimParams.Calculations.SimulationMode.VLES, this.LES);
            this.d_simKeyLookup.put(SimParams.Calculations.SimulationMode.SVLES, this.LES);
            this.d_simKeyLookup.put(SimParams.Calculations.SimulationMode.DNS, this.DNS);
            this.d_cards = new CardLayout();
            this.d_lesParamCard = new guiPanel(new GridBagLayout());
            this.d_dnsParamCard = new guiPanel();
            this.d_simPanel = new guiPanel();
            this.d_cflPanel = new JPanel(new GridBagLayout());
            this.d_vonNeumannPanel = new JPanel(new GridBagLayout());
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.d_cbSmag = new guiCheckBox(Intl.intl("Specify Smagorinsky Constant") + ":");
            this.d_cbCFLStability = new guiCheckBox(Intl.intl("Specify CFL Region"));
            this.d_cbVNStability = new guiCheckBox(Intl.intl("Specify Von Neumann Region"));
            this.d_cbSchmidt = new guiCheckBox(Intl.intl("Specify Schmidt Number:"));
            this.d_cbPrandtl = new guiCheckBox(Intl.intl("Specify Prandtl Number:"));
            this.d_cbInitUnmixedFraction = new guiCheckBox(Intl.intl("Initial Unmixed Fraction:"));
            this.d_cbBaroclinic = new guiComboBox();
            this.d_cbBaroclinic.setRenderer(this.getBaroclinicRenderer());
            this.d_cbBaroclinic.add(SimParams.Calculations.BaroclinicState.AUTO);
            this.d_cbBaroclinic.add(SimParams.Calculations.BaroclinicState.TRUE);
            this.d_cbBaroclinic.add(SimParams.Calculations.BaroclinicState.FALSE);
            SimParams.Calculations tempCalc = new SimParams(this.d_pyroMod.getSurfaceMgr()).getCalculations();
            this.d_dfSmag = ValueFields.doubleFld(tempCalc.getCsmag(), SimParams.Calculations.CSMAG_RANGE);
            this.d_dfCFLMin = ValueFields.doubleFld(tempCalc.getCflRange()[0]);
            this.d_dfCFLMax = ValueFields.doubleFld(tempCalc.getCflRange()[1]);
            this.d_dfVNMin = ValueFields.doubleFld(tempCalc.getVnRange()[0]);
            this.d_dfVNMax = ValueFields.doubleFld(tempCalc.getVnRange()[1]);
            this.d_dfSchmidt = ValueFields.doubleFld(tempCalc.getSchmidtNum(), SimParams.Calculations.SC_RANGE);
            this.d_dfPrandtl = ValueFields.doubleFld(tempCalc.getPrandtlNum(), SimParams.Calculations.PR_RANGE);
            this.d_dfInitUnmixedFraction = ValueFields.doubleFld(1.0, DoubleVR.between(0.0, 1.0, true, true));
            JTextField temp = new JTextField(6);
            this.d_dfCFLMin.setPreferredSize(temp.getPreferredSize());
            this.d_dfCFLMax.setPreferredSize(temp.getPreferredSize());
            this.d_dfVNMin.setPreferredSize(temp.getPreferredSize());
            this.d_dfVNMax.setPreferredSize(temp.getPreferredSize());
            this.d_cbSimulations = new guiComboBox();
            this.d_cbSimulations.setRenderer(this.getSimulationTypeRenderer());
            this.d_cbSimulations.addItem((SimParams.Calculations.SimulationMode)SimParams.Calculations.SimulationMode.LES);
            this.d_cbSimulations.addItem((SimParams.Calculations.SimulationMode)SimParams.Calculations.SimulationMode.VLES);
            this.d_cbSimulations.addItem((SimParams.Calculations.SimulationMode)SimParams.Calculations.SimulationMode.SVLES);
            this.d_cbSimulations.addItem((SimParams.Calculations.SimulationMode)SimParams.Calculations.SimulationMode.DNS);
            this.d_cbSimulations.addItemListener(e -> {
                SimParams.Calculations.SimulationMode comboSelection = this.d_cbSimulations.getSelectedItem();
                this.d_cards.show(this.d_cardPanel, this.d_simKeyLookup.get((Object)comboSelection));
            });
            this.d_cbSmag.addActionListener(new CheckedListener<Double>(this.d_dfSmag));
            this.d_cbCFLStability.addActionListener(new CheckedListener<Double>(this.d_dfCFLMin));
            this.d_cbVNStability.addActionListener(new CheckedListener<Double>(this.d_dfVNMin));
            this.d_cbSchmidt.addActionListener(new CheckedListener<Double>(this.d_dfSchmidt));
            this.d_cbPrandtl.addActionListener(new CheckedListener<Double>(this.d_dfPrandtl));
            this.d_cbInitUnmixedFraction.addActionListener(new CheckedListener<Double>(this.d_dfInitUnmixedFraction));
            this.buildSimPanel();
        }

        private ListCellRenderer getSimulationTypeRenderer() {
            return new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof SimParams.Calculations.SimulationMode) {
                        this.setText(((SimParams.Calculations.SimulationMode)((Object)value)).getDisplayName());
                    }
                    return this;
                }
            };
        }

        private ListCellRenderer getBaroclinicRenderer() {
            return new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof SimParams.Calculations.SimulationMode) {
                        this.setText(((SimParams.Calculations.BaroclinicState)((Object)value)).displayName);
                    }
                    return this;
                }
            };
        }

        private void buildSimPanel() {
            this.d_simPanel.setLayout(new GridBagLayout());
            int row = 0;
            GridBagUtil.add(this.d_simPanel, this.d_cbSmag, 0, row, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_simPanel, this.d_dfSmag, 2, row++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_simPanel, this.d_cbCFLStability, 0, row, 1, 1, 0, 12, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_cflPanel, new guiLabel(Intl.intl("Min:")), 0, 0, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_cflPanel, this.d_dfCFLMin, 1, 0, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_cflPanel, new guiLabel(Intl.intl("Max:")), 0, 1, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_cflPanel, this.d_dfCFLMax, 1, 1, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_simPanel, this.d_cflPanel, 1, row, 2, 2, 0, -1, 12, 6, 0, 0.0, 0.0, 18);
            GridBagUtil.add(this.d_simPanel, this.d_cbVNStability, 0, row += 2, 1, 1, 0, 12, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_vonNeumannPanel, new guiLabel(Intl.intl("Min") + ":"), 0, 0, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_vonNeumannPanel, this.d_dfVNMin, 1, 0, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_vonNeumannPanel, new guiLabel(Intl.intl("Max") + ":"), 0, 1, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_vonNeumannPanel, this.d_dfVNMax, 1, 1, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_simPanel, this.d_vonNeumannPanel, 1, row, 2, 2, 0, -1, 12, 6, 0, 0.0, 0.0, 18);
            GridBagUtil.add(this.d_simPanel, new guiLabel(Intl.intl("Simulation Type") + ":"), 0, row += 2, 1, 1, 6, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_simPanel, this.d_cbSimulations, 1, row++, 2, 1, 6, 0, 6, 12, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_simPanel, new JSeparator(0), 0, row++, 3, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_lesParamCard, new guiLabel(Intl.intl("Include Baroclinic Torque:")), 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_lesParamCard, this.d_cbBaroclinic, 2, row++, 1, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_lesParamCard, this.d_cbSchmidt, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_lesParamCard, this.d_dfSchmidt, 2, row++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_lesParamCard, this.d_cbPrandtl, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_lesParamCard, this.d_dfPrandtl, 2, row++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_lesParamCard, this.d_cbInitUnmixedFraction, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_lesParamCard, this.d_dfInitUnmixedFraction, 2, row++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
            this.d_cardPanel.add((Component)this.d_lesParamCard, this.LES);
            this.d_cardPanel.add((Component)this.d_dnsParamCard, this.DNS);
            GridBagUtil.add(this.d_simPanel, this.d_cardPanel, 0, row, 3, 3, 0, 0, 0, 0, 0, 0.0, 0.0, 18);
            GridBagUtil.addGlue(this.d_simPanel);
            LinkStatus.link((AbstractButton)this.d_cbSmag, this.d_dfSmag);
            LinkStatus.link((AbstractButton)this.d_cbSchmidt, this.d_dfSchmidt);
            LinkStatus.link((AbstractButton)this.d_cbPrandtl, this.d_dfPrandtl);
            LinkStatus.link((AbstractButton)this.d_cbInitUnmixedFraction, this.d_dfInitUnmixedFraction);
            LinkStatus.link((AbstractButton)this.d_cbCFLStability, this.d_cflPanel);
            LinkStatus.link((AbstractButton)this.d_cbVNStability, this.d_vonNeumannPanel);
        }

        public void saveData(SimParams.Calculations calc) {
            SimParams.Calculations defaultCalcs = new SimParams(this.d_pyroMod.getSurfaceMgr()).getCalculations();
            if (this.d_cbSmag.isSelected()) {
                calc.setCsmag((Double)this.d_dfSmag.getValue());
            } else {
                calc.setCsmag(defaultCalcs.getCsmag());
            }
            if (this.d_cbCFLStability.isSelected()) {
                calc.setCflRange((Double)this.d_dfCFLMin.getValue(), (Double)this.d_dfCFLMax.getValue());
            } else {
                calc.setCflRange(defaultCalcs.getCflRange()[0], defaultCalcs.getCflRange()[1]);
            }
            if (this.d_cbVNStability.isSelected()) {
                calc.setVnRange((Double)this.d_dfVNMin.getValue(), (Double)this.d_dfVNMax.getValue());
            } else {
                calc.setVnRange(defaultCalcs.getVnRange()[0], defaultCalcs.getVnRange()[1]);
            }
            if (this.d_cbSchmidt.isVisible() && this.d_cbSchmidt.isSelected()) {
                calc.setSchmidtNum((Double)this.d_dfSchmidt.getValue());
            } else {
                calc.setSchmidtNum(defaultCalcs.getSchmidtNum());
            }
            if (this.d_cbPrandtl.isVisible() && this.d_cbPrandtl.isSelected()) {
                calc.setPrandtlNum((Double)this.d_dfPrandtl.getValue());
            } else {
                calc.setPrandtlNum(defaultCalcs.getPrandtlNum());
            }
            if (this.d_cbInitUnmixedFraction.isVisible() && this.d_cbInitUnmixedFraction.isSelected()) {
                calc.setInitUnmixedFraction((Double)this.d_dfInitUnmixedFraction.getValue());
            } else {
                calc.setInitUnmixedFraction(defaultCalcs.getInitUnmixedFraction());
            }
            calc.setSimMode(this.d_cbSimulations.getSelectedItem());
            calc.setBaroclinicState(this.d_cbBaroclinic.getSelectedItem());
        }

        public void loadData() {
            SimParams.Calculations defaultCalcs = new SimParams(this.d_pyroMod.getSurfaceMgr()).getCalculations();
            SimParams.Calculations calc = this.d_pyroMod.getSimParams().getCalculations();
            this.d_cbSimulations.setSelectedItem((Object)calc.getSimMode());
            this.d_cbBaroclinic.setSelectedItem((Object)calc.getBaroclinicState());
            double smag = calc.getCsmag();
            if (smag != defaultCalcs.getCsmag()) {
                this.d_cbSmag.setSelected(true);
                this.d_dfSmag.setValue(smag);
            } else {
                this.d_cbSmag.setSelected(false);
            }
            double[] cfl = calc.getCflRange();
            if (cfl[0] != defaultCalcs.getCflRange()[0] || cfl[1] != defaultCalcs.getCflRange()[1]) {
                this.d_cbCFLStability.setSelected(true);
                this.d_dfCFLMin.setValue(cfl[0]);
                this.d_dfCFLMax.setValue(cfl[1]);
            } else {
                this.d_cbCFLStability.setSelected(false);
            }
            double[] vn = calc.getVnRange();
            if (vn[0] != defaultCalcs.getVnRange()[0] || vn[1] != defaultCalcs.getVnRange()[1]) {
                this.d_cbVNStability.setSelected(true);
                this.d_dfVNMin.setValue(vn[0]);
                this.d_dfVNMax.setValue(vn[1]);
            } else {
                this.d_cbVNStability.setSelected(false);
            }
            double prandtl = calc.getPrandtlNum();
            if (prandtl != defaultCalcs.getPrandtlNum()) {
                this.d_cbPrandtl.setSelected(true);
                this.d_dfPrandtl.setValue(prandtl);
            } else {
                this.d_cbPrandtl.setSelected(false);
            }
            double initUnmixedFraction = calc.getInitUnmixedFraction();
            if (initUnmixedFraction != defaultCalcs.getInitUnmixedFraction()) {
                this.d_cbInitUnmixedFraction.setSelected(true);
                this.d_dfInitUnmixedFraction.setValue(initUnmixedFraction);
            } else {
                this.d_cbInitUnmixedFraction.setSelected(false);
            }
            double schmidt = calc.getSchmidtNum();
            if (schmidt != defaultCalcs.getSchmidtNum()) {
                this.d_cbSchmidt.setSelected(true);
                this.d_dfSchmidt.setValue(schmidt);
            } else {
                this.d_cbSchmidt.setSelected(false);
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!this.d_dfCFLMax.isEmpty() && !this.d_dfCFLMin.isEmpty() && (Double)this.d_dfCFLMin.getValue() > (Double)this.d_dfCFLMax.getValue()) {
                return SimulationPropertiesDlg.this.invalidateFormattedFld(showWarn, allowModify, this.d_dfCFLMin, Intl.intl("Min must be less than or equal to Max") + ".");
            }
            if (!this.d_dfVNMax.isEmpty() && !this.d_dfVNMin.isEmpty() && (Double)this.d_dfVNMin.getValue() > (Double)this.d_dfVNMax.getValue()) {
                return SimulationPropertiesDlg.this.invalidateFormattedFld(showWarn, allowModify, this.d_dfVNMin, Intl.intl("Min must be less than or equal to Max") + ".");
            }
            return true;
        }

        public guiPanel getPanel() {
            return this.d_simPanel;
        }
    }

    private class ParticlePanel
    extends guiPanel {
        private static final long serialVersionUID = -3492088206321508526L;
        private final guiCheckBox d_cbPorousFloor;
        private final guiCheckBox d_cbMaxPartPerMesh;
        private final guiCheckBox d_cbAllowUndersideDroplets;
        private final ValueField<Integer> d_ifMaxPartPerMesh;
        private final PyroMod d_pyroMod;
        private final guiPanel d_partPanel;

        public ParticlePanel(PyroMod mod) {
            this.d_pyroMod = mod;
            this.d_partPanel = new guiPanel();
            this.d_cbMaxPartPerMesh = new guiCheckBox(Intl.intl("Max Particles per Mesh") + ":");
            this.d_cbPorousFloor = new guiCheckBox(Intl.intl("Droplets Disappear at Floor"));
            this.d_cbAllowUndersideDroplets = new guiCheckBox(Intl.intl("Allow Underside Droplets"));
            this.d_ifMaxPartPerMesh = ValueFields.intFld(new SimParams(this.d_pyroMod.getSurfaceMgr()).getParticles().getMaxParticlesPerMesh(), SimParams.Particles.MAX_PARTICLES_PER_MESH);
            this.d_cbMaxPartPerMesh.addActionListener(new CheckedListener<Integer>(this.d_ifMaxPartPerMesh));
            this.buildParticlePanel();
        }

        private void buildParticlePanel() {
            this.d_partPanel.setLayout(new GridBagLayout());
            int row = 0;
            GridBagUtil.add(this.d_partPanel, this.d_cbPorousFloor, 0, row++, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_partPanel, this.d_cbAllowUndersideDroplets, 0, row++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_partPanel, this.d_cbMaxPartPerMesh, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_partPanel, this.d_ifMaxPartPerMesh, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 18);
            GridBagUtil.addGlue(this.d_partPanel);
            LinkStatus.link((AbstractButton)this.d_cbMaxPartPerMesh, this.d_ifMaxPartPerMesh);
        }

        public guiPanel getPanel() {
            return this.d_partPanel;
        }

        public void saveData(SimParams.Particles part) {
            part.setPourousFloor(this.d_cbPorousFloor.isSelected());
            part.setAllowUndersideDroplets(this.d_cbAllowUndersideDroplets.isSelected());
            if (this.d_cbMaxPartPerMesh.isSelected()) {
                part.setMaxParticlesPerMesh((Integer)this.d_ifMaxPartPerMesh.getValue());
            } else {
                part.setMaxParticlesPerMesh(new SimParams(this.d_pyroMod.getSurfaceMgr()).getParticles().getMaxParticlesPerMesh());
            }
        }

        public void loadData() {
            SimParams.Particles part = this.d_pyroMod.getSimParams().getParticles();
            this.d_cbPorousFloor.setSelected(part.isPourousFloor());
            this.d_cbAllowUndersideDroplets.setSelected(part.getAllowUndersideDroplets());
            int maxPart = part.getMaxParticlesPerMesh();
            if (maxPart != new SimParams(this.d_pyroMod.getSurfaceMgr()).getParticles().getMaxParticlesPerMesh()) {
                this.d_cbMaxPartPerMesh.setSelected(true);
                this.d_ifMaxPartPerMesh.setValue(maxPart);
            } else {
                this.d_cbMaxPartPerMesh.setSelected(false);
            }
        }
    }

    private class EnvironmentPanel
    extends guiPanel {
        private static final long serialVersionUID = -6127356283272895039L;
        private final guiCheckBox d_cbSpecTMPA;
        private final guiCheckBox d_cbSpecPRESSAMB;
        private final guiCheckBox d_cbAmbMFO2;
        private final guiCheckBox d_cbAmbMFCO2;
        private final guiCheckBox d_cbRelHum;
        private final guiCheckBox d_cbGroundLevel;
        private final guiCheckBox d_cbMaxVis;
        private final guiCheckBox d_cbVisFactor;
        private final guiCheckBox d_cbSpecGravity;
        private final guiCheckBox d_cbWind;
        private final ValueField<UnitDouble> d_vfTMPA;
        private final ValueField<UnitDouble> d_vfPRESSAMB;
        private final ValueField<UnitDouble> d_vfAmbMFO2;
        private final ValueField<UnitDouble> d_vfAmbMFCO2;
        private final ValueField<UnitDouble> d_vfRelHum;
        private final ValueField<UnitDouble> d_vfGroundLevel;
        private final ValueField<UnitDouble> d_vfMaxVis;
        private final ValueField<Double> d_dfVisFactor;
        private final UnitSystem d_system;
        private final PyroMod d_pyroMod;
        private final guiPanel d_envPanel;
        private final guiPanel d_gravpan;
        private final VariantEditor d_veX;
        private final VariantEditor d_veY;
        private final VariantEditor d_veZ;
        private final JButton d_editWindBtn;
        private final String d_gravString = Intl.intl("Gravity");
        private SimParams.Wind d_tempWind;

        public EnvironmentPanel(PyroMod mod) {
            this.d_pyroMod = mod;
            this.d_system = ((PyroSim)Application.getApp()).getUnitSystem();
            this.d_gravpan = new guiPanel(new GridBagLayout());
            this.d_envPanel = new guiPanel();
            this.d_cbSpecTMPA = new guiCheckBox(Intl.intl("Ambient Temperature:"));
            this.d_cbSpecPRESSAMB = new guiCheckBox(Intl.intl("Ambient Pressure:"));
            this.d_cbAmbMFO2 = new guiCheckBox(Intl.intl("Ambient Oxygen Mass Fraction:"));
            this.d_cbAmbMFCO2 = new guiCheckBox(Intl.intl("Ambient Carbon Dioxide Mass Fraction:"));
            this.d_cbRelHum = new guiCheckBox(Intl.intl("Relative Humidity:"));
            this.d_cbGroundLevel = new guiCheckBox(Intl.intl("Ground Level:"));
            this.d_cbMaxVis = new guiCheckBox(Intl.intl("Maximum Visibility:"));
            this.d_cbVisFactor = new guiCheckBox(Intl.intl("Visibility Factor:"));
            this.d_cbSpecGravity = new guiCheckBox(Intl.intl("Specify Gravity"));
            this.d_cbWind = new guiCheckBox(Intl.intl("Configure Wind"));
            SimParams.Environment env = this.d_pyroMod.getSimParams().getEnvironment();
            this.d_vfTMPA = ValueFields.udFld(env.getAmbTemp(), SimParams.Environment.TEMPERATURE_RANGE, UnitSystem.getSource(1));
            this.d_vfPRESSAMB = ValueFields.udFld(env.getAmbPressure(), SimParams.Environment.AMBIENT_PRESSURE_RANGE, UnitSystem.getSource(39));
            this.d_vfAmbMFO2 = ValueFields.udFld(env.getAmbMFO2(), UnitSystem.getSource(18));
            this.d_vfAmbMFCO2 = ValueFields.udFld(env.getAmbMFCO2(), UnitSystem.getSource(18));
            this.d_vfRelHum = ValueFields.udFld(env.getRelHumidity(), SimParams.Environment.RELATIVE_HUMIDITY_RANGE, UnitSystem.getSource(64));
            this.d_vfGroundLevel = ValueFields.udFld(env.getGroundLevel(), UnitSystem.getSource(0));
            this.d_vfMaxVis = ValueFields.udFld(env.getMaxVisibility(), UnitSystem.getSource(0));
            this.d_dfVisFactor = ValueFields.doubleFld(env.getVisibilityFactor());
            this.d_editWindBtn = new JButton(Intl.intl("Edit..."));
            this.d_tempWind = new SimParams.Wind();
            this.d_cbSpecTMPA.addActionListener(new CheckedListener<UnitDouble>(this.d_vfTMPA));
            this.d_cbSpecPRESSAMB.addActionListener(new CheckedListener<UnitDouble>(this.d_vfPRESSAMB));
            this.d_cbRelHum.addActionListener(new CheckedListener<UnitDouble>(this.d_vfRelHum));
            this.d_veX = new VariantEditor(Intl.intl("X"), Intl.intl("Gravity[X]"), SimParams.Environment.GRAVX_PROFILE);
            this.d_veY = new VariantEditor(Intl.intl("Y"), Intl.intl("Gravity[Y]"), SimParams.Environment.GRAVY_PROFILE);
            this.d_veZ = new VariantEditor(Intl.intl("Z"), Intl.intl("Gravity[Z]"), SimParams.Environment.GRAVZ_PROFILE);
            this.d_editWindBtn.addActionListener(e -> {
                guiDialog wDlg = new guiDialog((Window)SimulationPropertiesDlg.this, Intl.intl("Wind Parameters"), 9);
                WindPanel wPanel = new WindPanel();
                wDlg.getDialogPane().add(wPanel);
                wPanel.load(this.d_tempWind);
                if (wDlg.doModal() == 1) {
                    wPanel.save(this.d_tempWind);
                    SimulationPropertiesDlg.this.d_dlgPanel.setModified(true);
                }
            });
            this.buildEnvironmentPanel();
        }

        public boolean validateGravity(VariantEditor veX, VariantEditor veY, VariantEditor veZ, boolean showWarn) {
            return SimulationPropertiesDlg.validateVariant(this.getParent(), veX, showWarn, Intl.intl("Specify Gravity (X)")) && SimulationPropertiesDlg.validateVariant(this.getParent(), veY, showWarn, Intl.intl("Specify Gravity (Y)")) && SimulationPropertiesDlg.validateVariant(this.getParent(), veZ, showWarn, Intl.intl("Specify Gravity (Z)"));
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (!this.validateGravity(this.d_veX, this.d_veY, this.d_veZ, showWarn)) {
                return false;
            }
            SurfaceManager surfs = this.d_pyroMod.getSurfaceMgr();
            for (Surface s : surfs.flatten()) {
                String msg;
                int choice;
                UnitDouble groundLevel;
                UnitDouble udZ0;
                ISurfDesc surfDesc = s.getSurfDesc();
                AirFlow airFlow = null;
                if (surfDesc instanceof BlowerSurfDesc) {
                    airFlow = ((BlowerSurfDesc)surfDesc).d_airFlow;
                } else if (surfDesc instanceof InFlowSurfDesc) {
                    airFlow = ((InFlowSurfDesc)surfDesc).d_airFlow;
                }
                if (airFlow == null || !(airFlow.d_profile instanceof AirFlow.AtmosphericProf) || !(udZ0 = ((AirFlow.AtmosphericProf)airFlow.d_profile).d_origin).lt(groundLevel = (UnitDouble)this.d_vfGroundLevel.getValue(), 1.0E-6) || (choice = JOptionPane.showConfirmDialog(this, msg = String.format(Intl.intl("Warning: Ground Level above lowest atmospheric\nvelocity profile (%1$s, %2$s)."), s.getName(), udZ0.toString()), Intl.intl("Warning"), 2, 2)) != 2) continue;
                return false;
            }
            return true;
        }

        private void buildEnvironmentPanel() {
            this.d_envPanel.setLayout(new GridBagLayout());
            int row = 0;
            GridBagUtil.add(this.d_envPanel, this.d_cbSpecTMPA, 0, row, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfTMPA, 1, row++, 1, 1, 12, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbSpecPRESSAMB, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfPRESSAMB, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbAmbMFO2, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfAmbMFO2, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbAmbMFCO2, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfAmbMFCO2, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbWind, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_editWindBtn, 1, row++, 1, 1, 0, 0, 6, 3, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbRelHum, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfRelHum, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbGroundLevel, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfGroundLevel, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbMaxVis, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfMaxVis, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbVisFactor, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_dfVisFactor, 1, row++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbSpecGravity, 0, row, 1, 1, 0, 12, 12, 12, 0, 0.0, 0.0, 17);
            this.d_veX.addToPanel(this.d_gravpan, 0, 0, 0, 0, 0, 0);
            this.d_veY.addToPanel(this.d_gravpan, 0, 1, 0, 0, 0, 0);
            this.d_veZ.addToPanel(this.d_gravpan, 0, 2, 0, 0, 0, 0);
            GridBagUtil.add(this.d_envPanel, this.d_gravpan, 1, row, 2, 3, 0, 5, 12, 6, 0, 0.0, 0.0, 18);
            GridBagUtil.addGlue(this.d_envPanel);
            LinkStatus.link((AbstractButton)this.d_cbSpecTMPA, this.d_vfTMPA);
            LinkStatus.link((AbstractButton)this.d_cbSpecPRESSAMB, this.d_vfPRESSAMB);
            LinkStatus.link((AbstractButton)this.d_cbAmbMFO2, this.d_vfAmbMFO2);
            LinkStatus.link((AbstractButton)this.d_cbAmbMFCO2, this.d_vfAmbMFCO2);
            LinkStatus.link((AbstractButton)this.d_cbRelHum, this.d_vfRelHum);
            LinkStatus.link((AbstractButton)this.d_cbGroundLevel, this.d_vfGroundLevel);
            LinkStatus.link((AbstractButton)this.d_cbMaxVis, this.d_vfMaxVis);
            LinkStatus.link((AbstractButton)this.d_cbVisFactor, this.d_dfVisFactor);
            LinkStatus.link((AbstractButton)this.d_cbSpecGravity, this.d_gravpan);
            LinkStatus.link((AbstractButton)this.d_cbWind, this.d_editWindBtn);
        }

        public void saveData(SimParams.Environment env, SimParams.Wind wind) {
            SimParams tempParams = new SimParams(this.d_pyroMod.getSurfaceMgr());
            SimParams.Environment tempEnv = tempParams.getEnvironment();
            if (this.d_cbSpecTMPA.isSelected()) {
                env.setAmbTemp((UnitDouble)this.d_vfTMPA.getValue());
            } else {
                env.setAmbTemp(tempEnv.getAmbTemp());
            }
            if (this.d_cbSpecPRESSAMB.isSelected()) {
                env.setAmbPressure((UnitDouble)this.d_vfPRESSAMB.getValue());
            } else {
                env.setAmbPressure(tempEnv.getAmbPressure());
            }
            if (this.d_cbAmbMFO2.isSelected()) {
                env.setAmbMFO2((UnitDouble)this.d_vfAmbMFO2.getValue());
            } else {
                env.setAmbMFO2(tempEnv.getAmbMFO2());
            }
            if (this.d_cbAmbMFCO2.isSelected()) {
                env.setAmbMFCO2((UnitDouble)this.d_vfAmbMFCO2.getValue());
            } else {
                env.setAmbMFCO2(tempEnv.getAmbMFCO2());
            }
            if (this.d_cbRelHum.isSelected()) {
                env.setRelHumidity((UnitDouble)this.d_vfRelHum.getValue());
            } else {
                env.setRelHumidity(tempEnv.getRelHumidity());
            }
            if (this.d_cbGroundLevel.isSelected()) {
                env.setGroundLevel((UnitDouble)this.d_vfGroundLevel.getValue());
            } else {
                env.setGroundLevel(tempEnv.getGroundLevel());
            }
            if (this.d_cbMaxVis.isSelected()) {
                env.setMaxVisibility((UnitDouble)this.d_vfMaxVis.getValue());
            } else {
                env.setMaxVisibility(tempEnv.getMaxVisibility());
            }
            if (this.d_cbVisFactor.isSelected()) {
                env.setVisibilityFactor((Double)this.d_dfVisFactor.getValue());
            } else {
                env.setVisibilityFactor(tempEnv.getVisibilityFactor());
            }
            if (this.d_cbSpecGravity.isSelected()) {
                env.setGravityAccel(this.d_veX.getValue(), this.d_veY.getValue(), this.d_veZ.getValue());
            } else {
                env.setGravityAccel(tempEnv.getGravityX(), tempEnv.getGravityY(), tempEnv.getGravityZ());
            }
            if (this.d_cbWind.isSelected()) {
                wind.copyVals(this.d_tempWind);
            } else {
                wind.copyVals(tempParams.getWind());
            }
        }

        public void loadData() {
            UnitDouble relHum;
            SimParams.Environment env = this.d_pyroMod.getSimParams().getEnvironment();
            SimParams.Wind wind = this.d_pyroMod.getSimParams().getWind();
            SimParams tempParams = new SimParams(this.d_pyroMod.getSurfaceMgr());
            SimParams.Environment tempEnv = tempParams.getEnvironment();
            Variant xGravVar = env.getGravityX();
            Variant yGravVar = env.getGravityY();
            Variant zGravVar = env.getGravityZ();
            if (xGravVar != null && !xGravVar.equals(tempEnv.getGravityX()) || yGravVar != null && !yGravVar.equals(tempEnv.getGravityY()) || zGravVar != null && !zGravVar.equals(tempEnv.getGravityZ())) {
                this.d_veX.init(xGravVar);
                this.d_veY.init(yGravVar);
                this.d_veZ.init(zGravVar);
                this.d_cbSpecGravity.setSelected(true);
            } else {
                this.d_cbSpecGravity.setSelected(false);
            }
            UnitDouble tmpa = env.getAmbTemp();
            if (tmpa != null && !tmpa.equals(tempEnv.getAmbTemp())) {
                this.d_cbSpecTMPA.setSelected(true);
                this.d_vfTMPA.setValue(tmpa);
            } else {
                this.d_cbSpecTMPA.setSelected(false);
            }
            UnitDouble pressAmb = env.getAmbPressure();
            if (pressAmb != null && !pressAmb.equals(tempEnv.getAmbPressure())) {
                this.d_cbSpecPRESSAMB.setSelected(true);
                this.d_vfPRESSAMB.setValue(pressAmb);
            } else {
                this.d_cbSpecPRESSAMB.setSelected(false);
            }
            UnitDouble o2Amb = env.getAmbMFO2();
            if (o2Amb != null && !o2Amb.equals(tempEnv.getAmbMFO2())) {
                this.d_cbAmbMFO2.setSelected(true);
                this.d_vfAmbMFO2.setValue(o2Amb);
            } else {
                this.d_cbAmbMFO2.setSelected(false);
            }
            UnitDouble co2Amb = env.getAmbMFCO2();
            if (co2Amb != null && !co2Amb.equals(tempEnv.getAmbMFCO2())) {
                this.d_cbAmbMFCO2.setSelected(true);
                this.d_vfAmbMFCO2.setValue(co2Amb);
            }
            if (!(relHum = env.getRelHumidity()).equals(tempEnv.getRelHumidity())) {
                this.d_cbRelHum.setSelected(true);
                this.d_vfRelHum.setValue(relHum);
            } else {
                this.d_cbRelHum.setSelected(false);
            }
            UnitDouble groundLevel = env.getGroundLevel();
            if (!theUtil.equal(groundLevel, tempEnv.getGroundLevel())) {
                this.d_cbGroundLevel.setSelected(true);
                this.d_vfGroundLevel.setValue(groundLevel);
            } else {
                this.d_cbGroundLevel.setSelected(false);
            }
            UnitDouble maxVis = env.getMaxVisibility();
            if (maxVis != null && !maxVis.equals(tempEnv.getMaxVisibility())) {
                this.d_cbMaxVis.setSelected(true);
                this.d_vfMaxVis.setValue(maxVis);
            } else {
                this.d_cbMaxVis.setSelected(false);
            }
            double visFactor = env.getVisibilityFactor();
            if (visFactor != tempEnv.getVisibilityFactor()) {
                this.d_cbVisFactor.setSelected(true);
                this.d_dfVisFactor.setValue(visFactor);
            }
            if (wind.isDefault()) {
                this.d_cbWind.setSelected(false);
            } else {
                this.d_cbWind.setSelected(true);
            }
            this.d_tempWind.copyVals(wind);
        }

        public guiPanel getPanel() {
            return this.d_envPanel;
        }
    }

    private class TimePanel
    extends guiPanel {
        private static final long serialVersionUID = -6852541345028055481L;
        private final guiCheckBox d_cbSpecTimeStep;
        private final guiCheckBox d_lockTimeStep;
        private final guiCheckBox d_restrictTimeStep;
        private final ValueField<UnitDouble> d_dfStartTime;
        private final ValueField<UnitDouble> d_dfEndTime;
        private final ValueField<UnitDouble> d_dfTimeStep;
        private final ValueField<Integer> d_wallIncFld;
        private final UnitSystem d_system;
        private final Unit d_timeUnit;
        private final PyroMod d_pyroMod;
        private final guiPanel d_timePanel;

        public TimePanel(PyroMod mod) {
            this.d_pyroMod = mod;
            this.d_system = ((PyroSim)Application.getApp()).getUnitSystem();
            this.d_timeUnit = this.d_system.getTimeUnit();
            SimParams.Time tempTime = new SimParams.Time();
            this.d_timePanel = new guiPanel();
            this.d_lockTimeStep = new guiCheckBox(Intl.intl("Do not allow time step changes"));
            this.d_restrictTimeStep = new guiCheckBox(Intl.intl("Do not allow time step to exceed initial"));
            this.d_cbSpecTimeStep = new guiCheckBox(Intl.intl("Initial Time Step:"));
            this.d_dfEndTime = ValueFields.udFld(tempTime.getStopTime(), UnitSystem.getSource(2));
            this.d_dfStartTime = ValueFields.udFld(tempTime.getStartTime(), UnitSystem.getSource(2));
            this.d_dfTimeStep = ValueFields.udFld(UnitSystem.getSource(2), SimParams.Time.TIME_STEP_RANGE);
            this.d_wallIncFld = ValueFields.intFld(2, SimParams.Time.WALL_INC_RANGE);
            this.d_cbSpecTimeStep.addActionListener(new CheckedListener<UnitDouble>(this.d_dfTimeStep));
            this.buildTimePanel();
        }

        private void buildTimePanel() {
            this.d_timePanel.setLayout(new GridBagLayout());
            guiLabel startTimeLbl = new guiLabel(Intl.intl("Start Time:"));
            guiLabel endTimeLbl = new guiLabel(Intl.intl("End Time:"));
            guiLabel wallIncLbl = new guiLabel(Intl.intl("Wall Update Increment:"));
            guiLabel wallLbl2 = new guiLabel(Intl.intl("frames"));
            int row = 0;
            GridBagUtil.add(this.d_timePanel, startTimeLbl, 0, row, 1, 1, 12, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_dfStartTime, 1, row++, 1, 1, 12, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, endTimeLbl, 0, row, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_dfEndTime, 1, row++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_cbSpecTimeStep, 0, row, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_dfTimeStep, 1, row++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_lockTimeStep, 0, row++, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_restrictTimeStep, 0, row++, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, wallIncLbl, 0, row, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_wallIncFld, 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, wallLbl2, 2, row++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this.d_timePanel);
            LinkStatus.link((AbstractButton)this.d_cbSpecTimeStep, this.d_dfTimeStep);
        }

        public void saveData(SimParams.Time time, SimParams.OpenMp openMp) {
            SimParams.Time tempTime = new SimParams(this.d_pyroMod.getSurfaceMgr()).getTime();
            time.setTimeStepLocks(this.d_lockTimeStep.isSelected(), this.d_restrictTimeStep.isSelected());
            time.setStartTime((UnitDouble)this.d_dfStartTime.getValue());
            time.setStopTime((UnitDouble)this.d_dfEndTime.getValue());
            if (this.d_cbSpecTimeStep.isSelected()) {
                time.setInitTimeStep((UnitDouble)this.d_dfTimeStep.getValue());
            } else {
                time.setInitTimeStep(tempTime.getInitTimeStep());
            }
            time.setWallIncrement((Integer)this.d_wallIncFld.getValue());
        }

        public void loadData() {
            SimParams.Time time = this.d_pyroMod.getSimParams().getTime();
            SimParams.Time tempTime = new SimParams(this.d_pyroMod.getSurfaceMgr()).getTime();
            this.d_lockTimeStep.setSelected(time.lockTimeSteps());
            this.d_restrictTimeStep.setSelected(time.restrictTimeSteps());
            this.d_dfStartTime.setValue(time.getStartTime());
            this.d_dfEndTime.setValue(time.getStopTime());
            UnitDouble timeStep = time.getInitTimeStep();
            this.d_dfTimeStep.setValue(timeStep);
            if (timeStep != null && !timeStep.equals(tempTime.getInitTimeStep())) {
                this.d_cbSpecTimeStep.setSelected(true);
            } else {
                this.d_cbSpecTimeStep.setSelected(false);
            }
            this.d_wallIncFld.setValue(time.getWallIncrement());
        }

        public guiPanel getPanel() {
            return this.d_timePanel;
        }
    }
}

