/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;

public class RampFuncDlg
extends guiDialog {
    private static final long serialVersionUID = 8555427952325986796L;
    private guiTableEditor d_editor;
    private final guiComboBox<IRampInput> d_rampInputs;
    private final int d_fUnitType;
    private final IRampInput d_defRampInput;
    private ValueField<UnitDouble> d_constEditor;

    public RampFuncDlg(IRampInput defRampInput, int valUnit, String valDesc, Collection<IRampInput> rampInputs) {
        this(defRampInput, valUnit, valDesc, rampInputs, UnitSystem.getUndefinedUnit(), "");
    }

    public RampFuncDlg(IRampInput defRampInput, int valUnit, String valDesc, Collection<IRampInput> rampInputs, int constUnitType, String constDesc) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("Ramping Function Values"), 9);
        this.d_defRampInput = defRampInput;
        if (rampInputs == null) {
            rampInputs = this.getRampInputs(this.d_defRampInput);
        }
        this.d_rampInputs = this.createInputCombo(rampInputs);
        this.d_fUnitType = valUnit;
        String[] headers = new String[]{"", this.formatColHeader(valDesc, valUnit)};
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        this.d_editor = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{Double.class, Double.class}), 30);
        this.d_editor.getTable().setNullValuesAllowed(false);
        this.d_editor.setPreferredSize(new Dimension(410, 250));
        GridBagHelper gb = new GridBagHelper(dlgPanel);
        if (UnitSystem.isValidUnit(constUnitType)) {
            guiLabel constLbl = new guiLabel(constDesc);
            this.d_constEditor = ValueFields.udFld(UnitSystem.getSource(constUnitType));
            gb.addRow(constLbl, this.d_constEditor);
            gb.addFilledRow(new JSeparator());
        } else {
            this.d_constEditor = null;
        }
        gb.addRow(Intl.intl("Function Input:"), this.d_rampInputs);
        gb.addRow(this.d_editor, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        this.d_editor.getTable().autoSizeColumns(200);
        this.d_rampInputs.setSelectedItem(this.d_defRampInput);
        this.updateInputHeader();
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
    }

    public static RampFuncDlg newTimeFracDlg(Ramp r) {
        RampFuncDlg dlg = new RampFuncDlg(r.getDefaultInput(), 28, Intl.intl("Fraction"), null);
        dlg.loadData(r);
        return dlg;
    }

    private guiComboBox<IRampInput> createInputCombo(Collection<IRampInput> inputs) {
        guiComboBox<IRampInput> combo = new guiComboBox<IRampInput>(inputs);
        combo.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -2828821800298865042L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                IRampInput input = (IRampInput)value;
                String text = input.getName();
                if (input instanceof SignalInput) {
                    SignalInput si = (SignalInput)input;
                    text = si.getUnitType() == 2 && (si.input.getAttachedSource() instanceof RampInputs.TimeInput || si.input.getAttachedSource() instanceof Clock) ? RampInputs.TIME.getName() : String.format(Intl.intl("Device: %s"), input.getName());
                }
                this.setText(text);
                return c;
            }
        });
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RampFuncDlg.this.updateInputHeader();
                }
            }
        });
        return combo;
    }

    private Collection<IRampInput> getRampInputs(IRampInput defaultInput) {
        ArrayList<SignalInput> extraInputs = new ArrayList<SignalInput>();
        PyroMod domain = PyroSim.getApp().getMediator();
        for (IDevice devc : domain.getDevices().flatten()) {
            if (!(devc instanceof ISignalSource)) continue;
            for (IOutPin iOutPin : ((ISignalSource)((Object)devc)).getOutputPins()) {
                if (!(iOutPin instanceof IDoubleOutPin)) continue;
                SignalInput input = new SignalInput((IDoubleOutPin)iOutPin);
                extraInputs.add(input);
            }
        }
        IRampInput[] inputsArr = extraInputs.toArray(new IRampInput[extraInputs.size()]);
        Arrays.sort(inputsArr, new Comparator<IRampInput>(){

            @Override
            public int compare(IRampInput o1, IRampInput o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        ArrayList<IRampInput> inputs = new ArrayList<IRampInput>();
        inputs.add(defaultInput);
        if (defaultInput.getUnitType() != 2) {
            IDoubleOutPin clock = (IDoubleOutPin)Clock.INSTANCE.getOutputPins().get(0);
            inputs.add(new SignalInput(clock));
        }
        for (IRampInput input : inputsArr) {
            inputs.add(input);
        }
        return inputs;
    }

    private void updateInputHeader() {
        IRampInput input = this.d_rampInputs.getSelectedItem();
        String desc = this.formatColHeader(input.getName(), input.getUnitType());
        this.d_editor.getTable().getColumnModel().getColumn(0).setHeaderValue(desc);
        this.repaint();
    }

    private String formatColHeader(String header, int unitType) {
        Unit unit = this.getUnit(unitType);
        String unitStr = unit.toString();
        return unitStr.isEmpty() ? header : String.format("%s (%s)", header, unitStr);
    }

    private Unit getTUnit() {
        IRampInput input = this.d_rampInputs.getSelectedItem();
        return this.getUnit(input.getUnitType());
    }

    private Unit getFUnit() {
        return this.getUnit(this.d_fUnitType);
    }

    private Unit getUnit(int type) {
        return PyroSim.getApp().getUnitSystem().getUnit(type);
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        this.savePreferredSize(PyroPrefs.LastRampDlgSizeX.key.toString(), PyroPrefs.LastRampDlgSizeY.key.toString());
        return result;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        TableModel model = this.d_editor.getTable().getModel();
        if (model.getRowCount() == 0) {
            String msg = Intl.intl("Error: At least one point must be entered for the function.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        if (!this.noDuplicates(model)) {
            String msg = Intl.intl("Error: Duplicate function time points are not permitted.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    private boolean noDuplicates(TableModel model) {
        int numLines = model.getRowCount();
        for (int i = 0; i < numLines; ++i) {
            for (int j = 0; j < i; ++j) {
                if (guiTableUtil.getDouble(model, i, 0) != guiTableUtil.getDouble(model, j, 0) || guiTableUtil.getDouble(model, i, 1) != guiTableUtil.getDouble(model, j, 1)) continue;
                return false;
            }
        }
        return true;
    }

    public void loadData(Ramp ramp) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_editor.getTable().getModel();
        if (ramp != null) {
            this.d_rampInputs.setSelectedItem(ramp.getInput());
            Unit tUnit = this.getTUnit();
            Unit fUnit = this.getFUnit();
            int numRecsAdded = 0;
            List<Ramp.Entry> entries = ramp.getRecords();
            for (Ramp.Entry rampRec : entries) {
                UnitDouble t = rampRec.t;
                UnitDouble f = rampRec.f;
                model.setValueAt(t.getValue(tUnit), numRecsAdded, 0);
                model.setValueAt(f.getValue(fUnit), numRecsAdded, 1);
                ++numRecsAdded;
            }
        }
        this.updateInputHeader();
    }

    public Ramp getRamp() {
        TableModel model = this.d_editor.getTable().getModel();
        int numRows = model.getRowCount();
        if (numRows > 0) {
            Vector<Ramp.Entry> recs = new Vector<Ramp.Entry>(numRows);
            IRampInput input = this.d_rampInputs.getSelectedItem();
            Unit tUnit = this.getTUnit();
            Unit fUnit = this.getFUnit();
            for (int i = 0; i < numRows; ++i) {
                UnitDouble t = new UnitDouble((Double)model.getValueAt(i, 0), tUnit);
                UnitDouble f = new UnitDouble((Double)model.getValueAt(i, 1), fUnit);
                Ramp.Entry rampRec = new Ramp.Entry(t, f);
                recs.add(rampRec);
            }
            Ramp r = new Ramp(recs, this.d_defRampInput, input, this.d_fUnitType);
            return r;
        }
        return null;
    }

    public void loadData(UnitDouble constVal) {
        if (this.d_constEditor == null) {
            assert (false) : "No editor specified for constant fields.";
            return;
        }
        this.d_constEditor.setValue(constVal);
    }

    public UnitDouble getConstVal() {
        if (this.d_constEditor == null) {
            assert (false) : "No editor specified for constant fields.";
            return null;
        }
        return (UnitDouble)this.d_constEditor.getValue();
    }
}

