/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.domain.Floor;
import pyrosim.domain.ModelImage;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.Disposable;

public class FloorBGImageEditor
extends guiPanel {
    private static final long serialVersionUID = 6723707473871121849L;
    private Floor d_floor = null;
    private EditBGImageAction d_editAction;
    private guiTextField d_fileName = new guiTextField();
    private JButton d_editButton = new JButton("...");
    private JButton d_deleteButton = new JButton(Intl.intl("Remove"));
    private LinkedList d_floorEditedListeners = new LinkedList();
    private LinkedList d_floorDeletedListeners = new LinkedList();

    public FloorBGImageEditor(Floor f, EditBGImageAction editAction) {
        this.setLayout(new GridBagLayout());
        this.d_editAction = editAction;
        Insets fnInsets = this.d_fileName.getBorder().getBorderInsets(this.d_fileName);
        this.d_fileName.setBorder(BorderFactory.createEmptyBorder(0, fnInsets.left, 0, fnInsets.right));
        this.d_fileName.setEditable(false);
        this.d_editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloorBGImageEditor.this.editBGImage();
            }
        });
        this.d_deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloorBGImageEditor.this.deleteBGImage();
            }
        });
        Insets buttonInset = this.d_editButton.getMargin();
        buttonInset.right = 2;
        buttonInset.left = 2;
        this.d_editButton.setMargin(buttonInset);
        this.d_deleteButton.setMargin(buttonInset);
        GridBagUtil.add(this, this.d_fileName, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_editButton, 1, 0, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0, 13);
        GridBagUtil.add(this, this.d_deleteButton, 2, 0, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0, 13);
        this.setEditingFloor(f);
    }

    public void setEditingFloor(Floor f) {
        this.d_floor = f;
        this.updateComponents();
    }

    public Floor getEditingFloor() {
        return this.d_floor;
    }

    public void addFloorEditedListener(ActionListener listener) {
        this.d_floorEditedListeners.add(listener);
    }

    public void addFloorDeletedListener(ActionListener listener) {
        this.d_floorDeletedListeners.add(listener);
    }

    protected void deleteBGImage() {
        if (this.d_floor == null) {
            return;
        }
        this.d_floor.setBgImage(null);
        this.updateComponents();
        Iterator it = this.d_floorDeletedListeners.iterator();
        while (it.hasNext()) {
            ((ActionListener)it.next()).actionPerformed(null);
        }
    }

    protected void editBGImage() {
        if (this.d_floor == null) {
            return;
        }
        boolean changed = this.d_editAction.editFloor(this.d_floor);
        if (changed) {
            this.updateComponents();
            Iterator it = this.d_floorEditedListeners.iterator();
            while (it.hasNext()) {
                ((ActionListener)it.next()).actionPerformed(null);
            }
        }
    }

    public guiTextField getFilenameTextField() {
        return this.d_fileName;
    }

    public JButton getEditButton() {
        return this.d_editButton;
    }

    public JButton getDeleteButton() {
        return this.d_deleteButton;
    }

    protected void updateComponents() {
        ModelImage image = this.d_floor != null ? this.d_floor.getBgImage() : null;
        this.d_deleteButton.setEnabled(image != null);
        String id = image != null ? image.getImage().getFilename() : null;
        this.d_fileName.setText(id);
        this.d_fileName.setToolTipText(id);
        this.d_fileName.setCaretPosition(0);
        if (this.d_floor != null) {
            this.d_editButton.setToolTipText("Edit the background image for the \"" + this.d_floor.getName() + "\" floor.");
            this.d_deleteButton.setToolTipText("Remove the background image from the \"" + this.d_floor.getName() + "\" floor.");
        } else {
            this.d_editButton.setToolTipText(null);
            this.d_deleteButton.setToolTipText(null);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        for (int m = 0; m < this.getComponentCount(); ++m) {
            this.getComponent(m).setBackground(c);
        }
    }

    public static interface EditBGImageAction
    extends Disposable {
        public boolean editFloor(Floor var1);
    }

    private class FocusTP
    extends FocusTraversalPolicy {
        private FocusTP() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(FloorBGImageEditor.this.d_editButton)) {
                return FloorBGImageEditor.this.d_deleteButton;
            }
            if (aComponent.equals(FloorBGImageEditor.this.d_deleteButton)) {
                return FloorBGImageEditor.this.d_fileName;
            }
            if (aComponent.equals(FloorBGImageEditor.this.d_fileName)) {
                return null;
            }
            return FloorBGImageEditor.this.d_editButton;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(FloorBGImageEditor.this.d_editButton)) {
                return null;
            }
            if (aComponent.equals(FloorBGImageEditor.this.d_deleteButton)) {
                return FloorBGImageEditor.this.d_editButton;
            }
            if (aComponent.equals(FloorBGImageEditor.this.d_fileName)) {
                return FloorBGImageEditor.this.d_deleteButton;
            }
            return FloorBGImageEditor.this.d_editButton;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return FloorBGImageEditor.this.d_editButton;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return FloorBGImageEditor.this.d_fileName;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return FloorBGImageEditor.this.d_editButton;
        }
    }
}

