/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.variant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.variant.IRampProfile;
import pyrosim.domain.variant.Variant;

public class DefRampProfile
implements IRampProfile {
    public final String dispName;
    public final Input[] inputs;
    public final Variant defValue;

    public DefRampProfile(String dispName, int fUnitType, Input ... inputs) {
        this(dispName, DefRampProfile.newRamp(fUnitType, inputs), inputs);
    }

    protected static Ramp newRamp(int fUnitType, Input ... inputs) {
        assert (inputs.length > 0 && inputs[0].val != null);
        return new Ramp(Collections.EMPTY_LIST, inputs[0].val, fUnitType);
    }

    public DefRampProfile(String dispName, Ramp defValue, Input ... inputs) {
        this(dispName, Variant.ramp(defValue), inputs);
    }

    protected DefRampProfile(String dispName, Variant defVar, Input ... inputs) {
        assert (inputs.length > 0 && inputs[0].val != null);
        this.dispName = dispName;
        this.inputs = inputs;
        this.defValue = defVar;
    }

    @Override
    public Variant.Type getType() {
        return Variant.Type.RAMP;
    }

    @Override
    public String getDisplayName() {
        return this.dispName;
    }

    @Override
    public Variant getDefaultValue() {
        return this.defValue;
    }

    @Override
    public Collection<IRampInput> getRampInputs(PyroMod domain) {
        ArrayList<IRampInput> inputs = new ArrayList<IRampInput>();
        for (Input input : this.inputs) {
            if (input.val == null) continue;
            inputs.add(input.val);
        }
        if (this.test(Input.SIGNALS) && !this.test(Input.TIME)) {
            IDoubleOutPin clock = (IDoubleOutPin)Clock.INSTANCE.getOutputPins().get(0);
            inputs.add(new SignalInput(clock));
        }
        final IRampInput defInput = (IRampInput)inputs.get(0);
        Comparator<IRampInput> nameSorter = new Comparator<IRampInput>(){

            @Override
            public int compare(IRampInput o1, IRampInput o2) {
                if (o1 == defInput) {
                    return -1;
                }
                if (o2 == defInput) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(inputs, nameSorter);
        if (this.test(Input.SIGNALS)) {
            ArrayList<SignalInput> signalInputs = new ArrayList<SignalInput>();
            for (IDevice devc : domain.getDevices().flatten()) {
                if (!(devc instanceof ISignalSource)) continue;
                for (IOutPin iOutPin : ((ISignalSource)((Object)devc)).getOutputPins()) {
                    if (!(iOutPin instanceof IDoubleOutPin)) continue;
                    SignalInput input = new SignalInput((IDoubleOutPin)iOutPin);
                    signalInputs.add(input);
                }
            }
            Collections.sort(signalInputs, nameSorter);
            inputs.addAll(signalInputs);
        }
        return inputs;
    }

    private boolean test(Input val) {
        for (Input v : this.inputs) {
            if (v != val) continue;
            return true;
        }
        return false;
    }

    public static enum Input {
        TIME(RampInputs.TIME),
        HEAT(RampInputs.HEAT),
        PRESSURE(RampInputs.PRESSURE),
        XPOS(RampInputs.XPOS),
        ZPOS(RampInputs.ZPOS),
        MASS(RampInputs.MASS),
        FLOW(RampInputs.FLOW),
        SIGNALS(null);

        public final IRampInput val;

        private Input(IRampInput val) {
            this.val = val;
        }
    }
}

