/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.ramp;

import java.io.ObjectStreamException;
import pyrosim.Intl;
import pyrosim.domain.ramp.IRampInput;

public class RampInputs {
    public static final TimeInput TIME = new TimeInput();
    public static final HeatInput HEAT = new HeatInput();
    public static final PressureInput PRESSURE = new PressureInput();
    public static final XPositionInput XPOS = new XPositionInput();
    public static final ElevationInput ZPOS = new ElevationInput();
    public static final MassLoadingInput MASS = new MassLoadingInput();
    public static final VolumeFlowInput FLOW = new VolumeFlowInput();

    public static class VolumeFlowInput
    implements IRampInput {
        static final long serialVersionUID = 1L;

        private VolumeFlowInput() {
        }

        @Override
        public String getName() {
            return Intl.intl("Volume Flow");
        }

        @Override
        public int getUnitType() {
            return 24;
        }

        public Object readResolve() throws ObjectStreamException {
            return FLOW;
        }

        @Override
        public String getTVar() {
            return "T";
        }
    }

    public static class MassLoadingInput
    implements IRampInput {
        static final long serialVersionUID = 1L;

        private MassLoadingInput() {
        }

        @Override
        public String getName() {
            return Intl.intl("Mass Loading");
        }

        @Override
        public int getUnitType() {
            return 77;
        }

        public Object readResolve() throws ObjectStreamException {
            return MASS;
        }

        @Override
        public String getTVar() {
            return "T";
        }
    }

    public static class ElevationInput
    implements IRampInput {
        static final long serialVersionUID = 1L;

        @Override
        public String getName() {
            return Intl.intl("Z Position");
        }

        @Override
        public int getUnitType() {
            return 0;
        }

        public Object readResolve() throws ObjectStreamException {
            return ZPOS;
        }

        @Override
        public String getTVar() {
            return "Z";
        }
    }

    public static class XPositionInput
    implements IRampInput {
        public static final int XDIR = 0;
        static final long serialVersionUID = 1L;

        @Override
        public String getName() {
            return Intl.intl("X Position");
        }

        @Override
        public int getUnitType() {
            return 0;
        }

        public Object readResolve() throws ObjectStreamException {
            return XPOS;
        }

        @Override
        public String getTVar() {
            return "X";
        }
    }

    public static class PressureInput
    implements IRampInput {
        static final long serialVersionUID = 1L;

        private PressureInput() {
        }

        @Override
        public String getName() {
            return Intl.intl("Pressure Drop");
        }

        @Override
        public int getUnitType() {
            return 39;
        }

        public Object readResolve() throws ObjectStreamException {
            return PRESSURE;
        }

        @Override
        public String getTVar() {
            return "T";
        }
    }

    public static class TimeInput
    implements IRampInput {
        static final long serialVersionUID = 1L;

        private TimeInput() {
        }

        @Override
        public String getName() {
            return Intl.intl("Time");
        }

        @Override
        public int getUnitType() {
            return 2;
        }

        public Object readResolve() throws ObjectStreamException {
            return TIME;
        }

        @Override
        public String getTVar() {
            return "T";
        }
    }

    public static class HeatInput
    implements IRampInput {
        static final long serialVersionUID = 1L;

        private HeatInput() {
        }

        @Override
        public String getName() {
            return Intl.intl("Temperature");
        }

        @Override
        public int getUnitType() {
            return 1;
        }

        public Object readResolve() throws ObjectStreamException {
            return HEAT;
        }

        @Override
        public String getTVar() {
            return "T";
        }
    }
}

