/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.PyroDisplayGeom;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.ObstFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.LWArray;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.nmt.BooleanOp;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.SolidGeom;
import thunderheadeng.geometry.objs.elem.ElementBuilder;
import thunderheadeng.geometry.objs.elem.ElementBuilders;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementPoly;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Task;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class Obstruction
extends AFDSObject
implements IObstruction {
    static final long serialVersionUID = 1L;
    private static final int DEF_FLAGS = -2147483556;
    private Object d_geom;
    private Object d_surfaces;
    @Deprecated
    private Object d_texMapper;
    @SkipDep
    private TexOrigin d_texOrigin;
    @SkipDep
    private UnitDouble d_bulkDensity;
    private transient Integer d_cachedNumFaces = null;
    private static final int CREASEID = 0x7FFFFFFD;
    private static final int NOCREASEID = 0x7FFFFFFC;
    private static final Predicate<Surface> s_surfFilter = new Predicate<Surface>(){

        @Override
        public boolean test(Surface surf) {
            return !surf.isPredefined(PredefSurf.OPEN) && !surf.isPredefined(PredefSurf.MIRROR) && !surf.isPredefined(PredefSurf.HVAC) && !surf.isPredefined(PredefSurf.PERIODIC);
        }
    };

    public Obstruction(String name, IGeomNode geom, Surface[] surfs) {
        super(name);
        this.d_geom = geom;
        this.d_surfaces = LWArray.newArray(surfs);
        this.d_texOrigin = TexOrigin.defaultWorld();
        this.d_bulkDensity = null;
        this.setOptions(92, true);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean prior87;
        in.defaultReadObject();
        boolean bl = prior87 = PyroSimObjectInputStream.getVersion(in) < 87;
        if (prior87) {
            IElemSource uvSrc = (IElemSource)this.d_texMapper;
            this.d_texMapper = null;
            if (this.d_geom instanceof IGeom) {
                this.d_geom = GeomNodeUtil.newNode((IGeom)this.d_geom, Elements.NONE);
            } else assert (this.d_geom instanceof IGeomNode);
            if (uvSrc != Elements.NO_UV) {
                IElemSource uv = uvSrc;
                this.d_geom = ((IGeomNode)this.d_geom).applyUVElements("uvset", (pix, oldUV) -> uv.getPrimSource((int)pix));
            }
            this.d_geom = ((IGeomNode)this.d_geom).prune();
        }
    }

    @Override
    public Object clone() {
        Obstruction clone = (Obstruction)super.clone();
        Surface[] surfs = this.getSurfaces();
        clone.d_surfaces = LWArray.newArray(surfs);
        return clone;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("OBST");
    }

    @Override
    public boolean isControllable() {
        return true;
    }

    @Override
    public UnitDouble getBulkDensity() {
        return this.d_bulkDensity;
    }

    @Override
    public void setBulkDensity(UnitDouble dens) {
        if (theUtil.equal(dens, this.d_bulkDensity)) {
            return;
        }
        this.d_bulkDensity = dens;
        this.changedEvt(new Object[0]);
    }

    private static int filterOptions(int options) {
        return options & 0xFD;
    }

    @Override
    public void setOptions(int options, boolean set) {
        this.setFlags(Obstruction.filterOptions(options), set, new Object[0]);
    }

    @Override
    public boolean getOptions(int options) {
        return this.testFlags(Obstruction.filterOptions(options));
    }

    @Override
    public int getSetOptions() {
        return Obstruction.filterOptions(super.getSetFlags());
    }

    @Override
    public TexOrigin getTextureOrigin() {
        return this.d_texOrigin;
    }

    @Override
    public void setTextureOrigin(TexOrigin origin) {
        if (this.d_texOrigin.equals(origin)) {
            return;
        }
        this.d_texOrigin = origin;
        this.changedEvt(new Object[0]);
    }

    @Override
    public int getNumFaces() {
        if (this.d_cachedNumFaces == null) {
            this.d_cachedNumFaces = this.getGeom().getNumPrims(1);
        }
        return this.d_cachedNumFaces;
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return new FragGen();
    }

    @Override
    public List<Pair<IObstruction, IHole>> intersectHoles(Supplier<Collection<? extends IHole>> getNearHoles) {
        if (this.getDomain() == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<IObstruction, IHole>> result = new ArrayList<Pair<IObstruction, IHole>>();
        BiConsumer<IHole, DisplayGeom> addHole = (hole, display) -> {
            int numFaces = display.node.getNumPrims(1);
            if (numFaces == 0) {
                return;
            }
            Obstruction clone = (Obstruction)this.clone();
            clone.setGeom(display.node);
            Pair<Surface[], Color[]> surfsAndColors = GeomUtil.getSurfsAndColors(numFaces, display.props);
            clone.setSurfaces((Surface[])surfsAndColors.v1);
            clone.setColors((Color[])surfsAndColors.v2);
            result.add(new Pair<Obstruction, IHole>(clone, (IHole)hole));
        };
        DisplayGeom posGeom = this.constructIsectDisplay(getNearHoles, addHole, () -> this.getDisplayProps(true), oprops -> this.getInnerProps((PyroMod)this.getDomain(), (IPropsSrc)oprops, true));
        if (posGeom == null) {
            return Collections.EMPTY_LIST;
        }
        addHole.accept(null, posGeom);
        return result;
    }

    @Override
    public DisplayGeom getDisplayGeom(PyroMod domain, IDisplayProps drawProps) {
        IPyroDisplayProps pyroProps = drawProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)drawProps : null;
        DisplayGeom disp = FDSUtil.getRastDisplay(pyroProps, this, this.getTextureOrigin());
        if (disp == null) {
            Predicate<Object> holeFilter = pyroProps != null ? pyroProps.getHoleFilter() : Filters.alwaysTrue();
            Supplier<Collection<IHole>> getHoles = domain != null && !Filters.alwaysFalse(holeFilter) ? () -> theUtil.filter(domain.getGeomProx().getNearObjs(this), IHole.class, holeFilter) : () -> Collections.emptyList();
            IPropsSrc obstProps = this.getDisplayProps();
            if (domain != null) {
                disp = this.constructIsectDisplay(getHoles, null, () -> obstProps, oprops -> this.getInnerProps(domain, (IPropsSrc)oprops, false));
            }
            if (disp == null) {
                IGeomNode node = FDSUtil.finalizeUVElements(this.getGeom(), this.d_texOrigin);
                disp = new DisplayGeom(node, obstProps);
            }
        }
        IPrimProps innerProps = this.getInnerProps(domain, disp.props, false);
        int options = 0;
        if (this.getOptions(32)) {
            options |= 1;
        }
        disp = new PyroDisplayGeom(disp, innerProps, options);
        return disp;
    }

    protected IPrimProps getInnerProps(PyroMod domain, IPropsSrc obstProps, boolean surfsAsMats) {
        if (obstProps instanceof UniformProps) {
            return obstProps.get(0);
        }
        if (domain != null) {
            Surface inert = domain.getSurfaceMgr().get(PredefSurf.INERT);
            Color color = surfsAsMats ? null : inert.getColor();
            return new IPrimProps.Face(color, inert, 0);
        }
        return new IPrimProps.Face(Color.BLACK, null, 0);
    }

    private DisplayGeom constructIsectDisplay(Supplier<Collection<? extends IHole>> getNearHoles, BiConsumer<IHole, DisplayGeom> holeGeometry, Supplier<IPropsSrc> getObstProps, Function<IPropsSrc, IPrimProps> getInnerProps) {
        if (this.getOptions(4)) {
            try {
                Collection<? extends IHole> nearHoles = getNearHoles.get();
                if (!nearHoles.isEmpty()) {
                    IGeomNode iGeomNode;
                    IPropsSrc obstProps = getObstProps.get();
                    IPrimProps holeProps = getInnerProps.apply(obstProps);
                    ArrayList<HoleInfo> holeGeoms = new ArrayList<HoleInfo>(nearHoles.size());
                    for (IHole iHole : nearHoles) {
                        holeGeoms.add(new HoleInfo(iHole, GeomUtil.flatten(iHole.getGeom())));
                    }
                    PlanarCoordMapper defPrimUV = TexCoordGenerator.newGenerator(this.getGeom(), this.d_texOrigin);
                    DisplayGeom dispGeom = Obstruction.subtractHoles(defPrimUV, iGeomNode = FDSUtil.finalizeUVElements(this.getGeom(), this.d_texOrigin), obstProps, 0, holeGeoms, holeProps, holeGeometry);
                    if (dispGeom != null) {
                        return dispGeom;
                    }
                }
            }
            catch (Throwable t) {
                System.err.printf("Error subtracting holes: obst=%s%n", this.getName());
                t.printStackTrace();
            }
        }
        return null;
    }

    private static Model toModel(TransformInfo xform, IGeom geom, Map<IPrimProps, Integer> propIdMap, IPropsSrc props, int propOffset, IPropertySet elements, int elemOffset) {
        Model model = new Model();
        List faces = GeomUtil.explode(geom.transform(xform, 0), IFace.class);
        int nprims = faces.size();
        IPropertySet subElems = Elements.newElements();
        subElems.setIfNotDefault(Elements.CREASE, ((IElemSource)((Object)elements.get(Elements.CREASE))).subset(elemOffset, nprims));
        subElems.setIfNotDefault(Elements.ORIENT, ((IElemSource)((Object)elements.get(Elements.ORIENT))).subset(elemOffset, nprims));
        Elements.transformEq(subElems, xform);
        IElemSource creases = (IElemSource)((Object)subElems.get(Elements.CREASE));
        IElemSource orients = (IElemSource)((Object)subElems.get(Elements.ORIENT));
        IPropsSrc sprops = props.subset(propOffset, nprims);
        Iterator<IPrimProps> propit = sprops.iterator();
        int[] creaseid = new int[]{0x7FFFFFFD};
        int[] nocreaseid = new int[]{0x7FFFFFFC};
        ArrayList edgeids = new ArrayList();
        Point3d[][] tpoints = new Point3d[1][3];
        Function<IPrimProps, Integer> newPropFunc = p -> propIdMap.size();
        Elements.processPolys(faces, (ufaces, m, allPoly) -> {
            int ucount = ufaces.size();
            if (allPoly.booleanValue()) {
                List<Boolean> ucreases = creases.subset((int)m, ucount).generate(Boolean.class, (List<IPolygon>)ufaces, orients.subset((int)m, ucount), sprops.subset((int)m, ucount));
                Iterator<Boolean> creaseit = ucreases.iterator();
                for (IFace face : ufaces) {
                    IPrimProps prop = (IPrimProps)propit.next();
                    Integer id = (Integer)propIdMap.computeIfAbsent(prop, newPropFunc);
                    IPolygon poly = (IPolygon)face;
                    Point3d[][] loops = PolyUtil.getLoops(poly, false);
                    int nedges = PolyUtil.getNumVerts(poly);
                    edgeids.clear();
                    for (int n = 0; n < nedges; ++n) {
                        boolean crease = creaseit.next();
                        edgeids.add(crease ? creaseid : nocreaseid);
                    }
                    model.addPolygonFace(poly.getPlane(true), loops, new int[]{id}, edgeids);
                }
            } else {
                int fix = m;
                for (IFace face : ufaces) {
                    IPrimProps prop = (IPrimProps)propit.next();
                    Integer id = (Integer)propIdMap.computeIfAbsent(prop, newPropFunc);
                    Mesh mesh = face.triangulate(0.1);
                    ElementMesh<Boolean> fcreases = creases.getPrimSource(fix).generate(Boolean.class, face, (Elements.Orient)((Object)((Object)orients.getPrimElement(fix))), mesh, prop);
                    Iterator<Boolean> fcreaseit = fcreases.iterator();
                    for (int n = 0; n < mesh.indices.length; n += 3) {
                        edgeids.clear();
                        for (int o = 0; o < 3; ++o) {
                            point3dArray[0][o] = mesh.vertices[mesh.indices[n + o]];
                            edgeids.add(fcreaseit.next() != false ? creaseid : nocreaseid);
                        }
                        model.addPolygonFace(new Plane3d(true, tpoints[0]), tpoints, new int[]{id}, edgeids);
                    }
                    ++fix;
                }
            }
        });
        return model;
    }

    /*
     * WARNING - void declaration
     */
    private static DisplayGeom subtractHoles(IElemSource<Point2d> defTexGen, IGeomNode obstGeom, IPropsSrc obstProps, int obstPropOffset, List<HoleInfo> holeGeoms, IPrimProps holeProps, BiConsumer<IHole, DisplayGeom> holeGeometry) {
        void var14_21;
        IPropertySet newElems;
        void var14_18;
        int oPropOffset = obstPropOffset;
        DisplayBuilder builder = new DisplayBuilder(obstGeom, obstProps, oPropOffset);
        TransformInfo ti = obstGeom.getLocalTransform().getInfo();
        int obstElemOffset = 0;
        for (IGeom geom : builder.oldGeoms) {
            Obstruction.subtractHoles(ti, geom, obstProps, obstPropOffset, builder.oldElems, obstElemOffset, holeGeoms, holeProps, defTexGen, builder, holeGeometry);
            int nprims = geom.getNumPrims(1);
            obstPropOffset += nprims;
            obstElemOffset += nprims;
        }
        int numGeomPrims = obstPropOffset - oPropOffset;
        ArrayList<IGeomNode> tchildren = new ArrayList<IGeomNode>(obstGeom.getChildren().size());
        for (IGeomNode iGeomNode : obstGeom.getChildren()) {
            tchildren.add(iGeomNode.quickTransform(ti));
        }
        ArrayList<ModifiedChild> modChildren = null;
        boolean bl = false;
        while (var14_18 < tchildren.size()) {
            IGeomNode child = (IGeomNode)tchildren.get((int)var14_18);
            DisplayGeom mchild = Obstruction.subtractHoles(defTexGen, child, obstProps, obstPropOffset, holeGeoms, holeProps, holeGeometry);
            int ncprims = child.getNumPrims(7);
            if (mchild != null) {
                if (modChildren == null) {
                    modChildren = new ArrayList<ModifiedChild>();
                }
                modChildren.add(new ModifiedChild(mchild.node, mchild.props, (int)var14_18, obstPropOffset, ncprims));
            }
            obstPropOffset += ncprims;
            ++var14_18;
        }
        if (!builder.isModified() && modChildren == null) {
            return null;
        }
        PropsBuilder newProps = new PropsBuilder();
        if (builder.isModified()) {
            ElementsBuilder elemsBuilder = new ElementsBuilder();
            for (int m = 0; m < builder.geoms.size(); ++m) {
                IGeom g = builder.geoms.get(m);
                int pcount = g.getNumPrims(7);
                IPropsSrc p = builder.props.get(m);
                newProps.add(p, pcount);
                for (Map.Entry<Elements.ElemProp<?>, IElemSource<?>> entry : builder.elems.get(m).entrySet()) {
                    elemsBuilder.add(entry.getKey(), entry.getValue(), pcount);
                }
                for (Map.Entry<Object, IElemSource<Object>> entry : builder.uvElems.get(m).entrySet()) {
                    elemsBuilder.addUV((String)entry.getKey(), entry.getValue(), pcount);
                }
                elemsBuilder.next(pcount);
            }
            newElems = elemsBuilder.finish();
            IGeom iGeom = thunderheadeng.geometry.objs.GeomUtil.group(builder.geoms);
        } else {
            IGeom iGeom = obstGeom.getLocalGeom().transform(ti, 0);
            newElems = Elements.transform(obstGeom.getLocalElements(), ti);
            newProps.add(obstProps.subset(oPropOffset, numGeomPrims), numGeomPrims);
        }
        if (modChildren != null) {
            ArrayList newChildren = new ArrayList(tchildren.size());
            int poffset = oPropOffset + numGeomPrims;
            int coffset = 0;
            for (ModifiedChild mchild : modChildren) {
                newChildren.addAll(tchildren.subList(coffset, mchild.childIx));
                int nuprops = mchild.propBegin - poffset;
                newProps.add(obstProps.subset(poffset, nuprops), nuprops);
                poffset += nuprops;
                newChildren.add(mchild.node);
                newProps.add(mchild.props, mchild.node.getNumPrims(7));
                coffset = mchild.childIx + 1;
                poffset += mchild.nSkippedProps;
            }
            newChildren.addAll(tchildren.subList(coffset, tchildren.size()));
            newProps.add(obstProps.subset(poffset, obstPropOffset - poffset), obstPropOffset - poffset);
            tchildren = newChildren;
        } else {
            int numChildPrims = obstPropOffset - numGeomPrims - oPropOffset;
            newProps.add(obstProps.subset(oPropOffset + numGeomPrims, numChildPrims), numChildPrims);
        }
        IGeomNode newNode = GeomNodeUtil.newNode(TransformUtil.IDENTITY, (IGeom)var14_21, newElems, tchildren);
        return new DisplayGeom(newNode, newProps.finalizeProps());
    }

    private static void subtractHoles(TransformInfo obstXform, IGeom obstGeom, IPropsSrc obstProps, int obstPropsOffset, IPropertySet obstElems, int obstElemsOffset, List<HoleInfo> holeGeoms, IPrimProps holeProps, IElemSource<Point2d> defUVPrim, DisplayBuilder result, BiConsumer<IHole, DisplayGeom> holeGeometry) {
        LinkedHashMap<IPrimProps, Integer> propIdMap = new LinkedHashMap<IPrimProps, Integer>();
        boolean modified = false;
        Model obstModel = null;
        AABox obstbb = obstXform.getBounds(obstGeom, new AABox());
        boolean obstSolid = !obstGeom.isShell();
        for (HoleInfo holeInfo : holeGeoms) {
            DisplayGeomBuilder holeGeomBuilder = holeGeometry != null ? new DisplayGeomBuilder() : null;
            for (Pair<TransformInfo, IGeom> holeGeom : holeInfo.geom) {
                Model newModel;
                boolean holeSolid;
                Containment contains = obstbb.test(((TransformInfo)holeGeom.v1).getBounds((IGeom)holeGeom.v2, new AABox()));
                if (contains == Containment.OUTSIDE) continue;
                if (obstModel == null) {
                    obstModel = Obstruction.toModel(obstXform, obstGeom, propIdMap, obstProps, obstPropsOffset, obstElems, obstElemsOffset);
                }
                obstSolid = obstSolid && obstModel.getFaces().size() >= 4;
                Model holeModel = Obstruction.toModel((TransformInfo)holeGeom.v1, (IGeom)holeGeom.v2, propIdMap, new UniformProps(holeProps), 0, Elements.NONE, 0);
                boolean bl = holeSolid = !((IGeom)holeGeom.v2).isShell() && holeModel.getFaces().size() >= 4;
                if (holeGeomBuilder == null) {
                    newModel = BooleanOp.subtract(obstModel, obstSolid, holeModel, holeSolid);
                } else {
                    Pair<Model, Model> iresult = BooleanOp.subtractAndIntersect(obstModel, obstSolid, holeModel, holeSolid);
                    newModel = (Model)iresult.v1;
                    if (iresult.v2 != null) {
                        Obstruction.addDisplay((Model)iresult.v2, holeSolid, new PropertySet(), defUVPrim, propIdMap, (g, elems, props) -> holeGeomBuilder.add((IGeom)g, (IPropsSrc)props, (IPropertySet)elems));
                    }
                }
                if (newModel == obstModel || newModel == null) continue;
                obstModel = newModel;
                obstbb = obstModel.getBoundingBox();
                modified = true;
            }
            if (holeGeomBuilder == null) continue;
            holeGeometry.accept(holeInfo.hole, holeGeomBuilder.finish().toDisplay());
        }
        if (modified) {
            assert (obstModel != null);
            Obstruction.addDisplay(obstModel, obstSolid, obstElems, defUVPrim, propIdMap, result::add);
        } else {
            result.skip();
        }
    }

    private static void addDisplay(Model srcModel, boolean isSolid, IPropertySet srcElems, IElemSource<Point2d> defUVPrim, Map<IPrimProps, Integer> propIdMap, TriConsumer<IGeom, IPropertySet, IPropsSrc> result) {
        IPrimProps[] props = new IPrimProps[propIdMap.size()];
        for (Map.Entry<IPrimProps, Integer> entry : propIdMap.entrySet()) {
            IPrimProps prop = entry.getKey();
            if (prop.testOptions(2)) {
                prop = prop.setOptions(prop.getOptions() & 0xFFFFFFFD);
            }
            props[entry.getValue().intValue()] = prop;
        }
        IPrimProps[] resultProps = new IPrimProps[srcModel.getFaces().size()];
        ArrayList<Object> geoms = new ArrayList<Object>(resultProps.length);
        int ix = 0;
        ElementBuilder<Boolean> creaseBuilder = ElementBuilders.crease();
        ArrayList creaseList = new ArrayList();
        for (Face face : srcModel.getFaces()) {
            creaseList.clear();
            IPolygon poly = GeomUtil.toPoly(face, eids -> {
                boolean crease = NmtUtil.findGroup(eids, 0x7FFFFFFD) || !NmtUtil.findGroup(eids, 0x7FFFFFFC);
                creaseList.add(crease);
            });
            int groupid = face.groups[0];
            IPrimProps prop = props[groupid];
            resultProps[ix++] = prop;
            geoms.add(poly);
            creaseBuilder.add(new ElementPoly<Boolean>(theUtil.toArray(creaseList, Boolean.class)), 1);
        }
        IGeom geom = thunderheadeng.geometry.objs.GeomUtil.group(geoms);
        if (isSolid) {
            geom = new SolidGeom(geom);
        }
        ListMap<String, IElemSource<Point2d>> uvsets = new ListMap<String, IElemSource<Point2d>>();
        for (String uvset : srcElems.get(Elements.UV).keySet()) {
            uvsets.put(uvset, defUVPrim);
        }
        IPropertySet elems = Elements.newElements();
        elems.setIfNotDefault(Elements.UV, uvsets);
        elems.setIfNotDefault(Elements.CREASE, creaseBuilder.finish());
        elems = Elements.finalizeElements(elems);
        result.accept(geom, elems, new FlattenedProps(resultProps));
    }

    @Override
    public IGeomNode getGeom() {
        return (IGeomNode)this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        if (this.d_geom == geom) {
            return;
        }
        assert (geom.getNumPrims(6) == 0) : "Geometry assigned to an obstruction should contain only faces.";
        this.d_geom = geom;
        this.d_cachedNumFaces = null;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setSurfaces(Surface[] surfs) {
        assert (surfs.length == 1 || surfs.length == this.getGeom().getNumPrims(1));
        this.d_surfaces = LWArray.newArray(surfs);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Surface[] getSurfaces() {
        return LWArray.toArray(this.d_surfaces, Surface.class);
    }

    public IPropsSrc getDisplayProps() {
        return this.getDisplayProps(false);
    }

    private IPropsSrc getDisplayProps(boolean surfsAsMats) {
        Surface[] surfs = this.getSurfaces();
        Color[] colors = this.getColors();
        int options = GeomUtil.isCullGeom(this.getGeom()) ? 2 : 0;
        BiFunction<Color, Surface, IPrimProps> newProps = surfsAsMats ? (c, s) -> new IPrimProps.Face((Color)c, (IMaterial)s, options) : (c, s) -> FDSUtil.newObstFaceProps(c, s, options);
        if (surfs.length == 1 && colors.length == 1) {
            IPrimProps prop = newProps.apply(colors[0], surfs[0]);
            return new UniformProps(prop);
        }
        int numProps = Math.max(surfs.length, colors.length);
        IPrimProps[] props = new IPrimProps[numProps];
        for (int m = 0; m < numProps; ++m) {
            Surface surf = surfs.length == 1 ? surfs[0] : surfs[m];
            Color color = colors.length == 1 ? colors[0] : colors[m];
            props[m] = newProps.apply(color, surf);
        }
        return new FlattenedProps(props);
    }

    @Override
    public Predicate<Surface> getSurfFilter() {
        return s_surfFilter;
    }

    public static Predicate<Surface> getSurfaceFilter() {
        return s_surfFilter;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        IPyroObject[] surfs = this.getSurfaces();
        deps.add(DLink.REQUIRED, surfs);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof Surface) {
            Util.keepIfNullOr(objs, o -> o instanceof Surface && s_surfFilter.test((Surface)o));
        } else {
            super.removeInvalidReplacements(old, objs);
        }
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (!(dep instanceof Surface) && Util.containsAny(changes, Surface.EVT_APPEARANCE, Surface.EVT_COLOR, EventChannel.EVT_GENERAL)) {
            return super.taskUpdateDep(dep, changes);
        }
        return GeomUtil.taskChanged(this);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (!(old instanceof Surface)) {
            return super.taskReplaceDep(old, replacement);
        }
        return new AUndoableTask(){
            private IGeomNode d_oldNode = null;
            private int[] d_ixes = null;

            @Override
            public void undo() {
                this.setData((Surface)old, this.d_oldNode);
                this.d_ixes = null;
                this.d_oldNode = null;
            }

            private boolean keepUV() {
                Material mrepl;
                if (old == replacement) {
                    return true;
                }
                if (old == null || replacement == null) {
                    return false;
                }
                Surface sold = (Surface)old;
                Surface srepl = (Surface)replacement;
                Material mold = sold.getAppearance();
                if (mold == (mrepl = srepl.getAppearance())) {
                    return true;
                }
                if (mold == null || mrepl == null) {
                    return false;
                }
                for (MatChannel channel : MatChannel.values()) {
                    Texture trepl;
                    Texture told = mold.getAttributes().getTexture(channel);
                    if (Objects.equals(told, trepl = mold.getAttributes().getTexture(channel))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void run() {
                boolean keepUV = this.keepUV();
                ArrayList<Integer> ixes = new ArrayList<Integer>();
                BitSet bits = new BitSet();
                Surface[] surfs = Obstruction.this.getSurfaces();
                for (int m2 = 0; m2 < surfs.length; ++m2) {
                    if (surfs[m2] != old) continue;
                    ixes.add(m2);
                    bits.set(m2);
                }
                this.d_ixes = theUtil.toIntArray(ixes);
                IGeomNode newNode = this.d_oldNode = Obstruction.this.getGeom();
                if (!keepUV) {
                    newNode = surfs.length > 1 ? this.d_oldNode.applyUVElements((uvset, m, oldEl) -> bits.get((int)m) ? FDSUtil.getDefaultTexMapper() : oldEl) : this.d_oldNode.applyUniformProp(Elements.UV, FDSUtil.getDefaultTexMapperSets());
                }
                this.setData((Surface)replacement, newNode);
            }

            private void setData(Surface surf, IGeomNode node) {
                Surface[] surfs = Obstruction.this.getSurfaces();
                Surface[] newSurfs = (Surface[])surfs.clone();
                for (int m = 0; m < this.d_ixes.length; ++m) {
                    newSurfs[this.d_ixes[m]] = surf;
                }
                Obstruction.this.pauseUpdates();
                Obstruction.this.setSurfaces(newSurfs);
                Obstruction.this.setGeom(node);
                Obstruction.this.resumeUpdates();
            }
        };
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Surface.class);
    }

    private static class DisplayBuilder {
        public final ITransform oldXform;
        public final List<IGeom> oldGeoms;
        public final IPropertySet oldElems;
        public final IPropsSrc oldProps;
        private int geomIx = 0;
        public List<IGeom> geoms = null;
        public List<Map<Elements.ElemProp<?>, IElemSource<?>>> elems = null;
        public List<Map<String, IElemSource<Point2d>>> uvElems = null;
        public List<IPropsSrc> props = null;

        public DisplayBuilder(IGeomNode node, IPropsSrc oldProps, int propOffset) {
            this.oldXform = node.getLocalTransform();
            this.oldGeoms = thunderheadeng.geometry.objs.GeomUtil.flatten(node.getLocalGeom());
            this.oldElems = node.getLocalElements();
            this.oldProps = oldProps.subset(propOffset, node.getLocalGeom().getNumPrims(7));
        }

        public void add(IGeom geom, IPropertySet elems, IPropsSrc props) {
            if (this.geoms == null) {
                this.geoms = new ArrayList<IGeom>(this.oldGeoms.size());
                assert (this.elems == null && this.props == null && this.uvElems == null);
                this.elems = new ArrayList(this.oldGeoms.size());
                this.uvElems = new ArrayList<Map<String, IElemSource<Point2d>>>(this.oldGeoms.size());
                this.props = new ArrayList<IPropsSrc>(this.oldGeoms.size());
                int poffset = 0;
                TransformInfo ti = this.oldXform.getInfo();
                IPropertySet telems = Elements.transform(this.oldElems, ti);
                for (int m = 0; m < this.oldGeoms.size(); ++m) {
                    IGeom g = this.oldGeoms.get(m).transform(ti, 0);
                    this.geoms.add(g);
                    int numPrims = g.getNumPrims(7);
                    this.props.add(this.oldProps.subset(poffset, numPrims));
                    this.elems.add(DisplayBuilder.toMap(telems, poffset, numPrims));
                    this.uvElems.add(DisplayBuilder.toUVMap(telems, poffset, numPrims));
                    poffset += numPrims;
                }
            }
            this.geoms.set(this.geomIx, geom);
            this.props.set(this.geomIx, props);
            int numPrims = geom.getNumPrims(7);
            this.elems.set(this.geomIx, DisplayBuilder.toMap(elems, 0, numPrims));
            this.uvElems.set(this.geomIx, DisplayBuilder.toUVMap(elems, 0, numPrims));
            ++this.geomIx;
        }

        private static Map<Elements.ElemProp<?>, IElemSource<?>> toMap(IPropertySet telems, int poffset, int numPrims) {
            HashMap elemMap = new HashMap();
            for (Elements.ElemProp<?> prop : Elements.FIXED) {
                elemMap.put(prop, ((IElemSource)telems.get(prop)).subset(poffset, numPrims));
            }
            return elemMap;
        }

        private static Map<String, IElemSource<Point2d>> toUVMap(IPropertySet telems, int poffset, int numPrims) {
            HashMap<String, IElemSource<Point2d>> elemMap = new HashMap<String, IElemSource<Point2d>>();
            for (Map.Entry<String, IElemSource<Point2d>> entry : telems.get(Elements.UV).entrySet()) {
                elemMap.put(entry.getKey(), entry.getValue().subset(poffset, numPrims));
            }
            return elemMap;
        }

        public void skip() {
            ++this.geomIx;
        }

        public boolean isModified() {
            return this.geoms != null;
        }
    }

    private static class ModifiedChild {
        public final IGeomNode node;
        public final IPropsSrc props;
        public final int childIx;
        public final int propBegin;
        public final int nSkippedProps;

        public ModifiedChild(IGeomNode node, IPropsSrc props, int childIx, int propBegin, int nSkippedProps) {
            this.node = node;
            this.props = props;
            this.childIx = childIx;
            this.propBegin = propBegin;
            this.nSkippedProps = nSkippedProps;
        }
    }

    private static class HoleInfo {
        public IHole hole;
        public final List<Pair<TransformInfo, IGeom>> geom;

        public HoleInfo(IHole hole, List<Pair<TransformInfo, IGeom>> geom) {
            this.hole = hole;
            this.geom = geom;
        }
    }

    private class FragGen
    implements IFDSObjProps {
        @Override
        public IFragGenerator getFragGenerator(RasterizationOptions rastOptions) {
            return new ObstFragGenerator(Obstruction.this, rastOptions);
        }

        @Override
        public FaceProps getFace(int ix) {
            Surface[] surfs = Obstruction.this.getSurfaces();
            Surface surf = surfs.length > 1 ? surfs[ix] : surfs[0];
            Color[] colors = Obstruction.this.getColors();
            Color color = colors.length == 1 ? colors[0] : colors[ix];
            return new FaceProps(surf, color);
        }

        @Override
        public boolean thickenEnabled() {
            return Obstruction.this.getOptions(1);
        }
    }
}

