/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.devices.ASourceDevice;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.signals.IDoubleInPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class AMeasuringDevc
extends ASourceDevice
implements IDirectDependent,
IMeasurer {
    static final long serialVersionUID = 1L;
    private Object d_outPin;
    private IQuantity d_measurement;
    private OneLogicInPin d_freezePin;
    private static final Logger LOGGER = Logger.getLogger(AMeasuringDevc.class.getName());

    public AMeasuringDevc(String name, IQuantity measurment) {
        super(name);
        this.d_measurement = measurment;
        this.d_outPin = this.createOutInfo(new QuantOutPin(this));
        this.d_freezePin = new OneLogicInPin(this);
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return this.getMsrInfo().latches();
    }

    private MeasureOutInfo createOutInfo(QuantOutPin outPin) {
        return new MeasureOutInfo(this, true, outPin, Intl.intl("ALARM"));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.d_outPin instanceof QuantOutPin) {
            this.d_outPin = this.createOutInfo((QuantOutPin)this.d_outPin);
        }
        ((MeasureOutInfo)this.d_outPin).legacySetSource(this);
        if (this.d_freezePin == null) {
            this.d_freezePin = new OneLogicInPin(this);
        }
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    @Override
    public Object clone() {
        AMeasuringDevc clone = (AMeasuringDevc)super.clone();
        clone.d_outPin = ((MeasureOutInfo)this.d_outPin).clone(clone);
        clone.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AMeasuringDevc)) {
            return false;
        }
        AMeasuringDevc devc = (AMeasuringDevc)obj;
        return super.equals(devc) && this.d_measurement.equals(devc.d_measurement) && this.d_outPin.equals(devc.d_outPin) && this.d_freezePin.equals(devc.d_freezePin);
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        ArrayList<IOutPin> pins = new ArrayList<IOutPin>();
        ((MeasureOutInfo)this.d_outPin).getPins(pins);
        return pins;
    }

    @Override
    public int getNumMeasurements() {
        return 1;
    }

    public IQuantity getQuantity() {
        return this.d_measurement;
    }

    @Override
    public IQuantity getQuantity(int index) {
        return this.getQuantity();
    }

    public void setQuantity(IQuantity m, Unit newUnit) {
        assert (m != null);
        if (!this.d_measurement.equals(m)) {
            if (this.getDomain() != null) {
                DepSnapshot ds = ((PyroMod)this.getDomain()).getDependencies(this);
                Set<Dependency> deps = ds.getDependents(this);
                for (Dependency dep : deps) {
                    if (!(dep.source instanceof IDoubleInPin)) continue;
                    IDoubleInPin pin = (IDoubleInPin)dep.source;
                    pin.updateInputUnit(newUnit);
                }
            }
            this.d_measurement = m;
            this.changedEvt(new Object[0]);
        }
    }

    public MeasureOutInfo getMsrInfo() {
        return (MeasureOutInfo)this.d_outPin;
    }

    @Override
    public MeasureOutInfo getMsrInfo(int index) {
        return this.getMsrInfo();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        if (this.d_measurement != null) {
            QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.d_measurement);
        } else {
            LOGGER.warning("Null quantity found while taking dependency snapshot.");
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        QuantReplacer replacer = new QuantReplacer();
        replacer.removeInvalidReplacements(old, objs, this.d_measurement);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.d_measurement);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    private static class QuantOutPin
    extends APyroObject
    implements IDoubleOutPin {
        static final long serialVersionUID = 1L;
        @SkipDep
        private ISignalSource d_source;

        public QuantOutPin(AMeasuringDevc source) {
            this.d_source = source;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
        }

        @Override
        public ISignalSource getAttachedSource() {
            return this.d_source;
        }

        @Override
        public void setSource(ISignalSource source) {
            assert (source instanceof AMeasuringDevc);
            this.d_source = source;
        }

        @Override
        public String getName() {
            return Intl.intl("OUT");
        }

        @Override
        public void setName(String id) {
        }

        @Override
        public int getUnitType() {
            return ((AMeasuringDevc)((AMeasuringDevc)this.d_source)).d_measurement.get().unitType;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof QuantOutPin && this.getAttachedSource().equals(((QuantOutPin)obj).getAttachedSource());
        }

        @Override
        public Object clone(ISignalSource newSource) {
            QuantOutPin pin = (QuantOutPin)super.clone();
            assert (newSource instanceof AMeasuringDevc);
            pin.d_source = newSource;
            return pin;
        }

        public int hashCode() {
            return 160596815 + this.getAttachedSource().hashCode();
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this.equals(obj);
        }
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)AMeasuringDevc.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    AMeasuringDevc.this.d_measurement = obj;
                    AMeasuringDevc.this.changedEvt(new Object[0]);
                }
            };
        }
    }
}

