/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.Arrays;
import java.util.List;
import pyrosim.Intl;
import pyrosim.domain.INamed;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.Util;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;

public class ControlBridge
extends AControl
implements INamed,
ILatchable {
    static final long serialVersionUID = 1L;
    private IInPin d_inPin = new OneLogicInPin(this);
    private IOutPin d_outPin = new LogicOutPin(this);

    public ControlBridge(String name) {
        super(name);
    }

    @Override
    protected String getDefaultName() {
        return Intl.intl("bridge");
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return Util.inputLatches(this.d_inPin);
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        ControlBridge clone = (ControlBridge)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        clone.d_outPin = (IOutPin)this.d_outPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ControlBridge)) {
            return false;
        }
        ControlBridge op = (ControlBridge)obj;
        return super.equals(obj) && this.d_inPin.equals(op.d_inPin);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 153696506 + this.d_inPin.hashCode();
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this.equals(obj);
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public void setName(String name) {
        ISignalSource src;
        this.pauseUpdates();
        super.setName(name);
        ISignalSource iSignalSource = src = !this.d_inPin.getConnections().isEmpty() ? this.d_inPin.getConnectedSources().iterator().next() : null;
        if (src instanceof IControl) {
            ((IControl)src).setName(name);
        }
        this.resumeUpdates();
    }
}

