/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SurfComposition
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_initInnerTemp;
    public final TimeFunction d_tempRamp;
    public final List<SurfLayer> d_layers;
    public final Backing d_backing;
    public final Double d_layerDivide;

    public SurfComposition() {
        this(null, TimeFunction.newDefault(), Backing.newDefault(), null, new ArrayList<SurfLayer>(0));
    }

    public SurfComposition(UnitDouble initialInnerTemp, TimeFunction tempRamp, Backing backing, Double layerDivide, List<SurfLayer> layers) {
        this.d_initInnerTemp = initialInnerTemp;
        this.d_tempRamp = tempRamp;
        this.d_backing = backing;
        this.d_layerDivide = layerDivide;
        this.d_layers = Collections.unmodifiableList(layers);
        assert (this.d_layerDivide == null || this.d_layerDivide <= (double)this.d_layers.size() && this.d_layerDivide >= 0.0);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + theUtil.hashCode(this.d_backing);
        hash = 31 * hash + theUtil.hashCode(this.d_layerDivide);
        hash = 31 * hash + theUtil.hashCode(this.d_initInnerTemp);
        hash = 31 * hash + theUtil.hashCode(this.d_tempRamp);
        hash = 31 * hash + theUtil.hashCode(this.d_layers);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SurfComposition)) {
            return false;
        }
        SurfComposition comp = (SurfComposition)obj;
        return this.d_backing.equals(comp.d_backing) && theUtil.equal(this.d_layerDivide, comp.d_layerDivide) && theUtil.equal(this.d_initInnerTemp, comp.d_initInnerTemp) && this.d_tempRamp.equals(comp.d_tempRamp) && this.d_layers.equals(comp.d_layers);
    }

    public static class SurfLayer
    implements IDirectDependent,
    Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_thickness;
        private final Map<Material, SurfComponent> d_components;

        public SurfLayer(UnitDouble thickness, Collection<SurfComponent> comps) {
            this.d_thickness = thickness;
            this.d_components = new LinkedIdentityHashMap<Material, SurfComponent>();
            for (SurfComponent comp : comps) {
                this.d_components.put(comp.d_material, comp);
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.d_thickness);
            hash = 31 * hash + theUtil.hashCode(this.d_components);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SurfLayer)) {
                return false;
            }
            SurfLayer layer = (SurfLayer)obj;
            return this.d_thickness.equals(layer.d_thickness) && Util.identityMapsEqual(this.d_components, layer.d_components);
        }

        public Collection<SurfComponent> getComponents() {
            return this.d_components.values();
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            deps.add(DLink.REQUIRED, this.d_components.keySet());
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
            Util.keepIfNullOr(objs, Material.class);
        }

        @Override
        public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
            if (!this.d_components.containsKey(old)) {
                return null;
            }
            return new AUndoableTask(){
                private Map<Material, SurfComponent> d_oldComp;

                @Override
                public void undo() {
                    d_components.clear();
                    d_components.putAll(this.d_oldComp);
                    this.d_oldComp = null;
                }

                @Override
                public void run() {
                    this.d_oldComp = new LinkedIdentityHashMap<Material, SurfComponent>(d_components);
                    SurfComponent oldComp = (SurfComponent)d_components.remove(old);
                    SurfComponent existingComp = (SurfComponent)d_components.get(replacement);
                    if (existingComp == null) {
                        SurfComponent newComp = new SurfComponent(oldComp.d_massFraction, (Material)replacement);
                        d_components.put((Material)replacement, newComp);
                    } else {
                        SurfComponent combinedComp = new SurfComponent(oldComp.d_massFraction + existingComp.d_massFraction, (Material)replacement);
                        d_components.put((Material)replacement, combinedComp);
                    }
                }
            };
        }

        @Override
        public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
            return EmptyTask.INSTANCE;
        }

        public static class SurfComponent
        implements Serializable {
            static final long serialVersionUID = 1L;
            public final double d_massFraction;
            public final Material d_material;

            public SurfComponent(double massFraction, Material mat) {
                this.d_massFraction = massFraction;
                this.d_material = mat;
            }

            public int hashCode() {
                int hash = 7;
                hash = 31 * hash + theUtil.hashCode(this.d_massFraction);
                hash = 31 * hash + theUtil.hashCode(this.d_material);
                return hash;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof SurfComponent)) {
                    return false;
                }
                SurfComponent comp = (SurfComponent)obj;
                return this.d_massFraction == comp.d_massFraction && this.d_material.equals(comp.d_material);
            }
        }
    }
}

