/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.domain.boundcond.surf.AOutFlowSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.util.Util;
import thunderheadeng.util.theUtil;

public class LayeredSurfDesc
extends AOutFlowSurfDesc {
    static final long serialVersionUID = 1L;
    public final TempRegulation d_temperature;
    public final Fuel.IReaction d_iReac;
    public final SurfComposition d_surfComp;
    public final SpecInjList d_specInj;
    public final boolean d_burnAway;
    public final ZonePath d_leakPath;
    public final ISlip d_slip;
    public final Geometry d_geom;

    public LayeredSurfDesc() {
        this(IGeometry.DEFAULT, new Fuel.MaterialReac(), new SurfComposition(), null, null, false, null, TempRegulation.newDefault());
    }

    public LayeredSurfDesc(IGeometry geom, Fuel.IReaction reac, SurfComposition surfComp, SpecInjList specInj, ParticleInjection partInj, boolean burnAway, ZonePath leakPath, TempRegulation tr) {
        this(geom, null, reac, surfComp, specInj, partInj, burnAway, leakPath, tr);
    }

    public LayeredSurfDesc(IGeometry geom, ISlip slip, Fuel.IReaction reac, SurfComposition surfComp, SpecInjList specInj, ParticleInjection partInj, boolean burnAway, ZonePath leakPath, TempRegulation tr) {
        super(partInj, geom);
        this.d_specInj = specInj;
        this.d_iReac = reac;
        this.d_surfComp = surfComp;
        this.d_burnAway = burnAway;
        this.d_leakPath = leakPath;
        this.d_temperature = tr;
        this.d_slip = slip;
        this.d_geom = Geometry.FLAT;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + theUtil.hashCode((Object)this.d_geom);
        hash = 31 * hash + theUtil.hashCode(this.d_iReac);
        hash = 31 * hash + theUtil.hashCode(this.d_surfComp);
        hash = 31 * hash + theUtil.hashCode(this.d_specInj);
        hash = 31 * hash + theUtil.hashCode(this.d_burnAway);
        hash = 31 * hash + theUtil.hashCode(this.d_leakPath);
        hash = 31 * hash + theUtil.hashCode(this.d_temperature);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LayeredSurfDesc)) {
            return false;
        }
        LayeredSurfDesc lsd = (LayeredSurfDesc)obj;
        return super.equals(obj) && this.d_geom.equals((Object)lsd.d_geom) && this.d_iReac.equals(lsd.d_iReac) && this.d_surfComp.equals(lsd.d_surfComp) && theUtil.equal(this.d_specInj, lsd.d_specInj) && this.d_burnAway == lsd.d_burnAway && theUtil.equal(this.d_leakPath, lsd.d_leakPath) && this.d_temperature.equals(lsd.d_temperature);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(in) < 38) {
            try {
                Util.assignFinalField(this, "d_slip", ISlip.DEFAULT);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (this.d_temperature == null) {
            try {
                Util.assignFinalField(this, "d_temperature", TempRegulation.newDefault());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (this.d_geometry == null) {
            try {
                Util.assignFinalField(this, "d_geometry", IGeometry.DEFAULT);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (PyroSimObjectInputStream.getVersion(in) < 70 && this.d_temperature.isFixedTempTR()) {
            TempRegulation tr = TempRegulation.newCalcTempTR(this.d_temperature.d_thermalBCs.d_emissivity, this.d_temperature.d_htCoef, this.d_temperature.d_logarithmic);
            try {
                Util.assignFinalField(this, "d_temperature", tr);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static enum Geometry {
        FLAT,
        CYLINDRICAL,
        SPHERICAL;

    }
}

