/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.Serializable;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.image.Image;

public class ModelImage
implements Serializable,
Cloneable,
Comparable<ModelImage> {
    static final long serialVersionUID = 1L;
    private final Image d_image;
    private BGImageXform d_xform;
    private float d_opacity = 1.0f;

    public ModelImage(Image image, BGImageXform xform, float opacity) {
        this.d_image = image;
        this.d_xform = xform;
        this.d_opacity = opacity;
    }

    public String toString() {
        Point3d anchor = this.d_xform.anchorModel;
        double distAB = this.d_xform.distABModel;
        return this.d_xform.anchorImage + ";" + anchor.x + "," + anchor.y + ";" + this.d_xform.aImage + ";" + this.d_xform.bImage + ";" + anchor.z + ";" + distAB + ";" + this.d_opacity;
    }

    public ModelImage clone() {
        try {
            return (ModelImage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelImage)) {
            return false;
        }
        ModelImage i = (ModelImage)o;
        return i.d_xform.equals(this.d_xform) && i.d_opacity == this.d_opacity;
    }

    @Override
    public int compareTo(ModelImage obj) {
        if (obj == null) {
            return 1;
        }
        return obj.d_image.getFilename().compareTo(this.d_image.getFilename());
    }

    public Image getImage() {
        return this.d_image;
    }

    public void setLWTransform(BGImageXform xform) {
        this.d_xform = xform;
    }

    public BGImageXform getLWTransform() {
        return this.d_xform;
    }

    public float getOpacity() {
        return this.d_opacity;
    }

    public void setOpacity(float opacity) {
        this.d_opacity = opacity;
    }
}

