/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxf;
import thunderheadeng.geometry.RTreef;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theTimer;

public class GeomLocator {
    private Set<IDisplayableGeomSrc> d_dirtyGeom = GeomLocator.newDirtySet();
    private final RTreef<IDisplayableGeomSrc> d_finite = new RTreef(2, 16);
    private final Set<IDisplayableGeomSrc> d_infinite = new LinkedIdentityHashSet<IDisplayableGeomSrc>();

    private static Set<IDisplayableGeomSrc> newDirtySet() {
        return new LinkedIdentityHashSet<IDisplayableGeomSrc>();
    }

    public void add(IDisplayableGeomSrc geom) {
        this.d_dirtyGeom.add(geom);
    }

    public void remove(IDisplayableGeomSrc geom) {
        this.d_finite.remove(geom);
        this.d_infinite.remove(geom);
        this.d_dirtyGeom.remove(geom);
    }

    public void update(IDisplayableGeomSrc geom) {
        this.d_dirtyGeom.add(geom);
    }

    public void updateDirty() {
        if (this.d_dirtyGeom.isEmpty()) {
            return;
        }
        theTimer timer = new theTimer();
        for (IDisplayableGeomSrc geom : this.d_dirtyGeom) {
            this.removeGeometry(geom);
            this.addGeometry(geom);
        }
        this.d_dirtyGeom = GeomLocator.newDirtySet();
        if (System.getProperty("dev") != null) {
            System.out.println("updated geom search " + timer.curr());
        }
    }

    private void addGeometry(IDisplayableGeomSrc geom) {
        AABox bounds = geom.getBounds();
        if (bounds.isInfinite()) {
            this.d_infinite.add(geom);
        } else {
            AABoxf boundsFloat = bounds.toAABoxf();
            if (boundsFloat.isInfinite()) {
                System.err.printf("GeomLocator.addGeometry(geom=%s) - Error: double-precision bounding box can't fit into float.%n", geom.toString());
                return;
            }
            this.d_finite.insert(boundsFloat, geom);
        }
    }

    private void addGeometry(Collection<? extends IDisplayableGeomSrc> searchGeom) {
        for (IDisplayableGeomSrc iDisplayableGeomSrc : searchGeom) {
            this.addGeometry(iDisplayableGeomSrc);
        }
    }

    private boolean removeGeometry(IDisplayableGeomSrc geom) {
        this.d_finite.remove(geom);
        this.d_infinite.remove(geom);
        return true;
    }

    private boolean removeGeometry(Collection<? extends IDisplayableGeomSrc> searchGeom) {
        boolean result = true;
        for (IDisplayableGeomSrc iDisplayableGeomSrc : searchGeom) {
            result &= this.removeGeometry(iDisplayableGeomSrc);
        }
        return result;
    }

    public void find(final ITest<AABox> tester, IResult<? super IDisplayableGeomSrc> result, boolean includeInvisible) {
        ITest<AABoxf> testConverter = new ITest<AABoxf>(){

            @Override
            public Containment test(AABoxf bounds) {
                return tester.test(new AABox(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ(), bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ()));
            }
        };
        this.findf(testConverter, result, includeInvisible);
    }

    public void findf(ITest<AABoxf> tester, IResult<? super IDisplayableGeomSrc> result, boolean includeInvisible) {
        this.updateDirty();
        this.find(tester, result, this.d_finite, includeInvisible);
        this.find(result, this.d_infinite, includeInvisible);
    }

    private void find(ITest<AABoxf> test, final IResult<? super IDisplayableGeomSrc> result, RTreef<IDisplayableGeomSrc> finiteGeom, boolean includeInvisible) {
        IResult<IDisplayableGeomSrc> res = result;
        if (!includeInvisible) {
            res = new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                    if (!obj.isVisible()) {
                        return;
                    }
                    result.mark(obj, ctmt);
                }
            };
        }
        finiteGeom.find(test, res);
    }

    private void find(IResult<? super IDisplayableGeomSrc> result, Set<IDisplayableGeomSrc> infiniteGeom, boolean includeInvisible) {
        for (IDisplayableGeomSrc geom : infiniteGeom) {
            if (!includeInvisible && !geom.isVisible()) continue;
            result.mark(geom, Containment.INTERSECTS);
        }
    }

    public static class Collector<T extends IDisplayableGeomSrc>
    extends CollResult<IDisplayableGeomSrc, T> {
        public Collector(Class<T> type) {
            this(type, Filters.acceptAll(type));
        }

        public Collector(Class<T> type, Predicate<T> filter) {
            super(type, filter);
        }
    }
}

