/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.variant.ConstProfile;
import pyrosim.domain.variant.DefRampProfile;
import pyrosim.domain.variant.DefaultProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ExSpec
extends NamedPyroObject
implements Serializable,
Cloneable,
ICustomFDSPropsContainer,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public static final int TYPE_PREDEFINED = 0;
    public static final int TYPE_PRIMITIVE = 1;
    public static final int TYPE_LUMPED_MASS = 2;
    public static final int TYPE_LUMPED_VOLUME = 3;
    public static final int TYPE_REAC_FUEL = 4;
    public static final int TYPE_PREDEFINED_LUMPED = 5;
    public static final int WT_NO_WEIGHT_SET = 0;
    public static final int WT_MOL_WEIGHT_SET = 1;
    public static final int WT_FORMULA_SET = 2;
    public static final int ID_NONE = 0;
    public static final VariantProfile SPECHEAT_PROFILE = ExSpec.newVarProf(11, DefRampProfile.Input.HEAT, 0.0);
    public static final VariantProfile DIFFUSIVITY_PROFILE = ExSpec.newVarProf(27, DefRampProfile.Input.TIME, 0.0);
    public static final VariantProfile VISCOSITY_PROFILE = ExSpec.newVarProf(41, DefRampProfile.Input.TIME, 0.0);
    private String d_fyi;
    private int d_type;
    private boolean d_isStatic;
    private UnitDouble d_molWt;
    private double d_massFrac0;
    private String d_formula;
    private int d_wtType;
    private Map<ExSpec, Double> d_composition;
    private LUMPED_RULE d_lumpedOnlyRule;
    private boolean d_background;
    private PrimitiveParams d_primParams;
    private CustomFDSProps d_advancedProps;

    private static VariantProfile newVarProf(int unit, DefRampProfile.Input input, double defValSI) {
        return new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), unit, SIUS.newud(defValSI, unit)), new DefRampProfile(Intl.intl("Custom"), unit, input));
    }

    public ExSpec(String name, int type) {
        this(name, type, false);
    }

    public ExSpec(String name, int type, boolean isStatic) {
        super(name);
        SIUS uSys = SIUS.getInstance();
        this.d_type = type;
        this.d_fyi = "";
        this.d_isStatic = isStatic;
        this.d_massFrac0 = 0.0;
        this.d_molWt = new UnitDouble(29.0, uSys.getMolecularWeightUnit());
        this.d_formula = "";
        this.d_wtType = 1;
        this.d_background = false;
        this.d_composition = new LinkedHashMap<ExSpec, Double>();
        this.d_lumpedOnlyRule = LUMPED_RULE.AUTO;
        this.d_primParams = new PrimitiveParams(this);
        this.d_advancedProps = CustomFDSProps.EMPTY;
    }

    public ExSpec(ExSpec original) {
        this.d_isStatic = false;
        this.setName(original.getName());
        this.setFYI(original.getFYI());
        this.setMassFrac0(original.getMassFrac0());
        this.setMolecularWeight(original.getMolecularWeight());
        this.setChemFormula(original.getChemFormula());
        this.setWtType(original.getWtType());
        this.setComposition(original.getType(), new LinkedHashMap<ExSpec, Double>(original.getComposition()));
        this.setType(original.getType());
        this.setLumpedComponentOnlyRule(original.getLumpedComponentOnlyRule());
        this.setPrimParams(original.getPrimParams());
        this.setCustomFDSProps(original.getCustomFDSProps());
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getWtType() == 0 && this.getChemFormula().length() > 0) {
            this.setWtType(2);
        }
        if (this.isStaticInstance()) {
            return ExSpecList.getPredefinedSpecies(this.getName());
        }
        if (this.d_lumpedOnlyRule == null) {
            this.d_lumpedOnlyRule = LUMPED_RULE.AUTO;
        }
        return this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isStaticInstance() {
        return this.d_isStatic;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_primParams.d_spec = this;
        if (this.d_composition == null) {
            this.d_composition = new LinkedHashMap<ExSpec, Double>();
        } else if (!(this.d_composition instanceof LinkedHashMap)) {
            this.d_composition = new LinkedHashMap<ExSpec, Double>(this.d_composition);
        }
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        return new ExSpec(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExSpec)) {
            return false;
        }
        ExSpec spec = (ExSpec)obj;
        return this.getName().equals(spec.getName()) && this.getFYI().equals(spec.getFYI()) && this.getMolecularWeight().equals(spec.getMolecularWeight()) && this.getMassFrac0() == spec.getMassFrac0() && this.getPrimParams().equals(spec.getPrimParams()) && this.getLumpedComponentOnlyRule().equals((Object)spec.getLumpedComponentOnlyRule()) && Util.isObjMapEqual(this.getComposition(), spec.getComposition()) && this.getCustomFDSProps().equals(spec.getCustomFDSProps());
    }

    public int getType() {
        return this.d_type;
    }

    public void setType(int type) {
        this.d_type = type;
        this.changedEvt(new Object[0]);
    }

    public void setComposition(int type, Map<ExSpec, Double> comp) {
        this.d_type = type;
        this.d_composition = comp;
        this.changedEvt(new Object[0]);
    }

    public Map<ExSpec, Double> getComposition() {
        return this.d_composition;
    }

    public double getMassFrac0() {
        return this.d_massFrac0;
    }

    public void setMassFrac0(double massFrac) {
        this.d_massFrac0 = massFrac;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getMolecularWeight() {
        return this.d_molWt;
    }

    public void setMolecularWeight(UnitDouble molWt) {
        this.d_molWt = molWt;
        this.d_wtType = molWt.getValueNoUnit() > 0.0 ? 1 : 0;
        this.changedEvt(new Object[0]);
    }

    public String getChemFormula() {
        return this.d_formula;
    }

    public void setChemFormula(String formula) {
        this.d_formula = formula;
        if (formula.length() > 0) {
            this.d_wtType = 2;
        }
        this.changedEvt(new Object[0]);
    }

    public int getWtType() {
        return this.d_wtType;
    }

    public void setWtType(int type) {
        this.d_wtType = type;
    }

    public LUMPED_RULE getLumpedComponentOnlyRule() {
        return this.d_lumpedOnlyRule;
    }

    public void setLumpedComponentOnlyRule(LUMPED_RULE rule) {
        this.d_lumpedOnlyRule = rule;
        this.changedEvt(new Object[0]);
    }

    public boolean isBackgroundSpec() {
        return this.d_background;
    }

    public void setIsBackgroundSpec(boolean background) {
        this.d_background = background;
        this.changedEvt(new Object[0]);
    }

    public boolean isAdvancedRecBackgroundSpec() {
        return this.d_advancedProps.getProps().containsKey("BACKGROUND") && this.d_advancedProps.getProps().get("BACKGROUND").equals(".TRUE.");
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("SPEC");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_advancedProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_advancedProps = props;
        this.changedEvt(new Object[0]);
    }

    public PrimitiveParams getPrimParams() {
        return this.d_primParams;
    }

    private void setPrimParams(PrimitiveParams primParams) {
        this.d_primParams = primParams.clone(this);
        this.changedEvt(new Object[0]);
    }

    public int compareTo(ExSpec that) {
        if (this.isFirstPrimitive() && that.isFirstPrimitive()) {
            return ExSpec.defaultCompare(this, that);
        }
        if (this.isFirstPrimitive()) {
            return -1;
        }
        if (that.isFirstPrimitive()) {
            return 1;
        }
        if (this.getType() == 0 && that.getType() == 0) {
            return ExSpec.defaultCompare(this, that);
        }
        if (this.getType() == 0) {
            return -1;
        }
        if (that.getType() == 0) {
            return 1;
        }
        if (this.getType() == 1 && that.getType() == 1) {
            return ExSpec.defaultCompare(this, that);
        }
        if (this.getType() == 1) {
            return -1;
        }
        if (that.getType() == 1) {
            return 1;
        }
        if (this.isFirstLumped()) {
            return -1;
        }
        if (that.isFirstLumped()) {
            return 1;
        }
        return ExSpec.defaultCompare(this, that);
    }

    private static int defaultCompare(ExSpec o1, ExSpec o2) {
        return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
    }

    public boolean isPredefined() {
        return this.d_type == 0 || this.d_type == 5;
    }

    public boolean isPrimitive() {
        return this.d_type == 1;
    }

    public boolean isLumped() {
        return this.d_type == 2 || this.d_type == 3 || this.d_type == 5;
    }

    private boolean isFirstPrimitive() {
        return !(this.d_type != 0 && this.d_type != 1 || !this.isBackgroundSpec() && !this.isAdvancedRecBackgroundSpec());
    }

    private boolean isFirstLumped() {
        return this.isLumped() && (this.isBackgroundSpec() || this.isAdvancedRecBackgroundSpec());
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        for (ExSpec spec : this.d_composition.keySet()) {
            deps.add(DLink.WEAK, (IPyroObject)spec);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.keepIfNullOr(objs, o -> o instanceof ExSpec && !((ExSpec)o).isLumped());
    }

    @Override
    public Task taskReplaceDep(final IPyroObject oldSpec, final IPyroObject repSpec) {
        return new AReplaceRefTask<ExSpec>((Object)oldSpec, (Object)repSpec){
            private double oldVal;
            private double replacementValOld;
            {
                super(old, repl);
                this.oldVal = (Double)ExSpec.this.d_composition.get(oldSpec);
                this.replacementValOld = Double.NaN;
            }

            @Override
            protected void set(ExSpec toAdd) {
                if (toAdd == repSpec) {
                    if (Double.isNaN(this.replacementValOld)) {
                        this.replacementValOld = ExSpec.this.d_composition.getOrDefault(repSpec, 0.0);
                    }
                    ExSpec.this.d_composition.remove(oldSpec);
                    if (repSpec != null) {
                        ExSpec.this.d_composition.put(toAdd, this.oldVal + this.replacementValOld);
                    }
                } else if (toAdd == oldSpec) {
                    if (this.replacementValOld > 0.0) {
                        ExSpec.this.d_composition.put((ExSpec)repSpec, this.replacementValOld);
                    } else {
                        ExSpec.this.d_composition.remove(repSpec);
                    }
                    ExSpec.this.d_composition.put((ExSpec)oldSpec, this.oldVal);
                }
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public String toString() {
        return String.format("ExSpec[name=%s, type=%s, isStatic=%s]", this.getName(), this.d_type, this.d_isStatic);
    }

    public static class PrimitiveParams
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private ExSpec d_spec;
        private Variant d_diffusivityVar;
        private Variant d_viscosityVar;
        private double d_sigmaLJ;
        private boolean d_sigmaLJSet;
        private double d_epsilonKLJ;
        private boolean d_epsilonKLJSet;
        private String d_radCalSurrogate;
        private boolean d_aerosol;
        private UnitDouble d_densitySolid;
        private UnitDouble d_conductivitySolid;
        private UnitDouble d_meanDiameter;
        private Variant d_specHeat;
        private UnitDouble d_refTemp;
        private boolean d_refTempSet;
        private Variant d_refEnthalpyVar;
        private Variant d_densityLiquidVar;
        private Variant d_specHeatLiquidVar;
        private Variant d_vapTempVar;
        private Variant d_meltTempVar;
        private Variant d_HoVaporizationVar;
        private Variant d_EoFormationVar;
        private Variant d_hvRefTempVar;

        public PrimitiveParams(ExSpec spec) {
            this.d_spec = spec;
            this.d_diffusivityVar = DIFFUSIVITY_PROFILE.getDefault();
            this.d_viscosityVar = VISCOSITY_PROFILE.getDefault();
            this.d_sigmaLJ = 0.0;
            this.d_sigmaLJSet = false;
            this.d_epsilonKLJ = 0.0;
            this.d_epsilonKLJSet = false;
            this.d_radCalSurrogate = "";
            this.d_aerosol = false;
            this.d_densitySolid = new UnitDouble(1800.0, SI.KILOGRAM.divide(SI.METER.pow(3)));
            this.d_conductivitySolid = new UnitDouble(0.26, SI.WATT.divide((Unit)SI.METER).divide((Unit)SI.KELVIN));
            this.d_meanDiameter = new UnitDouble(1.0E-6, (Unit)SI.METER);
            this.d_specHeat = SPECHEAT_PROFILE.getDefault();
            this.d_refTemp = new UnitDouble(25.0, SI.CELSIUS);
            this.d_refTempSet = false;
            this.d_refEnthalpyVar = Variant.DEFAULT;
            this.d_densityLiquidVar = Variant.DEFAULT;
            this.d_specHeatLiquidVar = SPECHEAT_PROFILE.getDefault();
            this.d_vapTempVar = Variant.DEFAULT;
            this.d_meltTempVar = Variant.DEFAULT;
            this.d_HoVaporizationVar = Variant.DEFAULT;
            this.d_EoFormationVar = Variant.DEFAULT;
            this.d_hvRefTempVar = Variant.DEFAULT;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PrimitiveParams)) {
                return false;
            }
            PrimitiveParams params = (PrimitiveParams)obj;
            return theUtil.equal(this.getDiffusivity(), params.getDiffusivity()) && theUtil.equal(this.getViscosity(), params.getViscosity()) && this.compareBoolDoublePair(this.isSigmaLJSet(), params.isSigmaLJSet(), this.getSigmaLJ(), params.getSigmaLJ()) && this.compareBoolDoublePair(this.isEpsilonKLJSet(), params.isEpsilonKLJSet(), this.getEpsilonKLJ(), params.getEpsilonKLJ()) && theUtil.equal(this.getRadCalSurrogate(), params.getRadCalSurrogate()) && theUtil.equal(this.isAerosol(), params.isAerosol()) && theUtil.equal(this.getDensitySolid(), params.getDensitySolid()) && theUtil.equal(this.getConductivitySolid(), params.getConductivitySolid()) && theUtil.equal(this.getMeanDiameter(), params.getMeanDiameter()) && theUtil.equal(this.getSpecHeat(), params.getSpecHeat()) && theUtil.equal(this.getRefTemp(), params.getRefTemp()) && theUtil.equal(this.getRefEnthalpy(), params.getRefEnthalpy()) && theUtil.equal(this.getDensityLiquid(), params.getDensityLiquid()) && theUtil.equal(this.getSpecHeatLiquid(), params.getSpecHeatLiquid()) && theUtil.equal(this.getVapTemp(), params.getVapTemp()) && theUtil.equal(this.getMeltTemp(), params.getMeltTemp()) && theUtil.equal(this.getHoVaporization(), params.getHoVaporization()) && theUtil.equal(this.getEoFormation(), params.getEoFormation()) && theUtil.equal(this.getHVRefTemp(), params.getHVRefTemp());
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.d_diffusivityVar);
            hash = 31 * hash + theUtil.hashCode(this.d_viscosityVar);
            hash = 31 * hash + theUtil.hashCode(this.d_sigmaLJ);
            hash = 31 * hash + theUtil.hashCode(this.d_sigmaLJSet);
            hash = 31 * hash + theUtil.hashCode(this.d_epsilonKLJ);
            hash = 31 * hash + theUtil.hashCode(this.d_epsilonKLJSet);
            hash = 31 * hash + theUtil.hashCode(this.d_radCalSurrogate);
            hash = 31 * hash + theUtil.hashCode(this.d_aerosol);
            hash = 31 * hash + theUtil.hashCode(this.d_densitySolid);
            hash = 31 * hash + theUtil.hashCode(this.d_conductivitySolid);
            hash = 31 * hash + theUtil.hashCode(this.d_meanDiameter);
            hash = 31 * hash + theUtil.hashCode(this.d_specHeat);
            hash = 31 * hash + theUtil.hashCode(this.d_refTemp);
            hash = 31 * hash + theUtil.hashCode(this.d_refTempSet);
            hash = 31 * hash + theUtil.hashCode(this.d_refEnthalpyVar);
            hash = 31 * hash + theUtil.hashCode(this.d_densityLiquidVar);
            hash = 31 * hash + theUtil.hashCode(this.d_specHeatLiquidVar);
            hash = 31 * hash + theUtil.hashCode(this.d_vapTempVar);
            hash = 31 * hash + theUtil.hashCode(this.d_meltTempVar);
            hash = 31 * hash + theUtil.hashCode(this.d_HoVaporizationVar);
            hash = 31 * hash + theUtil.hashCode(this.d_EoFormationVar);
            hash = 31 * hash + theUtil.hashCode(this.d_hvRefTempVar);
            return hash;
        }

        public boolean compareBoolDoublePair(boolean isSet1, boolean isSet2, double d1, double d2) {
            if (isSet1) {
                if (isSet2) {
                    return d1 == d2;
                }
                return d1 == 0.0;
            }
            if (isSet2) {
                return d2 == 0.0;
            }
            return true;
        }

        public PrimitiveParams clone(ExSpec spec) {
            try {
                PrimitiveParams clone = (PrimitiveParams)super.clone();
                clone.d_spec = spec;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }

        protected void changedEvt() {
            this.d_spec.changedEvt(new Object[0]);
        }

        public Variant getDiffusivity() {
            return this.d_diffusivityVar;
        }

        public void setDiffusivity(Variant v) {
            this.d_diffusivityVar = v;
            this.changedEvt();
        }

        public boolean isDiffusivitySet() {
            return !this.d_diffusivityVar.isDefault();
        }

        public Variant getViscosity() {
            return this.d_viscosityVar;
        }

        public void setViscosity(Variant v) {
            this.d_viscosityVar = v;
            this.changedEvt();
        }

        public boolean isViscositySet() {
            return !this.d_viscosityVar.isDefault();
        }

        public double getSigmaLJ() {
            return this.d_sigmaLJ;
        }

        public void setSigmaLJ(double sigmaLJ, boolean state) {
            this.d_sigmaLJ = sigmaLJ;
            this.d_sigmaLJSet = state;
            this.changedEvt();
        }

        public boolean isSigmaLJSet() {
            return this.d_sigmaLJSet;
        }

        public double getEpsilonKLJ() {
            return this.d_epsilonKLJ;
        }

        public void setEpsilonKLJ(double epsilonKLJ, boolean state) {
            this.d_epsilonKLJ = epsilonKLJ;
            this.d_epsilonKLJSet = state;
            this.changedEvt();
        }

        public boolean isEpsilonKLJSet() {
            return this.d_epsilonKLJSet;
        }

        public String getRadCalSurrogate() {
            return this.d_radCalSurrogate;
        }

        public void setRadCalSurrogate(String radCalSurrogate) {
            this.d_radCalSurrogate = radCalSurrogate;
            this.changedEvt();
        }

        public boolean isAerosol() {
            return this.d_aerosol;
        }

        public void setAerosol(boolean aerosol) {
            this.d_aerosol = aerosol;
            this.changedEvt();
        }

        public UnitDouble getDensitySolid() {
            return this.d_densitySolid;
        }

        public void setDensitySolid(UnitDouble densitySolid) {
            this.d_densitySolid = densitySolid;
            this.changedEvt();
        }

        public UnitDouble getConductivitySolid() {
            return this.d_conductivitySolid;
        }

        public void setConductivitySolid(UnitDouble conductivitySolid) {
            this.d_conductivitySolid = conductivitySolid;
            this.changedEvt();
        }

        public UnitDouble getMeanDiameter() {
            return this.d_meanDiameter;
        }

        public void setMeanDiameter(UnitDouble meanDiameter) {
            this.d_meanDiameter = meanDiameter;
            this.changedEvt();
        }

        public Variant getSpecHeat() {
            return this.d_specHeat;
        }

        public void setSpecHeat(Variant specHeat) {
            this.d_specHeat = specHeat;
            this.changedEvt();
        }

        public boolean isSpecHeatSet() {
            return !this.d_specHeat.isDefault();
        }

        public UnitDouble getRefTemp() {
            return this.d_refTemp;
        }

        public void setRefTemp(UnitDouble refTemp, boolean state) {
            this.d_refTemp = refTemp;
            this.d_refTempSet = state;
            this.changedEvt();
        }

        public boolean isRefTempSet() {
            return this.d_refTempSet;
        }

        public Variant getRefEnthalpy() {
            return this.d_refEnthalpyVar;
        }

        public void setRefEnthalpy(UnitDouble refEnthalpy) {
            this.d_refEnthalpyVar = refEnthalpy != null ? Variant.constant(refEnthalpy) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isRefEnthalpySet() {
            return !this.d_refEnthalpyVar.isDefault();
        }

        public Variant getDensityLiquid() {
            return this.d_densityLiquidVar;
        }

        public void setDensityLiquid(UnitDouble densityLiquid) {
            this.d_densityLiquidVar = densityLiquid != null ? Variant.constant(densityLiquid) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isDensityLiquidSet() {
            return !this.d_densityLiquidVar.isDefault();
        }

        public Variant getSpecHeatLiquid() {
            return this.d_specHeatLiquidVar;
        }

        public void setSpecHeatLiquid(Variant specHeat) {
            this.d_specHeatLiquidVar = specHeat;
            this.changedEvt();
        }

        public boolean isSpecHeatLiquidSet() {
            return !this.d_specHeatLiquidVar.isDefault();
        }

        public Variant getVapTemp() {
            return this.d_vapTempVar;
        }

        public void setVapTemp(UnitDouble vapTemp) {
            this.d_vapTempVar = vapTemp != null ? Variant.constant(vapTemp) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isVapTempSet() {
            return !this.d_vapTempVar.isDefault();
        }

        public Variant getMeltTemp() {
            return this.d_meltTempVar;
        }

        public void setMeltingTemp(UnitDouble meltTemp) {
            this.d_meltTempVar = meltTemp != null ? Variant.constant(meltTemp) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isMeltingTempSet() {
            return !this.d_meltTempVar.isDefault();
        }

        public Variant getHoVaporization() {
            return this.d_HoVaporizationVar;
        }

        public void setHoVaporization(UnitDouble HoVaporization) {
            this.d_HoVaporizationVar = HoVaporization != null ? Variant.constant(HoVaporization) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isHoVaporizationSet() {
            return !this.d_HoVaporizationVar.isDefault();
        }

        public Variant getEoFormation() {
            return this.d_EoFormationVar;
        }

        public void setEoFormation(UnitDouble eoFormation) {
            this.d_EoFormationVar = eoFormation != null ? Variant.constant(eoFormation) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isEoFormationSet() {
            return !this.d_EoFormationVar.isDefault();
        }

        public Variant getHVRefTemp() {
            return this.d_hvRefTempVar;
        }

        public void setHVRefTemp(UnitDouble hvRefTemp) {
            this.d_hvRefTempVar = hvRefTemp != null ? Variant.constant(hvRefTemp) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isHVRefTempSet() {
            return !this.d_hvRefTempVar.isDefault();
        }
    }

    public static enum LUMPED_RULE {
        AUTO(Intl.intl("AUTO")),
        TRUE(Intl.intl("TRUE")),
        FALSE(Intl.intl("FALSE"));

        public final String id;

        private LUMPED_RULE(String id) {
            this.id = id;
        }
    }
}

